/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.signature.validation;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.comma.signature.comments.InterfaceEventComment;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.InterfaceSignatureDefinition;
import org.eclipse.comma.signature.interfaceSignature.InterfaceSignaturePackage;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.signature.utilities.InterfaceUtilities;
import org.eclipse.comma.signature.validation.AbstractInterfaceSignatureValidator;
import org.eclipse.comma.types.types.Import;
import org.eclipse.comma.types.types.ModelContainer;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.validation.Check;

public class InterfaceSignatureValidator
extends AbstractInterfaceSignatureValidator {
    @Inject
    private IEObjectDocumentationProvider documentationProvider;

    @Check
    public void checkNamesImportedTypeModels(InterfaceSignatureDefinition root) {
        String sigFilename = root.eResource().getURI().trimFileExtension().lastSegment();
        EList _imports = root.getImports();
        for (Import import_ : _imports) {
            String importedFilename = URI.createURI((String)import_.getImportURI()).trimFileExtension().lastSegment();
            boolean _equals = importedFilename.equals(sigFilename);
            if (!_equals) continue;
            this.error("\ufffdImported type file should have a different name than the current signature file.", (EObject)import_, (EStructuralFeature)TypesPackage.Literals.IMPORT__IMPORT_URI);
        }
    }

    @Check
    public void checkDuplicatedTypeNamesInInterface(Signature s) {
        this.checkForNameDuplications((Iterable)s.getTypes(), "type declaration", null, new String[0]);
    }

    @Check
    public HashMultimap<String, Object> checkLocalTypesForDuplications(InterfaceSignatureDefinition decl) {
        HashMultimap _xblockexpression = null;
        HashMultimap multiMap = super.checkDuplicationsInImportedTypes((ModelContainer)decl);
        List<InterfaceEvent> events = InterfaceUtilities.getAllInterfaceEvents(decl.getSignature());
        EList<TypeDecl> _types = decl.getSignature().getTypes();
        for (TypeDecl tLocal : _types) {
            boolean _containsKey = multiMap.containsKey((Object)tLocal.getName());
            if (_containsKey) {
                this.error("Type with the same name is already imported", (EObject)tLocal, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
                continue;
            }
            multiMap.put((Object)tLocal.getName(), (Object)tLocal);
        }
        for (InterfaceEvent ev : events) {
            boolean _containsKey_1 = multiMap.containsKey((Object)ev.getName());
            if (!_containsKey_1) continue;
            this.error("Interface event duplicates type name", (EObject)ev, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
        _xblockexpression = multiMap;
        return _xblockexpression;
    }

    @Check
    public void checkDuplicatedParameters(InterfaceEvent e) {
        this.checkForNameDuplications((Iterable)e.getParameters(), "parameter", null, new String[0]);
    }

    @Check
    public void checkParameterDirection(InterfaceEvent e) {
        if (e instanceof Notification || e instanceof Signal) {
            EList<Parameter> _parameters = e.getParameters();
            for (Parameter p : _parameters) {
                boolean _notEquals;
                DIRECTION _direction = p.getDirection();
                boolean bl = _notEquals = !Objects.equal((Object)((Object)_direction), (Object)((Object)DIRECTION.IN));
                if (!_notEquals) continue;
                this.error("Direction of parameters in notifications and signals must be IN", (EStructuralFeature)InterfaceSignaturePackage.Literals.INTERFACE_EVENT__PARAMETERS, e.getParameters().indexOf((Object)p));
            }
        }
    }

    @Check
    public void checkDuplicatedInterfaceEvents(Signature s) {
        this.checkForNameDuplications(InterfaceUtilities.getAllInterfaceEvents(s), "interface event", null, new String[0]);
    }

    @Check
    public void checkComment(InterfaceEvent ev) {
        boolean _not;
        String _documentation = this.documentationProvider.getDocumentation((EObject)ev);
        InterfaceEventComment evComment = new InterfaceEventComment(ev, _documentation);
        boolean _isValid = evComment.isValid();
        boolean bl = _not = !_isValid;
        if (_not) {
            this.warning(evComment.getErrorMessage(), (EObject)ev, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkForVoidType(Type t) {
        if (t.getType() instanceof SimpleTypeDecl && t.getType().getName().equals("void")) {
            boolean _not;
            EObject _eContainer = t.eContainer();
            boolean bl = _not = !(_eContainer instanceof Command);
            if (_not) {
                this.error("Usage of type void is not allowed", (EStructuralFeature)TypesPackage.Literals.TYPE__TYPE);
            }
        }
    }
}

