/*
 * Copyright (c) 2017 Goldman Sachs and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableCharList extends ImmutableCharCollection, CharList
{
    @Override
    ImmutableCharList select(CharPredicate predicate);

    @Override
    ImmutableCharList reject(CharPredicate predicate);

    /**
     * @since 9.0.
     */
    @Override
    default ImmutableCharList tap(CharProcedure procedure)
    {
        this.forEach(procedure);
        return this;
    }

    @Override
    <V> ImmutableList<V> collect(CharToObjectFunction<? extends V> function);

    @Override
    ImmutableCharList newWith(char element);

    @Override
    ImmutableCharList newWithout(char element);

    @Override
    ImmutableCharList newWithAll(CharIterable elements);

    @Override
    ImmutableCharList newWithoutAll(CharIterable elements);

    @Override
    ImmutableCharList toReversed();

    /**
     * @since 6.0.
     */
    @Override
    ImmutableCharList distinct();

    @Override
    ImmutableCharList subList(int fromIndex, int toIndex);
}
