/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Predicate;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.Function3;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.ConcurrentMutableMap;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.procedure.MapEntryToProcedure2;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.map.mutable.AbstractMutableMap;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.MapIterate;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

public final class ConcurrentHashMap<K, V>
extends AbstractMutableMap<K, V>
implements ConcurrentMutableMap<K, V>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Object RESIZE_SENTINEL = new Object();
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final AtomicReferenceFieldUpdater<ConcurrentHashMap, AtomicReferenceArray> TABLE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ConcurrentHashMap.class, AtomicReferenceArray.class, "table");
    private static final AtomicIntegerFieldUpdater<ConcurrentHashMap> SIZE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ConcurrentHashMap.class, "size");
    private static final Object RESIZED = new Object();
    private static final Object RESIZING = new Object();
    private static final int PARTITIONED_SIZE_THRESHOLD = 4096;
    private static final int SIZE_BUCKETS = 7;
    private volatile AtomicReferenceArray table;
    private AtomicIntegerArray partitionedSize;
    private volatile int size;

    public ConcurrentHashMap() {
        this(16);
    }

    public ConcurrentHashMap(int initialCapacity) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        int threshold = initialCapacity;
        threshold += threshold >> 1;
        for (capacity = 1; capacity < threshold; capacity <<= 1) {
        }
        if (capacity >= 4096) {
            this.partitionedSize = new AtomicIntegerArray(112);
        }
        this.table = new AtomicReferenceArray(capacity + 1);
    }

    public static <K, V> ConcurrentHashMap<K, V> newMap() {
        return new ConcurrentHashMap<K, V>();
    }

    public static <K, V> ConcurrentHashMap<K, V> newMap(int newSize) {
        return new ConcurrentHashMap<K, V>(newSize);
    }

    private static int indexFor(int h, int length) {
        return h & length - 2;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        int length;
        Object o;
        int hash = this.hash(key);
        AtomicReferenceArray currentArray = this.table;
        while (true) {
            int index;
            if ((o = currentArray.get(index = ConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                Object candidate = e.getKey();
                if (!candidate.equals(key)) continue;
                return e.getValue();
            }
            Entry newEntry = new Entry(key, value, (Entry)o);
            if (currentArray.compareAndSet(index, o, newEntry)) break;
        }
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return null;
    }

    private void incrementSizeAndPossiblyResize(AtomicReferenceArray currentArray, int length, Object prev) {
        int threshold;
        int localSize;
        this.addToSize(1);
        if (prev != null && (localSize = this.size()) + 1 > (threshold = (length >> 1) + (length >> 2))) {
            this.resize(currentArray);
        }
    }

    private int hash(Object key) {
        int h = key.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h;
    }

    private AtomicReferenceArray helpWithResizeWhileCurrentIndex(AtomicReferenceArray currentArray, int index) {
        AtomicReferenceArray newArray = this.helpWithResize(currentArray);
        int helpCount = 0;
        while (currentArray.get(index) != RESIZED) {
            newArray = this.helpWithResize(currentArray);
            if ((++helpCount & 7) != 0) continue;
            Thread.yield();
        }
        return newArray;
    }

    private AtomicReferenceArray helpWithResize(AtomicReferenceArray currentArray) {
        ResizeContainer resizeContainer = (ResizeContainer)currentArray.get(currentArray.length() - 1);
        AtomicReferenceArray newTable = resizeContainer.nextArray;
        if (resizeContainer.getQueuePosition() > ResizeContainer.QUEUE_INCREMENT) {
            resizeContainer.incrementResizer();
            this.reverseTransfer(currentArray, resizeContainer);
            resizeContainer.decrementResizerAndNotify();
        }
        return newTable;
    }

    private void resize(AtomicReferenceArray oldTable) {
        this.resize(oldTable, (oldTable.length() - 1 << 1) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resize(AtomicReferenceArray oldTable, int newSize) {
        int oldCapacity = oldTable.length();
        int end = oldCapacity - 1;
        Object last = oldTable.get(end);
        if (this.size() < end && last == RESIZE_SENTINEL) {
            return;
        }
        if (oldCapacity >= 0x40000000) {
            throw new RuntimeException("index is too large!");
        }
        ResizeContainer resizeContainer = null;
        boolean ownResize = false;
        if (last == null || last == RESIZE_SENTINEL) {
            AtomicReferenceArray atomicReferenceArray = oldTable;
            synchronized (atomicReferenceArray) {
                if (oldTable.get(end) == null) {
                    oldTable.set(end, RESIZE_SENTINEL);
                    if (this.partitionedSize == null && newSize >= 4096) {
                        this.partitionedSize = new AtomicIntegerArray(112);
                    }
                    resizeContainer = new ResizeContainer(new AtomicReferenceArray(newSize), oldTable.length() - 1);
                    oldTable.set(end, resizeContainer);
                    ownResize = true;
                }
            }
        }
        if (ownResize) {
            this.transfer(oldTable, resizeContainer);
            AtomicReferenceArray src = this.table;
            while (!TABLE_UPDATER.compareAndSet(this, oldTable, resizeContainer.nextArray)) {
                if (src == oldTable) continue;
                this.helpWithResize(src);
            }
        } else {
            this.helpWithResize(oldTable);
        }
    }

    private void transfer(AtomicReferenceArray src, ResizeContainer resizeContainer) {
        AtomicReferenceArray dest = resizeContainer.nextArray;
        int j = 0;
        while (j < src.length() - 1) {
            Object o = src.get(j);
            if (o == null) {
                if (!src.compareAndSet(j, null, RESIZED)) continue;
                ++j;
                continue;
            }
            if (o == RESIZED || o == RESIZING) {
                j = (j & ~(ResizeContainer.QUEUE_INCREMENT - 1)) + ResizeContainer.QUEUE_INCREMENT;
                if (resizeContainer.resizers.get() != 1) continue;
                break;
            }
            if (!src.compareAndSet(j, o, RESIZING)) continue;
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                this.unconditionalCopy(dest, e);
            }
            src.set(j, RESIZED);
            ++j;
        }
        resizeContainer.decrementResizerAndNotify();
        resizeContainer.waitForAllResizers();
    }

    private void reverseTransfer(AtomicReferenceArray src, ResizeContainer resizeContainer) {
        AtomicReferenceArray dest = resizeContainer.nextArray;
        while (resizeContainer.getQueuePosition() > 0) {
            int start = resizeContainer.subtractAndGetQueuePosition();
            int end = start + ResizeContainer.QUEUE_INCREMENT;
            if (end <= 0) continue;
            if (start < 0) {
                start = 0;
            }
            int j = end - 1;
            while (j >= start) {
                Object o = src.get(j);
                if (o == null) {
                    if (!src.compareAndSet(j, null, RESIZED)) continue;
                    --j;
                    continue;
                }
                if (o == RESIZED || o == RESIZING) {
                    resizeContainer.zeroOutQueuePosition();
                    return;
                }
                if (!src.compareAndSet(j, o, RESIZING)) continue;
                for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                    this.unconditionalCopy(dest, e);
                }
                src.set(j, RESIZED);
                --j;
            }
        }
    }

    private void unconditionalCopy(AtomicReferenceArray dest, Entry<K, V> toCopyEntry) {
        int hash = this.hash(toCopyEntry.getKey());
        AtomicReferenceArray currentArray = dest;
        while (true) {
            int length;
            int index;
            Object o;
            if ((o = currentArray.get(index = ConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = ((ResizeContainer)currentArray.get(length - 1)).nextArray;
                continue;
            }
            Entry<K, V> newEntry = o == null ? (toCopyEntry.getNext() == null ? toCopyEntry : new Entry((Object)toCopyEntry.getKey(), (Object)toCopyEntry.getValue())) : new Entry(toCopyEntry.getKey(), toCopyEntry.getValue(), (Entry)o);
            if (currentArray.compareAndSet(index, o, newEntry)) break;
        }
    }

    @Override
    public V getIfAbsentPut(K key, Function<? super K, ? extends V> factory) {
        return this.getIfAbsentPutWith(key, factory, key);
    }

    @Override
    public V getIfAbsentPut(K key, Function0<? extends V> factory) {
        int length;
        Object o;
        int hash = this.hash(key);
        AtomicReferenceArray currentArray = this.table;
        V newValue = null;
        boolean createdValue = false;
        while (true) {
            Entry newEntry;
            int index;
            if ((o = currentArray.get(index = ConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                Object candidate = e.getKey();
                if (!candidate.equals(key)) continue;
                return e.getValue();
            }
            if (!createdValue) {
                createdValue = true;
                newValue = factory.value();
            }
            if (currentArray.compareAndSet(index, o, newEntry = new Entry(key, newValue, (Entry)o))) break;
        }
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return newValue;
    }

    @Override
    public V getIfAbsentPut(K key, V value) {
        int length;
        Object o;
        int hash = this.hash(key);
        AtomicReferenceArray currentArray = this.table;
        while (true) {
            int index;
            if ((o = currentArray.get(index = ConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                Object candidate = e.getKey();
                if (!candidate.equals(key)) continue;
                return e.getValue();
            }
            Entry newEntry = new Entry(key, value, (Entry)o);
            if (currentArray.compareAndSet(index, o, newEntry)) break;
        }
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return value;
    }

    public <P1, P2> V putIfAbsentGetIfPresent(K key, Function2<? super K, ? super V, ? extends K> keyTransformer, Function3<P1, P2, ? super K, ? extends V> factory, P1 param1, P2 param2) {
        int length;
        Object o;
        int hash = this.hash(key);
        AtomicReferenceArray currentArray = this.table;
        Object newValue = null;
        boolean createdValue = false;
        while (true) {
            Entry newEntry;
            int index;
            if ((o = currentArray.get(index = ConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                Object candidate = e.getKey();
                if (!candidate.equals(key)) continue;
                return e.getValue();
            }
            if (!createdValue) {
                createdValue = true;
                newValue = factory.value(param1, param2, key);
                if (newValue == null) {
                    return null;
                }
                key = keyTransformer.value(key, newValue);
            }
            if (currentArray.compareAndSet(index, o, newEntry = new Entry(key, newValue, (Entry)o))) break;
        }
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean remove(Object key, Object value) {
        hash = this.hash(key);
        currentArray = this.table;
        block0: while (true) {
            if ((o = currentArray.get(index = ConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == ConcurrentHashMap.RESIZED || o == ConcurrentHashMap.RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (e = (Entry<K, V>)o; e != null; e = e.getNext()) {
                candidate = e.getKey();
                if (!candidate.equals(key) || !this.nullSafeEquals(e.getValue(), value)) continue;
                replacement = this.createReplacementChainForRemoval((Entry)o, e);
                if (currentArray.compareAndSet(index, o, replacement)) ** break;
                continue block0;
                this.addToSize(-1);
                return true;
            }
            break;
        }
        return false;
    }

    private void addToSize(int value) {
        if (this.partitionedSize != null && this.incrementPartitionedSize(value)) {
            return;
        }
        this.incrementLocalSize(value);
    }

    private boolean incrementPartitionedSize(int value) {
        int h = (int)Thread.currentThread().getId();
        h ^= h >>> 18 ^ h >>> 12;
        if ((h = (h ^ h >>> 10) & 7) != 0) {
            int localSize;
            h = h - 1 << 4;
            while (!this.partitionedSize.compareAndSet(h, localSize = this.partitionedSize.get(h), localSize + value)) {
            }
            return true;
        }
        return false;
    }

    private void incrementLocalSize(int value) {
        int localSize;
        while (!SIZE_UPDATER.compareAndSet(this, localSize = this.size, localSize + value)) {
        }
    }

    @Override
    public int size() {
        int localSize = this.size;
        if (this.partitionedSize != null) {
            for (int i = 0; i < 7; ++i) {
                localSize += this.partitionedSize.get(i << 4);
            }
        }
        return localSize;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        ResizeContainer resizeContainer;
        AtomicReferenceArray currentArray = this.table;
        do {
            resizeContainer = null;
            for (int i = 0; i < currentArray.length() - 1; ++i) {
                Object o = currentArray.get(i);
                if (o == RESIZED || o == RESIZING) {
                    resizeContainer = (ResizeContainer)currentArray.get(currentArray.length() - 1);
                    continue;
                }
                if (o == null) continue;
                for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                    Object v = e.getValue();
                    if (!this.nullSafeEquals(v, value)) continue;
                    return true;
                }
            }
            if (resizeContainer == null) continue;
            if (resizeContainer.isNotDone()) {
                this.helpWithResize(currentArray);
                resizeContainer.waitForAllResizers();
            }
            currentArray = resizeContainer.nextArray;
        } while (resizeContainer != null);
        return false;
    }

    private boolean nullSafeEquals(Object v, Object value) {
        return v == value || v != null && v.equals(value);
    }

    @Override
    public V get(Object key) {
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(key);
        int index = ConcurrentHashMap.indexFor(hash, currentArray.length());
        Object o = currentArray.get(index);
        if (o == RESIZED || o == RESIZING) {
            return this.slowGet(key, hash, index, currentArray);
        }
        for (Entry e = (Entry)o; e != null; e = e.getNext()) {
            Object k = e.key;
            if (k != key && !key.equals(k)) continue;
            return (V)e.value;
        }
        return null;
    }

    private V slowGet(Object key, int hash, int index, AtomicReferenceArray currentArray) {
        int length;
        Object o;
        while ((o = currentArray.get(index = ConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
            currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
        }
        for (Entry e = (Entry)o; e != null; e = e.getNext()) {
            Object candidate = e.getKey();
            if (!candidate.equals(key)) continue;
            return e.getValue();
        }
        return null;
    }

    private Entry<K, V> getEntry(Object key) {
        int length;
        int index;
        Object o;
        int hash = this.hash(key);
        AtomicReferenceArray currentArray = this.table;
        while ((o = currentArray.get(index = ConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
            currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
        }
        for (Entry e = (Entry)o; e != null; e = e.getNext()) {
            Object candidate = e.getKey();
            if (!candidate.equals(key)) continue;
            return e;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(key);
        int index = ConcurrentHashMap.indexFor(hash, length = currentArray.length());
        Object o = currentArray.get(index);
        if (o == null) {
            Entry newEntry = new Entry(key, value, null);
            this.addToSize(1);
            if (currentArray.compareAndSet(index, null, newEntry)) {
                return null;
            }
            this.addToSize(-1);
        }
        return this.slowPut(key, value, hash, currentArray);
    }

    private V slowPut(K key, V value, int hash, AtomicReferenceArray currentArray) {
        int length;
        Object o;
        block0: while (true) {
            int index;
            if ((o = currentArray.get(index = ConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                Object candidate = e.getKey();
                if (!candidate.equals(key)) continue;
                Object oldValue = e.getValue();
                Entry newEntry = new Entry(e.getKey(), value, this.createReplacementChainForRemoval((Entry)o, e));
                if (!currentArray.compareAndSet(index, o, newEntry)) continue block0;
                return oldValue;
            }
            Entry newEntry = new Entry(key, value, (Entry)o);
            if (currentArray.compareAndSet(index, o, newEntry)) break;
        }
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return null;
    }

    public void putAllInParallel(Map<? extends K, ? extends V> map, int chunks, Executor executor) {
        if (this.size() == 0) {
            int capacity;
            int threshold = map.size();
            threshold += threshold >> 1;
            for (capacity = 1; capacity < threshold; capacity <<= 1) {
            }
            this.resize(this.table, capacity + 1);
        }
        if (map instanceof ConcurrentHashMap && chunks > 1 && map.size() > 50000) {
            int i;
            ConcurrentHashMap incoming = (ConcurrentHashMap)map;
            AtomicReferenceArray currentArray = incoming.table;
            FutureTask[] futures = new FutureTask[chunks];
            int chunkSize = currentArray.length() / chunks;
            if (currentArray.length() % chunks != 0) {
                ++chunkSize;
            }
            for (i = 0; i < chunks; ++i) {
                int start = i * chunkSize;
                int end = Math.min((i + 1) * chunkSize, currentArray.length());
                futures[i] = new FutureTask<Object>(() -> this.sequentialPutAll(currentArray, start, end), null);
                executor.execute(futures[i]);
            }
            for (i = 0; i < chunks; ++i) {
                try {
                    futures[i].get();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("parallelForEachKeyValue failed", e);
                }
            }
        } else {
            this.putAll(map);
        }
    }

    private void sequentialPutAll(AtomicReferenceArray currentArray, int start, int end) {
        for (int i = start; i < end; ++i) {
            Object o = currentArray.get(i);
            if (o == RESIZED || o == RESIZING) {
                throw new ConcurrentModificationException("can't iterate while resizing!");
            }
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                Object key = e.getKey();
                Object value = e.getValue();
                this.put(key, value);
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        MapIterate.forEachKeyValue(map, this::put);
    }

    @Override
    public void clear() {
        ResizeContainer resizeContainer;
        AtomicReferenceArray currentArray = this.table;
        do {
            resizeContainer = null;
            for (int i = 0; i < currentArray.length() - 1; ++i) {
                Object o = currentArray.get(i);
                if (o == RESIZED || o == RESIZING) {
                    resizeContainer = (ResizeContainer)currentArray.get(currentArray.length() - 1);
                    continue;
                }
                if (o == null) continue;
                if (!currentArray.compareAndSet(i, o, null)) continue;
                int removedEntries = 0;
                for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                    ++removedEntries;
                }
                this.addToSize(-removedEntries);
            }
            if (resizeContainer == null) continue;
            if (resizeContainer.isNotDone()) {
                this.helpWithResize(currentArray);
                resizeContainer.waitForAllResizers();
            }
            currentArray = resizeContainer.nextArray;
        } while (resizeContainer != null);
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(key);
        int index = ConcurrentHashMap.indexFor(hash, length = currentArray.length());
        Object o = currentArray.get(index);
        if (o == RESIZED || o == RESIZING) {
            return this.slowReplace(key, oldValue, newValue, hash, currentArray);
        }
        for (Entry e = (Entry)o; e != null; e = e.getNext()) {
            Object candidate = e.getKey();
            if (candidate != key && !candidate.equals(key)) continue;
            if (oldValue == e.getValue() || oldValue != null && oldValue.equals(e.getValue())) {
                Entry replacement = this.createReplacementChainForRemoval((Entry)o, e);
                Entry newEntry = new Entry(key, newValue, replacement);
                return currentArray.compareAndSet(index, o, newEntry) || this.slowReplace(key, oldValue, newValue, hash, currentArray);
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean slowReplace(K key, V oldValue, V newValue, int hash, AtomicReferenceArray currentArray) {
        block0: while (true) {
            int length;
            int index;
            Object o;
            if ((o = currentArray.get(index = ConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                Object candidate = e.getKey();
                if (candidate != key && !candidate.equals(key)) continue;
                if (oldValue != e.getValue() && (oldValue == null || !oldValue.equals(e.getValue()))) return false;
                Entry replacement = this.createReplacementChainForRemoval((Entry)o, e);
                Entry newEntry = new Entry(key, newValue, replacement);
                if (currentArray.compareAndSet(index, o, newEntry)) return true;
                continue block0;
            }
            break;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(key);
        int index = ConcurrentHashMap.indexFor(hash, length = currentArray.length());
        Object o = currentArray.get(index);
        if (o == null) {
            return null;
        }
        return this.slowReplace(key, value, hash, currentArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private V slowReplace(K key, V value, int hash, AtomicReferenceArray currentArray) {
        block0: while (true) {
            int length;
            int index;
            Object o;
            if ((o = currentArray.get(index = ConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                Object candidate = e.getKey();
                if (!candidate.equals(key)) continue;
                Object oldValue = e.getValue();
                Entry newEntry = new Entry(e.getKey(), value, this.createReplacementChainForRemoval((Entry)o, e));
                if (currentArray.compareAndSet(index, o, newEntry)) return oldValue;
                continue block0;
            }
            break;
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(key);
        int index = ConcurrentHashMap.indexFor(hash, length = currentArray.length());
        Object o = currentArray.get(index);
        if (o == RESIZED || o == RESIZING) {
            return this.slowRemove(key, hash, currentArray);
        }
        for (Entry e = (Entry)o; e != null; e = e.getNext()) {
            Object candidate = e.getKey();
            if (!candidate.equals(key)) continue;
            Entry replacement = this.createReplacementChainForRemoval((Entry)o, e);
            if (currentArray.compareAndSet(index, o, replacement)) {
                this.addToSize(-1);
                return e.getValue();
            }
            return this.slowRemove(key, hash, currentArray);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private V slowRemove(Object key, int hash, AtomicReferenceArray currentArray) {
        block0: while (true) {
            if ((o = currentArray.get(index = ConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == ConcurrentHashMap.RESIZED || o == ConcurrentHashMap.RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (e = (Entry<K, V>)o; e != null; e = e.getNext()) {
                candidate = e.getKey();
                if (!candidate.equals(key)) continue;
                replacement = this.createReplacementChainForRemoval((Entry)o, e);
                if (currentArray.compareAndSet(index, o, replacement)) ** break;
                continue block0;
                this.addToSize(-1);
                return e.getValue();
            }
            break;
        }
        return null;
    }

    private Entry<K, V> createReplacementChainForRemoval(Entry<K, V> original, Entry<K, V> toRemove) {
        if (original == toRemove) {
            return original.getNext();
        }
        Entry replacement = null;
        for (Entry<K, V> e = original; e != null; e = e.getNext()) {
            if (e == toRemove) continue;
            replacement = new Entry(e.getKey(), e.getValue(), replacement);
        }
        return replacement;
    }

    public void parallelForEachKeyValue(List<Procedure2<K, V>> blocks, Executor executor) {
        AtomicReferenceArray currentArray = this.table;
        int chunks = blocks.size();
        if (chunks > 1) {
            int i;
            FutureTask[] futures = new FutureTask[chunks];
            int chunkSize = currentArray.length() / chunks;
            if (currentArray.length() % chunks != 0) {
                ++chunkSize;
            }
            for (i = 0; i < chunks; ++i) {
                int start = i * chunkSize;
                int end = Math.min((i + 1) * chunkSize, currentArray.length());
                Procedure2<K, V> block = blocks.get(i);
                futures[i] = new FutureTask<Object>(() -> this.sequentialForEachKeyValue(block, currentArray, start, end), null);
                executor.execute(futures[i]);
            }
            for (i = 0; i < chunks; ++i) {
                try {
                    futures[i].get();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("parallelForEachKeyValue failed", e);
                }
            }
        } else {
            this.sequentialForEachKeyValue(blocks.get(0), currentArray, 0, currentArray.length());
        }
    }

    private void sequentialForEachKeyValue(Procedure2<? super K, ? super V> block, AtomicReferenceArray currentArray, int start, int end) {
        for (int i = start; i < end; ++i) {
            Object o = currentArray.get(i);
            if (o == RESIZED || o == RESIZING) {
                throw new ConcurrentModificationException("can't iterate while resizing!");
            }
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                Object key = e.getKey();
                Object value = e.getValue();
                block.value(key, value);
            }
        }
    }

    public void parallelForEachValue(List<Procedure<V>> blocks, Executor executor) {
        AtomicReferenceArray currentArray = this.table;
        int chunks = blocks.size();
        if (chunks > 1) {
            int i;
            FutureTask[] futures = new FutureTask[chunks];
            int chunkSize = currentArray.length() / chunks;
            if (currentArray.length() % chunks != 0) {
                ++chunkSize;
            }
            for (i = 0; i < chunks; ++i) {
                int start = i * chunkSize;
                int end = Math.min((i + 1) * chunkSize, currentArray.length() - 1);
                Procedure<V> block = blocks.get(i);
                futures[i] = new FutureTask<Object>(() -> this.sequentialForEachValue(block, currentArray, start, end), null);
                executor.execute(futures[i]);
            }
            for (i = 0; i < chunks; ++i) {
                try {
                    futures[i].get();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("parallelForEachKeyValue failed", e);
                }
            }
        } else {
            this.sequentialForEachValue(blocks.get(0), currentArray, 0, currentArray.length());
        }
    }

    private void sequentialForEachValue(Procedure<V> block, AtomicReferenceArray currentArray, int start, int end) {
        for (int i = start; i < end; ++i) {
            Object o = currentArray.get(i);
            if (o == RESIZED || o == RESIZING) {
                throw new ConcurrentModificationException("can't iterate while resizing!");
            }
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                Object value = e.getValue();
                block.value(value);
            }
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        AtomicReferenceArray currentArray = this.table;
        for (int i = 0; i < currentArray.length() - 1; ++i) {
            Object o = currentArray.get(i);
            if (o == RESIZED || o == RESIZING) {
                throw new ConcurrentModificationException("can't compute hashcode while resizing!");
            }
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                Object key = e.getKey();
                Object value = e.getValue();
                h += (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
            }
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        for (Map.Entry<K, V> e : this.entrySet()) {
            K key = e.getKey();
            V value = e.getValue();
            if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = iterator.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!iterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int capacity;
        int size = in.readInt();
        for (capacity = 1; capacity < size; capacity <<= 1) {
        }
        this.table = new AtomicReferenceArray(capacity + 1);
        for (int i = 0; i < size; ++i) {
            this.put(in.readObject(), in.readObject());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size = this.size();
        out.writeInt(size);
        int count = 0;
        for (int i = 0; i < this.table.length() - 1; ++i) {
            Object o = this.table.get(i);
            if (o == RESIZED || o == RESIZING) {
                throw new ConcurrentModificationException("Can't serialize while resizing!");
            }
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                ++count;
                out.writeObject(e.getKey());
                out.writeObject(e.getValue());
            }
        }
        if (count != size) {
            throw new ConcurrentModificationException("Map changed while serializing");
        }
    }

    public static <NK, NV> ConcurrentHashMap<NK, NV> newMap(Map<NK, NV> map) {
        ConcurrentHashMap<NK, NV> result = new ConcurrentHashMap<NK, NV>(map.size());
        result.putAll(map);
        return result;
    }

    @Override
    public ConcurrentHashMap<K, V> withKeyValue(K key, V value) {
        return (ConcurrentHashMap)super.withKeyValue((Object)key, (Object)value);
    }

    @Override
    public ConcurrentHashMap<K, V> withMap(Map<? extends K, ? extends V> map) {
        return (ConcurrentHashMap)super.withMap((Map)map);
    }

    @Override
    public ConcurrentHashMap<K, V> withMapIterable(MapIterable<? extends K, ? extends V> mapIterable) {
        return (ConcurrentHashMap)super.withMapIterable((MapIterable)mapIterable);
    }

    @Override
    public ConcurrentHashMap<K, V> withAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> keyValues) {
        return (ConcurrentHashMap)super.withAllKeyValues((Iterable)keyValues);
    }

    @Override
    public ConcurrentHashMap<K, V> withAllKeyValueArguments(Pair<? extends K, ? extends V> ... keyValues) {
        return (ConcurrentHashMap)super.withAllKeyValueArguments((Pair[])keyValues);
    }

    @Override
    public ConcurrentHashMap<K, V> withoutKey(K key) {
        return (ConcurrentHashMap)super.withoutKey((Object)key);
    }

    @Override
    public ConcurrentHashMap<K, V> withoutAllKeys(Iterable<? extends K> keys) {
        return (ConcurrentHashMap)super.withoutAllKeys((Iterable)keys);
    }

    @Override
    public MutableMap<K, V> clone() {
        return ConcurrentHashMap.newMap(this);
    }

    @Override
    public <K, V> MutableMap<K, V> newEmpty(int capacity) {
        return ConcurrentHashMap.newMap();
    }

    @Override
    public boolean notEmpty() {
        return !this.isEmpty();
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        Iterate.forEachWithIndex(this.values(), objectIntProcedure);
    }

    @Override
    public Iterator<V> iterator() {
        return this.values().iterator();
    }

    @Override
    public MutableMap<K, V> newEmpty() {
        return ConcurrentHashMap.newMap();
    }

    @Override
    public ConcurrentMutableMap<K, V> tap(Procedure<? super V> procedure) {
        this.each(procedure);
        return this;
    }

    @Override
    public void forEachValue(Procedure<? super V> procedure) {
        IterableIterate.forEach(this.values(), procedure);
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        IterableIterate.forEach(this.keySet(), procedure);
    }

    @Override
    public void forEachKeyValue(Procedure2<? super K, ? super V> procedure) {
        IterableIterate.forEach(this.entrySet(), new MapEntryToProcedure2<K, V>(procedure));
    }

    @Override
    public <E> MutableMap<K, V> collectKeysAndValues(Iterable<E> iterable, Function<? super E, ? extends K> keyFunction, Function<? super E, ? extends V> valueFunction) {
        Iterate.addToMap(iterable, keyFunction, valueFunction, this);
        return this;
    }

    @Override
    public V removeKey(K key) {
        return this.remove(key);
    }

    @Override
    public <P> V getIfAbsentPutWith(K key, Function<? super P, ? extends V> function, P parameter) {
        int length;
        Object o;
        int hash = this.hash(key);
        AtomicReferenceArray currentArray = this.table;
        V newValue = null;
        boolean createdValue = false;
        while (true) {
            Entry newEntry;
            int index;
            if ((o = currentArray.get(index = ConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                Object candidate = e.getKey();
                if (!candidate.equals(key)) continue;
                return e.getValue();
            }
            if (!createdValue) {
                createdValue = true;
                newValue = function.valueOf(parameter);
            }
            if (currentArray.compareAndSet(index, o, newEntry = new Entry(key, newValue, (Entry)o))) break;
        }
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return newValue;
    }

    @Override
    public V getIfAbsent(K key, Function0<? extends V> function) {
        V result = this.get(key);
        if (result == null) {
            return function.value();
        }
        return result;
    }

    @Override
    public <P> V getIfAbsentWith(K key, Function<? super P, ? extends V> function, P parameter) {
        V result = this.get(key);
        if (result == null) {
            return function.valueOf(parameter);
        }
        return result;
    }

    @Override
    public <A> A ifPresentApply(K key, Function<? super V, ? extends A> function) {
        V result = this.get(key);
        return result == null ? null : (A)function.valueOf((V)result);
    }

    @Override
    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        Iterate.forEachWith(this.values(), procedure, parameter);
    }

    @Override
    public V updateValue(K key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        V result;
        Entry newEntry;
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(key);
        int index = ConcurrentHashMap.indexFor(hash, length = currentArray.length());
        Object o = currentArray.get(index);
        if (o == null && currentArray.compareAndSet(index, null, newEntry = new Entry(key, result = function.valueOf(factory.value()), null))) {
            this.addToSize(1);
            return result;
        }
        return this.slowUpdateValue(key, factory, function, hash, currentArray);
    }

    private V slowUpdateValue(K key, Function0<? extends V> factory, Function<? super V, ? extends V> function, int hash, AtomicReferenceArray currentArray) {
        V result;
        int length;
        Object o;
        block0: while (true) {
            int index;
            if ((o = currentArray.get(index = ConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                Object candidate = e.getKey();
                if (!candidate.equals(key)) continue;
                Object oldValue = e.getValue();
                V newValue = function.valueOf(oldValue);
                Entry newEntry = new Entry(e.getKey(), newValue, this.createReplacementChainForRemoval((Entry)o, e));
                if (!currentArray.compareAndSet(index, o, newEntry)) continue block0;
                return newValue;
            }
            result = function.valueOf(factory.value());
            Entry newEntry = new Entry(key, result, (Entry)o);
            if (currentArray.compareAndSet(index, o, newEntry)) break;
        }
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return result;
    }

    @Override
    public <P> V updateValueWith(K key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        V result;
        Entry newEntry;
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(key);
        int index = ConcurrentHashMap.indexFor(hash, length = currentArray.length());
        Object o = currentArray.get(index);
        if (o == null && currentArray.compareAndSet(index, null, newEntry = new Entry(key, result = function.value(factory.value(), parameter), null))) {
            this.addToSize(1);
            return result;
        }
        return this.slowUpdateValueWith(key, factory, function, parameter, hash, currentArray);
    }

    private <P> V slowUpdateValueWith(K key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter, int hash, AtomicReferenceArray currentArray) {
        V result;
        int length;
        Object o;
        block0: while (true) {
            int index;
            if ((o = currentArray.get(index = ConcurrentHashMap.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            for (Entry e = (Entry)o; e != null; e = e.getNext()) {
                Object candidate = e.getKey();
                if (!candidate.equals(key)) continue;
                Object oldValue = e.getValue();
                V newValue = function.value(oldValue, parameter);
                Entry newEntry = new Entry(e.getKey(), newValue, this.createReplacementChainForRemoval((Entry)o, e));
                if (!currentArray.compareAndSet(index, o, newEntry)) continue block0;
                return newValue;
            }
            result = function.value(factory.value(), parameter);
            Entry newEntry = new Entry(key, result, (Entry)o);
            if (currentArray.compareAndSet(index, o, newEntry)) break;
        }
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
        return result;
    }

    @Override
    public ImmutableMap<K, V> toImmutable() {
        return Maps.immutable.ofMap(this);
    }

    private static final class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;
        private final Entry<K, V> next;

        private Entry(K key, V value) {
            this.key = key;
            this.value = value;
            this.next = null;
        }

        private Entry(K key, V value, Entry<K, V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new RuntimeException("not implemented");
        }

        public Entry<K, V> getNext() {
            return this.next;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            K k1 = this.key;
            Map.Entry e = (Map.Entry)o;
            Object k2 = e.getKey();
            if (k1 == k2 || k1 != null && k1.equals(k2)) {
                V v1 = this.value;
                Object v2 = e.getValue();
                return v1 == v2 || v1 != null && v1.equals(v2);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }

        @Override
        public void remove() {
            this.removeByKeyValue();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean removeAll(Collection<?> col) {
            Objects.requireNonNull(col);
            boolean removed = false;
            if (this.size() > col.size()) {
                for (Object o : col) {
                    removed |= this.remove(o);
                }
            } else {
                EntryIterator itr = new EntryIterator();
                while (itr.hasNext()) {
                    if (!col.contains(itr.next())) continue;
                    removed |= itr.removeByKeyValue();
                }
            }
            return removed;
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<K, V>> filter) {
            Objects.requireNonNull(filter);
            boolean removed = false;
            EntryIterator itr = new EntryIterator();
            while (itr.hasNext()) {
                if (!filter.test((Map.Entry)itr.next())) continue;
                removed |= itr.removeByKeyValue();
            }
            return removed;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Entry candidate = ConcurrentHashMap.this.getEntry(e.getKey());
            return e.equals(candidate);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentHashMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        private List<IteratorState> todo;
        private IteratorState currentState;
        private Entry<K, V> next;
        private int index;
        private Entry<K, V> current;

        protected HashIterator() {
            this.currentState = new IteratorState(ConcurrentHashMap.this.table);
            this.findNext();
        }

        private void findNext() {
            while (this.index < this.currentState.end) {
                Object o = this.currentState.currentTable.get(this.index);
                if (o == RESIZED || o == RESIZING) {
                    int endResized;
                    AtomicReferenceArray nextArray = ConcurrentHashMap.this.helpWithResizeWhileCurrentIndex(this.currentState.currentTable, this.index);
                    for (endResized = this.index + 1; endResized < this.currentState.end && this.currentState.currentTable.get(endResized) == RESIZED; ++endResized) {
                    }
                    if (this.todo == null) {
                        this.todo = new FastList<IteratorState>(4);
                    }
                    if (endResized < this.currentState.end) {
                        this.todo.add(new IteratorState(this.currentState.currentTable, endResized, this.currentState.end));
                    }
                    int powerTwoLength = this.currentState.currentTable.length() - 1;
                    this.todo.add(new IteratorState(nextArray, this.index + powerTwoLength, endResized + powerTwoLength));
                    this.currentState.currentTable = nextArray;
                    this.currentState.end = endResized;
                    this.currentState.start = this.index;
                    continue;
                }
                if (o != null) {
                    this.next = (Entry)o;
                    ++this.index;
                    break;
                }
                ++this.index;
            }
            if (this.next == null && this.index == this.currentState.end && this.todo != null && !this.todo.isEmpty()) {
                this.currentState = this.todo.remove(this.todo.size() - 1);
                this.index = this.currentState.start;
                this.findNext();
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K, V> nextEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.getNext();
            if (this.next == null) {
                this.findNext();
            }
            this.current = e;
            return e;
        }

        protected void removeByKey() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object key = this.current.key;
            this.current = null;
            ConcurrentHashMap.this.remove(key);
        }

        protected boolean removeByKeyValue() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object key = this.current.key;
            Object val = this.current.value;
            this.current = null;
            return ConcurrentHashMap.this.remove(key, val);
        }
    }

    private static final class IteratorState {
        private AtomicReferenceArray currentTable;
        private int start;
        private int end;

        private IteratorState(AtomicReferenceArray currentTable) {
            this.currentTable = currentTable;
            this.end = this.currentTable.length() - 1;
        }

        private IteratorState(AtomicReferenceArray currentTable, int start, int end) {
            this.currentTable = currentTable;
            this.start = start;
            this.end = end;
        }
    }

    private final class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }

        @Override
        public void remove() {
            this.removeByKey();
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    private static final class ResizeContainer {
        private static final int QUEUE_INCREMENT = Math.min(1024, Integer.highestOneBit(Runtime.getRuntime().availableProcessors()) << 4);
        private final AtomicInteger resizers = new AtomicInteger(1);
        private final AtomicReferenceArray nextArray;
        private final AtomicInteger queuePosition;

        private ResizeContainer(AtomicReferenceArray nextArray, int oldSize) {
            this.nextArray = nextArray;
            this.queuePosition = new AtomicInteger(oldSize);
        }

        public void incrementResizer() {
            this.resizers.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decrementResizerAndNotify() {
            int remaining = this.resizers.decrementAndGet();
            if (remaining == 0) {
                ResizeContainer resizeContainer = this;
                synchronized (resizeContainer) {
                    this.notifyAll();
                }
            }
        }

        public int getQueuePosition() {
            return this.queuePosition.get();
        }

        public int subtractAndGetQueuePosition() {
            return this.queuePosition.addAndGet(-QUEUE_INCREMENT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForAllResizers() {
            if (this.resizers.get() > 0) {
                int i;
                for (i = 0; i < 16 && this.resizers.get() != 0; ++i) {
                }
                for (i = 0; i < 16 && this.resizers.get() != 0; ++i) {
                    Thread.yield();
                }
            }
            if (this.resizers.get() > 0) {
                ResizeContainer resizeContainer = this;
                synchronized (resizeContainer) {
                    while (this.resizers.get() > 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        public boolean isNotDone() {
            return this.resizers.get() > 0;
        }

        public void zeroOutQueuePosition() {
            this.queuePosition.set(0);
        }
    }

    private final class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public void remove() {
            this.removeByKeyValue();
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean removeAll(Collection<?> col) {
            Objects.requireNonNull(col);
            boolean removed = false;
            ValueIterator itr = new ValueIterator();
            while (itr.hasNext()) {
                if (!col.contains(itr.next())) continue;
                removed |= itr.removeByKeyValue();
            }
            return removed;
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter) {
            Objects.requireNonNull(filter);
            boolean removed = false;
            ValueIterator itr = new ValueIterator();
            while (itr.hasNext()) {
                if (!filter.test(itr.next())) continue;
                removed |= itr.removeByKeyValue();
            }
            return removed;
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }
}

