/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import java.io.IOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;

public class CloudErrorUtil {
    private CloudErrorUtil() {
    }

    public static String getConnectionError(CoreException e) {
        String error = CloudErrorUtil.getInvalidCredentialsError(e);
        if (error == null) {
            if (CloudErrorUtil.isUnknownHostException(e)) {
                error = Messages.ERROR_UNABLE_TO_ESTABLISH_CONNECTION_UNKNOWN_HOST;
            } else if (CloudErrorUtil.isRestClientException(e)) {
                error = NLS.bind((String)Messages.ERROR_FAILED_REST_CLIENT, (Object)e.getMessage());
            }
        }
        return error;
    }

    public static CoreException checkRestException(Throwable t) {
        String error = CloudErrorUtil.getInvalidCredentialsError(t);
        if (error == null) {
            if (t instanceof ResourceAccessException && t.getCause() instanceof UnknownHostException) {
                error = Messages.ERROR_UNABLE_TO_ESTABLISH_CONNECTION_UNKNOWN_HOST;
            } else if (t instanceof RestClientException) {
                error = NLS.bind((String)Messages.ERROR_FAILED_REST_CLIENT, (Object)t.getMessage());
            }
        }
        return error != null ? CloudErrorUtil.toCoreException(error, t) : CloudErrorUtil.toCoreException(t);
    }

    public static CoreException checkServerCommunicationError(RuntimeException e) {
        if (e != null && e.getCause() instanceof IOException) {
            if (e.getCause() instanceof SSLPeerUnverifiedException) {
                return CloudErrorUtil.toCoreException(e.getCause());
            }
            String errorMessage = NLS.bind((String)Messages.ERROR_UNABLE_TO_COMMUNICATE_SERVER, (Object)e.getMessage());
            CloudFoundryPlugin.logError(errorMessage, e);
            return new CoreException((IStatus)new Status(4, "org.eclipse.cft.server.core", errorMessage));
        }
        return CloudErrorUtil.checkRestException(e);
    }

    public static boolean isConnectionError(CoreException e) {
        return CloudErrorUtil.getConnectionError(e) != null;
    }

    public static String getInvalidCredentialsError(Throwable error) {
        if (CloudErrorUtil.isUnauthorisedException(error)) {
            return Messages.ERROR_WRONG_EMAIL_OR_PASSWORD_UNAUTHORISED;
        }
        if (CloudErrorUtil.isForbiddenException(error)) {
            return Messages.ERROR_WRONG_EMAIL_OR_PASSWORD_FORBIDDEN;
        }
        OAuth2AccessDeniedException oauthException = null;
        if (error instanceof OAuth2AccessDeniedException) {
            oauthException = (OAuth2AccessDeniedException)error;
        } else if (error.getCause() instanceof OAuth2AccessDeniedException) {
            oauthException = (OAuth2AccessDeniedException)error.getCause();
        }
        if (oauthException != null) {
            return NLS.bind((String)Messages.ERROR_ACCESS_TOKEN, (Object)oauthException.getOAuth2ErrorCode());
        }
        return null;
    }

    public static boolean isWrongCredentialsException(CoreException e) {
        HttpClientErrorException httpException;
        HttpStatus statusCode;
        Throwable cause = e.getCause();
        if (cause instanceof HttpClientErrorException && (statusCode = (httpException = (HttpClientErrorException)cause).getStatusCode()).equals((Object)HttpStatus.FORBIDDEN) && httpException instanceof CloudFoundryException) {
            return ((CloudFoundryException)httpException).getDescription().equals("Operation not permitted");
        }
        return false;
    }

    public static boolean isAppStoppedStateError(Exception e) {
        String message;
        HttpClientErrorException badRequestException = CloudErrorUtil.getBadRequestException(e);
        if (badRequestException != null && (message = CloudErrorUtil.getHttpErrorMessage((HttpStatusCodeException)badRequestException)) != null) {
            return (message = message.toLowerCase()).contains("state") && message.contains("stop");
        }
        return false;
    }

    public static boolean is503Error(Throwable t) {
        String message;
        HttpServerErrorException httpException = CloudErrorUtil.getHttpServerError(t);
        if (httpException != null && (message = CloudErrorUtil.getHttpErrorMessage((HttpStatusCodeException)httpException)) != null) {
            message = message.toLowerCase();
            return message.contains("503");
        }
        return false;
    }

    public static String getHostTakenError(Exception e) {
        String message;
        HttpClientErrorException badRequestException = CloudErrorUtil.getBadRequestException(e);
        if (badRequestException != null && (message = CloudErrorUtil.getHttpErrorMessage((HttpStatusCodeException)badRequestException)) != null && (message = message.toLowerCase()).contains("host") && message.contains("taken")) {
            return Messages.ERROR_HOST_TAKEN;
        }
        return null;
    }

    protected static String getHttpErrorMessage(HttpStatusCodeException error) {
        String message = null;
        if (error instanceof CloudFoundryException) {
            message = ((CloudFoundryException)error).getDescription();
        }
        if (message == null && (message = error.getMessage()) == null && (message = error.getStatusText()) == null) {
            message = error.getResponseBodyAsString();
        }
        return message;
    }

    public static boolean isFileNotFoundForInstance(Exception e) {
        String message;
        HttpClientErrorException badRequestException = CloudErrorUtil.getBadRequestException(e);
        if (badRequestException != null && (message = CloudErrorUtil.getHttpErrorMessage((HttpStatusCodeException)badRequestException)) != null) {
            return (message = message.toLowerCase()).contains("file error") && message.contains("request failed") && message.contains("as the instance is not found");
        }
        return false;
    }

    public static boolean isRequestedFileRangeNotSatisfiable(CloudFoundryException cfe) {
        return cfe != null && HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE.equals((Object)cfe.getStatusCode());
    }

    public static HttpClientErrorException getBadRequestException(Exception t) {
        HttpStatus statusCode;
        HttpClientErrorException httpException = CloudErrorUtil.getHttpClientError(t);
        if (httpException != null && HttpStatus.BAD_REQUEST.equals((Object)(statusCode = httpException.getStatusCode()))) {
            return httpException;
        }
        return null;
    }

    protected static HttpClientErrorException getHttpClientError(Throwable t) {
        if (t == null) {
            return null;
        }
        HttpClientErrorException httpException = null;
        if (t instanceof HttpClientErrorException) {
            httpException = (HttpClientErrorException)t;
        } else {
            Throwable cause = t.getCause();
            if (cause instanceof HttpClientErrorException) {
                httpException = (HttpClientErrorException)cause;
            }
        }
        return httpException;
    }

    protected static HttpServerErrorException getHttpServerError(Throwable t) {
        if (t == null) {
            return null;
        }
        HttpServerErrorException httpException = null;
        if (t instanceof HttpServerErrorException) {
            httpException = (HttpServerErrorException)t;
        } else {
            Throwable cause = t.getCause();
            if (cause instanceof HttpServerErrorException) {
                httpException = (HttpServerErrorException)cause;
            }
        }
        return httpException;
    }

    public static CoreException toCoreException(Throwable e) {
        if (e instanceof CloudFoundryException && ((CloudFoundryException)e).getDescription() != null) {
            return new CoreException((IStatus)new Status(4, "org.eclipse.cft.server.core", NLS.bind((String)"{0} ({1})", (Object)((CloudFoundryException)e).getDescription(), (Object)e.getMessage()), e));
        }
        return new CoreException((IStatus)new Status(4, "org.eclipse.cft.server.core", NLS.bind((String)Messages.ERROR_PERFORMING_CLOUD_FOUNDRY_OPERATION, (Object)e.getMessage()), e));
    }

    public static boolean isForbiddenException(Throwable t) {
        return CloudErrorUtil.isHttpException(t, HttpStatus.FORBIDDEN);
    }

    public static boolean isUnauthorisedException(Throwable t) {
        return CloudErrorUtil.isHttpException(t, HttpStatus.UNAUTHORIZED);
    }

    public static boolean isNotFoundException(Throwable t) {
        return CloudErrorUtil.isHttpException(t, HttpStatus.NOT_FOUND);
    }

    public static boolean isHttpException(Throwable t, HttpStatus status) {
        HttpClientErrorException httpException = CloudErrorUtil.getHttpClientError(t);
        if (httpException != null) {
            HttpStatus statusCode = httpException.getStatusCode();
            return statusCode.equals((Object)status);
        }
        return false;
    }

    public static boolean isUnknownHostException(CoreException e) {
        Throwable cause = e.getStatus().getException();
        if (cause instanceof ResourceAccessException) {
            return ((ResourceAccessException)cause).getCause() instanceof UnknownHostException;
        }
        return false;
    }

    public static boolean isRestClientException(CoreException e) {
        Throwable cause = e.getStatus().getException();
        return cause instanceof RestClientException;
    }

    public static CoreException toCoreException(String message) {
        return CloudErrorUtil.toCoreException(message, null);
    }

    public static CoreException toCoreException(String message, Throwable error) {
        if (message == null) {
            message = Messages.ERROR_UNKNOWN;
        }
        if (error != null) {
            if (error.getMessage() != null) {
                message = String.valueOf(message) + " - " + error.getMessage();
            }
            return new CoreException(CloudFoundryPlugin.getErrorStatus(message, error));
        }
        return new CoreException(CloudFoundryPlugin.getErrorStatus(message));
    }

    public static CoreException asCoreException(String message, Throwable error, boolean replaceMessage) {
        if (message != null) {
            IStatus oldStatus = error instanceof CoreException ? ((CoreException)error).getStatus() : null;
            IStatus newStatus = null;
            if (oldStatus == null) {
                newStatus = CloudFoundryPlugin.getErrorStatus(message, error);
            } else {
                String enhancedMessage = replaceMessage ? message : String.valueOf(message) + " - " + oldStatus.getMessage();
                newStatus = new Status(oldStatus.getSeverity(), oldStatus.getPlugin(), oldStatus.getCode(), enhancedMessage, oldStatus.getException());
            }
            return new CoreException(newStatus);
        }
        if (error instanceof CoreException) {
            return (CoreException)error;
        }
        return new CoreException(CloudFoundryPlugin.getErrorStatus(error));
    }

    public static String getCloudFoundryErrorMessage(CloudFoundryException cfe) {
        return cfe.getMessage();
    }
}

