/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.util.ArrayList;
import java.util.List;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.Staging;
import org.eclipse.cft.server.core.CFApplicationArchive;
import org.eclipse.cft.server.core.EnvironmentVariable;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.DeploymentConfiguration;
import org.eclipse.cft.server.core.internal.client.StartOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public class PushApplicationOperation
extends StartOperation {
    public PushApplicationOperation(CloudFoundryServerBehaviour behaviour, IModule[] modules, boolean clearConsole) {
        super(behaviour, false, modules, clearConsole);
    }

    @Override
    protected DeploymentConfiguration prepareForDeployment(CloudFoundryApplicationModule appModule, IProgressMonitor monitor) throws CoreException {
        int moduleState = this.getBehaviour().getServer().getModulePublishState(new IModule[]{appModule.getLocalModule()});
        if (appModule.isDeployed() && moduleState == 1) {
            this.getBehaviour().printlnToConsole(appModule, Messages.CONSOLE_APP_FOUND);
            this.getBehaviour().printlnToConsole(appModule, NLS.bind((String)Messages.CONSOLE_APP_MAPPING_STARTED, (Object)appModule.getDeployedApplicationName()));
            try {
                this.getBehaviour().updateModuleWithBasicCloudInfo(appModule.getDeployedApplicationName(), monitor);
                this.getBehaviour().printlnToConsole(appModule, NLS.bind((String)Messages.CONSOLE_APP_MAPPING_COMPLETED, (Object)appModule.getDeployedApplicationName()));
            }
            catch (CoreException e) {
                CloudFoundryPlugin.log((IStatus)new Status(1, "org.eclipse.cft.server.core", "CoreException thrown during deployment.", (Throwable)e));
            }
        } else {
            CloudFoundryServer cloudServer = this.getBehaviour().getCloudFoundryServer();
            return CloudFoundryPlugin.getCallback().prepareForDeployment(cloudServer, appModule, monitor);
        }
        return null;
    }

    @Override
    protected void onOperationCanceled(OperationCanceledException e, IProgressMonitor monitor) throws CoreException {
        this.getBehaviour().updateModuleWithAllCloudInfo(this.getFirstModule(), monitor);
        monitor.setCanceled(true);
        CloudFoundryPlugin.log((IStatus)new Status(1, "org.eclipse.cft.server.core", "Operation cancelled during prepareForDeployment.", (Throwable)e));
    }

    @Override
    protected void pushApplication(CloudFoundryOperations client, CloudFoundryApplicationModule appModule, CFApplicationArchive applicationArchive, IProgressMonitor monitor) throws CoreException {
        CloudApplication existingApp;
        String appName;
        block11: {
            appName = appModule.getDeploymentInfo().getDeploymentName();
            existingApp = null;
            try {
                existingApp = this.getBehaviour().getCloudApplication(appName, monitor);
            }
            catch (CoreException ce) {
                if (CloudErrorUtil.isNotFoundException(ce)) break block11;
                throw ce;
            }
        }
        if (existingApp == null) {
            CoreException cloudAppCreationClientError;
            block12: {
                String creatingAppLabel = NLS.bind((String)Messages.CONSOLE_APP_CREATION, (Object)appName);
                this.getBehaviour().printlnToConsole(appModule, creatingAppLabel);
                String buildpack = appModule.getDeploymentInfo().getBuildpack();
                List<Object> uris = appModule.getDeploymentInfo().getUris() != null ? appModule.getDeploymentInfo().getUris() : new ArrayList(0);
                List<String> services = appModule.getDeploymentInfo().asServiceBindingList();
                List<EnvironmentVariable> variables = appModule.getDeploymentInfo().getEnvVariables();
                int instances = appModule.getDeploymentInfo().getInstances();
                String stack = appModule.getDeploymentInfo().getStack();
                Integer timeout = appModule.getDeploymentInfo().getTimeout();
                String command = appModule.getDeploymentInfo().getCommand();
                Staging staging = new Staging(command, buildpack, stack, timeout);
                cloudAppCreationClientError = null;
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
                subMonitor.subTask(creatingAppLabel);
                try {
                    client.createApplication(appName, staging, appModule.getDeploymentInfo().getDiskQuota(), Integer.valueOf(appModule.getDeploymentInfo().getMemory()), uris, services);
                }
                catch (Exception e) {
                    String hostTaken = CloudErrorUtil.getHostTakenError(e);
                    cloudAppCreationClientError = hostTaken != null ? CloudErrorUtil.toCoreException(hostTaken) : CloudErrorUtil.toCoreException(e);
                }
                subMonitor.worked(30);
                try {
                    CloudApplication actualApp = this.getBehaviour().getCloudApplication(appName, (IProgressMonitor)subMonitor.newChild(20));
                    if (actualApp != null) {
                        SubMonitor updateMonitor = SubMonitor.convert((IProgressMonitor)subMonitor, (int)100);
                        this.getBehaviour().getRequestFactory().getUpdateEnvVarRequest(appName, variables).run((IProgressMonitor)updateMonitor.newChild(50));
                        if (instances > 1) {
                            this.getBehaviour().updateApplicationInstances(appName, instances, (IProgressMonitor)updateMonitor.newChild(50));
                        } else {
                            updateMonitor.worked(50);
                        }
                    }
                }
                catch (CoreException ce) {
                    if (cloudAppCreationClientError != null) break block12;
                    throw ce;
                }
            }
            if (cloudAppCreationClientError != null) {
                throw cloudAppCreationClientError;
            }
        }
        super.pushApplication(client, appModule, applicationArchive, monitor);
    }

    @Override
    protected void performDeployment(CloudFoundryApplicationModule appModule, IProgressMonitor monitor) throws CoreException {
        if (!appModule.isDeployed()) {
            super.performDeployment(appModule, monitor);
        }
    }
}

