/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.application;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.cft.server.core.ArchiveEntry;
import org.eclipse.cft.server.core.CFApplicationArchive;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.application.AbstractArchiveEntry;
import org.eclipse.core.runtime.CoreException;

public class ZipArchive
implements CFApplicationArchive {
    private ZipFile zipFile;
    private List<ArchiveEntry> entries;
    private String name;

    public ZipArchive(ZipFile zipFile) {
        this.zipFile = zipFile;
        this.name = new File(zipFile.getName()).getName();
    }

    private List<ArchiveEntry> getEntries(ZipFile zipFile) {
        ArrayList<ZipArchiveEntry> entries = new ArrayList<ZipArchiveEntry>();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            entries.add(new ZipArchiveEntry(zipEntries.nextElement()));
        }
        return Collections.unmodifiableList(entries);
    }

    @Override
    public Iterable<ArchiveEntry> getEntries() {
        if (this.entries == null) {
            this.entries = this.getEntries(this.zipFile);
        }
        return this.entries;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() throws CoreException {
        try {
            if (this.zipFile != null) {
                this.zipFile.close();
            }
        }
        catch (IOException e) {
            throw CloudErrorUtil.toCoreException(e);
        }
    }

    class ZipArchiveEntry
    extends AbstractArchiveEntry {
        private ZipEntry entry;

        public ZipArchiveEntry(ZipEntry entry) {
            this.entry = entry;
        }

        @Override
        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }

        @Override
        public long getSize() {
            return this.entry.getSize();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.isDirectory()) {
                return null;
            }
            return ZipArchive.this.zipFile.getInputStream(this.entry);
        }
    }
}

