/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import org.eclipse.cft.server.ui.internal.wizards.AvailableService;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class TextCompositeLayout
extends Layout {
    final boolean isIconProviderAvailableForServerType;

    public TextCompositeLayout(boolean isIconProviderAvailableForServerType) {
        this.isIconProviderAvailableForServerType = isIconProviderAvailableForServerType;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        int[] result = this.layoutImpl(composite, wHint, flushCache, false);
        return new Point(result[0], result[1]);
    }

    protected void layout(Composite composite, boolean flushCache) {
        this.layoutImpl(composite, -1, flushCache, true);
    }

    protected int[] layoutImpl(Composite composite, int wHint, boolean flushCache, boolean apply) {
        Control[] children = composite.getChildren();
        int width = wHint > 0 ? wHint : composite.getParent().getClientArea().width;
        int x = 0;
        int y = 10;
        int c = 0;
        while (c < children.length) {
            x = 10;
            boolean isVisible = children[c + 1].getVisible();
            AvailableService service = (AvailableService)children[c].getData();
            if (!isVisible) {
                service.setAppxLocation(null);
            } else {
                Point p;
                Label imageLabel = (Label)children[c];
                if (this.isIconProviderAvailableForServerType) {
                    p = imageLabel.computeSize(32, 32, flushCache);
                    if (apply) {
                        imageLabel.setBounds(x, y + 3, p.x, p.y);
                    }
                    x += 40;
                }
                Label titleLabel = (Label)children[c + 1];
                p = titleLabel.computeSize(width - x - 20, -1, flushCache);
                if (apply) {
                    titleLabel.setBounds(x, y, p.x, p.y);
                }
                y += p.y;
                Label descLabel = (Label)children[c + 2];
                p = descLabel.computeSize(width - x - 20, -1, flushCache);
                if (apply) {
                    descLabel.setBounds(x, y, p.x, p.y);
                }
                if (apply) {
                    Rectangle topBounds = this.isIconProviderAvailableForServerType ? imageLabel.getBounds() : titleLabel.getBounds();
                    Rectangle descLabelBounds = descLabel.getBounds();
                    int rowHeight = descLabelBounds.y + descLabelBounds.height - topBounds.y;
                    service.setAppxLocation(new Rectangle(topBounds.x, topBounds.y, width - 20, rowHeight));
                }
                y += p.y;
                y += 10;
            }
            c += 3;
        }
        if (apply) {
            composite.setSize(width, y);
        }
        return new int[]{width, y};
    }
}

