/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerEvent;
import org.eclipse.cft.server.core.internal.CloudServerListener;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class CloudFoundryServerStatusSection
extends ServerEditorSection
implements CloudServerListener,
IServerListener {
    private CloudFoundryServer cfServer;
    private Text statusLabel;
    private Button connectButton;
    private Button disconnectButton;
    private Label nameLabel;
    private Composite composite;

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 258);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        section.setText(Messages.CloudFoundryServerStatusSection_TEXT_SERV_STAT);
        section.setExpanded(true);
        this.composite = toolkit.createComposite((Composite)section);
        section.setClient((Control)this.composite);
        GridLayoutFactory.fillDefaults().numColumns(4).margins(10, 5).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.composite);
        this.nameLabel = toolkit.createLabel(this.composite, "");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.nameLabel);
        this.nameLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        int borderStyleBackup = toolkit.getBorderStyle();
        try {
            toolkit.setBorderStyle(0);
            this.statusLabel = toolkit.createText(this.composite, "", 8);
        }
        finally {
            toolkit.setBorderStyle(borderStyleBackup);
        }
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.statusLabel);
        this.connectButton = toolkit.createButton(this.composite, Messages.CloudFoundryServerStatusSection_TEXT_CONN_BUTTON, 8);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.connectButton);
        this.connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Job job = new Job(Messages.CloudFoundryServerStatusSection_JOB_CONN_SERVER){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            CloudFoundryServerStatusSection.this.cfServer.getBehaviour().connect(monitor);
                        }
                        catch (CoreException e) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.cft.server.ui", "", (Throwable)e), 1);
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        });
        this.disconnectButton = toolkit.createButton(this.composite, Messages.CloudFoundryServerStatusSection_TEXT_DISCONN_BUTTON, 8);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.disconnectButton);
        this.disconnectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Job job = new Job(Messages.CloudFoundryServerStatusSection_JOB_CONN_SERVER){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            CloudFoundryServerStatusSection.this.cfServer.getBehaviour().disconnect(monitor);
                        }
                        catch (CoreException e) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.cft.server.ui", "", (Throwable)e), 1);
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        });
        this.update();
        ServerEventHandler.getDefault().addServerListener((CloudServerListener)this);
        this.cfServer.getServer().addServerListener((IServerListener)this);
    }

    private void update() {
        if (this.cfServer == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CloudFoundryServerStatusSection.this.composite != null && !CloudFoundryServerStatusSection.this.composite.isDisposed()) {
                    CloudFoundryServerStatusSection.this.nameLabel.setText(String.valueOf(CloudFoundryServerStatusSection.this.cfServer.getServer().getName()) + ": ");
                    int s = CloudFoundryServerStatusSection.this.cfServer.getServer().getServerState();
                    String statusString = Messages.CloudFoundryServerStatusSection_TEXT_NOT_CONNECTED;
                    if (s == 2) {
                        statusString = Messages.CloudFoundryServerStatusSection_TEXT_CONNECTED;
                    }
                    CloudFoundryServerStatusSection.this.statusLabel.setText(statusString);
                    CloudFoundryServerStatusSection.this.connectButton.setEnabled(s != 2);
                    CloudFoundryServerStatusSection.this.disconnectButton.setEnabled(s == 2);
                    CloudFoundryServerStatusSection.this.composite.layout(true);
                }
            }
        });
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (this.server != null) {
            this.cfServer = (CloudFoundryServer)this.server.loadAdapter(CloudFoundryServer.class, null);
        }
    }

    public void serverChanged(CloudServerEvent event) {
        this.update();
    }

    public void serverChanged(ServerEvent event) {
        this.update();
    }

    public void dispose() {
        this.cfServer.getServer().removeServerListener((IServerListener)this);
        ServerEventHandler.getDefault().removeServerListener((CloudServerListener)this);
    }
}

