/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.application;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.cloudfoundry.client.lib.archive.ApplicationArchive;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.internal.ApplicationUrlLookupService;
import org.eclipse.cft.server.core.internal.CloudApplicationURL;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryProjectUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudUtil;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.application.ApplicationDelegate;
import org.eclipse.cft.server.core.internal.application.CloudZipApplicationArchive;
import org.eclipse.cft.server.core.internal.application.ManifestParser;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResource;

public class JavaWebApplicationDelegate
extends ApplicationDelegate {
    @Override
    public boolean requiresURL() {
        return true;
    }

    @Override
    public boolean providesApplicationArchive(IModule module) {
        return true;
    }

    @Override
    public ApplicationArchive getApplicationArchive(IModule module, CloudFoundryServer cloudServer, IModuleResource[] moduleResources, IProgressMonitor monitor) throws CoreException {
        CloudFoundryApplicationModule appModule = this.getCloudFoundryApplicationModule(module, cloudServer);
        ApplicationArchive manifestArchive = JavaWebApplicationDelegate.getArchiveFromManifest(appModule, cloudServer);
        if (manifestArchive != null) {
            return manifestArchive;
        }
        try {
            File warFile = CloudUtil.createWarFile(new IModule[]{appModule.getLocalModule()}, (Server)cloudServer.getServer(), monitor);
            CloudFoundryPlugin.trace("War file " + warFile.getName() + " created");
            return new CloudZipApplicationArchive(new ZipFile(warFile));
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cft.server.core", "Failed to create war file. \nApplication: " + appModule.getApplication().getName() + "\nModule: " + appModule.getName() + "\nException: " + e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public IStatus validateDeploymentInfo(ApplicationDeploymentInfo deploymentInfo) {
        IStatus status = super.validateDeploymentInfo(deploymentInfo);
        if (status.isOK() && (deploymentInfo.getUris() == null || deploymentInfo.getUris().isEmpty())) {
            String errorMessage = Messages.JavaWebApplicationDelegate_ERROR_NO_MAPPED_APP_URL;
            status = CloudFoundryPlugin.getErrorStatus(errorMessage);
        }
        return status;
    }

    @Override
    public ApplicationDeploymentInfo getDefaultApplicationDeploymentInfo(IModule module, CloudFoundryServer cloudServer, IProgressMonitor monitor) throws CoreException {
        ApplicationDeploymentInfo info = super.getDefaultApplicationDeploymentInfo(module, cloudServer, monitor);
        if ((info.getUris() == null || info.getUris().isEmpty()) && info.getDeploymentName() != null) {
            CloudApplicationURL url = ApplicationUrlLookupService.update(cloudServer, monitor).getDefaultApplicationURL(info.getDeploymentName());
            info.setUris(Arrays.asList(url.getUrl()));
        }
        return info;
    }

    public static ApplicationArchive getArchiveFromManifest(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) throws CoreException {
        String archivePath = null;
        ManifestParser parser = new ManifestParser(appModule, cloudServer);
        if (parser.hasManifest()) {
            archivePath = parser.getApplicationProperty(null, "path");
        }
        File packagedFile = null;
        if (archivePath != null) {
            Path path = new Path(archivePath);
            if (path.getFileExtension() != null) {
                IFile projectRelativeFile = null;
                IProject project = CloudFoundryProjectUtil.getProject(appModule);
                if (project != null) {
                    projectRelativeFile = project.getFile(archivePath);
                }
                if (projectRelativeFile != null && projectRelativeFile.exists()) {
                    packagedFile = projectRelativeFile.getLocation().toFile();
                } else {
                    File absoluteFile = new File(archivePath);
                    if (absoluteFile.exists() && absoluteFile.canRead()) {
                        packagedFile = absoluteFile;
                    }
                }
            }
            if (packagedFile == null) {
                String message = NLS.bind((String)Messages.JavaWebApplicationDelegate_ERROR_FILE_NOT_FOUND_MANIFEST_YML, (Object)archivePath);
                throw CloudErrorUtil.toCoreException(message);
            }
            try {
                return new CloudZipApplicationArchive(new ZipFile(packagedFile));
            }
            catch (ZipException e) {
                throw CloudErrorUtil.toCoreException(e);
            }
            catch (IOException e) {
                throw CloudErrorUtil.toCoreException(e);
            }
        }
        return null;
    }
}

