/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryProjectUtil;
import org.eclipse.cft.server.core.internal.CloudServerEvent;
import org.eclipse.cft.server.core.internal.CloudServerListener;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.jrebel.CloudRebelAppHandler;
import org.eclipse.cft.server.ui.internal.CloudUiUtil;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModule;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CloudRebelUIHandler
extends CloudRebelAppHandler {
    private static CloudRebelAppHandler handler;

    public void register() {
        if (handler == null && CloudRebelAppHandler.isJRebelIDEInstalled()) {
            handler = this;
            ServerEventHandler.getDefault().addServerListener((CloudServerListener)handler);
        }
    }

    protected void handleRebelProject(CloudServerEvent event, IModule module, IProgressMonitor monitor) throws CoreException {
        IProject project = module.getProject();
        if (event.getType() == 700 && CloudFoundryProjectUtil.isSpringBootCloudFoundryConfigured((IProject)project)) {
            this.updateRebelXML(project, monitor);
        }
        super.handleRebelProject(event, module, monitor);
    }

    protected void updateRebelXML(IProject project, IProgressMonitor monitor) {
        try {
            IFile file = this.getRebelXMLFile(project);
            if (file != null && file.isAccessible()) {
                String path;
                String string = path = file.getRawLocation() != null ? file.getRawLocation().toString() : null;
                if (path != null) {
                    List<String> outputPaths = this.getClasspathSourceOutputPaths(project);
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = factory.newDocumentBuilder();
                    Document doc = db.parse(new File(path));
                    Node javaProjectOutputElement = null;
                    NodeList nodeList = doc.getElementsByTagName("*");
                    if (nodeList != null) {
                        String libFolderName = "lib/**";
                        String javaBuildpackFolderName = ".java-buildpack/**";
                        int i = 0;
                        while (i < nodeList.getLength()) {
                            Element element;
                            String att;
                            Node node = nodeList.item(i);
                            if (node instanceof Element && node.getNodeName().equals("dir") && (att = (element = (Element)node).getAttribute("name")) != null) {
                                for (String outpath : outputPaths) {
                                    if (!att.contains(outpath)) continue;
                                    javaProjectOutputElement = element;
                                    break;
                                }
                                if (javaProjectOutputElement != null) break;
                            }
                            ++i;
                        }
                        if (javaProjectOutputElement != null) {
                            NodeList binChildren = javaProjectOutputElement.getChildNodes();
                            Element existingExcludeLib = null;
                            Element existingExcludeJavabuildpack = null;
                            if (binChildren != null) {
                                int i2 = 0;
                                while (i2 < binChildren.getLength()) {
                                    Element excludeElement;
                                    Attr attr;
                                    Node node = binChildren.item(i2);
                                    if (node instanceof Element && node.getNodeName().equals("exclude") && (attr = (excludeElement = (Element)node).getAttributeNode("name")) != null && attr.getNodeValue() != null) {
                                        if (attr.getNodeValue().equals(libFolderName)) {
                                            existingExcludeLib = excludeElement;
                                        } else if (attr.getNodeValue().equals(javaBuildpackFolderName)) {
                                            existingExcludeJavabuildpack = excludeElement;
                                        }
                                    }
                                    ++i2;
                                }
                            }
                            Element updatedExcludeLib = null;
                            if (existingExcludeLib == null) {
                                updatedExcludeLib = doc.createElement("exclude");
                                updatedExcludeLib.setAttribute("name", libFolderName);
                                javaProjectOutputElement.appendChild(updatedExcludeLib);
                            }
                            Element updatedExcludeJavabuildpack = null;
                            if (existingExcludeJavabuildpack == null) {
                                updatedExcludeJavabuildpack = doc.createElement("exclude");
                                updatedExcludeJavabuildpack.setAttribute("name", javaBuildpackFolderName);
                                javaProjectOutputElement.appendChild(updatedExcludeJavabuildpack);
                            }
                            if (updatedExcludeLib != null || updatedExcludeJavabuildpack != null) {
                                final boolean[] proceed = new boolean[1];
                                final ArrayList<String> toexclude = new ArrayList<String>();
                                if (updatedExcludeLib != null) {
                                    toexclude.add(libFolderName);
                                }
                                if (updatedExcludeJavabuildpack != null) {
                                    toexclude.add(javaBuildpackFolderName);
                                }
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        Shell shell = CloudUiUtil.getShell();
                                        proceed[0] = shell != null && !shell.isDisposed() && MessageDialog.openQuestion((Shell)shell, (String)Messages.CloudRebelUIHandler_TEXT_REPLACE_REBEL_XML_TITLE, (String)NLS.bind((String)Messages.CloudRebelUIHandler_TEXT_REPLACE_REBEL_XML_BODY, (Object)toexclude));
                                    }
                                });
                                if (proceed[0]) {
                                    project.setPersistentProperty(new QualifiedName("org.zeroturnaround.eclipse.jrebel", "autoGenerateRebelXml"), "false");
                                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                                    transformer.setOutputProperty("indent", "yes");
                                    DOMSource source = new DOMSource(doc);
                                    StreamResult console = new StreamResult(new File(path));
                                    transformer.transform(source, console);
                                    project.refreshLocal(2, monitor);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (ParserConfigurationException e) {
            CloudFoundryPlugin.logError((Throwable)e);
        }
        catch (SAXException e) {
            CloudFoundryPlugin.logError((Throwable)e);
        }
        catch (IOException e) {
            CloudFoundryPlugin.logError((Throwable)e);
        }
        catch (TransformerException e) {
            CloudFoundryPlugin.logError((Throwable)e);
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError((Throwable)e);
        }
    }

    protected List<String> getClasspathSourceOutputPaths(IProject project) {
        IJavaProject javaProject = CloudFoundryProjectUtil.getJavaProject((IProject)project);
        ArrayList<String> outputPaths = new ArrayList<String>();
        if (javaProject != null) {
            try {
                String outputPath;
                IClasspathEntry[] classpath = javaProject.getResolvedClasspath(true);
                if (classpath != null) {
                    IClasspathEntry[] iClasspathEntryArray = classpath;
                    int n = classpath.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (entry != null && entry.getEntryKind() == 3) {
                            String outputPath2;
                            String string = outputPath2 = entry.getOutputLocation() != null ? entry.getOutputLocation().toString() : null;
                            if (outputPath2 != null && !outputPaths.contains(outputPath2) && !outputPath2.contains("target/test-classes")) {
                                outputPaths.add(outputPath2);
                            }
                        }
                        ++n2;
                    }
                }
                String string = outputPath = javaProject.getOutputLocation() != null ? javaProject.getOutputLocation().toString() : null;
                if (outputPath != null && !outputPaths.contains(outputPath)) {
                    outputPaths.add(outputPath);
                }
            }
            catch (JavaModelException e) {
                CloudFoundryPlugin.logError((Throwable)e);
            }
        }
        return outputPaths;
    }

    protected IFile getRebelXMLFile(IProject project) {
        if (project != null && project.isAccessible()) {
            try {
                return this.getFile((IResource)project, "rebel.xml");
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logError((Throwable)e);
            }
        }
        return null;
    }

    protected IFile getFile(IResource resource, String fileName) throws CoreException {
        IContainer container;
        IResource[] children;
        if (resource instanceof IFile && resource.getName().equals(fileName)) {
            return (IFile)resource;
        }
        if (resource instanceof IContainer && (children = (container = (IContainer)resource).members()) != null) {
            IResource[] iResourceArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                IFile file = this.getFile(child, fileName);
                if (file != null) {
                    return file;
                }
                ++n2;
            }
        }
        return null;
    }
}

