/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.debug;

import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.debug.CloudFoundryDebugProvider;
import org.eclipse.cft.server.core.internal.debug.NgrokDebugProvider;
import org.eclipse.cft.server.core.internal.debug.SshDebugProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public class DebugProviderRegistry {
    private static final CloudFoundryDebugProvider[] providers = DebugProviderRegistry.getProviders();

    protected static CloudFoundryDebugProvider getDebugProvider(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        CloudFoundryDebugProvider[] cloudFoundryDebugProviderArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            CloudFoundryDebugProvider provider = cloudFoundryDebugProviderArray[n2];
            if (provider.isDebugSupported(appModule, cloudServer)) {
                return provider;
            }
            ++n2;
        }
        return null;
    }

    public static CloudFoundryDebugProvider getProvider(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        CloudFoundryDebugProvider provider = DebugProviderRegistry.getDebugProvider(appModule, cloudServer);
        return provider;
    }

    public static CloudFoundryDebugProvider getExistingProvider(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) throws CoreException {
        CloudFoundryDebugProvider provider = DebugProviderRegistry.getProvider(appModule, cloudServer);
        if (provider == null) {
            throw CloudErrorUtil.toCoreException(NLS.bind((String)"Unable to find a debug provider for {0}. Please check if debug is supported for the given application in {1} ", (Object)appModule.getDeployedApplicationName(), (Object)cloudServer.getServer().getId()));
        }
        return provider;
    }

    private static CloudFoundryDebugProvider[] getProviders() {
        return new CloudFoundryDebugProvider[]{new NgrokDebugProvider(), new SshDebugProvider()};
    }
}

