/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.cloudfoundry.client.lib.ApplicationLogListener;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.StreamingLogToken;
import org.cloudfoundry.client.lib.domain.ApplicationLog;
import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudDomain;
import org.cloudfoundry.client.lib.domain.CloudRoute;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.cloudfoundry.client.lib.domain.InstancesInfo;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.CFApplicationArchive;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.CFServiceOffering;
import org.eclipse.cft.server.core.internal.ApplicationAction;
import org.eclipse.cft.server.core.internal.ApplicationInstanceRunningTracker;
import org.eclipse.cft.server.core.internal.ApplicationUrlLookupService;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryLoginHandler;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudFoundryServerTarget;
import org.eclipse.cft.server.core.internal.CloudFoundryTargetManager;
import org.eclipse.cft.server.core.internal.CloudServerEvent;
import org.eclipse.cft.server.core.internal.CloudUtil;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.ModuleResourceDeltaWrapper;
import org.eclipse.cft.server.core.internal.OperationScheduler;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.UpdateOperationsScheduler;
import org.eclipse.cft.server.core.internal.application.ApplicationRegistry;
import org.eclipse.cft.server.core.internal.application.CachingApplicationArchive;
import org.eclipse.cft.server.core.internal.client.AdditionalV1Operations;
import org.eclipse.cft.server.core.internal.client.BaseClientRequest;
import org.eclipse.cft.server.core.internal.client.BehaviourRequest;
import org.eclipse.cft.server.core.internal.client.CFV1Application;
import org.eclipse.cft.server.core.internal.client.CancellableRequestThread;
import org.eclipse.cft.server.core.internal.client.ClientRequest;
import org.eclipse.cft.server.core.internal.client.ClientRequestFactory;
import org.eclipse.cft.server.core.internal.client.CloudBehaviourOperations;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.DeploymentInfoWorkingCopy;
import org.eclipse.cft.server.core.internal.client.ICloudFoundryOperation;
import org.eclipse.cft.server.core.internal.client.diego.CFInfo;
import org.eclipse.cft.server.core.internal.debug.ApplicationDebugLauncher;
import org.eclipse.cft.server.core.internal.jrebel.CFRebelServerIntegration;
import org.eclipse.cft.server.core.internal.spaces.CloudFoundrySpace;
import org.eclipse.cft.server.core.internal.spaces.CloudOrgsAndSpaces;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.internal.IModuleVisitor;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPublishInfo;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.RestClientException;

public class CloudFoundryServerBehaviour
extends ServerBehaviourDelegate {
    private CloudFoundryOperations client;
    private AdditionalV1Operations additionalClientSupport;
    private UpdateOperationsScheduler operationsScheduler;
    private ApplicationUrlLookupService applicationUrlLookup;
    private CloudBehaviourOperations cloudBehaviourOperations;
    private ClientRequestFactory requestFactory;
    private CloudFoundryServerTarget serverTarget;
    private CloudFoundryTargetManager targetManager = CloudFoundryPlugin.getTargetManager();
    private IServerListener serverListener = new IServerListener(){

        public void serverChanged(ServerEvent event) {
            if (event.getKind() == 16) {
                CloudFoundryServerBehaviour.this.internalResetClient();
            }
        }
    };
    private final ReentrantLock clientLock = new ReentrantLock();

    ClientRequestFactory getRequestFactory() throws CoreException {
        if (this.requestFactory == null) {
            this.requestFactory = this.getTarget().createRequestFactory(this.getCloudFoundryServer().getServer());
        }
        return this.requestFactory;
    }

    public synchronized void setTargetManager(CloudFoundryTargetManager targetManager) {
        if (targetManager != null) {
            this.targetManager = targetManager;
        }
    }

    protected synchronized CloudFoundryServerTarget getTarget() throws CoreException {
        if (this.serverTarget == null) {
            this.serverTarget = this.targetManager.getTarget(this.getCloudFoundryServer());
        }
        return this.serverTarget;
    }

    public boolean canControlModule(IModule[] module) {
        return module.length == 1;
    }

    public void connect(IProgressMonitor monitor) throws CoreException {
        CloudFoundryServer cloudServer = this.getCloudFoundryServer();
        this.getRequestFactory().connect().run(monitor);
        Server server = (Server)cloudServer.getServerOriginal();
        server.setServerState(2);
        server.setServerPublishState(1);
        this.getApplicationUrlLookup().refreshDomains(monitor);
        this.asyncUpdateAll();
        ServerEventHandler.getDefault().fireServerEvent(new CloudServerEvent(this.getCloudFoundryServer(), 403));
    }

    public boolean regenerateSsoLogin(String passcode, IProgressMonitor monitor) throws CoreException {
        CloudFoundryServer cloudServer = this.getCloudFoundryServer();
        CloudFoundryServerBehaviour.createExternalClientLogin(cloudServer, cloudServer.getUrl(), null, null, cloudServer.isSelfSigned(), true, cloudServer.getPasscode(), null, monitor);
        CloudFoundryOperations result = this.getClient(null, true, monitor);
        return result != null;
    }

    public CloudBehaviourOperations operations() {
        if (this.cloudBehaviourOperations == null) {
            this.cloudBehaviourOperations = new CloudBehaviourOperations(this);
        }
        return this.cloudBehaviourOperations;
    }

    private synchronized UpdateOperationsScheduler getUpdateModulesScheduler() {
        return (UpdateOperationsScheduler)this.getOperationScheduler();
    }

    public synchronized OperationScheduler getOperationScheduler() {
        if (this.operationsScheduler == null) {
            CloudFoundryServer server = null;
            try {
                server = this.getCloudFoundryServer();
            }
            catch (CoreException ce) {
                CloudFoundryPlugin.logError(ce);
            }
            this.operationsScheduler = new UpdateOperationsScheduler(server);
        }
        return this.operationsScheduler;
    }

    public ApplicationDebugLauncher getDebugLauncher() {
        try {
            return CloudFoundryPlugin.getCallback().getDebugLauncher(this.getCloudFoundryServer());
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
            return ApplicationDebugLauncher.NO_DEBUG;
        }
    }

    public synchronized List<CloudDomain> getDomainsFromOrgs(IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getDomainsFromOrgs().run(monitor);
    }

    public synchronized List<CloudDomain> getDomainsForSpace(IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getDomainsForSpace().run(monitor);
    }

    public void deleteModules(IModule[] modules, boolean deleteServices, IProgressMonitor monitor) throws CoreException {
        this.operations().deleteModules(modules, deleteServices).run(monitor);
    }

    public void deleteApplication(String appName, IProgressMonitor monitor) throws CoreException {
        this.getRequestFactory().deleteApplication(appName).run(monitor);
    }

    public ICloudFoundryOperation getDeleteServicesOperation(List<String> services) throws CoreException {
        return this.operations().deleteServices(services);
    }

    public ApplicationUrlLookupService getApplicationUrlLookup() {
        if (this.applicationUrlLookup == null) {
            try {
                this.applicationUrlLookup = new ApplicationUrlLookupService(this.getCloudFoundryServer());
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logError("Failed to create the Cloud Foundry Application URL lookup service due to {" + e.getMessage(), e);
            }
        }
        return this.applicationUrlLookup;
    }

    protected List<IModuleResource> getChangedResources(IModuleResourceDelta[] deltas) {
        ArrayList<IModuleResource> changed = new ArrayList<IModuleResource>();
        if (deltas != null) {
            this.findNonChangedResources(deltas, changed);
        }
        return changed;
    }

    protected void findNonChangedResources(IModuleResourceDelta[] deltas, List<IModuleResource> changed) {
        if (deltas == null || deltas.length == 0) {
            return;
        }
        IModuleResourceDelta[] iModuleResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResourceDelta delta = iModuleResourceDeltaArray[n2];
            IModuleResource resource = delta.getModuleResource();
            if (resource instanceof IModuleFile && delta.getKind() != 0) {
                changed.add(new ModuleResourceDeltaWrapper(delta));
            }
            this.findNonChangedResources(delta.getAffectedChildren(), changed);
            ++n2;
        }
    }

    public void disconnect(IProgressMonitor monitor) throws CoreException {
        CloudFoundryPlugin.getCallback().disconnecting(this.getCloudFoundryServer());
        Server server = (Server)this.getServer();
        server.setServerState(3);
        CloudFoundryServer cloudServer = this.getCloudFoundryServer();
        Collection<CloudFoundryApplicationModule> cloudModules = cloudServer.getExistingCloudModules();
        for (CloudFoundryApplicationModule appModule : cloudModules) {
            CloudFoundryPlugin.getCallback().stopApplicationConsole(appModule, cloudServer);
        }
        HashSet<CloudFoundryApplicationModule> deletedModules = new HashSet<CloudFoundryApplicationModule>(cloudModules);
        cloudServer.clearApplications();
        server.setExternalModules(new IModule[0]);
        for (CloudFoundryApplicationModule module : deletedModules) {
            server.setModuleState(new IModule[]{module.getLocalModule()}, 0);
        }
        server.setServerState(4);
        server.setServerPublishState(1);
        ServerEventHandler.getDefault().fireServerEvent(new CloudServerEvent(this.getCloudFoundryServer(), 406));
    }

    public void reconnect(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subMonitor.subTask(NLS.bind((String)Messages.CloudFoundryServerBehaviour_RECONNECTING_SERVER, (Object)this.getCloudFoundryServer().getServer().getId()));
        this.disconnect((IProgressMonitor)subMonitor.newChild(40));
        try {
            this.resetClient((IProgressMonitor)subMonitor.newChild(20));
        }
        catch (CloudFoundryException cfe) {
            throw CloudErrorUtil.toCoreException(cfe);
        }
        this.connect((IProgressMonitor)subMonitor.newChild(40));
    }

    public void dispose() {
        super.dispose();
        this.getServer().removeServerListener(this.serverListener);
    }

    public CloudFoundryServer getCloudFoundryServer() throws CoreException {
        Server server = (Server)this.getServer();
        CloudFoundryServer cloudFoundryServer = (CloudFoundryServer)((Object)server.loadAdapter(CloudFoundryServer.class, null));
        if (cloudFoundryServer == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cft.server.core", "Fail to load server"));
        }
        return cloudFoundryServer;
    }

    public CloudApplication getApplication(String appName, IProgressMonitor monitor) throws CoreException {
        return this.getCloudApplication(appName, monitor);
    }

    public CloudApplication getCloudApplication(String appName, IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getCloudApplication(appName).run(monitor);
    }

    public CloudFoundryApplicationModule updateDeployedModule(IModule module, IProgressMonitor monitor) throws CoreException {
        String name;
        CloudFoundryApplicationModule appModule = this.getCloudFoundryServer().getExistingCloudModule(module);
        if (appModule != null && appModule.isDeployed() && (name = appModule.getDeployedApplicationName()) != null) {
            return this.updateModuleWithAllCloudInfo(name, monitor);
        }
        return null;
    }

    public CloudFoundryApplicationModule updateModuleWithAllCloudInfo(IModule module, IProgressMonitor monitor) throws CoreException {
        String name;
        CloudFoundryApplicationModule appModule = this.getCloudFoundryServer().getExistingCloudModule(module);
        if (appModule != null && (name = appModule.getDeployedApplicationName()) != null) {
            return this.updateModuleWithAllCloudInfo(name, monitor);
        }
        return null;
    }

    public CloudFoundryApplicationModule updateModuleWithBasicCloudInfo(IModule module, IProgressMonitor monitor) throws CoreException {
        CloudFoundryApplicationModule appModule = this.getCloudFoundryServer().getExistingCloudModule(module);
        String name = appModule != null ? appModule.getDeployedApplicationName() : module.getName();
        return this.updateModuleWithBasicCloudInfo(name, monitor);
    }

    public CloudFoundryApplicationModule updateModuleWithBasicCloudInfo(String appName, IProgressMonitor monitor) throws CoreException {
        ApplicationStats stats;
        SubMonitor subMonitor;
        CloudApplication updatedApp;
        block3: {
            updatedApp = null;
            subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.subTask(NLS.bind((String)Messages.CloudFoundryServer_UPDATING_MODULE, (Object)appName, (Object)this.getServer().getId()));
            stats = null;
            try {
                updatedApp = this.getCloudApplication(appName, (IProgressMonitor)subMonitor.newChild(50));
                if (updatedApp != null) {
                    stats = this.getApplicationStats(appName, monitor);
                }
            }
            catch (CoreException e) {
                if (CloudErrorUtil.isNotFoundException(e)) break block3;
                throw e;
            }
        }
        return this.getCloudFoundryServer().updateModule(updatedApp, appName, stats, (IProgressMonitor)subMonitor.newChild(50));
    }

    public CloudFoundryApplicationModule updateModuleWithAllCloudInfo(String appName, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CloudFoundryApplicationModule appModule = this.updateModuleWithBasicCloudInfo(appName, (IProgressMonitor)subMonitor.newChild(50));
        this.updateInstancesInfo(appModule, (IProgressMonitor)subMonitor.newChild(50));
        return appModule;
    }

    public void cleanModuleStates(IModule[] modules, IProgressMonitor monitor) {
        IServer iServer = this.getServer();
        if (iServer != null && iServer instanceof Server) {
            Server server = (Server)iServer;
            final ServerPublishInfo info = server.getServerPublishInfo();
            info.startCaching();
            info.clearCache();
            info.fill(modules);
            final ArrayList modules2 = new ArrayList();
            server.visit(new IModuleVisitor(){

                public boolean visit(IModule[] module) {
                    info.fill(module);
                    modules2.add(module);
                    return true;
                }
            }, monitor);
            info.removeDeletedModulePublishInfo(server, modules2);
            info.save();
            super.setModulePublishState(modules, 1);
        }
    }

    private void updateInstancesInfo(CloudFoundryApplicationModule appModule, IProgressMonitor monitor) throws CoreException {
        block3: {
            if (appModule == null) {
                return;
            }
            try {
                InstancesInfo info = this.getInstancesInfo(appModule.getDeployedApplicationName(), monitor);
                appModule.setInstancesInfo(info);
            }
            catch (CoreException e) {
                if (CloudErrorUtil.isNotFoundException(e)) break block3;
                throw e;
            }
        }
    }

    public List<CloudApplication> getApplications(IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getApplications().run(monitor);
    }

    public List<CloudApplication> getBasicApplications(IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getBasicApplications().run(monitor);
    }

    public CFV1Application getCompleteApplication(CloudApplication application, IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getCompleteApplication(application).run(monitor);
    }

    public ApplicationStats getApplicationStats(String appName, IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getApplicationStats(appName).run(monitor);
    }

    public InstancesInfo getInstancesInfo(String applicationId, IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getInstancesInfo(applicationId).run(monitor);
    }

    public String getFile(CloudApplication app, int instanceIndex, String path, boolean isDir, IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getFile(app, instanceIndex, path, isDir).run(monitor);
    }

    public List<CFServiceOffering> getServiceOfferings(IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getServiceOfferings().run(monitor);
    }

    public void deleteAllApplications(IProgressMonitor monitor) throws CoreException {
        this.getRequestFactory().deleteAllApplications().run(monitor);
    }

    public List<CFServiceInstance> getServices(IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getServices().run(monitor);
    }

    public void refreshModules(IProgressMonitor monitor) {
        this.asyncUpdateAll();
    }

    public CloudFoundryOperations resetClient(IProgressMonitor monitor) throws CoreException {
        return this.resetClient(null, monitor);
    }

    public CloudFoundryOperations resetClient(CloudCredentials credentials, IProgressMonitor monitor) throws CoreException {
        this.internalResetClient();
        return this.getClient(credentials, false, monitor);
    }

    protected void internalResetClient() {
        this.client = null;
        this.additionalClientSupport = null;
        this.applicationUrlLookup = null;
        this.cloudBehaviourOperations = null;
        this.operationsScheduler = null;
    }

    public void startModule(IModule[] modules, IProgressMonitor monitor) throws CoreException {
        this.operations().applicationDeployment(modules, ApplicationAction.RESTART).run(monitor);
    }

    public void stop(boolean force) {
        this.setServerState(4);
        try {
            ServerEventHandler.getDefault().fireServerEvent(new CloudServerEvent(this.getCloudFoundryServer(), 406));
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
        }
    }

    public void stopModule(IModule[] modules, IProgressMonitor monitor) throws CoreException {
        this.operations().applicationDeployment(modules, ApplicationAction.STOP).run(monitor);
    }

    public ICloudFoundryOperation getStopAppOperation(IModule[] modules) {
        try {
            return this.operations().applicationDeployment(modules, ApplicationAction.STOP);
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
            return null;
        }
    }

    public StreamingLogToken addApplicationLogListener(final String appName, final ApplicationLogListener listener) {
        if (appName != null && listener != null) {
            try {
                return (StreamingLogToken)new BehaviourRequest<StreamingLogToken>(Messages.ADDING_APPLICATION_LOG_LISTENER, this){

                    @Override
                    protected StreamingLogToken doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                        return client.streamLogs(appName, listener);
                    }
                }.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                CloudFoundryPlugin.logError(NLS.bind((String)Messages.ERROR_APPLICATION_LOG_LISTENER, (Object)appName, (Object)e.getMessage()), e);
            }
        }
        return null;
    }

    public List<ApplicationLog> getRecentApplicationLogs(String appName, IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getRecentApplicationLogs(appName).run(monitor);
    }

    public void restartModule(IModule[] modules, IProgressMonitor monitor) throws CoreException {
        this.operations().applicationDeployment(modules, ApplicationAction.RESTART).run(monitor);
    }

    public ICloudFoundryOperation getUpdateRestartOperation(IModule[] modules) throws CoreException {
        return this.operations().applicationDeployment(modules, ApplicationAction.UPDATE_RESTART);
    }

    public ICloudFoundryOperation getRestartOperation(IModule[] modules) throws CoreException {
        return this.operations().applicationDeployment(modules, ApplicationAction.RESTART);
    }

    public void updateApplicationInstances(CloudFoundryApplicationModule module, int instanceCount, IProgressMonitor monitor) throws CoreException {
        this.operations().instancesUpdate(module, instanceCount).run(monitor);
    }

    void updateApplicationInstances(String appName, int instanceCount, IProgressMonitor monitor) throws CoreException {
        this.getRequestFactory().updateApplicationInstances(appName, instanceCount).run(monitor);
    }

    public void updatePassword(String newPassword, IProgressMonitor monitor) throws CoreException {
        this.getRequestFactory().updatePassword(newPassword).run(monitor);
    }

    public void updateApplicationMemory(CloudFoundryApplicationModule module, int memory, IProgressMonitor monitor) throws CoreException {
        this.operations().memoryUpdate(module, memory).run(monitor);
    }

    public void updateApplicationUrls(String appName, List<String> uris, IProgressMonitor monitor) throws CoreException {
        this.operations().mappedUrlsUpdate(appName, uris).run(monitor);
    }

    public void updateServices(String appName, List<String> services, IProgressMonitor monitor) throws CoreException {
        CloudFoundryApplicationModule appModule = this.getCloudFoundryServer().getExistingCloudModule(appName);
        this.operations().bindServices(appModule, services);
    }

    public void refreshApplicationBoundServices(CloudFoundryApplicationModule appModule, IProgressMonitor monitor) throws CoreException {
        List<CFServiceInstance> allServices;
        DeploymentInfoWorkingCopy copy = appModule.resolveDeploymentInfoWorkingCopy(monitor);
        List<CFServiceInstance> boundServices = copy.getServices();
        if (boundServices != null && !boundServices.isEmpty() && (allServices = this.getServices(monitor)) != null) {
            HashMap<String, CFServiceInstance> existingAsMap = new HashMap<String, CFServiceInstance>();
            for (CFServiceInstance existingServices : allServices) {
                existingAsMap.put(existingServices.getName(), existingServices);
            }
            ArrayList<CFServiceInstance> updatedServices = new ArrayList<CFServiceInstance>();
            for (CFServiceInstance boundService : boundServices) {
                CFServiceInstance updatedService = (CFServiceInstance)existingAsMap.get(boundService.getName());
                if (updatedService != null) {
                    updatedServices.add(updatedService);
                    continue;
                }
                updatedServices.add(boundService);
            }
            copy.setServices(updatedServices);
            copy.save();
        }
    }

    public void register(String email, String password, IProgressMonitor monitor) throws CoreException {
        this.getRequestFactory().register(email, password).run(monitor);
    }

    private void reestablishSsoSessionIfNeeded(CloudFoundryException e, CloudFoundryServer cloudServer) throws CoreException {
        if (cloudServer.isSso() && (e.getStatusCode() == HttpStatus.UNAUTHORIZED || e.getStatusCode() == HttpStatus.FORBIDDEN)) {
            boolean result = CloudFoundryPlugin.getCallback().ssoLoginUserPrompt(cloudServer);
            if (this.client != null) {
                return;
            }
            if (result) {
                CloudCredentials credentials = CloudUtil.createSsoCredentials(cloudServer.getPasscode(), cloudServer.getToken());
                this.client = CloudFoundryServerBehaviour.createClientWithCredentials(cloudServer.getUrl(), credentials, cloudServer.getCloudFoundrySpace(), cloudServer.isSelfSigned());
                return;
            }
        }
        throw e;
    }

    protected CloudFoundryOperations getClient(CloudCredentials credentials, boolean ignoreLock, IProgressMonitor monitor) throws CoreException {
        boolean weOwnLock = false;
        try {
            if (!ignoreLock) {
                this.clientLock.lock();
                weOwnLock = true;
            }
            if (this.client == null) {
                CloudFoundryServer cloudServer = this.getCloudFoundryServer();
                String url = cloudServer.getUrl();
                if (!cloudServer.hasCloudSpace()) {
                    throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.ERROR_FAILED_CLIENT_CREATION_NO_SPACE, (Object)cloudServer.getServerId()));
                }
                CloudFoundrySpace cloudFoundrySpace = cloudServer.getCloudFoundrySpace();
                if (credentials != null) {
                    this.client = CloudFoundryServerBehaviour.createClientWithCredentials(url, credentials, cloudFoundrySpace, cloudServer.isSelfSigned());
                } else if (this.getCloudFoundryServer().isSso()) {
                    try {
                        credentials = CloudUtil.createSsoCredentials(cloudServer.getPasscode(), cloudServer.getToken());
                        this.client = CloudFoundryServerBehaviour.createClientWithCredentials(url, credentials, cloudFoundrySpace, cloudServer.isSelfSigned());
                    }
                    catch (CloudFoundryException e) {
                        this.reestablishSsoSessionIfNeeded(e, cloudServer);
                    }
                } else {
                    String userName = cloudServer.getUsername();
                    String password = cloudServer.getPassword();
                    credentials = new CloudCredentials(userName, password);
                    this.client = CloudFoundryServerBehaviour.createClientWithCredentials(url, credentials, cloudFoundrySpace, cloudServer.isSelfSigned());
                }
            }
            CloudFoundryOperations cloudFoundryOperations = this.client;
            return cloudFoundryOperations;
        }
        finally {
            if (weOwnLock) {
                this.clientLock.unlock();
            }
        }
    }

    private synchronized AdditionalV1Operations getAdditionalV1ClientOperations(CloudFoundryOperations client) throws CoreException {
        CloudOrgsAndSpaces spacesFromCF;
        if (this.additionalClientSupport != null) {
            return this.additionalClientSupport;
        }
        CloudFoundryServer server = this.getCloudFoundryServer();
        HttpProxyConfiguration httpProxyConfiguration = server.getProxyConfiguration();
        CloudSpace sessionSpace = null;
        CloudFoundrySpace storedSpace = server.getCloudFoundrySpace();
        if (storedSpace != null && (sessionSpace = storedSpace.getSpace()) == null && storedSpace.getOrgName() != null && storedSpace.getSpaceName() != null && (spacesFromCF = CloudFoundryServerBehaviour.internalGetCloudSpaces(client)) != null) {
            sessionSpace = spacesFromCF.getSpace(storedSpace.getOrgName(), storedSpace.getSpaceName());
        }
        if (sessionSpace == null) {
            throw CloudErrorUtil.toCoreException("No Cloud space resolved for " + server.getServer().getId() + ". Please verify that the server is connected and refreshed and try again.");
        }
        this.additionalClientSupport = this.getRequestFactory().createAdditionalV1Operations(client, sessionSpace, this.getRequestFactory().getCloudInfo(), httpProxyConfiguration, server.isSelfSigned());
        return this.additionalClientSupport;
    }

    public CloudFoundryOperations getClient(IProgressMonitor monitor) throws CoreException {
        return this.getClient(null, false, monitor);
    }

    public synchronized AdditionalV1Operations getAdditionalV1ClientOperations(IProgressMonitor monitor) throws CoreException {
        CloudFoundryOperations client = this.getClient(monitor);
        return this.getAdditionalV1ClientOperations(client);
    }

    protected void initialize(IProgressMonitor monitor) {
        super.initialize(monitor);
        CFRebelServerIntegration integration = CloudFoundryPlugin.getCallback().getJRebelServerIntegration();
        if (integration != null) {
            integration.register();
        }
        this.getServer().addServerListener(this.serverListener, 16);
        try {
            if (this.getCloudFoundryServer().isSso() && this.getCloudFoundryServer().getToken() == null) {
                return;
            }
            this.getApplicationUrlLookup().refreshDomains(monitor);
            this.asyncUpdateAll();
            ServerEventHandler.getDefault().fireServerEvent(new CloudServerEvent(this.getCloudFoundryServer(), 403));
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
        }
    }

    public IStatus publishAdd(String moduleName, IProgressMonitor monitor) {
        List allModules = this.getAllModules();
        try {
            for (IModule[] module : allModules) {
                if (!module[0].getName().equals(moduleName)) continue;
                this.operations().applicationDeployment(module, ApplicationAction.PUSH).run(monitor);
                return Status.OK_STATUS;
            }
        }
        catch (CoreException ce) {
            this.handlePublishError(ce);
            return ce.getStatus();
        }
        return CloudFoundryPlugin.getErrorStatus("Internal error: no module with name : " + moduleName + " found to publish. Refresh or clean the server and try again.");
    }

    public boolean existCloudApplicationModule(String moduleName) {
        List allModules = this.getAllModules();
        for (IModule[] modules : allModules) {
            if (!(modules[0] instanceof CloudFoundryApplicationModule) || !modules[0].getName().equals(moduleName)) continue;
            return true;
        }
        return false;
    }

    protected void handlePublishError(CoreException e) {
        IStatus errorStatus = CloudFoundryPlugin.getErrorStatus(NLS.bind((String)Messages.ERROR_FAILED_TO_PUSH_APP, (Object)e.getMessage()));
        CloudFoundryPlugin.log(errorStatus);
    }

    protected void publishModules(int kind, List modules, List deltaKind2, MultiStatus multi, IProgressMonitor monitor) {
        if (modules != null && deltaKind2 != null) {
            ArrayList<IModule[]> filteredModules = new ArrayList<IModule[]>(modules.size());
            ArrayList<Integer> filteredDeltaKinds = new ArrayList<Integer>(deltaKind2.size());
            int i = 0;
            while (i < modules.size() && i < deltaKind2.size()) {
                int knd;
                IModule m;
                if (monitor.isCanceled()) {
                    return;
                }
                IModule[] module = (IModule[])modules.get(i);
                if (!(module.length == 0 || this.shouldIgnorePublishRequest(m = module[module.length - 1]) || 1 != (knd = ((Integer)deltaKind2.get(i)).intValue()) && 3 != knd)) {
                    filteredModules.add(module);
                    filteredDeltaKinds.add(knd);
                }
                ++i;
            }
            if (!filteredModules.isEmpty()) {
                modules = filteredModules;
                deltaKind2 = filteredDeltaKinds;
            }
        }
        super.publishModules(kind, (List)modules, (List)deltaKind2, multi, monitor);
    }

    protected void publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        CloudFoundryPlugin.logInfo(CloudFoundryServerBehaviour.convertPublishModuleToString(deltaKind, module));
        super.publishModule(kind, deltaKind, module, monitor);
        try {
            if (deltaKind == 3) {
                CloudFoundryServer cloudServer = this.getCloudFoundryServer();
                CloudFoundryApplicationModule cloudModule = cloudServer.getExistingCloudModule(module[0]);
                if (cloudModule != null && cloudModule.getApplication() != null) {
                    this.getRequestFactory().deleteApplication(cloudModule.getDeployedApplicationName()).run(monitor);
                }
            } else if (!module[0].isExternal()) {
                int publishState = this.getServer().getModulePublishState(module);
                ICloudFoundryOperation op = null;
                if (deltaKind == 1 || publishState == 0) {
                    op = this.operations().applicationDeployment(module, ApplicationAction.PUSH);
                } else if (deltaKind == 2) {
                    op = this.operations().applicationDeployment(module, ApplicationAction.UPDATE_RESTART);
                } else if (this.isChildModuleChanged(module, monitor)) {
                    op = this.operations().applicationDeployment(module, ApplicationAction.UPDATE_RESTART);
                }
                if (op != null) {
                    op.run(monitor);
                }
            }
        }
        catch (CoreException e) {
            this.handlePublishError(e);
            throw e;
        }
    }

    private boolean isChildModuleChanged(IModule[] module, IProgressMonitor monitor) {
        if (module == null || module.length == 0) {
            return false;
        }
        IServer myserver = this.getServer();
        IModule[] childModules = myserver.getChildModules(module, monitor);
        if (childModules != null && childModules.length > 0) {
            IModule[] currentChild = new IModule[module.length + 1];
            int i = 0;
            while (i < module.length) {
                currentChild[i] = module[i];
                ++i;
            }
            IModule[] iModuleArray = childModules;
            int n = childModules.length;
            int n2 = 0;
            while (n2 < n) {
                IModule child;
                currentChild[module.length] = child = iModuleArray[n2];
                if (myserver.getModulePublishState(currentChild) != 1 || this.isChildModuleChanged(currentChild, monitor)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public CloudOrgsAndSpaces getCloudSpaces(IProgressMonitor monitor) throws CoreException {
        return (CloudOrgsAndSpaces)new BehaviourRequest<CloudOrgsAndSpaces>(Messages.GETTING_ORGS_AND_SPACES, this){

            @Override
            protected CloudOrgsAndSpaces doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                return CloudFoundryServerBehaviour.internalGetCloudSpaces(client);
            }
        }.run(monitor);
    }

    public List<CloudRoute> getRoutes(String domainName, IProgressMonitor monitor) throws CoreException {
        BaseClientRequest<List<CloudRoute>> request = this.getRequestFactory().getRoutes(domainName);
        CancellableRequestThread<List<CloudRoute>> t = new CancellableRequestThread<List<CloudRoute>>(request, monitor);
        return t.runAndWaitForCompleteOrCancelled();
    }

    public void deleteRoute(List<CloudRoute> routes, IProgressMonitor monitor) throws CoreException {
        BaseClientRequest<?> request = this.getRequestFactory().deleteRoute(routes);
        if (request != null) {
            request.run(monitor);
        }
    }

    public void deleteRoute(String host, String domainName, IProgressMonitor monitor) throws CoreException {
        BaseClientRequest<Void> request = this.getRequestFactory().deleteRoute(host, domainName);
        if (request != null) {
            request.run(monitor);
        }
    }

    public boolean reserveRouteIfAvailable(String host, String domainName, IProgressMonitor monitor) throws CoreException {
        BaseClientRequest<Boolean> request = this.getRequestFactory().reserveRouteIfAvailable(host, domainName);
        CancellableRequestThread<Boolean> t = new CancellableRequestThread<Boolean>(request, monitor);
        Boolean result = t.runAndWaitForCompleteOrCancelled();
        if (result != null) {
            return result;
        }
        return false;
    }

    public static CloudOrgsAndSpaces getCloudSpacesExternalClient(CloudFoundryServer cfServer, CloudCredentials credentials, String url, boolean selfSigned, IProgressMonitor monitor) throws CoreException {
        return CloudFoundryServerBehaviour.getCloudSpacesExternalClient(cfServer, credentials, url, selfSigned, false, null, null, monitor);
    }

    public static CloudOrgsAndSpaces getCloudSpacesExternalClient(CloudFoundryServer cfServer, CloudCredentials credentials, String url, boolean selfSigned, boolean sso, String passcode, String tokenValue, IProgressMonitor monitor) throws CoreException {
        final CloudFoundryOperations operations = CloudFoundryServerBehaviour.createExternalClientLogin(cfServer, url, credentials.getEmail(), credentials.getPassword(), selfSigned, sso, passcode, tokenValue, monitor);
        return (CloudOrgsAndSpaces)new ClientRequest<CloudOrgsAndSpaces>(Messages.GETTING_ORGS_AND_SPACES){

            @Override
            protected CloudOrgsAndSpaces doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                return CloudFoundryServerBehaviour.internalGetCloudSpaces(client);
            }

            @Override
            protected CloudFoundryOperations getClient(IProgressMonitor monitor) throws CoreException {
                return operations;
            }
        }.run(monitor);
    }

    private static CloudOrgsAndSpaces internalGetCloudSpaces(CloudFoundryOperations client) {
        List foundSpaces = client.getSpaces();
        if (foundSpaces != null && !foundSpaces.isEmpty()) {
            ArrayList<CloudSpace> actualSpaces = new ArrayList<CloudSpace>(foundSpaces);
            CloudOrgsAndSpaces orgsAndSpaces = new CloudOrgsAndSpaces(actualSpaces);
            return orgsAndSpaces;
        }
        return null;
    }

    public static void validate(CloudFoundryServer server, String location, String userName, String password, boolean selfSigned, boolean sso, String passcode, String tokenValue, IProgressMonitor monitor) throws CoreException {
        CloudFoundryServerBehaviour.createExternalClientLogin(server, location, userName, password, selfSigned, sso, passcode, tokenValue, monitor);
    }

    public static CloudFoundryOperations createExternalClientLogin(CloudFoundryServer cfServer, String location, String userName, String password, boolean selfSigned, IProgressMonitor monitor) throws CoreException {
        return CloudFoundryServerBehaviour.createExternalClientLogin(cfServer, location, userName, password, selfSigned, false, null, null, monitor);
    }

    public static CloudFoundryOperations createExternalClientLogin(final CloudFoundryServer cfServer, String location, String userName, String password, boolean selfSigned, boolean sso, String passcode, String tokenValue, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.beginTask(Messages.CONNECTING, -1);
        try {
            CloudFoundryOperations client;
            if (sso) {
                CloudCredentials credentials = CloudUtil.createSsoCredentials(passcode, tokenValue);
                client = CloudFoundryServerBehaviour.createClientWithCredentials(location, credentials, null, selfSigned);
            } else {
                client = CloudFoundryServerBehaviour.createClientWithCredentials(location, new CloudCredentials(userName, password), null, selfSigned);
            }
            final CloudFoundryOperations finalClient = client;
            new ClientRequest<Void>(Messages.VALIDATING_CREDENTIALS){

                @Override
                protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                    CloudFoundryLoginHandler operationsHandler = new CloudFoundryLoginHandler(client, cfServer);
                    int attempts = 5;
                    operationsHandler.login((IProgressMonitor)progress, attempts, 2000L);
                    return null;
                }

                @Override
                protected CloudFoundryOperations getClient(IProgressMonitor monitor) throws CoreException {
                    return finalClient;
                }
            }.run(monitor);
            CloudFoundryOperations cloudFoundryOperations = client;
            return cloudFoundryOperations;
        }
        catch (RuntimeException t) {
            throw CloudErrorUtil.checkServerCommunicationError(t);
        }
        finally {
            progress.done();
        }
    }

    public static void register(String location, String userName, String password, boolean selfSigned, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.beginTask(Messages.CONNECTING, -1);
        try {
            try {
                CloudFoundryOperations client = CloudFoundryServerBehaviour.createClientForRegister(location, userName, password, selfSigned);
                client.register(userName, password);
            }
            catch (RestClientException e) {
                throw CloudErrorUtil.toCoreException(e);
            }
            catch (RuntimeException e) {
                throw CloudErrorUtil.checkServerCommunicationError(e);
            }
        }
        finally {
            progress.done();
        }
    }

    void resetPublishState(IModule[] modules) {
        this.setModulePublishState(modules, 1);
    }

    private static CloudFoundryOperations createClientForRegister(String location, String userName, String password, boolean selfSigned) throws CoreException {
        if (password == null) {
            password = "";
        }
        return CloudFoundryServerBehaviour.createClientWithCredentials(location, new CloudCredentials(userName, password), null, selfSigned);
    }

    private static CloudFoundryOperations createClientWithCredentials(String serverURL, CloudCredentials credentials, CloudFoundrySpace cloudSpace, boolean selfSigned) throws CoreException {
        try {
            URL url = new URL(serverURL);
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            return cloudSpace != null ? CloudFoundryPlugin.getCloudFoundryClientFactory().getCloudFoundryOperations(credentials, url, cloudSpace.getOrgName(), cloudSpace.getSpaceName(), selfSigned) : CloudFoundryPlugin.getCloudFoundryClientFactory().getCloudFoundryOperations(credentials, url, selfSigned);
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cft.server.core", "The server url " + serverURL + " is invalid: " + e.getMessage(), (Throwable)e));
        }
    }

    protected boolean hasChildModules(IModule[] modules) {
        IWebModule webModule = CloudUtil.getWebModule(modules);
        return webModule != null && webModule.getModules() != null && webModule.getModules().length > 0;
    }

    protected CFApplicationArchive generateApplicationArchiveFile(ApplicationDeploymentInfo deploymentInfo, CloudFoundryApplicationModule cloudModule, IModule[] modules, Server server, boolean incrementalPublish, IProgressMonitor monitor) throws CoreException {
        IModuleResource[] resources = this.getResources(modules);
        CFApplicationArchive archive = ApplicationRegistry.getApplicationArchive(cloudModule.getLocalModule(), this.getCloudFoundryServer().getServer(), resources, monitor);
        if (archive == null && incrementalPublish && !this.hasChildModules(modules)) {
            archive = this.getIncrementalPublishArchive(deploymentInfo, modules);
        }
        return archive;
    }

    protected void clearAndPrintlnConsole(CloudFoundryApplicationModule appModule, String message) throws CoreException {
        message = String.valueOf(message) + '\n';
        this.printToConsole(appModule, message, true, false);
    }

    protected void printlnToConsole(CloudFoundryApplicationModule appModule, String message) throws CoreException {
        message = String.valueOf(message) + '\n';
        this.printToConsole(appModule, message, false, false);
    }

    protected void printErrorlnToConsole(CloudFoundryApplicationModule appModule, String message) throws CoreException {
        message = NLS.bind((String)(String.valueOf(Messages.CONSOLE_ERROR_MESSAGE) + '\n'), (Object)message);
        this.printToConsole(appModule, message, false, true);
    }

    protected void printToConsole(CloudFoundryApplicationModule appModule, String message, boolean clearConsole, boolean isError) throws CoreException {
        CloudFoundryPlugin.getCallback().printToConsole(this.getCloudFoundryServer(), appModule, message, clearConsole, isError);
    }

    protected CFApplicationArchive getIncrementalPublishArchive(ApplicationDeploymentInfo deploymentInfo, IModule[] modules) {
        IModuleResource[] allResources = this.getResources(modules);
        IModuleResourceDelta[] deltas = this.getPublishedResourceDelta(modules);
        List<IModuleResource> changedResources = this.getChangedResources(deltas);
        CachingApplicationArchive moduleArchive = new CachingApplicationArchive(Arrays.asList(allResources), changedResources, modules[0], deploymentInfo.getDeploymentName());
        return moduleArchive;
    }

    private static String convertPublishModuleToString(int deltaKind, IModule[] module) {
        try {
            String deltaKindStr = deltaKind == 3 ? "REMOVED" : (deltaKind == 1 ? "ADDED" : (deltaKind == 2 ? "CHANGED" : (deltaKind == 0 ? "NO_CHANGE" : "Unknown")));
            String moduleStr = "{ ";
            if (module != null) {
                int x = 0;
                while (x < module.length) {
                    IModule currModule = module[x];
                    if (currModule != null) {
                        moduleStr = String.valueOf(moduleStr) + currModule.getName() + " [" + currModule.getId() + "/" + (currModule.getModuleType() != null ? currModule.getModuleType().getId() : "") + "]";
                        if (x + 1 < module.length) {
                            moduleStr = String.valueOf(moduleStr) + ", ";
                        }
                    }
                    ++x;
                }
            }
            moduleStr = String.valueOf(moduleStr.trim()) + "}";
            return "CloudFoundryServerBehaviour.publishModule(...): " + deltaKindStr + " " + moduleStr;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean canRestartModule(IModule[] modules) {
        IServer server;
        block4: {
            CloudFoundryServer cloudServer = this.getCloudFoundryServer();
            server = cloudServer.getServerOriginal();
            int moduleState = server.getModuleState(modules);
            if (moduleState != 2) break block4;
            return true;
        }
        try {
            int publishState = server.getModulePublishState(modules);
            if (publishState == 0) {
                return false;
            }
        }
        catch (CoreException ce) {
            CloudFoundryPlugin.logError(ce);
        }
        return super.canRestartModule(modules);
    }

    public ApplicationInstanceRunningTracker getApplicationInstanceRunningTracker(CloudFoundryApplicationModule appModule) throws CoreException {
        return new ApplicationInstanceRunningTracker(appModule, this.getCloudFoundryServer());
    }

    public List<String> getBuildpacks(IProgressMonitor monitor) throws CoreException {
        return this.getRequestFactory().getBuildpacks().run(monitor);
    }

    public boolean supportsSsh() {
        try {
            return this.getRequestFactory().supportsSsh();
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
            return false;
        }
    }

    public CFInfo getCloudInfo() throws CoreException {
        return this.getRequestFactory().getCloudInfo();
    }

    public void asyncUpdateAll() {
        UpdateOperationsScheduler scheduler = this.getUpdateModulesScheduler();
        if (scheduler != null) {
            scheduler.updateAll();
        }
    }

    public void asyncUpdateDeployedModule(IModule module) {
        UpdateOperationsScheduler scheduler = this.getUpdateModulesScheduler();
        if (scheduler != null) {
            scheduler.updateDeployedModule(module);
        }
    }

    public void asyncUpdateModuleAfterPublish(IModule module) {
        UpdateOperationsScheduler scheduler = this.getUpdateModulesScheduler();
        if (scheduler != null) {
            scheduler.updateModuleAfterPublish(module);
        }
    }

    public void asyncUpdateModule(IModule module) {
        UpdateOperationsScheduler scheduler = this.getUpdateModulesScheduler();
        if (scheduler != null) {
            scheduler.updateModule(module);
        }
    }

    protected static enum DebugSupportCheck {
        UNCHECKED,
        SUPPORTED,
        UNSUPPORTED;

    }

    static class PublishJobMonitor
    extends JobChangeAdapter {
        private List<Job> jobLst = new ArrayList<Job>();

        PublishJobMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void init() {
            List<Job> list = this.jobLst;
            synchronized (list) {
                this.jobLst.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            super.done(event);
            List<Job> list = this.jobLst;
            synchronized (list) {
                this.jobLst.remove(event.getJob());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void monitorJob(Job curJob) {
            curJob.addJobChangeListener((IJobChangeListener)this);
            List<Job> list = this.jobLst;
            synchronized (list) {
                this.jobLst.add(curJob);
            }
        }

        boolean isAllJobCompleted() {
            return this.jobLst.size() == 0;
        }

        void waitForJobCompletion(IProgressMonitor monitor) {
            while (!(monitor != null && monitor.isCanceled() || this.jobLst.size() <= 0)) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

