/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.ui.internal.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.eclipse.cft.server.core.CFApplicationArchive;
import org.eclipse.cft.server.core.internal.CFConsoleHandler;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryProjectUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.application.JavaWebApplicationDelegate;
import org.eclipse.cft.server.core.internal.application.ZipArchive;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.standalone.core.internal.application.ICloudFoundryArchiver;
import org.eclipse.cft.server.standalone.core.internal.application.StandaloneConsole;
import org.eclipse.cft.server.standalone.ui.internal.Messages;
import org.eclipse.cft.server.standalone.ui.internal.application.JavaPackageFragmentRootHandler;
import org.eclipse.cft.server.ui.internal.CFUiUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarRsrcUrlBuilder;
import org.eclipse.jdt.ui.jarpackager.IJarBuilder;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCallback;
import org.springframework.boot.loader.tools.LibraryScope;
import org.springframework.boot.loader.tools.Repackager;

public class JavaCloudFoundryArchiver
implements ICloudFoundryArchiver {
    private CloudFoundryApplicationModule appModule;
    private IModule actualModule;
    private CloudFoundryServer cloudServer;
    private boolean initialized = false;
    private static final String META_FOLDER_NAME = "META-INF";
    private static final String MANIFEST_FILE = "MANIFEST.MF";

    public void initialize(IModule module, IServer server) throws CoreException {
        this.cloudServer = CloudServerUtil.getCloudServer((IServer)server);
        this.actualModule = module;
        Assert.isNotNull((Object)module, (String)"Unable to package standalone application. No WTP module found for application. Refresh server and try again.");
        this.appModule = this.cloudServer.getExistingCloudModule(module);
        Assert.isNotNull((Object)this.appModule, (String)"Unable to package standalone application. No cloud application module found. Refresh server and try again.");
        this.initialized = true;
    }

    protected CFConsoleHandler getConsole() {
        return StandaloneConsole.getDefault();
    }

    /*
     * Unable to fully structure code
     */
    public CFApplicationArchive getApplicationArchive(IProgressMonitor monitor) throws CoreException {
        if (!this.initialized) {
            throw CloudErrorUtil.toCoreException((String)Messages.JavaCloudFoundryArchiver_ERROR_ARCHIVER_NOT_INITIALIZED);
        }
        this.refreshProject(monitor);
        project = this.getProject();
        projectName = project != null ? project.getName() : "UNKNOWN PROJECT";
        archive = JavaWebApplicationDelegate.getArchiveFromManifest((CloudFoundryApplicationModule)this.appModule, (CloudFoundryServer)this.cloudServer);
        if (archive != null) {
            this.getConsole().printToConsole(this.actualModule, this.cloudServer, NLS.bind((String)Messages.JavaCloudFoundryArchiver_FOUND_ARCHIVE_FROM_MANIFEST, (Object)archive.getName()));
        } else {
            block34: {
                packagedFile = null;
                javaProject = CloudFoundryProjectUtil.getJavaProject((CloudFoundryApplicationModule)this.appModule);
                if (javaProject == null) {
                    this.handleApplicationDeploymentFailure(Messages.JavaCloudFoundryArchiver_ERROR_NO_JAVA_PROJ_RESOLVED);
                }
                if ((mainType = (rootResolver = this.getPackageFragmentRootHandler(javaProject, monitor)).getMainType(monitor)) != null) {
                    this.getConsole().printToConsole(this.actualModule, this.cloudServer, NLS.bind((String)Messages.JavaCloudFoundryArchiver_PACKAGING_MAIN_TYPE, (Object)mainType.getFullyQualifiedName()));
                }
                if ((roots = rootResolver.getPackageFragmentRoots(monitor)) == null || roots.length == 0) {
                    this.handleApplicationDeploymentFailure(Messages.JavaCloudFoundryArchiver_ERROR_NO_PACKAGE_FRAG_ROOTS);
                }
                jarPackageData = this.getJarPackageData(roots, mainType, monitor);
                isBoot = CloudFoundryProjectUtil.isSpringBoot((CloudFoundryApplicationModule)this.appModule);
                metaFile = this.getManifest(roots, javaProject);
                if (!isBoot && metaFile != null) {
                    jarPackageData.setJarBuilder(this.getDefaultLibJarBuilder());
                    jarPackageData.setManifestLocation(metaFile.getFullPath());
                    jarPackageData.setSaveManifest(false);
                    jarPackageData.setGenerateManifest(false);
                    if (!jarPackageData.isManifestAccessible()) {
                        this.handleApplicationDeploymentFailure(NLS.bind((String)Messages.JavaCloudFoundryArchiver_ERROR_MANIFEST_NOT_ACCESSIBLE, (Object)metaFile.getLocation().toString()));
                    }
                    inputStream = null;
                    try {
                        inputStream = new FileInputStream(metaFile.getLocation().toFile());
                        manifest = new Manifest(inputStream);
                        att = manifest.getMainAttributes();
                        if (att.getValue("Main-Class") == null) {
                            this.handleApplicationDeploymentFailure(Messages.JavaCloudFoundryArchiver_ERROR_NO_MAIN_CLASS_IN_MANIFEST);
                        }
                    }
                    catch (FileNotFoundException e) {
                        this.handleApplicationDeploymentFailure(NLS.bind((String)Messages.JavaCloudFoundryArchiver_ERROR_FAILED_READ_MANIFEST, (Object)e.getLocalizedMessage()));
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException v0) {}
                        }
                        break block34;
                    }
                    catch (IOException e) {
                        try {
                            this.handleApplicationDeploymentFailure(NLS.bind((String)Messages.JavaCloudFoundryArchiver_ERROR_FAILED_READ_MANIFEST, (Object)e.getLocalizedMessage()));
                            ** if (inputStream == null) goto lbl-1000
                        }
                        catch (Throwable var16_20) {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException v2) {}
                            }
                            throw var16_20;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                inputStream.close();
                            }
                            catch (IOException v1) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block34;
                        }
                    }
                    ** if (inputStream == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        try {
                            inputStream.close();
                        }
                        catch (IOException v3) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block34;
                    }
                }
                jarPackageData.setGenerateManifest(true);
                jarPackageData.setExportOutputFolders(true);
            }
            try {
                this.getConsole().printToConsole(this.actualModule, this.cloudServer, NLS.bind((String)Messages.JavaCloudFoundryArchiver_PACKAGING_APPLICATION, (Object)projectName));
                packagedFile = this.packageApplication(jarPackageData, monitor);
            }
            catch (CoreException e) {
                this.handleApplicationDeploymentFailure(NLS.bind((String)Messages.JavaCloudFoundryArchiver_ERROR_JAVA_APP_PACKAGE, (Object)e.getMessage()));
            }
            if (packagedFile == null || !packagedFile.exists()) {
                this.handleApplicationDeploymentFailure(Messages.JavaCloudFoundryArchiver_ERROR_NO_PACKAGED_FILE_CREATED);
            } else {
                this.getConsole().printToConsole(this.actualModule, this.cloudServer, NLS.bind((String)Messages.JavaCloudFoundryArchiver_PACKAGING_APPLICATION_COMPLETED, (Object)projectName, (Object)packagedFile.getAbsolutePath()));
            }
            if (isBoot) {
                this.getConsole().printToConsole(this.actualModule, this.cloudServer, Messages.JavaCloudFoundryArchiver_REPACKAGING_SPRING_BOOT_APP);
                this.bootRepackage(roots, packagedFile);
            }
            try {
                archive = new ZipArchive(new ZipFile(packagedFile));
            }
            catch (IOException ioe) {
                this.handleApplicationDeploymentFailure(NLS.bind((String)Messages.JavaCloudFoundryArchiver_ERROR_CREATE_CF_ARCHIVE, (Object)ioe.getMessage()));
            }
        }
        return archive;
    }

    protected IProject getProject() {
        return CloudFoundryProjectUtil.getProject((CloudFoundryApplicationModule)this.appModule);
    }

    protected IFolder getMetaFolder(IResource resource) throws CoreException {
        if (!(resource instanceof IContainer)) {
            return null;
        }
        IContainer folder = (IContainer)resource;
        IResource[] members = folder.members();
        if (members != null) {
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource mem = iResourceArray[n2];
                if (META_FOLDER_NAME.equals(mem.getName()) && mem instanceof IFolder) {
                    return (IFolder)mem;
                }
                ++n2;
            }
        }
        return null;
    }

    protected IFile getManifest(IPackageFragmentRoot[] roots, IJavaProject javaProject) throws CoreException {
        IResource[] members;
        IFolder metaFolder = null;
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (!root.isArchive() && !root.isExternal() && (metaFolder = this.getMetaFolder(resource = root.getResource())) != null) break;
            ++n2;
        }
        if (metaFolder == null) {
            metaFolder = this.getMetaFolder((IResource)javaProject.getProject());
        }
        if (metaFolder != null && (members = metaFolder.members()) != null) {
            IResource[] iResourceArray = members;
            int n3 = members.length;
            n = 0;
            while (n < n3) {
                IResource mem = iResourceArray[n];
                if (MANIFEST_FILE.equals(mem.getName().toUpperCase()) && mem instanceof IFile) {
                    return (IFile)mem;
                }
                ++n;
            }
        }
        return null;
    }

    protected void refreshProject(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (project != null && project.isAccessible()) {
            this.getConsole().printToConsole(this.actualModule, this.cloudServer, NLS.bind((String)Messages.JavaCloudFoundryArchiver_REFRESHING_PROJECT, (Object)project.getName()));
            project.refreshLocal(2, monitor);
        }
    }

    protected IJarBuilder getDefaultLibJarBuilder() {
        return new FatJarRsrcUrlBuilder(){

            public void writeRsrcUrlClasses() throws IOException {
            }
        };
    }

    protected JavaPackageFragmentRootHandler getPackageFragmentRootHandler(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        return new JavaPackageFragmentRootHandler(javaProject, this.cloudServer);
    }

    protected void bootRepackage(final IPackageFragmentRoot[] roots, File packagedFile) throws CoreException {
        Repackager bootRepackager = new Repackager(packagedFile);
        try {
            bootRepackager.repackage(new Libraries(){

                public void doWithLibraries(LibraryCallback callBack) throws IOException {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                    int n = roots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File rootFile;
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                        if (root.isArchive() && (rootFile = new File(root.getPath().toOSString())).exists()) {
                            callBack.library(new Library(rootFile, LibraryScope.COMPILE));
                        }
                        ++n2;
                    }
                }
            });
        }
        catch (IOException e) {
            this.handleApplicationDeploymentFailure(NLS.bind((String)Messages.JavaCloudFoundryArchiver_ERROR_REPACKAGE_SPRING, (Object)e.getMessage()));
        }
    }

    protected JarPackageData getJarPackageData(IPackageFragmentRoot[] roots, IType mainType, IProgressMonitor monitor) throws CoreException {
        String filePath = JavaCloudFoundryArchiver.getTempJarPath(this.appModule.getLocalModule());
        if (filePath == null) {
            this.handleApplicationDeploymentFailure();
        }
        Path location = new Path(filePath);
        JarPackageData packageData = new JarPackageData();
        packageData.setJarLocation((IPath)location);
        packageData.setGenerateManifest(false);
        packageData.setSaveManifest(false);
        packageData.setManifestMainClass(mainType);
        packageData.setElements((Object[])roots);
        return packageData;
    }

    protected File packageApplication(final JarPackageData packageData, IProgressMonitor monitor) throws CoreException {
        int progressWork = 10;
        final SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)progressWork);
        final File[] createdFile = new File[1];
        final CoreException[] error = new CoreException[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Shell shell = CFUiUtil.getShell();
                    IJarExportRunnable runnable = packageData.createJarExportRunnable(shell);
                    try {
                        try {
                            runnable.run((IProgressMonitor)subProgress);
                            File file = new File(packageData.getJarLocation().toString());
                            if (!file.exists()) {
                                JavaCloudFoundryArchiver.this.handleApplicationDeploymentFailure();
                            } else {
                                createdFile[0] = file;
                            }
                        }
                        catch (InvocationTargetException e) {
                            throw CloudErrorUtil.toCoreException((Throwable)e);
                        }
                        catch (InterruptedException ie) {
                            throw CloudErrorUtil.toCoreException((Throwable)ie);
                        }
                    }
                    finally {
                        subProgress.done();
                    }
                }
                catch (CoreException e) {
                    error[0] = e;
                }
            }
        });
        if (error[0] != null) {
            throw error[0];
        }
        return createdFile[0];
    }

    protected void handleApplicationDeploymentFailure(String errorMessage) throws CoreException {
        if (errorMessage == null) {
            errorMessage = Messages.JavaCloudFoundryArchiver_ERROR_CREATE_PACKAGED_FILE;
        }
        errorMessage = String.valueOf(errorMessage) + " - " + this.appModule.getDeployedApplicationName() + ". Unable to package application for deployment.";
        this.getConsole().printErrorToConsole(this.actualModule, this.cloudServer, errorMessage);
        throw CloudErrorUtil.toCoreException((String)errorMessage);
    }

    protected void handleApplicationDeploymentFailure() throws CoreException {
        this.handleApplicationDeploymentFailure(null);
    }

    public static String getTempJarPath(IModule module) throws CoreException {
        try {
            File tempFolder = File.createTempFile("tempFolderForJavaAppJar", null);
            tempFolder.delete();
            tempFolder.mkdirs();
            if (!tempFolder.exists()) {
                throw CloudErrorUtil.toCoreException((String)NLS.bind((String)Messages.JavaCloudFoundryArchiver_ERROR_CREATE_TEMP_DIR, (Object)tempFolder.getPath()));
            }
            File targetFile = new File(tempFolder, String.valueOf(module.getName()) + ".jar");
            targetFile.deleteOnExit();
            String path = new Path(targetFile.getAbsolutePath()).toString();
            return path;
        }
        catch (IOException io) {
            CloudErrorUtil.toCoreException((Throwable)io);
            return null;
        }
    }
}

