/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.util;

import com.google.common.base.Function;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.cbi.targetplatform.model.IncludeDeclaration;
import org.eclipse.cbi.targetplatform.model.Location;
import org.eclipse.cbi.targetplatform.model.TargetContent;
import org.eclipse.cbi.targetplatform.model.TargetPlatform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class LocationIndexBuilder {
    @Inject
    private ImportUriResolver resolver;

    public ListMultimap<String, Location> getLocationIndex(TargetPlatform targetPlatform) {
        List<Location> locationList = this.getLocations(CollectionLiterals.newLinkedHashSet((Object[])new TargetPlatform[]{targetPlatform}), CollectionLiterals.newLinkedList((Object[])new TargetPlatform[]{targetPlatform}));
        Function _function = it -> it.getUri();
        return LinkedListMultimap.create((Multimap)Multimaps.index(locationList, (Function)_function));
    }

    private List<Location> getLocations(Set<TargetPlatform> visited, List<TargetPlatform> toBeVisited) {
        ArrayList locations = CollectionLiterals.newArrayList();
        Consumer<TargetPlatform> _function = it -> {
            boolean _not;
            LinkedList includes = CollectionLiterals.newLinkedList();
            Consumer<TargetContent> _function_1 = content -> {
                if (content instanceof Location) {
                    boolean _not;
                    boolean _isEmpty = includes.isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        locations.addAll(this.getLocationFromVisitedIncludes((TargetPlatform)it, includes, visited));
                        includes.clear();
                    }
                    locations.add((Location)content);
                } else if (content instanceof IncludeDeclaration) {
                    includes.add((IncludeDeclaration)content);
                }
            };
            ListExtensions.reverseView((List)it.getContents()).forEach(_function_1);
            boolean _isEmpty = includes.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                locations.addAll(this.getLocationFromVisitedIncludes((TargetPlatform)it, includes, visited));
                includes.clear();
            }
        };
        toBeVisited.forEach(_function);
        return locations;
    }

    private List<Location> getLocationFromVisitedIncludes(TargetPlatform parent, List<IncludeDeclaration> includes, Set<TargetPlatform> visited) {
        Functions.Function1 _function = it -> this.getImportedTargetPlatform(parent.eResource(), (IncludeDeclaration)it);
        Functions.Function1 _function_1 = it -> {
            boolean _contains = visited.contains(it);
            return !_contains;
        };
        List importedLocation = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map(includes, (Functions.Function1)_function)), (Functions.Function1)_function_1));
        visited.addAll(importedLocation);
        return this.getLocations(visited, importedLocation);
    }

    public LinkedList<TargetPlatform> getImportedTargetPlatforms(TargetPlatform targetPlatform) {
        LinkedHashSet visited = CollectionLiterals.newLinkedHashSet();
        LinkedList queue = CollectionLiterals.newLinkedList();
        LinkedList includeRet = CollectionLiterals.newLinkedList();
        queue.addLast(targetPlatform);
        visited.add(targetPlatform);
        while (!queue.isEmpty()) {
            LinkedList tr = CollectionLiterals.newLinkedList();
            TargetPlatform t = (TargetPlatform)queue.removeLast();
            Functions.Function1 _function = it -> this.getImportedTargetPlatform(t.eResource(), (IncludeDeclaration)it);
            Iterable _filterNull = IterableExtensions.filterNull((Iterable)ListExtensions.map((List)t.getIncludes(), (Functions.Function1)_function));
            for (TargetPlatform unvisited : _filterNull) {
                boolean _not;
                boolean _contains = visited.contains(unvisited);
                boolean bl = _not = !_contains;
                if (!_not) continue;
                visited.add(unvisited);
                queue.addLast(unvisited);
                tr.addFirst(unvisited);
            }
            includeRet.addAll(tr);
        }
        return includeRet;
    }

    public List<TargetPlatform> checkIncludeCycle(TargetPlatform targetPlatform) {
        LinkedHashSet acc = CollectionLiterals.newLinkedHashSet();
        LinkedList s = CollectionLiterals.newLinkedList();
        List _xifexpression = null;
        boolean _checkIncludeCycle = this.checkIncludeCycle(targetPlatform, acc, s);
        _xifexpression = _checkIncludeCycle ? ListExtensions.reverse((List)s) : CollectionLiterals.newImmutableList((Object[])new TargetPlatform[0]);
        return _xifexpression;
    }

    private boolean checkIncludeCycle(TargetPlatform targetPlatform, Set<TargetPlatform> visited, LinkedList<TargetPlatform> s) {
        s.addFirst(targetPlatform);
        Resource context = targetPlatform.eResource();
        Functions.Function1 _function = it -> this.getImportedTargetPlatform(context, (IncludeDeclaration)it);
        Set includedTPs = IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)targetPlatform.getIncludes(), (Functions.Function1)_function)));
        for (TargetPlatform includedTP : includedTPs) {
            boolean _contains = s.contains(includedTP);
            if (_contains) {
                s.addFirst(includedTP);
                return true;
            }
            visited.add(includedTP);
            boolean _checkIncludeCycle = this.checkIncludeCycle(includedTP, visited, s);
            if (!_checkIncludeCycle) continue;
            return true;
        }
        s.removeFirst();
        return false;
    }

    public TargetPlatform getImportedTargetPlatform(Resource context, IncludeDeclaration include) {
        EObject root;
        TargetPlatform ret = null;
        Resource resource = EcoreUtil2.getResource((Resource)context, (String)this.resolver.resolve((EObject)include));
        EList _contents = null;
        if (resource != null) {
            _contents = resource.getContents();
        }
        EObject _head = null;
        if (_contents != null) {
            _head = (EObject)IterableExtensions.head((Iterable)_contents);
        }
        if ((root = _head) instanceof TargetPlatform) {
            ret = (TargetPlatform)root;
        }
        return ret;
    }
}

