/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.formatting2;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.cbi.targetplatform.model.Environment;
import org.eclipse.cbi.targetplatform.model.IU;
import org.eclipse.cbi.targetplatform.model.IncludeDeclaration;
import org.eclipse.cbi.targetplatform.model.Location;
import org.eclipse.cbi.targetplatform.model.Options;
import org.eclipse.cbi.targetplatform.model.TargetContent;
import org.eclipse.cbi.targetplatform.model.TargetPlatform;
import org.eclipse.cbi.targetplatform.model.TargetPlatformPackage;
import org.eclipse.cbi.targetplatform.services.TargetPlatformGrammarAccess;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.internal.SinglelineDocCommentReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class TargetPlatformFormatter
extends AbstractFormatter2 {
    @Inject
    @Extension
    private TargetPlatformGrammarAccess _targetPlatformGrammarAccess;

    protected void _format(TargetPlatform it, @Extension IFormattableDocument document) {
        this.formatName(it, document);
        Consumer<TargetContent> _function = it_1 -> document.format(it_1);
        it.getContents().forEach(_function);
    }

    protected void _format(Options it, @Extension IFormattableDocument document) {
        this.formatWithKeyword(it, document);
        this.formatOptions(it, document);
    }

    protected void _format(Environment it, @Extension IFormattableDocument document) {
        this.formatEnvironmentKeyword(it, document);
        this.formatEnvironments(it, document);
    }

    protected void _format(IncludeDeclaration it, @Extension IFormattableDocument document) {
        Keyword includeKeyword = this._targetPlatformGrammarAccess.getIncludeDeclarationAccess().getIncludeKeyword_0();
        ISemanticRegion includeKeywordRegion = this.textRegionExtensions.regionFor((EObject)it).keyword(includeKeyword);
        ISemanticRegion firstIncludeKeywordRegion = (ISemanticRegion)IterableExtensions.head((Iterable)this.textRegionExtensions.allRegionsFor(it.eContainer()).keywords(new Keyword[]{includeKeyword}));
        Procedures.Procedure1 _function = it_1 -> {
            boolean _equals = Objects.equal((Object)includeKeywordRegion, (Object)firstIncludeKeywordRegion);
            if (_equals) {
                it_1.setNewLines(2, 2, 2);
            } else {
                it_1.setNewLines(1, 1, 1);
            }
        };
        document.prepend(includeKeywordRegion, _function);
        Procedures.Procedure1 _function_1 = it_1 -> it_1.oneSpace();
        document.append(includeKeywordRegion, _function_1);
    }

    protected void _format(Location it, @Extension IFormattableDocument document) {
        ISemanticRegion locationKeywordRegion = this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getLocationAccess().getLocationKeyword_0());
        Procedures.Procedure1 _function = it_1 -> it_1.setNewLines(2, 2, 2);
        document.prepend(locationKeywordRegion, _function);
        Procedures.Procedure1 _function_1 = it_1 -> it_1.oneSpace();
        document.append(locationKeywordRegion, _function_1);
        Procedures.Procedure1 _function_2 = it_1 -> it_1.oneSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)it).feature((EStructuralFeature)TargetPlatformPackage.Literals.LOCATION__ID), _function_2);
        ISemanticRegion begin = this.textRegionExtensions.regionFor((EObject)it).keyword("{");
        ISemanticRegion end = this.textRegionExtensions.regionFor((EObject)it).keyword("}");
        Procedures.Procedure1 _function_3 = it_1 -> it_1.oneSpace();
        document.prepend(begin, _function_3);
        Procedures.Procedure1 _function_4 = it_1 -> it_1.newLine();
        document.append(begin, _function_4);
        Procedures.Procedure1 _function_5 = it_1 -> it_1.indent();
        document.interior(begin, end, _function_5);
        Consumer<IU> _function_6 = it_1 -> document.format(it_1);
        it.getIus().forEach(_function_6);
        Procedures.Procedure1 _function_7 = it_1 -> it_1.newLine();
        document.prepend(end, _function_7);
    }

    protected void _format(IU it, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it_1 -> it_1.oneSpace();
        Procedures.Procedure1 _function_1 = it_1 -> it_1.noSpace();
        document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)it).feature((EStructuralFeature)TargetPlatformPackage.Literals.IU__VERSION), _function), _function_1);
        Procedures.Procedure1 _function_2 = it_1 -> it_1.newLine();
        document.append((EObject)it, _function_2);
    }

    private ISemanticRegion formatName(TargetPlatform it, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it_1 -> it_1.oneSpace();
        Procedures.Procedure1 _function_1 = it_1 -> {
            it_1.noSpace();
            it_1.setPriority(-1);
        };
        return document.append(document.prepend(this.textRegionExtensions.regionFor((EObject)it).feature((EStructuralFeature)TargetPlatformPackage.Literals.TARGET_PLATFORM__NAME), _function), _function_1);
    }

    private ISemanticRegion formatWithKeyword(Options it, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it_1 -> {
            it_1.oneSpace();
            it_1.setPriority(1);
        };
        return document.prepend(this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getOptionsAccess().getWithKeyword_0()), _function);
    }

    private void formatOptions(Options it, @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = it_1 -> {
            Procedures.Procedure1 _function_1 = it_2 -> {
                it_2.oneSpace();
                it_2.setPriority(1);
            };
            document.prepend(it_1, _function_1);
            Procedures.Procedure1 _function_2 = it_2 -> {
                it_2.noSpace();
                it_2.setPriority(-1);
            };
            document.append(it_1, _function_2);
        };
        this.textRegionExtensions.allSemanticRegions((EObject)it).forEach(_function);
        Consumer<ISemanticRegion> _function_1 = it_1 -> {
            Procedures.Procedure1 _function_2 = it_2 -> it_2.noSpace();
            Procedures.Procedure1 _function_3 = it_2 -> it_2.oneSpace();
            document.append(document.prepend(it_1, _function_2), _function_3);
        };
        this.textRegionExtensions.allRegionsFor((EObject)it).keywords(new String[]{","}).forEach(_function_1);
    }

    private ISemanticRegion formatEnvironmentKeyword(Environment it, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it_1 -> {
            it_1.oneSpace();
            it_1.setPriority(1);
        };
        return document.prepend(this.textRegionExtensions.regionFor((EObject)it).keyword(this._targetPlatformGrammarAccess.getEnvironmentAccess().getEnvironmentKeyword_1()), _function);
    }

    private void formatEnvironments(Environment it, @Extension IFormattableDocument document) {
        Consumer<ISemanticRegion> _function = it_1 -> {
            Procedures.Procedure1 _function_1 = it_2 -> {
                it_2.oneSpace();
                it_2.setPriority(1);
            };
            document.prepend(it_1, _function_1);
            Procedures.Procedure1 _function_2 = it_2 -> {
                it_2.noSpace();
                it_2.setPriority(-1);
            };
            document.append(it_1, _function_2);
        };
        this.textRegionExtensions.allSemanticRegions((EObject)it).forEach(_function);
        Consumer<ISemanticRegion> _function_1 = it_1 -> {
            Procedures.Procedure1 _function_2 = it_2 -> it_2.noSpace();
            Procedures.Procedure1 _function_3 = it_2 -> it_2.oneSpace();
            document.append(document.prepend(it_1, _function_2), _function_3);
        };
        this.textRegionExtensions.allRegionsFor((EObject)it).keywords(new String[]{","}).forEach(_function_1);
    }

    public ITextReplacer createCommentReplacer(IComment comment) {
        String ruleName;
        boolean _startsWith;
        ITextReplacer _xblockexpression = null;
        EObject grammarElement = comment.getGrammarElement();
        if (grammarElement instanceof AbstractRule && (_startsWith = (ruleName = ((AbstractRule)grammarElement).getName()).startsWith("SL"))) {
            return new SinglelineDocCommentReplacer(comment, "//");
        }
        _xblockexpression = super.createCommentReplacer(comment);
        return _xblockexpression;
    }

    public void format(Object it, IFormattableDocument document) {
        if (it instanceof XtextResource) {
            this._format((XtextResource)it, document);
            return;
        }
        if (it instanceof Environment) {
            this._format((Environment)it, document);
            return;
        }
        if (it instanceof IncludeDeclaration) {
            this._format((IncludeDeclaration)it, document);
            return;
        }
        if (it instanceof Location) {
            this._format((Location)it, document);
            return;
        }
        if (it instanceof Options) {
            this._format((Options)it, document);
            return;
        }
        if (it instanceof IU) {
            this._format((IU)it, document);
            return;
        }
        if (it instanceof TargetPlatform) {
            this._format((TargetPlatform)it, document);
            return;
        }
        if (it instanceof EObject) {
            this._format((EObject)it, document);
            return;
        }
        if (it == null) {
            this._format(null, document);
            return;
        }
        if (it != null) {
            this._format(it, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, document).toString());
    }
}

