/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.ui.handler;

import com.google.inject.Injector;
import org.eclipse.cbi.targetplatform.pde.Converter;
import org.eclipse.cbi.targetplatform.ui.handler.PDEIntegration;
import org.eclipse.cbi.targetplatform.ui.internal.TargetplatformActivator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;

public class ConvertTargetPlatformJob
extends Job {
    private IFile selectedElement;
    private boolean setTargetPlatform;

    public ConvertTargetPlatformJob(String name, IFile selectedElement, boolean setTargetPlatform) {
        super(name);
        this.selectedElement = selectedElement;
        this.setTargetPlatform = setTargetPlatform;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus ret = Status.OK_STATUS;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Injector injector = TargetplatformActivator.getInstance().getInjector("org.eclipse.cbi.targetplatform.TargetPlatform");
        Converter converter = new Converter();
        injector.injectMembers((Object)converter);
        Diagnostic diagnostic = null;
        String path = this.selectedElement.getLocation().toFile().getAbsolutePath();
        URI targetplatformFileURI = URI.createFileURI((String)path);
        try {
            diagnostic = converter.generateTargetDefinitionFile(targetplatformFileURI, (IProgressMonitor)subMonitor.newChild(95));
        }
        catch (OperationCanceledException cancel) {
            ret = new Status(8, "org.eclipse.cbi.targetplatform.TargetPlatform", cancel.getMessage(), (Throwable)cancel);
        }
        catch (Exception e) {
            ret = new Status(4, "org.eclipse.cbi.targetplatform.TargetPlatform", e.getMessage(), (Throwable)e);
        }
        IContainer container = this.selectedElement.getParent();
        if (container != null) {
            try {
                container.refreshLocal(1, (IProgressMonitor)subMonitor.newChild(5));
            }
            catch (CoreException e) {
                return new Status(4, TargetplatformActivator.getInstance().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e);
            }
        }
        if (this.setTargetPlatform) {
            PDEIntegration pdeIntegration = new PDEIntegration();
            URI targetFileURI = targetplatformFileURI.trimFileExtension().appendFileExtension("target");
            try {
                pdeIntegration.setTargetPlatform(targetFileURI, monitor);
            }
            catch (CoreException e) {
                ret = new Status(4, "org.eclipse.cbi.targetplatform.TargetPlatform", e.getMessage(), (Throwable)e);
            }
        }
        if (diagnostic != null) {
            return BasicDiagnostic.toIStatus((Diagnostic)diagnostic);
        }
        return ret;
    }
}

