/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.ui.hover;

import com.google.inject.Inject;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.eclipse.cbi.targetplatform.model.IU;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TargetPlatformHoverProvider
extends DefaultEObjectHoverProvider {
    @Inject
    @Extension
    private IProvisioningAgent _iProvisioningAgent;

    protected String getHoverInfoAsHtml(EObject o) {
        String _xifexpression = null;
        _xifexpression = o instanceof IU ? this.getHoverInfo((IU)o) : super.getHoverInfoAsHtml(o);
        return _xifexpression;
    }

    private String getHoverInfo(IU iu) {
        try {
            String _xblockexpression = null;
            Object _service = this._iProvisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            IMetadataRepositoryManager repositoryManager = (IMetadataRepositoryManager)_service;
            String _uri = iu.getLocation().getUri();
            URI _uRI = new URI(_uri);
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            IMetadataRepository metadataRepository = repositoryManager.loadRepository(_uRI, (IProgressMonitor)_nullProgressMonitor);
            IQuery _createIUQuery = QueryUtil.createIUQuery((String)iu.getID());
            NullProgressMonitor _nullProgressMonitor_1 = new NullProgressMonitor();
            Set idResults = metadataRepository.query(_createIUQuery, (IProgressMonitor)_nullProgressMonitor_1).toUnmodifiableSet();
            _xblockexpression = this.getHoverInfo(idResults);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private String getHoverInfo(Set<IInstallableUnit> ius) {
        String _xifexpression = null;
        boolean _isEmpty = ius.isEmpty();
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<b>No information available</b>");
            _xifexpression = _builder.toString();
        } else {
            boolean _equals;
            String _xblockexpression = null;
            Functions.Function1 _function = it -> {
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.getName((IInstallableUnit)it));
                return !_isNullOrEmpty;
            };
            IInstallableUnit _findFirst = (IInstallableUnit)IterableExtensions.findFirst(ius, (Functions.Function1)_function);
            String _name = null;
            if (_findFirst != null) {
                _name = this.getName(_findFirst);
            }
            String name = _name;
            Functions.Function1 _function_1 = it -> {
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.getProvider((IInstallableUnit)it));
                return !_isNullOrEmpty;
            };
            IInstallableUnit _findFirst_1 = (IInstallableUnit)IterableExtensions.findFirst(ius, (Functions.Function1)_function_1);
            String _provider = null;
            if (_findFirst_1 != null) {
                _provider = this.getProvider(_findFirst_1);
            }
            String provider = _provider;
            Functions.Function1 _function_2 = it -> it.getVersion();
            Functions.Function1 _function_3 = it -> it.getVersion();
            List versions = ListExtensions.map((List)ListExtensions.reverse((List)IterableExtensions.sortBy(ius, (Functions.Function1)_function_2)), (Functions.Function1)_function_3);
            StringConcatenation _builder_1 = new StringConcatenation();
            if (name != null) {
                _builder_1.append("<b>Name:</b> ");
                _builder_1.append(name);
                _builder_1.append("<br>");
            }
            _builder_1.newLineIfNotEmpty();
            if (provider != null) {
                _builder_1.append("<b>Provider:</b> ");
                _builder_1.append(provider);
                _builder_1.append("<br>");
            }
            _builder_1.newLineIfNotEmpty();
            int _size = versions.size();
            boolean bl = _equals = _size == 1;
            if (_equals) {
                _builder_1.append("<b>Version:</b> ");
                Version _head = (Version)IterableExtensions.head((Iterable)versions);
                _builder_1.append((Object)_head);
                _builder_1.newLineIfNotEmpty();
            } else {
                _builder_1.append("<b>Versions:</b><br>");
                _builder_1.newLine();
                boolean _hasElements = false;
                for (Version version : versions) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder_1.appendImmediate((Object)"<br>", "");
                    }
                    _builder_1.append((Object)version);
                    _builder_1.newLineIfNotEmpty();
                }
            }
            _xifexpression = _xblockexpression = _builder_1.toString();
        }
        return _xifexpression;
    }

    private String getName(IInstallableUnit it) {
        return it.getProperty("org.eclipse.equinox.p2.name", null);
    }

    private String getProvider(IInstallableUnit it) {
        return it.getProperty("org.eclipse.equinox.p2.provider", null);
    }
}

