/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.handler.cdt;

import java.util.Collections;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.capra.core.adapters.ArtifactMetaModelAdapter;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.handlers.AbstractArtifactHandler;
import org.eclipse.capra.core.handlers.AnnotationException;
import org.eclipse.capra.core.handlers.IAnnotateArtifact;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.handler.cdt.CDTAnnotate;
import org.eclipse.capra.handler.cdt.preferences.CDTPreferences;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.ecore.EObject;

public class CDTHandler
extends AbstractArtifactHandler<ICElement>
implements IAnnotateArtifact {
    public EObject createWrapper(ICElement element, EObject artifactModel) {
        ICompositeType type = (ICompositeType)element.getParent().getAncestor(65);
        if (type == null) {
            type = (ICompositeType)element.getParent().getAncestor(67);
        }
        if (type == null) {
            type = (ICompositeType)element.getParent().getAncestor(69);
        }
        String typePrefix = type == null ? "" : String.valueOf(type.getName()) + "/";
        String uri = new URIBuilder().setScheme("platform").setPath("/resource" + element.getPath()).setFragment(String.valueOf(typePrefix) + element.getElementName()).toString();
        ArtifactMetaModelAdapter adapter = (ArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactWrapperMetaModelAdapter().get();
        EObject wrapper = adapter.createArtifact(artifactModel, ((Object)((Object)this)).getClass().getName(), uri, element.getHandleIdentifier(), element.getElementName(), element.getPath().toString());
        return wrapper;
    }

    public ICElement resolveWrapper(EObject wrapper) {
        ArtifactMetaModelAdapter adapter = (ArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactWrapperMetaModelAdapter().get();
        return CoreModel.create((String)adapter.getArtifactIdentifier(wrapper));
    }

    public String getDisplayName(ICElement element) {
        return element.getElementName();
    }

    public void annotateArtifact(EObject wrapper, String annotation) throws AnnotationException {
        IEclipsePreferences preferences = CDTPreferences.getPreferences();
        if (!preferences.getBoolean("ANNOTATE_CDT", false)) {
            return;
        }
        ICElement handle = this.resolveWrapper(wrapper);
        try {
            CDTAnnotate.annotateArtifact(handle, annotation);
        }
        catch (CoreException e) {
            throw new AnnotationException(e.getStatus());
        }
    }

    public String generateMarkerMessage(IResourceDelta delta, String wrapperUri) {
        return null;
    }

    public List<Connection> addInternalLinks(EObject investigatedElement, List<String> selectedRelationshipTypes) {
        return Collections.emptyList();
    }

    public boolean isThereAnInternalTraceBetween(EObject first, EObject second) {
        return false;
    }
}

