/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.ui.wizards;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.polarsys.kitalpha.doc.gen.business.core.preference.helper.DocgenProjectPreferencesHelper;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeReferencesStrategy;
import org.polarsys.kitalpha.doc.gen.business.core.ui.wizards.string.Messages;

public class HTMLDocumentationGenerationWizardPage
extends WizardPage {
    private static final String STATUS_4 = Messages.HTMLDocumentationGenerationWizardPage_status_4;
    private static final String STATUS_3 = Messages.HTMLDocumentationGenerationWizardPage_status_3;
    private static final String STATUS_2 = Messages.HTMLDocumentationGenerationWizardPage_status_2;
    private static final String STATUS_1 = Messages.HTMLDocumentationGenerationWizardPage_stauts_1;
    private static final String MESSAGE = Messages.HTMLDocumentationGenerationWizardPage_message;
    private static final String OUTPUT_FOLDER_TEXT = Messages.HTMLDocumentationGenerationWizardPage_output_folder_text;
    private static final String BROWSE_TEXT = Messages.HTMLDocumentationGenerationWizardPage_browse_text;
    private static final String INPUT_MODEL_TEXT = Messages.HTMLDocumentationGenerationWizardPage_input_model_text;
    private static final String DESCRIPTION = Messages.HTMLDocumentationGenerationWizardPage_description;
    private static final String TITLE = Messages.HTMLDocumentationGenerationWizardPage_title;
    private static final String GEN_OPTION_EXPORT_REF = Messages.HTMLDocumentationGenerationWizardPage_Export_Ref;
    private Text containerText;
    private Text modelURIText;
    private ISelection selection;
    private Map<String, URI> launcherUris;
    private Combo combo;
    private ScopeReferencesStrategy referencesStrategy = ScopeReferencesStrategy.EXPORT;
    private boolean scopedGeneration = false;

    public boolean isScopedGeneration() {
        return this.scopedGeneration;
    }

    public void setScopedGeneration(boolean scopedGeneration) {
        this.scopedGeneration = scopedGeneration;
    }

    public HTMLDocumentationGenerationWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        GridData gd = new GridData(768);
        Label label = new Label(container, 0);
        label.setText(INPUT_MODEL_TEXT);
        this.modelURIText = new Text(container, 2052);
        gd = new GridData(768);
        this.modelURIText.setLayoutData((Object)gd);
        this.modelURIText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HTMLDocumentationGenerationWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(BROWSE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HTMLDocumentationGenerationWizardPage.this.modelSelection();
            }
        });
        label = new Label(container, 0);
        label.setText(OUTPUT_FOLDER_TEXT);
        this.containerText = new Text(container, 2052);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HTMLDocumentationGenerationWizardPage.this.dialogChanged();
            }
        });
        button = new Button(container, 8);
        button.setText(BROWSE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HTMLDocumentationGenerationWizardPage.this.outputFolderSelection();
            }
        });
        if (this.launcherUris.size() > 1) {
            label = new Label(container, 0);
            label.setText("Launcher:");
            this.combo = new Combo(container, 2048);
            GridData comboGridData = new GridData(768);
            comboGridData.horizontalSpan = 2;
            this.combo.setLayoutData((Object)comboGridData);
            for (String name : this.launcherUris.keySet()) {
                int index = this.combo.getItemCount();
                if (name.equals("Default Launcher")) {
                    index = 0;
                }
                this.combo.add(name, index);
            }
            this.combo.select(0);
        }
        if (this.isScopedGeneration()) {
            this.createScopeOptionsWidgets(container);
        }
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void createScopeOptionsWidgets(Composite container) {
        Group optionsGroup = new Group(container, 0);
        optionsGroup.setText("Partial generation options");
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 3;
        optionsGroup.setLayoutData((Object)groupGridData);
        GridLayout optionsGroupGridLayout = new GridLayout(1, false);
        optionsGroupGridLayout.verticalSpacing = 10;
        optionsGroup.setLayout((Layout)optionsGroupGridLayout);
        Button referencesStrategy_cb = new Button((Composite)optionsGroup, 32);
        referencesStrategy_cb.setText(GEN_OPTION_EXPORT_REF);
        referencesStrategy_cb.setSelection(this.referencesStrategy.equals((Object)ScopeReferencesStrategy.EXPORT));
        referencesStrategy_cb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Button btn = (Button)e.getSource();
                if (btn.getSelection()) {
                    HTMLDocumentationGenerationWizardPage.this.referencesStrategy = ScopeReferencesStrategy.EXPORT;
                } else {
                    HTMLDocumentationGenerationWizardPage.this.referencesStrategy = ScopeReferencesStrategy.DONT_EXPORT;
                }
            }
        });
    }

    public ScopeReferencesStrategy getReferencesStrategy() {
        return this.referencesStrategy;
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            Object obj = ssel.getFirstElement();
            if (obj instanceof EObject) {
                EObject modelElement = (EObject)obj;
                URI uri = modelElement.eResource().getURI();
                if (uri.isPlatform()) {
                    this.modelURIText.setText(uri.toString());
                    String outputPathDefaultValue = "/" + uri.segments()[1];
                    outputPathDefaultValue = DocgenProjectPreferencesHelper.getInstance((Object)obj).getOutputLocationPreference(outputPathDefaultValue);
                    this.containerText.setText(outputPathDefaultValue);
                }
            } else {
                if (obj instanceof IResource) {
                    IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                    String outputPathDefaultValue = container.getFullPath().toString();
                    outputPathDefaultValue = DocgenProjectPreferencesHelper.getInstance((Object)obj).getOutputLocationPreference(outputPathDefaultValue);
                    this.containerText.setText(outputPathDefaultValue);
                }
                Object[] objectArray = ssel.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof IFile) {
                        IFile modelFile = (IFile)object;
                        URI uri = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                        this.modelURIText.setText(String.valueOf(this.modelURIText.getText()) + " " + uri.toString());
                    }
                    ++n2;
                }
            }
        }
    }

    private void modelSelection() {
        String uriText;
        LoadResourceAction.LoadResourceDialog dialog = new LoadResourceAction.LoadResourceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        if (dialog.open() == 0 && (uriText = dialog.getURIText()) != null) {
            this.modelURIText.setText(uriText);
        }
    }

    private void outputFolderSelection() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, MESSAGE);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        if (!(container instanceof IFolder)) {
            this.updateStatus(STATUS_4);
            return;
        }
        if (this.getContainerName().length() == 0) {
            this.updateStatus(STATUS_1);
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus(STATUS_2);
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(STATUS_3);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getModelURI() {
        return this.modelURIText.getText();
    }

    public void setLauncherUris(Map<String, URI> launcherUris) {
        this.launcherUris = launcherUris;
    }

    public String getSelectedLauncher() {
        if (this.combo != null) {
            return this.combo.getText();
        }
        Iterator<String> iterator = this.launcherUris.keySet().iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return "";
    }

    public void savePreferences() {
        IStructuredSelection ssel = (IStructuredSelection)this.selection;
        Object obj = ssel.getFirstElement();
        DocgenProjectPreferencesHelper.getInstance((Object)obj).setOutputLocationPreference(this.containerText.getText());
    }
}

