/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.providers;

import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.model.pattern.Query;
import org.eclipse.egf.pattern.query.IQuery;
import org.eclipse.egf.pattern.query.QueryKind;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Point;

public class ParametersTableLabelProvider
extends CellLabelProvider {
    public String getToolTipText(Object element) {
        if (element instanceof PatternParameter) {
            return ((PatternParameter)element).getType();
        }
        if (element instanceof PatternVariable) {
            return ((PatternVariable)element).getType();
        }
        return null;
    }

    public Point getToolTipShift(Object object) {
        return new Point(5, 5);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 100;
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 5000;
    }

    public void update(ViewerCell cell) {
        EMap queryContext;
        Query query;
        Object element = cell.getElement();
        int columnIndex = cell.getColumnIndex();
        if (element instanceof PatternParameter && columnIndex == 2 && (query = ((PatternParameter)element).getQuery()) != null && (queryContext = query.getQueryContext()) != null && !queryContext.isEmpty()) {
            cell.setImage(Activator.getDefault().getImage("obj16/query_set.gif"));
        }
        if (element instanceof PatternParameter) {
            PatternParameter patternParameter = (PatternParameter)element;
            switch (columnIndex) {
                case 0: {
                    cell.setText(patternParameter.getName());
                    return;
                }
                case 1: {
                    cell.setText(ParametersTableLabelProvider.getType(patternParameter.getType()));
                    return;
                }
                case 2: {
                    Query query2 = patternParameter.getQuery();
                    if (query2 != null) {
                        String queryKindName;
                        String extensionId = query2.getExtensionId();
                        QueryKind queryKind = IQuery.INSTANCE.getQueryKind(extensionId);
                        String string = queryKindName = queryKind == null ? null : queryKind.getName();
                        if (queryKindName != null) {
                            cell.setText(queryKindName);
                            return;
                        }
                        cell.setText(extensionId == null ? "" : extensionId);
                        return;
                    }
                    cell.setText("");
                    return;
                }
            }
        } else if (element instanceof PatternVariable) {
            PatternVariable patternVariable = (PatternVariable)element;
            switch (columnIndex) {
                case 0: {
                    cell.setText(patternVariable.getName());
                    return;
                }
                case 1: {
                    cell.setText(ParametersTableLabelProvider.getType(patternVariable.getType()));
                    return;
                }
            }
        }
        cell.setText("");
    }

    public static String getType(String type) {
        int mark3;
        int mark3Index;
        int mark2Index;
        if (type == null || type.length() == 0) {
            return "";
        }
        int mark1Index = type.lastIndexOf("$");
        int index = ParametersTableLabelProvider.getIndex(mark1Index, mark2Index = type.lastIndexOf("."), mark3Index = (mark3 = type.lastIndexOf("//")) == -1 ? -1 : mark3 + 1);
        if (index != -1) {
            return type.substring(index + 1);
        }
        return type;
    }

    private static int getIndex(int mark1Index, int mark2Index, int mark3Index) {
        if (mark1Index > 0) {
            return mark1Index;
        }
        if (mark3Index > 0) {
            return mark3Index;
        }
        return mark2Index;
    }
}

