/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.util;

import org.eclipse.core.runtime.IProgressMonitor;

public class MonitorServices {
    private static IProgressMonitor monitor;
    private static int initTotalWork;
    private static int currentCount;

    static {
        initTotalWork = 0;
        currentCount = 0;
    }

    private MonitorServices() {
    }

    public static void initMonitor(IProgressMonitor parent) {
        monitor = parent;
    }

    public static void init(int totalWork) {
        initTotalWork = totalWork;
        currentCount = 0;
    }

    public static void dispose() {
        monitor = null;
        initTotalWork = 0;
        currentCount = 0;
    }

    public static void workSubMonitor(String taskName) {
        ++currentCount;
        StringBuilder buffer = new StringBuilder();
        buffer.append(taskName);
        buffer.append(" - ");
        buffer.append(currentCount);
        if (currentCount < initTotalWork) {
            buffer.append("/" + initTotalWork + " (" + Math.round(Integer.valueOf(currentCount).floatValue() / Integer.valueOf(initTotalWork).floatValue() * 100.0f) + "%)");
        }
        monitor.subTask(buffer.toString());
    }

    public static void addTotalCount(int i) {
        initTotalWork += i;
    }

    public static void resetCurrentCount() {
        currentCount = 0;
    }
}

