/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeBasedTable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.eclipse.buildship.core.internal.util.gradle.Path;
import org.eclipse.buildship.ui.internal.view.task.ProjectTask;
import org.eclipse.buildship.ui.internal.view.task.TaskSelector;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.Task;

class BuildInvocations {
    private final ImmutableList<ProjectTask> projectTasks;
    private final ImmutableList<TaskSelector> taskSelectors;

    private BuildInvocations(List<ProjectTask> projectTasks, List<TaskSelector> taskSelectors) {
        this.projectTasks = ImmutableList.copyOf(projectTasks);
        this.taskSelectors = ImmutableList.copyOf(taskSelectors);
    }

    public List<ProjectTask> getProjectTasks() {
        return this.projectTasks;
    }

    public List<TaskSelector> getTaskSelectors() {
        return this.taskSelectors;
    }

    public static Map<Path, BuildInvocations> collectAll(GradleProject project) {
        ImmutableMultimap<Path, ProjectTask> projectTasks = BuildInvocations.getAllProjectTasksByProjectPath(project);
        ImmutableMultimap<Path, TaskSelector> taskSelectors = BuildInvocations.getAllTaskSelectorsByProjectPath(project);
        return BuildInvocations.buildBuildInvocationsMapping(project, projectTasks, taskSelectors);
    }

    private static ImmutableMultimap<Path, ProjectTask> getAllProjectTasksByProjectPath(GradleProject project) {
        ImmutableMultimap.Builder tasks = ImmutableMultimap.builder();
        for (GradleTask task : project.getTasks()) {
            tasks.put((Object)Path.from((String)project.getPath()), (Object)ProjectTask.from((Task)task));
        }
        for (GradleProject child : project.getChildren()) {
            tasks.putAll(BuildInvocations.getAllProjectTasksByProjectPath(child));
        }
        return tasks.build();
    }

    private static ImmutableMultimap<Path, TaskSelector> getAllTaskSelectorsByProjectPath(GradleProject project) {
        ImmutableMultimap.Builder taskSelectors = ImmutableMultimap.builder();
        TreeBasedTable<String, Path, ProjectTask> tasksByNameAndPath = BuildInvocations.getAllProjectTasksByNameAndPath(project);
        for (String selectorName : tasksByNameAndPath.rowKeySet()) {
            SortedMap tasksByPath = tasksByNameAndPath.row((Object)selectorName);
            ProjectTask taskWithShortestPath = (ProjectTask)tasksByPath.get(tasksByPath.firstKey());
            boolean isPublic = Iterables.any(tasksByPath.values(), (Predicate)new Predicate<ProjectTask>(){

                public boolean apply(ProjectTask input) {
                    return input.isPublic();
                }
            });
            ImmutableSortedSet selectedPaths = ImmutableSortedSet.copyOf(tasksByPath.comparator(), tasksByPath.keySet());
            TaskSelector taskSelector = TaskSelector.from(selectorName, taskWithShortestPath.getDescription(), Path.from((String)project.getPath()), isPublic, taskWithShortestPath.getGroup(), (SortedSet<Path>)selectedPaths);
            taskSelectors.put((Object)Path.from((String)project.getPath()), (Object)taskSelector);
        }
        for (GradleProject childProject : project.getChildren()) {
            taskSelectors.putAll(BuildInvocations.getAllTaskSelectorsByProjectPath(childProject));
        }
        return taskSelectors.build();
    }

    private static TreeBasedTable<String, Path, ProjectTask> getAllProjectTasksByNameAndPath(GradleProject project) {
        TreeBasedTable tasks = TreeBasedTable.create((Comparator)Ordering.natural(), (Comparator)Path.Comparator.INSTANCE);
        for (GradleTask task : project.getTasks()) {
            ProjectTask projectTask = ProjectTask.from((Task)task);
            tasks.put((Object)projectTask.getName(), (Object)projectTask.getPath(), (Object)projectTask);
        }
        for (GradleProject childProject : project.getChildren()) {
            tasks.putAll(BuildInvocations.getAllProjectTasksByNameAndPath(childProject));
        }
        return tasks;
    }

    private static ImmutableSortedMap<Path, BuildInvocations> buildBuildInvocationsMapping(GradleProject project, Multimap<Path, ProjectTask> projectTasks, Multimap<Path, TaskSelector> taskSelectors) {
        Preconditions.checkState((boolean)taskSelectors.keySet().containsAll(projectTasks.keySet()), (Object)"Task selectors are always configured for all projects");
        ImmutableSortedMap.Builder mapping = ImmutableSortedMap.orderedBy((Comparator)Path.Comparator.INSTANCE);
        for (Path projectPath : taskSelectors.keySet()) {
            ImmutableList projectTasksOfProject = ImmutableList.copyOf((Collection)projectTasks.get((Object)projectPath));
            ImmutableList taskSelectorsOfProject = ImmutableList.copyOf((Collection)taskSelectors.get((Object)projectPath));
            mapping.put((Object)projectPath, (Object)new BuildInvocations((List<ProjectTask>)projectTasksOfProject, (List<TaskSelector>)taskSelectorsOfProject));
        }
        Sets.SetView projectsWithoutTaskSelectors = Sets.difference(BuildInvocations.getAllProjectPaths(project), (Set)taskSelectors.keySet());
        for (Path projectPath : projectsWithoutTaskSelectors) {
            mapping.put((Object)projectPath, (Object)new BuildInvocations((List<ProjectTask>)ImmutableList.of(), (List<TaskSelector>)ImmutableList.of()));
        }
        return mapping.build();
    }

    private static ImmutableSet<Path> getAllProjectPaths(GradleProject project) {
        ImmutableSet.Builder projectPaths = ImmutableSet.builder();
        projectPaths.add((Object)Path.from((String)project.getPath()));
        for (GradleProject childProject : project.getChildren()) {
            projectPaths.addAll(BuildInvocations.getAllProjectPaths(childProject));
        }
        return projectPaths.build();
    }
}

