/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.containers.lane;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.label.AddShapeLabelFeature;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class AddLaneFeature
extends AbstractBpmn2AddFeature<Lane> {
    public AddLaneFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public IAddFeature getAddLabelFeature(IFeatureProvider fp) {
        return new AddShapeLabelFeature(fp){

            @Override
            protected AbstractText createText(Shape labelShape, String labelText) {
                return gaService.createText((GraphicsAlgorithmContainer)labelShape, labelText);
            }

            @Override
            public void applyStyle(AbstractText text, BaseElement be) {
                super.applyStyle(text, be);
                text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
                text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
            }
        };
    }

    public boolean canAdd(IAddContext context) {
        boolean intoDiagram = context.getTargetContainer() instanceof Diagram;
        boolean intoLane = FeatureSupport.isTargetLane((ITargetContext)context);
        boolean intoParticipant = FeatureSupport.isTargetParticipant((ITargetContext)context);
        boolean intoFlowElementContainer = FeatureSupport.isTargetFlowElementsContainer((ITargetContext)context);
        boolean intoGroup = FeatureSupport.isTargetGroup((ITargetContext)context);
        return (intoDiagram || intoLane || intoParticipant || intoFlowElementContainer) && !intoGroup;
    }

    public PictogramElement add(IAddContext context) {
        Lane businessObject = (Lane)this.getBusinessObject(context);
        ContainerShape containerShape = peService.createContainerShape(context.getTargetContainer(), true);
        Rectangle rect = gaService.createRectangle((GraphicsAlgorithmContainer)containerShape);
        StyleUtil.applyStyle((GraphicsAlgorithm)rect, (BaseElement)businessObject);
        boolean isImport = context.getProperty((Object)"is.importing") != null;
        boolean isCopy = context.getProperty((Object)"copied.bpmn.shape") != null;
        int width = this.getWidth(context);
        int height = this.getHeight(context);
        gaService.setLocationAndSize((GraphicsAlgorithm)rect, context.getX(), context.getY(), width, height);
        BPMNShape bpmnShape = this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport && !isCopy);
        if (FeatureSupport.isTargetLane((ITargetContext)context)) {
            BPMNShape laneShape;
            Lane targetLane = FeatureSupport.getTargetLane((ITargetContext)context);
            if (!isImport && (laneShape = this.findDIShape((BaseElement)targetLane)) != null) {
                bpmnShape.setIsHorizontal(laneShape.isIsHorizontal());
            }
            businessObject.getFlowNodeRefs().addAll(targetLane.getFlowNodeRefs());
            targetLane.getFlowNodeRefs().clear();
        }
        if (FeatureSupport.isTargetParticipant((ITargetContext)context)) {
            BPMNShape participantShape;
            Participant targetParticipant = FeatureSupport.getTargetParticipant((ITargetContext)context);
            Process targetProcess = targetParticipant.getProcessRef();
            if (!isImport && (participantShape = this.findDIShape((BaseElement)targetParticipant)) != null) {
                bpmnShape.setIsHorizontal(participantShape.isIsHorizontal());
            }
            if (this.getNumberOfLanes((ITargetContext)context) == 1) {
                this.moveFlowNodes(targetProcess, businessObject);
            }
        }
        boolean horz = bpmnShape.isIsHorizontal();
        FeatureSupport.setHorizontal(containerShape, horz);
        if (FeatureSupport.isTargetLane((ITargetContext)context) || FeatureSupport.isTargetParticipant((ITargetContext)context)) {
            for (Shape s : this.getFlowNodeShapes(context, businessObject)) {
                GraphicsUtil.sendToFront(s);
                s.setContainer(containerShape);
                for (EObject linkedObj : s.getLink().getBusinessObjects()) {
                    if (!(linkedObj instanceof FlowNode)) continue;
                    businessObject.getFlowNodeRefs().add((FlowNode)linkedObj);
                }
            }
            containerShape.setContainer(context.getTargetContainer());
        }
        ((AddContext)context).setWidth(width);
        ((AddContext)context).setHeight(height);
        this.decorateShape(context, containerShape, businessObject);
        peService.createChopboxAnchor((AnchorContainer)containerShape);
        return containerShape;
    }

    @Override
    protected void decorateShape(IAddContext context, ContainerShape containerShape, Lane businessObject) {
    }

    private void moveFlowNodes(Process targetProcess, Lane lane) {
        for (FlowElement element : targetProcess.getFlowElements()) {
            if (!(element instanceof FlowNode)) continue;
            lane.getFlowNodeRefs().add((FlowNode)element);
        }
    }

    private List<Shape> getFlowNodeShapes(IAddContext context, Lane lane) {
        List nodes = lane.getFlowNodeRefs();
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        for (Shape s : context.getTargetContainer().getChildren()) {
            Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)s);
            if (bo == null || !nodes.contains(bo)) continue;
            shapes.add(s);
        }
        return shapes;
    }

    private int getNumberOfLanes(ITargetContext context) {
        ContainerShape targetContainer = context.getTargetContainer();
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)targetContainer);
        if (bo instanceof Lane) {
            Lane lane = (Lane)bo;
            return lane.getChildLaneSet().getLanes().size();
        }
        if (bo instanceof Participant) {
            List laneSets = ((Participant)bo).getProcessRef().getLaneSets();
            if (laneSets.size() > 0) {
                return ((LaneSet)laneSets.get(0)).getLanes().size();
            }
            return laneSets.size();
        }
        if (bo instanceof SubProcess) {
            List laneSets = ((SubProcess)bo).getLaneSets();
            if (laneSets.size() > 0) {
                return ((LaneSet)laneSets.get(0)).getLanes().size();
            }
            return laneSets.size();
        }
        return 0;
    }

    private Bounds getPreviousBounds(IAddContext context) {
        EObject bo = (EObject)this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
        if (bo instanceof Participant) {
            List laneSets = ((Participant)bo).getProcessRef().getLaneSets();
            List lanes = null;
            if (laneSets.size() > 0 && ((LaneSet)laneSets.get(0)).getLanes().size() > 1) {
                lanes = ((LaneSet)laneSets.get(0)).getLanes();
                Lane lane = (Lane)lanes.get(lanes.size() - 2);
                BPMNShape laneShape = this.findDIShape((BaseElement)lane);
                Bounds bounds = laneShape.getBounds();
                return bounds;
            }
        }
        return null;
    }

    @Override
    public Class getBusinessObjectType() {
        return Lane.class;
    }
}

