/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Artifact;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Choreography;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.ConversationLink;
import org.eclipse.bpmn2.ConversationNode;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InteractionNode;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.BpmnDiFactory;
import org.eclipse.bpmn2.di.ParticipantBandKind;
import org.eclipse.bpmn2.modeler.core.Messages;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.di.ImportDiagnostics;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.model.ModelHandlerLocator;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FixDuplicateIdsDialog;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.util.Bpmn2ResourceImpl;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.DcFactory;
import org.eclipse.dd.dc.Point;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.IllegalValueException;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class ModelHandler {
    Bpmn2ResourceImpl resource;
    Bpmn2Preferences prefs;

    ModelHandler() {
    }

    void createDefinitionsIfMissing() {
        TransactionalEditingDomain domain;
        EList contents = this.resource.getContents();
        if ((contents.isEmpty() || !(contents.get(0) instanceof DocumentRoot)) && (domain = TransactionUtil.getEditingDomain((Resource)this.resource)) != null) {
            final DocumentRoot docRoot = this.createObject(DocumentRoot.class);
            final Definitions definitions = this.createObject(Definitions.class);
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    docRoot.setDefinitions(definitions);
                    ModelHandler.this.resource.getContents().add((Object)docRoot);
                }
            });
            return;
        }
    }

    public Bpmn2Preferences getPreferences() {
        if (this.prefs == null) {
            this.prefs = Bpmn2Preferences.getInstance((Resource)this.resource);
        }
        return this.prefs;
    }

    public BPMNDiagram createDiagramType(ModelUtil.Bpmn2DiagramType diagramType, String targetNamespace) {
        BPMNDiagram diagram = null;
        switch (diagramType) {
            case PROCESS: {
                diagram = this.createProcessDiagram(Messages.ModelHandler_Default);
                break;
            }
            case COLLABORATION: {
                diagram = this.createCollaborationDiagram(Messages.ModelHandler_Default);
                break;
            }
            case CHOREOGRAPHY: {
                diagram = this.createChoreographyDiagram(Messages.ModelHandler_Default);
            }
        }
        if (diagram != null) {
            ((Definitions)diagram.eContainer()).setTargetNamespace(targetNamespace);
        }
        return diagram;
    }

    public BPMNDiagram createProcessDiagram(final String name) {
        this.resource.getContents();
        this.resource.getResourceSet();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)this.resource);
        final BPMNDiagram bpmnDiagram = BpmnDiFactory.eINSTANCE.createBPMNDiagram();
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    BPMNPlane plane = BpmnDiFactory.eINSTANCE.createBPMNPlane();
                    ModelUtil.setID((EObject)plane, (Resource)ModelHandler.this.resource);
                    Process process = ModelHandler.this.createProcess(null);
                    process.setName(String.valueOf(name) + Messages.ModelHandler_Process);
                    String filename = ModelHandler.this.resource.getURI().lastSegment();
                    if (filename.contains(".")) {
                        filename = filename.split("\\.")[0];
                    }
                    process.setId(ModelUtil.generateID((EObject)process, (Resource)ModelHandler.this.resource, filename));
                    StartEvent startEvent = ModelHandler.this.createObject(StartEvent.class);
                    process.getFlowElements().add(startEvent);
                    SequenceFlow flow = ModelHandler.this.createObject(SequenceFlow.class);
                    process.getFlowElements().add(flow);
                    EndEvent endEvent = ModelHandler.this.createObject(EndEvent.class);
                    process.getFlowElements().add(endEvent);
                    startEvent.getOutgoing().add(flow);
                    endEvent.getIncoming().add(flow);
                    flow.setSourceRef((FlowNode)startEvent);
                    flow.setTargetRef((FlowNode)endEvent);
                    BPMNShape shape = BpmnDiFactory.eINSTANCE.createBPMNShape();
                    ModelUtil.setID((EObject)shape, (Resource)ModelHandler.this.resource);
                    shape.setBpmnElement((BaseElement)startEvent);
                    Bounds bounds = DcFactory.eINSTANCE.createBounds();
                    bounds.setX(100.0f);
                    bounds.setY(100.0f);
                    bounds.setWidth(36.0f);
                    bounds.setHeight(36.0f);
                    shape.setBounds(bounds);
                    plane.getPlaneElement().add(shape);
                    ModelHandler.this.getPreferences().applyBPMNDIDefaults(shape, null);
                    BPMNEdge edge = BpmnDiFactory.eINSTANCE.createBPMNEdge();
                    edge.setBpmnElement((BaseElement)flow);
                    edge.setSourceElement((DiagramElement)shape);
                    Point wp = DcFactory.eINSTANCE.createPoint();
                    wp.setX(136.0f);
                    wp.setY(118.0f);
                    edge.getWaypoint().add(wp);
                    wp = DcFactory.eINSTANCE.createPoint();
                    wp.setX(500.0f);
                    wp.setY(118.0f);
                    edge.getWaypoint().add(wp);
                    plane.getPlaneElement().add(edge);
                    shape = BpmnDiFactory.eINSTANCE.createBPMNShape();
                    ModelUtil.setID((EObject)shape, (Resource)ModelHandler.this.resource);
                    shape.setBpmnElement((BaseElement)endEvent);
                    bounds = DcFactory.eINSTANCE.createBounds();
                    bounds.setX(500.0f);
                    bounds.setY(100.0f);
                    bounds.setWidth(36.0f);
                    bounds.setHeight(36.0f);
                    shape.setBounds(bounds);
                    plane.getPlaneElement().add(shape);
                    ModelHandler.this.getPreferences().applyBPMNDIDefaults(shape, null);
                    edge.setTargetElement((DiagramElement)shape);
                    plane.setBpmnElement((BaseElement)process);
                    bpmnDiagram.setPlane(plane);
                    bpmnDiagram.setName(String.valueOf(name) + Messages.ModelHandler_Process_Diagram);
                    ModelHandler.this.getDefinitions().getDiagrams().add(bpmnDiagram);
                }
            });
        }
        return bpmnDiagram;
    }

    public BPMNDiagram createCollaborationDiagram(final String name) {
        this.resource.getContents();
        final Bpmn2Preferences preferences = Bpmn2Preferences.getInstance((Resource)this.resource);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)this.resource);
        final BPMNDiagram bpmnDiagram = BpmnDiFactory.eINSTANCE.createBPMNDiagram();
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    ModelHandler.this.getAll(BPMNDiagram.class);
                    BPMNPlane plane = BpmnDiFactory.eINSTANCE.createBPMNPlane();
                    ModelUtil.setID((EObject)plane, (Resource)ModelHandler.this.resource);
                    Collaboration collaboration = ModelHandler.this.createCollaboration();
                    collaboration.setName(String.valueOf(name) + Messages.ModelHandler_Collaboration);
                    Process initiatingProcess = ModelHandler.this.createProcess(null);
                    initiatingProcess.setName(Messages.ModelHandler_Initiating_Process);
                    initiatingProcess.setDefinitionalCollaborationRef(collaboration);
                    Participant initiatingParticipant = Bpmn2ModelerFactory.create((Resource)ModelHandler.this.getResource(), Participant.class);
                    initiatingParticipant.setName(Messages.ModelHandler_Initiating_Pool);
                    initiatingParticipant.setProcessRef(initiatingProcess);
                    Process nonInitiatingProcess = ModelHandler.this.createProcess(null);
                    nonInitiatingProcess.setName(Messages.ModelHandler_Non_Initiating_Process);
                    nonInitiatingProcess.setDefinitionalCollaborationRef(collaboration);
                    Participant nonInitiatingParticipant = Bpmn2ModelerFactory.create((Resource)ModelHandler.this.getResource(), Participant.class);
                    nonInitiatingParticipant.setName(Messages.ModelHandler_Non_Initiating_Pool);
                    nonInitiatingParticipant.setProcessRef(nonInitiatingProcess);
                    collaboration.getParticipants().add(initiatingParticipant);
                    collaboration.getParticipants().add(nonInitiatingParticipant);
                    boolean horz = ModelHandler.this.getPreferences().isHorizontalDefault();
                    BPMNShape shape = BpmnDiFactory.eINSTANCE.createBPMNShape();
                    ModelUtil.setID((EObject)shape, (Resource)ModelHandler.this.resource);
                    ShapeStyle ss = preferences.getShapeStyle((EObject)initiatingParticipant);
                    shape.setBpmnElement((BaseElement)initiatingParticipant);
                    Bounds bounds = DcFactory.eINSTANCE.createBounds();
                    if (horz) {
                        bounds.setX(100.0f);
                        bounds.setY(100.0f);
                        bounds.setHeight((float)ss.getDefaultWidth());
                        bounds.setWidth((float)ss.getDefaultHeight());
                    } else {
                        bounds.setX(100.0f);
                        bounds.setY(100.0f);
                        bounds.setHeight((float)ss.getDefaultHeight());
                        bounds.setWidth((float)ss.getDefaultWidth());
                    }
                    shape.setBounds(bounds);
                    shape.setIsHorizontal(horz);
                    plane.getPlaneElement().add(shape);
                    ModelHandler.this.getPreferences().applyBPMNDIDefaults(shape, null);
                    shape = BpmnDiFactory.eINSTANCE.createBPMNShape();
                    ModelUtil.setID((EObject)shape, (Resource)ModelHandler.this.resource);
                    shape.setBpmnElement((BaseElement)nonInitiatingParticipant);
                    bounds = DcFactory.eINSTANCE.createBounds();
                    if (horz) {
                        bounds.setX(100.0f);
                        bounds.setY(350.0f);
                        bounds.setHeight((float)ss.getDefaultWidth());
                        bounds.setWidth((float)ss.getDefaultHeight());
                    } else {
                        bounds.setX(350.0f);
                        bounds.setY(100.0f);
                        bounds.setHeight((float)ss.getDefaultHeight());
                        bounds.setWidth((float)ss.getDefaultWidth());
                    }
                    shape.setBounds(bounds);
                    shape.setIsHorizontal(horz);
                    plane.getPlaneElement().add(shape);
                    ModelHandler.this.getPreferences().applyBPMNDIDefaults(shape, null);
                    plane.setBpmnElement((BaseElement)collaboration);
                    bpmnDiagram.setPlane(plane);
                    bpmnDiagram.setName(String.valueOf(name) + Messages.ModelHandler_Collaboration_Diagram);
                    ModelHandler.this.getDefinitions().getDiagrams().add(bpmnDiagram);
                }
            });
        }
        return bpmnDiagram;
    }

    public BPMNDiagram createChoreographyDiagram(final String name) {
        this.resource.getContents();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)this.resource);
        final BPMNDiagram bpmnDiagram = BpmnDiFactory.eINSTANCE.createBPMNDiagram();
        final Bpmn2Preferences preferences = Bpmn2Preferences.getInstance((Resource)this.resource);
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    ModelHandler.this.getAll(BPMNDiagram.class);
                    BPMNPlane plane = BpmnDiFactory.eINSTANCE.createBPMNPlane();
                    ModelUtil.setID((EObject)plane, (Resource)ModelHandler.this.resource);
                    Choreography choreography = ModelHandler.this.createChoreography();
                    choreography.setName(String.valueOf(name) + Messages.ModelHandler_Choreography);
                    Participant initiatingParticipant = Bpmn2ModelerFactory.create((Resource)ModelHandler.this.getResource(), Participant.class);
                    initiatingParticipant.setName(Messages.ModelHandler_Initiating_Participant);
                    Participant nonInitiatingParticipant = Bpmn2ModelerFactory.create((Resource)ModelHandler.this.getResource(), Participant.class);
                    nonInitiatingParticipant.setName(Messages.ModelHandler_Non_Initiating_Participant);
                    choreography.getParticipants().add(initiatingParticipant);
                    choreography.getParticipants().add(nonInitiatingParticipant);
                    ChoreographyTask task = ModelHandler.this.createObject(ChoreographyTask.class);
                    task.setName(Messages.ModelHandler_Choreography_Task);
                    task.getParticipantRefs().add(initiatingParticipant);
                    task.getParticipantRefs().add(nonInitiatingParticipant);
                    task.setInitiatingParticipantRef(initiatingParticipant);
                    choreography.getFlowElements().add(task);
                    BPMNShape taskShape = BpmnDiFactory.eINSTANCE.createBPMNShape();
                    ModelUtil.setID((EObject)taskShape, (Resource)ModelHandler.this.resource);
                    ShapeStyle ss = preferences.getShapeStyle((EObject)task);
                    int bandHeight = ss.getDefaultHeight() / 7;
                    taskShape.setBpmnElement((BaseElement)task);
                    Bounds bounds = DcFactory.eINSTANCE.createBounds();
                    bounds.setX(100.0f);
                    bounds.setY(100.0f);
                    bounds.setWidth((float)ss.getDefaultWidth());
                    bounds.setHeight((float)ss.getDefaultHeight());
                    taskShape.setBounds(bounds);
                    plane.getPlaneElement().add(taskShape);
                    ModelHandler.this.getPreferences().applyBPMNDIDefaults(taskShape, null);
                    BPMNShape participantShape = BpmnDiFactory.eINSTANCE.createBPMNShape();
                    ModelUtil.setID((EObject)participantShape, (Resource)ModelHandler.this.resource);
                    participantShape.setBpmnElement((BaseElement)initiatingParticipant);
                    participantShape.setChoreographyActivityShape(taskShape);
                    participantShape.setParticipantBandKind(ParticipantBandKind.TOP_INITIATING);
                    bounds = DcFactory.eINSTANCE.createBounds();
                    bounds.setX(100.0f);
                    bounds.setY(100.0f);
                    bounds.setWidth((float)ss.getDefaultWidth());
                    bounds.setHeight((float)bandHeight);
                    participantShape.setBounds(bounds);
                    plane.getPlaneElement().add(participantShape);
                    ModelHandler.this.getPreferences().applyBPMNDIDefaults(participantShape, null);
                    participantShape = BpmnDiFactory.eINSTANCE.createBPMNShape();
                    ModelUtil.setID((EObject)participantShape, (Resource)ModelHandler.this.resource);
                    participantShape.setBpmnElement((BaseElement)nonInitiatingParticipant);
                    participantShape.setChoreographyActivityShape(taskShape);
                    participantShape.setParticipantBandKind(ParticipantBandKind.BOTTOM_NON_INITIATING);
                    bounds = DcFactory.eINSTANCE.createBounds();
                    bounds.setX(100.0f);
                    bounds.setY((float)(100 + ss.getDefaultHeight() - bandHeight));
                    bounds.setWidth((float)ss.getDefaultWidth());
                    bounds.setHeight((float)bandHeight);
                    participantShape.setBounds(bounds);
                    plane.getPlaneElement().add(participantShape);
                    ModelHandler.this.getPreferences().applyBPMNDIDefaults(participantShape, null);
                    plane.setBpmnElement((BaseElement)choreography);
                    bpmnDiagram.setPlane(plane);
                    ModelHandler.this.getDefinitions().getDiagrams().add(bpmnDiagram);
                }
            });
        }
        return bpmnDiagram;
    }

    public static ModelHandler getInstance(EObject object) {
        return ModelHandlerLocator.getModelHandler(object.eResource());
    }

    public void dispose() {
        ModelHandlerLocator.dispose(this);
    }

    public <T extends FlowElement> T addFlowElement(Object target, T elem) {
        FlowElementsContainer container = this.getFlowElementContainer(target);
        container.getFlowElements().add(elem);
        return elem;
    }

    public <T extends Artifact> T addArtifact(Object target, T artifact) {
        Process process = this.getOrCreateProcess(this.getParticipant(target));
        process.getArtifacts().add(artifact);
        return artifact;
    }

    public <T extends RootElement> T addRootElement(T element) {
        if (!this.getDefinitions().getRootElements().contains(element)) {
            this.getDefinitions().getRootElements().add(element);
        }
        return element;
    }

    public ItemAwareElement addDataInputOutput(Object target, ItemAwareElement element) {
        if (element instanceof DataOutput) {
            this.getOrCreateIOSpecification(target).getDataOutputs().add((DataOutput)element);
        } else if (element instanceof DataInput) {
            this.getOrCreateIOSpecification(target).getDataInputs().add((DataInput)element);
        } else {
            return null;
        }
        return element;
    }

    public ConversationNode addConversationNode(BPMNDiagram bpmnDiagram, ConversationNode conversationNode) {
        Collaboration collaboration = this.getParticipantContainer(bpmnDiagram);
        if (collaboration == null && (collaboration = this.getCollaboration()) == null) {
            collaboration = this.createCollaboration();
        }
        if (collaboration != null) {
            collaboration.getConversations().add(conversationNode);
        }
        return conversationNode;
    }

    public Choreography addChoreographyActivity(BPMNDiagram bpmnDiagram, ChoreographyActivity choreographyActivity) {
        Collaboration collaboration = this.getParticipantContainer(bpmnDiagram);
        Choreography choreography = null;
        if (collaboration instanceof Choreography) {
            choreography = (Choreography)collaboration;
        } else {
            choreography = this.getChoreography();
            if (choreography == null) {
                choreography = this.createChoreography();
            }
        }
        choreography.getFlowElements().add(choreographyActivity);
        return choreography;
    }

    private InputOutputSpecification getOrCreateIOSpecification(Object target) {
        Process process = this.getOrCreateProcess(this.getParticipant(target));
        if (process.getIoSpecification() == null) {
            InputOutputSpecification ioSpec = this.createObject(InputOutputSpecification.class);
            process.setIoSpecification(ioSpec);
        }
        return process.getIoSpecification();
    }

    public void moveFlowNode(FlowNode node, Object source, Object target) {
        FlowElementsContainer targetContainer;
        FlowElementsContainer sourceContainer = this.getFlowElementContainer(source);
        if (sourceContainer != (targetContainer = this.getFlowElementContainer(target))) {
            sourceContainer.getFlowElements().remove(node);
            targetContainer.getFlowElements().add(node);
            for (SequenceFlow flow : node.getOutgoing()) {
                sourceContainer.getFlowElements().remove(flow);
                targetContainer.getFlowElements().add(flow);
            }
        }
    }

    public Participant addParticipant(BPMNDiagram bpmnDiagram) {
        Participant participant = null;
        Collaboration collaboration = this.getParticipantContainer(bpmnDiagram);
        if (collaboration != null) {
            participant = this.createObject(Participant.class);
            collaboration.getParticipants().add(participant);
        }
        return participant;
    }

    public Process createProcess(Participant participant) {
        Process process = Bpmn2ModelerFactory.create((Resource)this.getResource(), Process.class);
        if (participant != null) {
            participant.setProcessRef(process);
        }
        this.addRootElement(process);
        return process;
    }

    public Process getOrCreateProcess(Participant participant) {
        if (participant == null) {
            participant = this.getInternalParticipant();
        }
        if (participant != null && participant.getProcessRef() != null) {
            return participant.getProcessRef();
        }
        Process process = null;
        if (participant == null) {
            List<Process> processes = this.getAll(Process.class);
            Process process2 = process = processes.size() == 1 ? processes.get(0) : null;
        }
        if (process == null) {
            process = this.createProcess(participant);
            if (participant != null) {
                process.setName(String.valueOf(participant.getName()) + Messages.ModelHandler_Process_Label);
                if (participant.eContainer() instanceof Collaboration) {
                    process.setDefinitionalCollaborationRef((Collaboration)participant.eContainer());
                }
            }
        }
        return process;
    }

    public static Lane createLane(Lane targetLane) {
        Resource resource = targetLane.eResource();
        Lane lane = ModelHandler.createObject(resource, Lane.class);
        if (targetLane.getChildLaneSet() == null) {
            targetLane.setChildLaneSet(ModelHandler.createObject(resource, LaneSet.class));
        }
        LaneSet targetLaneSet = targetLane.getChildLaneSet();
        targetLaneSet.getLanes().add(lane);
        lane.getFlowNodeRefs().addAll(targetLane.getFlowNodeRefs());
        targetLane.getFlowNodeRefs().clear();
        return lane;
    }

    public Lane createLane(Object target) {
        Lane lane = this.createObject(Lane.class);
        FlowElementsContainer container = this.getFlowElementContainer(target);
        if (container.getLaneSets().isEmpty()) {
            LaneSet laneSet = this.createObject(LaneSet.class);
            laneSet.setName(String.valueOf(Messages.ModelHandler_Lane_Set) + ModelUtil.getIDNumber(laneSet.getId()));
            container.getLaneSets().add(laneSet);
        }
        ((LaneSet)container.getLaneSets().get(0)).getLanes().add(lane);
        return lane;
    }

    public SequenceFlow createSequenceFlow(FlowNode source, FlowNode target) {
        SequenceFlow sequenceFlow = this.createObject(SequenceFlow.class);
        this.addFlowElement(source.eContainer(), sequenceFlow);
        sequenceFlow.setSourceRef(source);
        sequenceFlow.setTargetRef(target);
        return sequenceFlow;
    }

    public MessageFlow createMessageFlow(InteractionNode source, InteractionNode target) {
        MessageFlow messageFlow = null;
        Participant participant = this.getParticipant(source);
        if (participant != null) {
            messageFlow = this.createObject(MessageFlow.class);
            messageFlow.setSourceRef(source);
            messageFlow.setTargetRef(target);
            if (participant.eContainer() instanceof Collaboration) {
                ((Collaboration)participant.eContainer()).getMessageFlows().add(messageFlow);
            }
        }
        return messageFlow;
    }

    public ConversationLink createConversationLink(InteractionNode source, InteractionNode target) {
        ConversationLink link = null;
        Participant participant = this.getParticipant(source);
        if (participant != null) {
            link = this.createObject(ConversationLink.class);
            link.setSourceRef(source);
            link.setTargetRef(target);
            if (participant.eContainer() instanceof Collaboration) {
                ((Collaboration)participant.eContainer()).getConversationLinks().add(link);
            }
        }
        return link;
    }

    public Association createAssociation(BaseElement source, BaseElement target) {
        Object e = null;
        e = this.getParticipant(source) != null ? source : (this.getParticipant(target) != null ? target : this.getInternalParticipant());
        Association association = this.createObject(Association.class);
        this.addArtifact(e, association);
        association.setSourceRef(source);
        association.setTargetRef(target);
        return association;
    }

    private Collaboration getCollaboration() {
        List rootElements = this.getDefinitions().getRootElements();
        for (RootElement element : rootElements) {
            if (!(element instanceof Collaboration)) continue;
            return (Collaboration)element;
        }
        return null;
    }

    public Collaboration createCollaboration() {
        Collaboration collaboration = this.createObject(Collaboration.class);
        this.addRootElement(collaboration);
        return collaboration;
    }

    private Collaboration getParticipantContainer(BPMNDiagram bpmnDiagram) {
        if (bpmnDiagram == null) {
            List rootElements = ModelHandler.getDefinitions((Resource)this.resource).getRootElements();
            for (RootElement element : rootElements) {
                if (!(element instanceof Collaboration) && !(element instanceof Choreography)) continue;
                return (Collaboration)element;
            }
        } else {
            BaseElement be = bpmnDiagram.getPlane().getBpmnElement();
            if (be instanceof Collaboration || be instanceof Choreography) {
                return (Collaboration)be;
            }
        }
        return null;
    }

    public Choreography getChoreography() {
        for (RootElement re : this.getDefinitions().getRootElements()) {
            if (!(re instanceof Choreography)) continue;
            return (Choreography)re;
        }
        return null;
    }

    public Choreography createChoreography() {
        Choreography choreography = this.createObject(Choreography.class);
        this.addRootElement(choreography);
        return choreography;
    }

    public Bpmn2ResourceImpl getResource() {
        return this.resource;
    }

    public Definitions getDefinitions() {
        return ModelHandler.getDefinitions((Resource)this.resource);
    }

    public static Definitions getDefinitions(Resource resource) {
        return (Definitions)((EObject)resource.getContents().get(0)).eContents().get(0);
    }

    /*
     * Unable to fully structure code
     */
    void loadResource() {
        block5: {
            try {
                this.resource.load(null);
                dups = ModelUtil.findDuplicateIds((Resource)this.resource);
                if (dups.size() > 0) {
                    dlg = new FixDuplicateIdsDialog(dups);
                    dlg.open();
                }
                break block5;
            }
            catch (Exception v0) {
                if (this.resource.getErrors().isEmpty()) break block5;
                diagnostics = new ImportDiagnostics((Resource)this.resource);
                ** for (error : this.resource.getErrors())
            }
lbl-1000:
            // 1 sources

            {
                if (error instanceof IllegalValueException) {
                    wrappedException = (IllegalValueException)error;
                    iv = wrappedException;
                    value = iv.getValue();
                    stringValue = value instanceof EObject != false ? diagnostics.getText((EObject)value) : "\"" + value.toString() + "\"";
                    message = String.valueOf(Messages.ModelHandler_20) + stringValue + Messages.ModelHandler_21 + "\"" + iv.getFeature().getName() + "\"";
                    diagnostics.add(4, iv.getObject(), message);
                    continue;
                }
                contents = (EObject)this.resource.getContents().get(0);
                diagnostics.add(4, contents, error.getMessage());
                continue;
            }
lbl24:
            // 1 sources

            diagnostics.report();
        }
    }

    public Participant getInternalParticipant() {
        Collaboration collaboration = this.getParticipantContainer(null);
        if (collaboration != null && collaboration.getParticipants().size() > 0) {
            return (Participant)collaboration.getParticipants().get(0);
        }
        return null;
    }

    public FlowElementsContainer getFlowElementContainer(Object o) {
        if (o == null) {
            return this.getOrCreateProcess(this.getInternalParticipant());
        }
        if (o instanceof Diagram) {
            o = BusinessObjectUtil.getFirstElementOfType((PictogramElement)((Diagram)o), BPMNDiagram.class);
        }
        if (o instanceof BPMNDiagram) {
            BPMNDiagram bpmnDiagram = (BPMNDiagram)o;
            BaseElement be = bpmnDiagram.getPlane().getBpmnElement();
            if (be != null && be instanceof FlowElementsContainer) {
                return (FlowElementsContainer)be;
            }
            if (be instanceof Collaboration) {
                Collaboration collaboration = (Collaboration)be;
                for (Participant participant : collaboration.getParticipants()) {
                    if (DIUtils.findBPMNShape((BaseElement)participant) != null) continue;
                    return this.getOrCreateProcess(participant);
                }
                Participant defaultParticipant = this.createObject(Participant.class);
                defaultParticipant.setName(Messages.ModelHandler_Default_Pool);
                return this.getOrCreateProcess(defaultParticipant);
            }
            if (be instanceof FlowElementsContainer) {
                return (FlowElementsContainer)be;
            }
        }
        if (o instanceof Participant) {
            return this.getOrCreateProcess((Participant)o);
        }
        if (o instanceof SubProcess) {
            return (FlowElementsContainer)o;
        }
        return this.findElementOfType(FlowElementsContainer.class, o);
    }

    public Participant getParticipant(Object o) {
        if (o == null) {
            return this.getInternalParticipant();
        }
        if (o instanceof Diagram) {
            BPMNDiagram bpmnDiagram = BusinessObjectUtil.getFirstElementOfType((PictogramElement)((Diagram)o), BPMNDiagram.class);
            Collaboration collaboration = this.getParticipantContainer(bpmnDiagram);
            if (collaboration != null && collaboration.getParticipants().size() > 0) {
                return (Participant)collaboration.getParticipants().get(0);
            }
            return null;
        }
        Object object = o;
        if (o instanceof Shape) {
            object = BusinessObjectUtil.getFirstElementOfType((PictogramElement)o, BaseElement.class);
        }
        if (object instanceof Participant) {
            return (Participant)object;
        }
        Process process = this.findElementOfType(Process.class, object);
        Collaboration collaboration = this.getParticipantContainer(null);
        if (collaboration != null) {
            if (process == null) {
                if (collaboration.getParticipants().size() > 0) {
                    return (Participant)collaboration.getParticipants().get(0);
                }
            } else {
                for (Participant p : collaboration.getParticipants()) {
                    if (p.getProcessRef() == null || !p.getProcessRef().equals(process)) continue;
                    return p;
                }
            }
        }
        return null;
    }

    public <T extends BaseElement> T findElementOfType(Class<T> clazz, Object from) {
        if (!(from instanceof BaseElement)) {
            return null;
        }
        if (clazz.isAssignableFrom(from.getClass())) {
            return (T)((BaseElement)from);
        }
        return this.findElementOfType(clazz, ((BaseElement)from).eContainer());
    }

    public <T> List<T> getAll(Class<T> class1) {
        return ModelHandler.getAll((Resource)this.resource, class1);
    }

    public static <T> List<T> getAll(Resource resource, Class<T> class1) {
        ArrayList<Object> l = new ArrayList<Object>();
        TreeIterator contents = resource.getAllContents();
        while (contents.hasNext()) {
            Object t = contents.next();
            if (!class1.isInstance(t)) continue;
            l.add(t);
        }
        return l;
    }

    public BaseElement findElement(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        List<BaseElement> baseElements = this.getAll(BaseElement.class);
        for (BaseElement be : baseElements) {
            if (!id.equals(be.getId())) continue;
            return be;
        }
        return null;
    }

    public EObject createObject(EClass eClass) {
        return ModelHandler.createObject((Resource)this.resource, eClass);
    }

    public <T extends EObject> T createObject(Class<T> clazz) {
        return ModelHandler.createObject((Resource)this.resource, clazz);
    }

    public static EObject createObject(Resource resource, EClass eClass) {
        return Bpmn2ModelerFactory.createObject(resource, eClass, new Bpmn2ModelerFactory.KeyValue[0]);
    }

    public static <T extends EObject> T createObject(Resource resource, Class<T> clazz) {
        return Bpmn2ModelerFactory.createObject(resource, clazz);
    }
}

