/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.lane;

import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.ui.features.AbstractDefaultDeleteFeature;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class DeleteLaneFeature
extends AbstractDefaultDeleteFeature {
    public DeleteLaneFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public void delete(IDeleteContext context) {
        ContainerShape laneContainerShape = (ContainerShape)context.getPictogramElement();
        ContainerShape parentContainerShape = laneContainerShape.getContainer();
        Lane lane = (Lane)this.getBusinessObjectForPictogramElement((PictogramElement)laneContainerShape);
        if (lane == null) {
            return;
        }
        LaneSet laneSet = (LaneSet)lane.eContainer();
        if (parentContainerShape != null) {
            boolean before = false;
            ContainerShape neighborContainerShape = this.getLaneAfter(laneContainerShape);
            if (neighborContainerShape == null) {
                neighborContainerShape = this.getLaneBefore(laneContainerShape);
                if (neighborContainerShape == null) {
                    super.delete(context);
                    if (laneSet.getLanes().size() == 0) {
                        EcoreUtil.delete((EObject)laneSet);
                    }
                    return;
                }
                before = true;
            }
            boolean isHorizontal = FeatureSupport.isHorizontal((ContainerShape)laneContainerShape);
            GraphicsAlgorithm ga = laneContainerShape.getGraphicsAlgorithm();
            GraphicsAlgorithm neighborGA = neighborContainerShape.getGraphicsAlgorithm();
            ResizeShapeContext newContext = new ResizeShapeContext((Shape)neighborContainerShape);
            if (!before) {
                Graphiti.getGaService().setLocation(neighborGA, ga.getX(), ga.getY());
            }
            newContext.setLocation(neighborGA.getX(), neighborGA.getY());
            if (isHorizontal) {
                newContext.setHeight(neighborGA.getHeight() + ga.getHeight());
                newContext.setWidth(neighborGA.getWidth());
            } else {
                newContext.setHeight(neighborGA.getHeight());
                newContext.setWidth(neighborGA.getWidth() + ga.getWidth());
            }
            IResizeShapeFeature resizeFeature = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)newContext);
            if (resizeFeature.canResizeShape((IResizeShapeContext)newContext)) {
                super.delete(context);
                resizeFeature.resizeShape((IResizeShapeContext)newContext);
                return;
            }
        }
        super.delete(context);
    }

    private ContainerShape getLaneBefore(ContainerShape container) {
        if (!BusinessObjectUtil.containsElementOfType((PictogramElement)container, Lane.class)) {
            return null;
        }
        ContainerShape parentContainerShape = container.getContainer();
        if (parentContainerShape == null) {
            return null;
        }
        GraphicsAlgorithm ga = container.getGraphicsAlgorithm();
        int x = ga.getX();
        int y = ga.getY();
        boolean isHorizontal = FeatureSupport.isHorizontal((ContainerShape)container);
        ContainerShape result = null;
        for (PictogramElement picElem : BusinessObjectUtil.getChildElementsOfType((ContainerShape)parentContainerShape, Lane.class)) {
            GraphicsAlgorithm resultGA;
            if (!(picElem instanceof ContainerShape) || picElem.equals(container)) continue;
            ContainerShape currentContainerShape = (ContainerShape)picElem;
            GraphicsAlgorithm currentGA = currentContainerShape.getGraphicsAlgorithm();
            if (isHorizontal) {
                if (currentGA.getY() >= y) continue;
                if (result != null) {
                    resultGA = result.getGraphicsAlgorithm();
                    if (resultGA.getY() >= currentGA.getY()) continue;
                    result = currentContainerShape;
                    continue;
                }
                result = currentContainerShape;
                continue;
            }
            if (currentGA.getX() >= x) continue;
            if (result != null) {
                resultGA = result.getGraphicsAlgorithm();
                if (resultGA.getX() >= currentGA.getX()) continue;
                result = currentContainerShape;
                continue;
            }
            result = currentContainerShape;
        }
        return result;
    }

    private ContainerShape getLaneAfter(ContainerShape container) {
        if (!BusinessObjectUtil.containsElementOfType((PictogramElement)container, Lane.class)) {
            return null;
        }
        ContainerShape parentContainerShape = container.getContainer();
        if (parentContainerShape == null) {
            return null;
        }
        GraphicsAlgorithm ga = container.getGraphicsAlgorithm();
        int x = ga.getX();
        int y = ga.getY();
        boolean isHorizontal = FeatureSupport.isHorizontal((ContainerShape)container);
        ContainerShape result = null;
        for (PictogramElement picElem : BusinessObjectUtil.getChildElementsOfType((ContainerShape)parentContainerShape, Lane.class)) {
            GraphicsAlgorithm resultGA;
            if (!(picElem instanceof ContainerShape) || picElem.equals(container)) continue;
            ContainerShape currentContainerShape = (ContainerShape)picElem;
            GraphicsAlgorithm currentGA = currentContainerShape.getGraphicsAlgorithm();
            if (isHorizontal) {
                if (currentGA.getY() <= y) continue;
                if (result != null) {
                    resultGA = result.getGraphicsAlgorithm();
                    if (resultGA.getY() <= currentGA.getY()) continue;
                    result = currentContainerShape;
                    continue;
                }
                result = currentContainerShape;
                continue;
            }
            if (currentGA.getX() <= x) continue;
            if (result != null) {
                resultGA = result.getGraphicsAlgorithm();
                if (resultGA.getX() <= currentGA.getX()) continue;
                result = currentContainerShape;
                continue;
            }
            result = currentContainerShape;
        }
        return result;
    }
}

