/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.data;

import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.model.ModelHandler;
import org.eclipse.bpmn2.modeler.core.model.ModelHandlerLocator;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public abstract class AbstractCreateDataInputOutputFeature<T extends ItemAwareElement>
extends AbstractBpmn2CreateFeature<T> {
    public AbstractCreateDataInputOutputFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canCreate(ICreateContext context) {
        BPMNDiagram bpmnDiagram;
        if (!super.canCreate(context)) {
            return false;
        }
        EObject containerBO = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
        boolean intoDiagram = containerBO instanceof BPMNDiagram;
        if (intoDiagram && (bpmnDiagram = (BPMNDiagram)containerBO).getPlane().getBpmnElement() instanceof SubProcess) {
            intoDiagram = false;
        }
        boolean intoLane = FeatureSupport.isTargetLane((ITargetContext)context) && FeatureSupport.isTargetLaneOnTop((ITargetContext)context);
        boolean intoParticipant = FeatureSupport.isTargetParticipant((ITargetContext)context);
        return intoDiagram || intoLane || intoParticipant;
    }

    public Object[] create(ICreateContext context) {
        ItemAwareElement element = (ItemAwareElement)this.createBusinessObject(context);
        ModelHandler mh = ModelHandlerLocator.getModelHandler(this.getDiagram().eResource());
        mh.addDataInputOutput(context.getTargetContainer(), element);
        PictogramElement pe = this.addGraphicalRepresentation((IAreaContext)context, element);
        return new Object[]{element, pe};
    }

    protected abstract String getStencilImageId();

    public String getCreateImageId() {
        return this.getStencilImageId();
    }

    public String getCreateLargeImageId() {
        return this.getStencilImageId();
    }
}

