/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.containers.participant;

import java.util.ArrayList;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.CreateShapeReferenceFeature;
import org.eclipse.bpmn2.modeler.core.features.SubMenuCustomFeature;
import org.eclipse.bpmn2.modeler.core.features.containers.participant.Messages;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.tb.ContextMenuEntry;
import org.eclipse.graphiti.tb.IContextMenuEntry;

public class CreateParticipantReferenceFeature
extends AbstractCustomFeature {
    protected boolean changesDone = false;
    private CreateShapeReferenceFeature<Participant> createFeature = null;

    public CreateParticipantReferenceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public CreateParticipantReferenceFeature(IFeatureProvider fp, BPMNShape bpmnShape, Participant participant) {
        super(fp);
        this.createFeature = this.createCreateFeature(bpmnShape, participant);
    }

    public String getDescription() {
        return Messages.CreateParticipantReferenceFeature_Create_Pool_Reference_In_Main_Diagram;
    }

    public String getName() {
        return Messages.CreateParticipantReferenceFeature_Create_Pool_Reference;
    }

    public boolean canExecute(ICustomContext context) {
        String key;
        IContextMenuEntry contextMenuEntry;
        Process thisProcess;
        if (this.createFeature != null) {
            return true;
        }
        CreateContext createContext = CreateParticipantReferenceFeature.prepareCreateContext(context);
        if (createContext == null) {
            return false;
        }
        BPMNDiagram thisDiagram = this.getBPMNDiagram(context);
        if (thisDiagram == null) {
            return false;
        }
        ArrayList<Participant> existingPools = new ArrayList<Participant>();
        for (DiagramElement de : thisDiagram.getPlane().getPlaneElement()) {
            BaseElement bpmnElement;
            if (!(de instanceof BPMNShape) || !((bpmnElement = ((BPMNShape)de).getBpmnElement()) instanceof Participant)) continue;
            existingPools.add((Participant)bpmnElement);
        }
        BaseElement be = thisDiagram.getPlane().getBpmnElement();
        if (be instanceof Process && (thisProcess = (Process)be).getDefinitionalCollaborationRef() != null) {
            for (Participant pool : thisProcess.getDefinitionalCollaborationRef().getParticipants()) {
                if (pool.getProcessRef() != thisProcess) continue;
                existingPools.add(pool);
            }
        }
        if ((contextMenuEntry = (IContextMenuEntry)context.getProperty((Object)(key = "context.menu.entry." + this.getName()))) != null) {
            if (contextMenuEntry.getChildren().length == 0) {
                for (BPMNDiagram mainDiagram : DIUtils.getBPMNDiagrams((EObject)thisDiagram, 1)) {
                    for (DiagramElement de : mainDiagram.getPlane().getPlaneElement()) {
                        BaseElement bpmnElement;
                        if (!(de instanceof BPMNShape) || !((bpmnElement = ((BPMNShape)de).getBpmnElement()) instanceof Participant) || existingPools.contains(bpmnElement)) continue;
                        Participant participant = (Participant)bpmnElement;
                        CreateShapeReferenceFeature<Participant> feature = this.createCreateFeature((BPMNShape)de, participant);
                        SubMenuCustomFeature submenuFeature = new SubMenuCustomFeature(this, (ICreateFeature)feature);
                        ContextMenuEntry cme = new ContextMenuEntry((IFeature)submenuFeature, (IContext)context);
                        cme.setText(participant.getName());
                        contextMenuEntry.add((IContextMenuEntry)cme);
                    }
                }
            }
            return contextMenuEntry.getChildren().length > 0;
        }
        return true;
    }

    private CreateShapeReferenceFeature<Participant> createCreateFeature(BPMNShape bpmnShape, Participant participant) {
        return new CreateShapeReferenceFeature<Participant>(this.getFeatureProvider(), bpmnShape, participant);
    }

    public boolean isAvailable(IContext context) {
        if (context instanceof ICustomContext) {
            return this.getBPMNDiagram((ICustomContext)context) != null;
        }
        return false;
    }

    private BPMNDiagram getBPMNDiagram(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes.length == 1 && pes[0] instanceof Diagram) {
            BPMNDiagram bpmnDiagram = (BPMNDiagram)BusinessObjectUtil.getBusinessObjectForPictogramElement(pes[0]);
            if (bpmnDiagram == null) {
                return null;
            }
            BaseElement be = bpmnDiagram.getPlane().getBpmnElement();
            if (be instanceof FlowElementsContainer) {
                return bpmnDiagram;
            }
        }
        return null;
    }

    public void execute(ICustomContext context) {
        CreateContext createContext;
        if (this.createFeature == null) {
            this.createFeature = (CreateShapeReferenceFeature)context.getProperty((Object)"create.feature");
        }
        if (this.createFeature != null && this.createFeature.canCreate((ICreateContext)(createContext = CreateParticipantReferenceFeature.prepareCreateContext(context)))) {
            createContext.putProperty((Object)"force.update.all", (Object)Boolean.TRUE);
            ContainerShape newShape = (ContainerShape)this.createFeature.create((ICreateContext)createContext)[0];
            this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer().setPictogramElementForSelection((PictogramElement)newShape);
            context.putProperty((Object)"pictogram.element", (Object)newShape);
            this.changesDone = true;
        }
    }

    public boolean hasDoneChanges() {
        return this.changesDone;
    }

    protected static CreateContext prepareCreateContext(ICustomContext context) {
        CreateContext cc = new CreateContext();
        PictogramElement[] pes = context.getPictogramElements();
        if (pes == null || pes.length != 1) {
            return null;
        }
        PictogramElement container = pes[0];
        if (!(container instanceof ContainerShape)) {
            return null;
        }
        cc.setTargetContainer((ContainerShape)container);
        cc.setX(context.getX());
        cc.setY(context.getY());
        return cc;
    }
}

