/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor.dialogs;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.ds.core.IDSProperty;
import org.eclipse.pde.internal.ds.ui.Activator;
import org.eclipse.pde.internal.ds.ui.Messages;
import org.eclipse.pde.internal.ds.ui.SWTUtil;
import org.eclipse.pde.internal.ds.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ds.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ds.ui.editor.sections.DSPropertiesSection;
import org.eclipse.pde.internal.ds.ui.parts.ComboPart;
import org.eclipse.pde.internal.ds.ui.parts.FormEntry;
import org.eclipse.pde.internal.ds.ui.wizards.DSNewClassCreationWizard;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DSEditPropertyDialog
extends FormDialog {
    private IDSProperty fProperty;
    private DSPropertiesSection fPropertiesSection;
    private FormEntry fNameEntry;
    private ComboPart fTypeCombo;
    private FormEntry fValuesEntry;
    private boolean fAddDialog;
    private static final String EMPTY = "";

    public DSEditPropertyDialog(Shell parentShell, IDSProperty property, DSPropertiesSection propertiesSection, boolean addDialog) {
        super(parentShell);
        this.fProperty = property;
        this.fPropertiesSection = propertiesSection;
        this.fAddDialog = addDialog;
    }

    protected void createFormContent(IManagedForm mform) {
        mform.getForm().setText(Messages.DSEditPropertyDialog_dialog_title);
        Composite container = mform.getForm().getBody();
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        FormToolkit toolkit = mform.getToolkit();
        toolkit.decorateFormHeading(mform.getForm().getForm());
        Composite mainContainer = toolkit.createComposite(container);
        mainContainer.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        mainContainer.setLayoutData((Object)new GridData(1808));
        this.fNameEntry = new FormEntry(mainContainer, toolkit, Messages.DSPropertyDetails_nameEntry, 2);
        toolkit.createLabel(mainContainer, Messages.DSPropertyDetails_typeEntry, 64);
        this.fTypeCombo = new ComboPart();
        this.fTypeCombo.createControl(mainContainer, toolkit, 8);
        String[] itemsCard = new String[]{"Boolean", "Byte", "Character", "Double", "Float", "Integer", "Long", "Short", "String"};
        this.fTypeCombo.setItems(itemsCard);
        GridData data = new GridData(768);
        data.horizontalIndent = 3;
        this.fTypeCombo.getControl().setLayoutData((Object)data);
        this.fValuesEntry = new FormEntry(mainContainer, toolkit, Messages.DSEditPropertyDialog_valuesLabel, 514);
        data = new GridData(768);
        data.heightHint = 60;
        data.horizontalIndent = 4;
        this.fValuesEntry.getText().setLayoutData((Object)data);
        this.updateFields();
        this.setEntryListeners();
        toolkit.paintBordersFor(mainContainer);
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.handleOKPressed();
            }
        }
        super.buttonPressed(buttonId);
    }

    private void handleOKPressed() {
        String typeSelection;
        this.fNameEntry.commit();
        if (!(this.fNameEntry.getValue().equals(EMPTY) && this.fProperty.getPropertyName() == null || this.fNameEntry.getValue().equals(this.fProperty.getPropertyName()))) {
            this.fProperty.setPropertyName(this.fNameEntry.getValue());
        }
        if ((typeSelection = this.fTypeCombo.getSelection()) != null && !typeSelection.equals(EMPTY) && !typeSelection.equals(this.fProperty.getPropertyType())) {
            this.fProperty.setPropertyType(typeSelection);
        }
        this.fValuesEntry.commit();
        StringTokenizer lines = new StringTokenizer(this.fValuesEntry.getValue(), "\n");
        if (lines.countTokens() == 1) {
            if (!this.fValuesEntry.getValue().equals(EMPTY) || this.fProperty.getPropertyValue() != null) {
                this.handleUniqueValue();
            }
        } else if (!(lines.countTokens() <= 1 || this.fValuesEntry.getValue().equals(EMPTY) && this.fProperty.getPropertyElemBody() == null)) {
            this.handleBodyValues();
        }
        if (this.fAddDialog) {
            this.fProperty.getModel().getDSComponent().addPropertyElement(this.fProperty);
        }
    }

    private void handleUniqueValue() {
        if (!this.fValuesEntry.getValue().equals(this.fProperty.getPropertyValue())) {
            this.fProperty.setPropertyValue(this.fValuesEntry.getValue());
        }
        if (this.fProperty.getPropertyElemBody() != null && !this.fProperty.getPropertyElemBody().equals(EMPTY)) {
            this.fProperty.setPropertyElemBody(EMPTY);
        }
    }

    private void handleBodyValues() {
        String propertyElemBody = this.fProperty.getPropertyElemBody();
        if (propertyElemBody != null) {
            propertyElemBody = EMPTY;
        }
        if (!this.fValuesEntry.getValue().equals(propertyElemBody)) {
            this.fProperty.setPropertyElemBody(this.fValuesEntry.getValue());
        }
        if (this.fProperty.getPropertyValue() != null && !this.fProperty.getPropertyValue().equals(EMPTY)) {
            this.fProperty.setPropertyValue(EMPTY);
        }
    }

    public void updateFields() {
        if (this.fProperty == null) {
            return;
        }
        if (this.fProperty.getPropertyName() != null) {
            this.fNameEntry.setValue(this.fProperty.getPropertyName(), true);
        } else {
            this.fNameEntry.setValue(EMPTY, true);
        }
        this.fNameEntry.setEditable(true);
        if (this.fProperty.getPropertyValue() != null && !this.fProperty.getPropertyValue().equals(EMPTY)) {
            this.fValuesEntry.setValue(this.fProperty.getPropertyValue(), true);
        } else if (this.fProperty.getPropertyElemBody() != null) {
            this.fValuesEntry.setValue(this.fProperty.getPropertyElemBody(), true);
        } else {
            this.fValuesEntry.setValue(EMPTY, true);
        }
        this.fValuesEntry.setEditable(true);
        if (this.fProperty.getPropertyType() != null) {
            this.fTypeCombo.setText(this.fProperty.getPropertyType());
        }
    }

    public void setEntryListeners() {
        this.fNameEntry.setFormEntryListener(new FormEntryAdapter((IContextPart)this.fPropertiesSection){

            @Override
            public void textValueChanged(FormEntry entry) {
            }

            @Override
            public void textDirty(FormEntry entry) {
            }

            @Override
            public void linkActivated(HyperlinkEvent e) {
                String value = DSEditPropertyDialog.this.fNameEntry.getValue();
                if ((value = DSEditPropertyDialog.this.handleLinkActivated(value, false)) != null) {
                    DSEditPropertyDialog.this.fNameEntry.setValue(value);
                }
            }

            @Override
            public void browseButtonSelected(FormEntry entry) {
                DSEditPropertyDialog.this.doOpenSelectionDialog(DSEditPropertyDialog.this.fNameEntry);
            }
        });
        this.fValuesEntry.setFormEntryListener(new FormEntryAdapter((IContextPart)this.fPropertiesSection){

            @Override
            public void textValueChanged(FormEntry entry) {
            }

            @Override
            public void textDirty(FormEntry entry) {
            }
        });
    }

    private String handleLinkActivated(String value, boolean isInter) {
        IProject project = this.getProject();
        try {
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IType element = javaProject.findType(value.replace('$', '.'));
                if (element != null) {
                    JavaUI.openInEditor((IJavaElement)element);
                } else {
                    DSNewClassCreationWizard wizard = new DSNewClassCreationWizard(project, isInter, value);
                    WizardDialog dialog = new WizardDialog(Activator.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                    if (dialog.open() == 0) {
                        return wizard.getQualifiedName();
                    }
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    private IProject getProject() {
        PDEFormEditor editor = (PDEFormEditor)this.fPropertiesSection.getPage().getEditor();
        return editor.getCommonProject();
    }

    private void doOpenSelectionDialog(FormEntry entry) {
        final IProject project = this.getProject();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Activator.getActiveWorkbenchShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)project.getWorkspace());
        IResource resource = this.getFile(entry);
        if (resource != null) {
            dialog.setInitialSelection((Object)resource);
        }
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    return ((IProject)element).equals((Object)project);
                }
                return true;
            }
        });
        dialog.setAllowMultiple(false);
        dialog.setTitle(Messages.DSEditPropertyDialog_dialog_title);
        dialog.setMessage(Messages.DSEditPropertyDialog_dialogMessage);
        dialog.setValidator(selection -> {
            if (selection != null && selection.length > 0 && (selection[0] instanceof IFile || selection[0] instanceof IContainer)) {
                return Status.OK_STATUS;
            }
            return Status.error((String)EMPTY, null);
        });
        if (dialog.open() == 0) {
            IResource res = (IResource)dialog.getFirstResult();
            IPath path = res.getProjectRelativePath();
            if (res instanceof IContainer) {
                path = path.addTrailingSeparator();
            }
            String value = path.toString();
            entry.setValue(value);
        }
    }

    private IResource getFile(FormEntry entry) {
        String value = entry.getValue();
        if (value.length() == 0) {
            return null;
        }
        IProject project = this.getProject();
        IPath path = project.getFullPath().append(value);
        return project.getWorkspace().getRoot().findMember(path);
    }
}

