/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.provider;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RefreshAction;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.actions.ShowPropertyAction;
import org.eclipse.birt.report.designer.ui.cubebuilder.action.EditCubeDimensionAction;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.CubeBuilder;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class TabularDimensionNodeProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        super.createContextMenu(sourceViewer, object, menu);
        if (((DimensionHandle)object).canEdit()) {
            menu.insertAfter("additions", (IAction)new EditCubeDimensionAction(object, Messages.getString("CubeDimensionNodeProvider.menu.text")));
        }
        menu.insertBefore("additions-refresh", (IAction)new ShowPropertyAction(object));
        menu.insertAfter("additions-refresh", (IContributionItem)new Separator());
        RefreshAction action = new RefreshAction(sourceViewer);
        if (action.isEnabled()) {
            menu.insertAfter("additions-refresh", (IAction)action);
        }
    }

    public String getNodeDisplayName(Object model) {
        DimensionHandle dimension = (DimensionHandle)model;
        return dimension.getName();
    }

    public Object[] getChildren(Object object) {
        HierarchyHandle hierarchy = (HierarchyHandle)((DimensionHandle)object).getContent("hierarchies", 0);
        ArrayList<LevelHandle> list = new ArrayList<LevelHandle>();
        int i = 0;
        while (i < hierarchy.getLevelCount()) {
            list.add(hierarchy.getLevel(i));
            ++i;
        }
        return list.toArray();
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public Object getParent(Object model) {
        DimensionHandle dimension = (DimensionHandle)model;
        CubeHandle cube = (CubeHandle)dimension.getContainer();
        if (cube != null) {
            return cube.getPropertyHandle("dimensions");
        }
        return null;
    }

    protected boolean performEdit(ReportElementHandle handle) {
        DimensionHandle dimensionHandle = (DimensionHandle)handle;
        CubeBuilder dialog = new CubeBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (TabularCubeHandle)dimensionHandle.getContainer());
        dialog.showPage("org.eclipse.birt.datasource.editor.cubebuilder.grouppage");
        return dialog.open() == 0;
    }

    public Image getNodeIcon(Object model) {
        if (model instanceof DesignElementHandle && ((DesignElementHandle)model).getSemanticErrors().size() > 0) {
            return ReportPlatformUIImages.getImage((String)"IMG_OBJS_ERROR_TSK");
        }
        return UIHelper.getImage("icons/obj16/dimension.gif");
    }
}

