/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.graphics;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.eclipse.draw3d.graphics3d.DisplayListManager;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.draw3d.util.converter.ColorBufferInfo;
import org.eclipse.draw3d.util.converter.ImageConverter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.lwjgl.opengl.GL11;

public class LwjglLinePattern {
    private boolean m_disposed = false;
    private int m_length;
    private int m_textureId = -1;

    public static Object getKey(int[] i_dashPattern) {
        int hashCode = 17;
        int i = 0;
        while (i < i_dashPattern.length) {
            hashCode = 37 * hashCode + i_dashPattern[i];
            ++i;
        }
        return hashCode;
    }

    public LwjglLinePattern(int[] i_dashPattern, DisplayListManager i_displayListManager) {
        if (i_dashPattern == null) {
            throw new NullPointerException("dashPattern must not be null");
        }
        if (i_displayListManager == null) {
            throw new NullPointerException("i_displayListManager must not be null");
        }
        i_displayListManager.interruptDisplayList();
        try {
            this.m_length = 0;
            int i = 0;
            while (i < i_dashPattern.length) {
                this.m_length += i_dashPattern[i];
                ++i;
            }
            Display device = Display.getCurrent();
            Image image = null;
            GC gc = null;
            try {
                image = new Image((Device)device, this.m_length, 1);
                gc = new GC((Drawable)image);
                gc.setForeground(device.getSystemColor(2));
                gc.setBackground(device.getSystemColor(1));
                gc.fillRectangle(0, 0, this.m_length, 1);
                gc.setLineDash(i_dashPattern);
                gc.drawLine(0, 0, this.m_length, 0);
                ColorBufferInfo info = new ColorBufferInfo(this.m_length, 1, 6410, 5121, 1);
                ImageConverter converter = ImageConverter.getInstance();
                ByteBuffer buffer = converter.imageToBuffer(image, info, null, false);
                GL11.glPushAttrib((int)262144);
                try {
                    IntBuffer intBuf = Draw3DCache.getIntBuffer((int)1);
                    try {
                        GL11.glDisable((int)3553);
                        GL11.glEnable((int)3552);
                        GL11.glGenTextures((IntBuffer)intBuf);
                        this.m_textureId = intBuf.get(0);
                        GL11.glBindTexture((int)3552, (int)this.m_textureId);
                        GL11.glTexParameteri((int)3552, (int)10242, (int)10497);
                        GL11.glTexParameteri((int)3552, (int)10240, (int)9728);
                        GL11.glTexParameteri((int)3552, (int)10241, (int)9728);
                        GL11.glTexImage1D((int)3552, (int)0, (int)6410, (int)this.m_length, (int)0, (int)6410, (int)5121, (ByteBuffer)buffer);
                    }
                    catch (Throwable throwable) {
                        Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{intBuf});
                        throw throwable;
                    }
                    Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{intBuf});
                }
                finally {
                    GL11.glPopAttrib();
                    GL11.glBindTexture((int)3552, (int)0);
                }
            }
            finally {
                if (gc != null) {
                    gc.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
            }
        }
        finally {
            i_displayListManager.resumeDisplayList();
        }
    }

    public void activate() {
        if (this.m_disposed) {
            throw new IllegalStateException("line pattern is disposed");
        }
        GL11.glPushAttrib((int)262144);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3552);
        GL11.glBindTexture((int)3552, (int)this.m_textureId);
        GL11.glTexEnvi((int)8960, (int)8704, (int)3042);
    }

    public void deactivate() {
        if (this.m_disposed) {
            throw new IllegalStateException("line pattern is disposed");
        }
        GL11.glPopAttrib();
        GL11.glBindTexture((int)3552, (int)0);
    }

    public void dispose() {
        if (this.m_disposed) {
            return;
        }
        if (this.m_textureId != -1) {
            IntBuffer intBuf = Draw3DCache.getIntBuffer((int)1);
            try {
                intBuf.put(0, this.m_textureId);
                GL11.glDeleteTextures((IntBuffer)intBuf);
                this.m_textureId = -1;
            }
            catch (Throwable throwable) {
                Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{intBuf});
                throw throwable;
            }
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{intBuf});
        }
        this.m_disposed = true;
    }

    public int getLength() {
        if (this.m_disposed) {
            throw new IllegalStateException("line pattern is disposed");
        }
        return this.m_length;
    }

    public float getS(float i_x1, float i_y1, float i_x2, float i_y2) {
        if (this.m_disposed) {
            throw new IllegalStateException("line pattern is disposed");
        }
        float dX = i_x2 - i_x1;
        float dY = i_y2 - i_y1;
        float lineLength = (float)Math.sqrt(dX * dX + dY * dY);
        return lineLength / (float)this.m_length;
    }

    public float getS(int i_x1, int i_y1, int i_x2, int i_y2) {
        if (this.m_disposed) {
            throw new IllegalStateException("line pattern is disposed");
        }
        int dX = i_x2 - i_x1;
        int dY = i_y2 - i_y1;
        float lineLength = (float)Math.sqrt(dX * dX + dY * dY);
        return lineLength / (float)this.m_length;
    }
}

