/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.testing.ares;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResultType implements Enumerator
{
    INCOMPLETE(1, "Incomplete", "INCOMPLETE"),
    SUCCESS(2, "Success", "SUCCESS"),
    FAILURE(3, "Failure", "FAILURE"),
    ERROR(-1, "Error", "ERROR");

    public static final int INCOMPLETE_VALUE = 1;
    public static final int SUCCESS_VALUE = 2;
    public static final int FAILURE_VALUE = 3;
    public static final int ERROR_VALUE = -1;
    private static final ResultType[] VALUES_ARRAY;
    public static final List<ResultType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ResultType[]{INCOMPLETE, SUCCESS, FAILURE, ERROR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ResultType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResultType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResultType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResultType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResultType get(int value) {
        switch (value) {
            case 1: {
                return INCOMPLETE;
            }
            case 2: {
                return SUCCESS;
            }
            case 3: {
                return FAILURE;
            }
            case -1: {
                return ERROR;
            }
        }
        return null;
    }

    private ResultType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

