/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model;

import java.util.List;
import org.ascape.model.Agent;
import org.ascape.model.rule.Rule;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.CoordinateMutable;
import org.ascape.model.space.Location;
import org.ascape.util.Conditional;
import org.ascape.util.data.DataPoint;

public class LocatedAgent
extends Agent
implements Location {
    private static final long serialVersionUID = 1L;
    public static final Rule MOVE_RANDOM_LOCATION_RULE = new Rule("Move To Random Location"){
        private static final long serialVersionUID = 1L;

        public void execute(Agent agent) {
            ((LocatedAgent)agent).moveToRandomLocation();
        }

        public boolean isCauseRemoval() {
            return false;
        }
    };
    public static final Rule RANDOM_WALK_RULE = new Rule("Random Walk"){
        private static final long serialVersionUID = 1L;

        public void execute(Agent agent) {
            ((LocatedAgent)agent).randomWalk();
        }

        public boolean isCauseRemoval() {
            return false;
        }
    };
    protected Coordinate coordinate;
    protected int thisUpdate;
    protected int agentSize = 5;

    public void initialize() {
        super.initialize();
        this.thisUpdate = 0;
    }

    public void requestUpdate() {
        this.thisUpdate = this.getIteration();
    }

    public void requestUpdateNext() {
        this.thisUpdate = this.getIteration() + 1;
    }

    public boolean isUpdateNeeded(int within) {
        return this.thisUpdate > this.getIteration() - within;
    }

    public Coordinate getCoordinate() {
        if (this.getScape() != null && this.getScape().getSpace() instanceof CoordinateMutable) {
            ((CoordinateMutable)((Object)this.getScape().getSpace())).coordinateSweep();
        }
        return this.coordinate;
    }

    public void setCoordinate(Coordinate coordinate) {
        this.coordinate = coordinate;
    }

    public LocatedAgent findNearest() {
        return this.findNearest(null, false, Double.MAX_VALUE);
    }

    public LocatedAgent findNearest(double distance) {
        return this.findNearest(null, false, distance);
    }

    public LocatedAgent findNearest(Conditional condition) {
        return this.findNearest(condition, false, Double.MAX_VALUE);
    }

    public LocatedAgent findNearest(Conditional condition, double distance) {
        return this.findNearest(condition, false, distance);
    }

    public LocatedAgent findNearest(Conditional condition, boolean includeSelf, double distance) {
        return this.getScape().findNearest(this.getCoordinate(), condition, includeSelf, distance);
    }

    public List findWithin(double distance) {
        return this.findWithin(null, distance);
    }

    public List findWithin(double distance, boolean includeSelf) {
        return this.findWithin(null, includeSelf, distance);
    }

    public List findWithin(Conditional condition, double distance) {
        return this.findWithin(condition, false, distance);
    }

    public List findWithin(Conditional condition, boolean includeSelf, double distance) {
        return this.getScape().findWithin(this.getCoordinate(), condition, includeSelf, distance);
    }

    public LocatedAgent findMaximumWithin(DataPoint data, boolean includeSelf, double distance) {
        return this.getScape().findMaximumWithin(this.getCoordinate(), data, null, includeSelf, distance);
    }

    public int countWithin(double distance) {
        return this.countWithin(null, distance);
    }

    public int countWithin(Conditional condition, double distance) {
        return this.countWithin(condition, false, distance);
    }

    public int countWithin(Conditional condition, boolean includeSelf, double distance) {
        return this.getScape().countWithin(this.getCoordinate(), condition, includeSelf, distance);
    }

    public boolean hasWithin(double distance) {
        return this.hasWithin(null, distance);
    }

    public boolean hasWithin(Conditional condition, double distance) {
        return this.getScape().hasWithin(condition, false, distance);
    }

    public boolean hasWithin(Conditional condition, boolean includeSelf, double distance) {
        return this.getScape().hasWithin(this.getCoordinate(), condition, includeSelf, distance);
    }

    public void moveToward(LocatedAgent target) {
        this.moveToward(target.getCoordinate());
    }

    public void moveToward(Coordinate target) {
        this.moveToward(target, 1.0);
    }

    public void moveToward(Coordinate target, double distance) {
        this.getScape().moveToward(this, target, distance);
    }

    public void moveAway(LocatedAgent target) {
        this.moveAway(target.getCoordinate());
    }

    public void moveAway(Coordinate target) {
        this.moveAway(target, 1.0);
    }

    public void moveAway(Coordinate target, double distance) {
        this.getScape().moveAway(this, target, distance);
    }

    public void moveToRandomLocation() {
        Coordinate coord = this.getScape().findRandomCoordinate();
        if (coord != null) {
            this.moveTo(coord);
        } else {
            System.err.println("Warning: no location to move to. Killing agent.");
            this.die();
        }
    }

    public void randomWalk() {
        throw new RuntimeException("Tried to move an agent in a scape that does not allow movement.");
    }

    public void moveTo(Coordinate coordinate) {
        this.setCoordinate(coordinate);
    }

    public double calculateDistance(LocatedAgent target) {
        return this.getScape().calculateDistance(this, target);
    }

    public double calculateDistance(Coordinate target) {
        return this.getScape().calculateDistance(this.getCoordinate(), target);
    }

    public int getAgentSize() {
        return this.agentSize;
    }

    public void setAgentSize(int agentSize) {
        this.agentSize = agentSize;
    }

    public String toString() {
        if (this.getName() != null) {
            if (this.coordinate != null) {
                return String.valueOf(this.getName()) + " " + this.coordinate;
            }
            return this.getName();
        }
        if (this.coordinate != null) {
            return "Agent at " + this.coordinate;
        }
        return "Agent";
    }
}

