/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.SWTBotTests.dotnettest;

import org.eclipse.acute.SWTBotTests.AbstractDotnetTest;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.junit.Assert;
import org.junit.Test;

public class TestConfiguration
extends AbstractDotnetTest {
    private String name = "Test_config1";

    @Override
    public void setup() throws CoreException {
        super.buildEmptyProject();
        String projectFileName = dotnetVersion.matches("2\\..*") ? "Project2.Tests.csproj" : (dotnetVersion.matches("1\\.0\\.1.*") ? "Project1.Tests.csproj" : "Project.Tests.json");
        this.csprojFile = this.project.getFile(projectFileName);
        this.csprojFile.create(this.getClass().getResourceAsStream(this.csprojFile.getName()), true, (IProgressMonitor)new NullProgressMonitor());
        this.csharpSourceFile = this.project.getFile("ProjectTestsPass.cs");
        this.csharpSourceFile.create(this.getClass().getResourceAsStream(this.csharpSourceFile.getName()), true, (IProgressMonitor)new NullProgressMonitor());
        bot.menu("Run").menu("Run Configurations...").click();
        bot.shell("Run Configurations").activate();
        bot.tree().select(new String[]{".NET Core Test"});
        bot.toolbarButtonWithTooltip("New launch configuration").click();
        bot.textWithLabel("Project:").setText(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + this.csprojFile.getFullPath().toPortableString());
        bot.textWithLabel("Name:").setText(this.name);
    }

    @Test
    public void testSelectTestMethod() {
        bot.radio("Run a single test").click();
        bot.button("\ud83d\udd0eSearch", 0).click();
        bot.waitUntil(Conditions.shellIsActive((String)"Class Selection"), 30000L);
        bot.button("OK").click();
        String className = bot.textWithLabel("Test class:").getText();
        bot.button("\ud83d\udd0eSearch", 1).click();
        bot.waitUntil(Conditions.shellIsActive((String)("Method Selection from \"" + className + "\"")));
        Assert.assertTrue((String)"No methods found for selected class", (boolean)bot.button("OK").isEnabled());
        bot.button("OK").click();
        bot.button("Apply").click();
        bot.button("Close").click();
    }

    @Override
    public void tearDown() throws CoreException {
        bot.menu("Run").menu("Run Configurations...").click();
        bot.shell("Run Configurations").activate();
        bot.tree().expandNode(new String[]{".NET Core Test"}).select(this.name);
        bot.toolbarButtonWithTooltip("Delete selected launch configuration(s)").click();
        bot.shell("Confirm Launch Configuration Deletion").activate();
        bot.button("Delete").click();
        bot.shell("Run Configurations").activate();
        bot.button("Close").click();
        super.tearDown();
    }
}

