/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.TMUIMessages;
import org.eclipse.tm4e.ui.internal.widgets.GrammarDefinitionContentProvider;
import org.eclipse.tm4e.ui.internal.widgets.GrammarDefinitionLabelProvider;
import org.eclipse.tm4e.ui.internal.widgets.ThemeContentProvider;
import org.eclipse.tm4e.ui.internal.widgets.ThemeLabelProvider;
import org.eclipse.tm4e.ui.internal.wizards.AbstractWizardPage;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.ThemeAssociation;

public class CreateThemeAssociationWizardPage
extends AbstractWizardPage {
    private static final String PAGE_NAME = CreateThemeAssociationWizardPage.class.getName();
    private ComboViewer themeViewer;
    private ComboViewer grammarViewer;
    private final IGrammarDefinition initialDefinition;
    private final IThemeAssociation initialAssociation;
    private Button whenDarkButton;

    protected CreateThemeAssociationWizardPage(IGrammarDefinition initialDefinition, IThemeAssociation initialAssociation) {
        super(PAGE_NAME);
        super.setTitle(TMUIMessages.CreateThemeAssociationWizardPage_title);
        super.setDescription(TMUIMessages.CreateThemeAssociationWizardPage_description);
        this.initialDefinition = initialDefinition;
        this.initialAssociation = initialAssociation;
    }

    @Override
    protected void createBody(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        parent.setFont(parent.getFont());
        parent.setLayoutData((Object)new GridData(768));
        parent.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(parent, 0);
        label.setText(TMUIMessages.CreateThemeAssociationWizardPage_theme_text);
        this.themeViewer = new ComboViewer(parent);
        this.themeViewer.setLabelProvider((IBaseLabelProvider)new ThemeLabelProvider());
        this.themeViewer.setContentProvider((IContentProvider)new ThemeContentProvider());
        this.themeViewer.setInput((Object)TMUIPlugin.getThemeManager());
        this.themeViewer.getControl().setLayoutData((Object)new GridData(768));
        this.themeViewer.getControl().addListener(13, (Listener)this);
        label = new Label(parent, 0);
        label.setText(TMUIMessages.CreateThemeAssociationWizardPage_grammar_text);
        this.grammarViewer = new ComboViewer(parent);
        this.grammarViewer.setLabelProvider((IBaseLabelProvider)new GrammarDefinitionLabelProvider());
        this.grammarViewer.setContentProvider((IContentProvider)new GrammarDefinitionContentProvider());
        this.grammarViewer.setInput((Object)TMEclipseRegistryPlugin.getGrammarRegistryManager());
        this.grammarViewer.getControl().setLayoutData((Object)new GridData(768));
        this.grammarViewer.getControl().addListener(13, (Listener)this);
        if (this.initialDefinition != null) {
            this.grammarViewer.setSelection((ISelection)new StructuredSelection((Object)this.initialDefinition));
        }
        this.whenDarkButton = new Button(parent, 32);
        this.whenDarkButton.setText(TMUIMessages.CreateThemeAssociationWizardPage_whenDark_text);
        GridData data = new GridData();
        data.horizontalSpan = 4;
        this.whenDarkButton.setLayoutData((Object)data);
        if (this.initialAssociation != null) {
            ITheme selectedTheme = TMUIPlugin.getThemeManager().getThemeById(this.initialAssociation.getThemeId());
            if (selectedTheme != null) {
                this.themeViewer.setSelection((ISelection)new StructuredSelection((Object)selectedTheme));
            }
            this.whenDarkButton.setSelection(this.initialAssociation.isWhenDark());
        }
    }

    @Override
    protected void initializeDefaultValues() {
        this.setPageComplete(false);
    }

    @Override
    protected IStatus validatePage(Event event) {
        if (this.themeViewer.getSelection().isEmpty()) {
            return new Status(4, "org.eclipse.tm4e.ui", TMUIMessages.CreateThemeAssociationWizardPage_theme_error_required);
        }
        if (this.grammarViewer.getSelection().isEmpty()) {
            return new Status(4, "org.eclipse.tm4e.ui", TMUIMessages.CreateThemeAssociationWizardPage_grammar_error_required);
        }
        return null;
    }

    public IThemeAssociation getThemeAssociation() {
        String themeId = ((ITheme)this.themeViewer.getStructuredSelection().getFirstElement()).getId();
        String scopeName = ((IGrammarDefinition)this.grammarViewer.getStructuredSelection().getFirstElement()).getScopeName();
        boolean whenDark = this.whenDarkButton.getSelection();
        return new ThemeAssociation(themeId, scopeName, whenDark);
    }
}

