/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListener;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractBreadCrumbEditor;
import org.eclipse.fordiac.ide.model.ui.widgets.GoIntoSubappSelectionEvent;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class GotoChildHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        EditPart editPart = GotoChildHandler.getValidEditPart((ISelection)selection);
        if (editPart != null) {
            SubApp subapp;
            Object object = editPart.getModel();
            if (object instanceof SubApp && (subapp = (SubApp)object).isUnfolded()) {
                IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
                AbstractBreadCrumbEditor breadCrumbEditor = OpenListener.getBreadCrumbEditor((IEditorPart)activeEditor);
                if (breadCrumbEditor != null) {
                    breadCrumbEditor.getBreadcrumb().setInput(editPart.getModel(), (SelectionChangedEvent)new GoIntoSubappSelectionEvent((ISelectionProvider)breadCrumbEditor.getBreadcrumb(), subapp));
                }
            } else {
                editPart.performRequest(new Request((Object)"open"));
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        IEditorPart editor = (IEditorPart)HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        EditPart validEditPart = GotoChildHandler.getValidEditPart(selection);
        this.setBaseEnabled(editor != null && validEditPart != null);
    }

    public static EditPart getValidEditPart(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            EditPart ep;
            Object object;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (!selection.isEmpty() && structuredSelection.size() == 1 && (object = structuredSelection.getFirstElement()) instanceof EditPart && (ep = (EditPart)object).getAdapter(EditPart.class) != null) {
                IInterfaceElement iel;
                EditPart editPart = (EditPart)ep.getAdapter(EditPart.class);
                Object model = editPart.getModel();
                if (GotoChildHandler.isSubAppOrCFBInstance(model)) {
                    return editPart;
                }
                if (model instanceof IInterfaceElement && GotoChildHandler.isSubAppOrCFBInstance((iel = (IInterfaceElement)model).getBlockFBNetworkElement())) {
                    return editPart;
                }
            }
        }
        return null;
    }

    private static boolean isSubAppOrCFBInstance(Object model) {
        return model instanceof SubApp || model instanceof CFBInstance;
    }
}

