/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.gef.utilities.TemplateCreationFactory;
import org.eclipse.fordiac.ide.model.Palette.DeviceTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.Palette.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.Palette.SegmentTypePaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.systemconfiguration.Activator;
import org.eclipse.fordiac.ide.util.imageprovider.FordiacImage;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;

public final class SystemConfPaletteFactory {
    private static final String PALETTE_DOCK_LOCATION = "SystemConfPaletteFactory.Location";
    private static final String PALETTE_SIZE = "SystemConfPaletteFactory.Size";
    private static final String PALETTE_STATE = "SystemConfPaletteFactory.State";

    public static FlyoutPaletteComposite.FlyoutPreferences createPalettePreferences() {
        boolean val = Activator.getDefault().getPreferenceStore().contains(PALETTE_STATE);
        FlyoutPaletteComposite.FlyoutPreferences preferences = new FlyoutPaletteComposite.FlyoutPreferences(){

            public int getDockLocation() {
                return Activator.getDefault().getPreferenceStore().getInt(SystemConfPaletteFactory.PALETTE_DOCK_LOCATION);
            }

            public int getPaletteState() {
                return Activator.getDefault().getPreferenceStore().getInt(SystemConfPaletteFactory.PALETTE_STATE);
            }

            public int getPaletteWidth() {
                return Activator.getDefault().getPreferenceStore().getInt(SystemConfPaletteFactory.PALETTE_SIZE);
            }

            public void setDockLocation(int location) {
                Activator.getDefault().getPreferenceStore().setValue(SystemConfPaletteFactory.PALETTE_DOCK_LOCATION, location);
            }

            public void setPaletteState(int state) {
                Activator.getDefault().getPreferenceStore().setValue(SystemConfPaletteFactory.PALETTE_STATE, state);
            }

            public void setPaletteWidth(int width) {
                Activator.getDefault().getPreferenceStore().setValue(SystemConfPaletteFactory.PALETTE_SIZE, width);
            }
        };
        if (!val) {
            preferences.setPaletteState(4);
            preferences.setPaletteWidth(125);
        }
        return preferences;
    }

    public static PaletteRoot createPalette(final AutomationSystem system) {
        final PaletteRoot palette = new PaletteRoot();
        SystemConfPaletteFactory.fillPalette(palette, system);
        system.getPalette().eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        palette.setVisible(false);
                        palette.getChildren().clear();
                        SystemConfPaletteFactory.fillPalette(palette, system);
                        palette.setVisible(true);
                    }
                });
            }
        });
        return palette;
    }

    private static void fillPalette(PaletteRoot palette, AutomationSystem system) {
        Palette pal = system.getPalette();
        for (PaletteGroup group : pal.getRootGroup().getSubGroups()) {
            if (!group.getEntries().isEmpty()) {
                SystemConfPaletteFactory.createDevGroup(palette, group);
            }
            if (!group.getEntries().isEmpty()) {
                SystemConfPaletteFactory.createRESGroup(palette, group);
            }
            if (group.getEntries().isEmpty()) continue;
            SystemConfPaletteFactory.createSEGGroup(palette, group);
        }
    }

    private static PaletteDrawer createRESGroup(PaletteRoot palette, PaletteGroup group) {
        PaletteDrawer paletteContainer = new PaletteDrawer(group.getLabel());
        paletteContainer.addAll(SystemConfPaletteFactory.createRESEntries(group));
        if (paletteContainer.getChildren().size() != 0) {
            palette.add((org.eclipse.gef.palette.PaletteEntry)paletteContainer);
        }
        return paletteContainer;
    }

    private static PaletteDrawer createDevGroup(PaletteRoot palette, PaletteGroup group) {
        PaletteDrawer paletteContainer = new PaletteDrawer(group.getLabel());
        paletteContainer.addAll(SystemConfPaletteFactory.createDEVEntries(group));
        if (paletteContainer.getChildren().size() != 0) {
            palette.add((org.eclipse.gef.palette.PaletteEntry)paletteContainer);
        }
        return paletteContainer;
    }

    private static PaletteDrawer createSEGGroup(PaletteRoot palette, PaletteGroup group) {
        PaletteDrawer paletteContainer = new PaletteDrawer(group.getLabel());
        paletteContainer.addAll(SystemConfPaletteFactory.createSEGEntries(group));
        if (paletteContainer.getChildren().size() != 0) {
            palette.add((org.eclipse.gef.palette.PaletteEntry)paletteContainer);
        }
        return paletteContainer;
    }

    private static List<org.eclipse.gef.palette.PaletteEntry> createRESEntries(PaletteGroup group) {
        ArrayList<org.eclipse.gef.palette.PaletteEntry> entries = new ArrayList<org.eclipse.gef.palette.PaletteEntry>();
        for (PaletteEntry entry : group.getEntries()) {
            org.eclipse.gef.palette.PaletteEntry paletteEntry;
            if (!(entry instanceof ResourceTypeEntry) || (paletteEntry = SystemConfPaletteFactory.createCreationEntry(entry, FordiacImage.ICON_Resource.getImageDescriptor())) == null) continue;
            entries.add(paletteEntry);
        }
        return entries;
    }

    private static List<org.eclipse.gef.palette.PaletteEntry> createDEVEntries(PaletteGroup group) {
        ArrayList<org.eclipse.gef.palette.PaletteEntry> entries = new ArrayList<org.eclipse.gef.palette.PaletteEntry>();
        for (PaletteEntry entry : group.getEntries()) {
            org.eclipse.gef.palette.PaletteEntry paletteEntry;
            if (!(entry instanceof DeviceTypePaletteEntry) || (paletteEntry = SystemConfPaletteFactory.createCreationEntry(entry, FordiacImage.ICON_Device.getImageDescriptor())) == null) continue;
            entries.add(paletteEntry);
        }
        return entries;
    }

    private static List<org.eclipse.gef.palette.PaletteEntry> createSEGEntries(PaletteGroup group) {
        ArrayList<org.eclipse.gef.palette.PaletteEntry> entries = new ArrayList<org.eclipse.gef.palette.PaletteEntry>();
        for (PaletteEntry entry : group.getEntries()) {
            org.eclipse.gef.palette.PaletteEntry paletteEntry;
            if (!(entry instanceof SegmentTypePaletteEntry) || (paletteEntry = SystemConfPaletteFactory.createCreationEntry(entry, FordiacImage.ICON_Segment.getImageDescriptor())) == null) continue;
            entries.add(paletteEntry);
        }
        return entries;
    }

    private static org.eclipse.gef.palette.PaletteEntry createCreationEntry(PaletteEntry entry, ImageDescriptor desc) {
        LibraryElement type = entry.getType();
        if (type == null) {
            return null;
        }
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry(type.getName(), type.getComment(), (CreationFactory)new TemplateCreationFactory((Object)entry), desc, desc);
        return combined;
    }
}

