/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.structuredtext.structuredText;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BinaryOperator implements Enumerator
{
    OR(0, "OR", "OR"),
    XOR(1, "XOR", "XOR"),
    AND(2, "AND", "AND"),
    EQ(3, "EQ", "="),
    NE(4, "NE", "<>"),
    LT(5, "LT", "<"),
    LE(6, "LE", "<="),
    GT(7, "GT", ">"),
    GE(8, "GE", ">="),
    ADD(9, "ADD", "+"),
    SUB(10, "SUB", "-"),
    MUL(11, "MUL", "*"),
    DIV(12, "DIV", "/"),
    MOD(13, "MOD", "MOD"),
    POWER(14, "POWER", "**");

    public static final int OR_VALUE = 0;
    public static final int XOR_VALUE = 1;
    public static final int AND_VALUE = 2;
    public static final int EQ_VALUE = 3;
    public static final int NE_VALUE = 4;
    public static final int LT_VALUE = 5;
    public static final int LE_VALUE = 6;
    public static final int GT_VALUE = 7;
    public static final int GE_VALUE = 8;
    public static final int ADD_VALUE = 9;
    public static final int SUB_VALUE = 10;
    public static final int MUL_VALUE = 11;
    public static final int DIV_VALUE = 12;
    public static final int MOD_VALUE = 13;
    public static final int POWER_VALUE = 14;
    private static final BinaryOperator[] VALUES_ARRAY;
    public static final List<BinaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BinaryOperator[]{OR, XOR, AND, EQ, NE, LT, LE, GT, GE, ADD, SUB, MUL, DIV, MOD, POWER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BinaryOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryOperator get(int value) {
        switch (value) {
            case 0: {
                return OR;
            }
            case 1: {
                return XOR;
            }
            case 2: {
                return AND;
            }
            case 3: {
                return EQ;
            }
            case 4: {
                return NE;
            }
            case 5: {
                return LT;
            }
            case 6: {
                return LE;
            }
            case 7: {
                return GT;
            }
            case 8: {
                return GE;
            }
            case 9: {
                return ADD;
            }
            case 10: {
                return SUB;
            }
            case 11: {
                return MUL;
            }
            case 12: {
                return DIV;
            }
            case 13: {
                return MOD;
            }
            case 14: {
                return POWER;
            }
        }
        return null;
    }

    private BinaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

