/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.structuredtext.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractNullSafeConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class DateValueConverter
extends AbstractNullSafeConverter<Date> {
    @Extension
    private final DateFormat format;

    public DateValueConverter(DateFormat format) {
        this.format = format;
    }

    protected String internalToString(Date value) {
        return this.format.format(value);
    }

    protected Date internalToValue(String string, INode node) throws ValueConverterException {
        Date _xblockexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)string);
        if (_isNullOrEmpty) {
            throw new ValueConverterException("Couldn't convert empty string to a date value.", node, null);
        }
        Date _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = this.format.parse(string);
        }
        catch (Throwable _t) {
            if (_t instanceof ParseException) {
                ParseException e = (ParseException)_t;
                throw new ValueConverterException("Couldn't convert '" + string + "' to a date value.", node, (Exception)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }
}

