/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.ui.handlers;

import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.IDeploymentExecutor;
import org.eclipse.fordiac.ide.deployment.ui.handlers.AbstractDeploymentCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.ResourceEditPart;

public class DeleteResourceHandler
extends AbstractDeploymentCommand {
    private Resource resource;

    @Override
    protected boolean prepareParametersToExecute(Object element) {
        this.device = null;
        if (element instanceof Resource) {
            this.resource = (Resource)element;
            this.device = this.resource.getDevice();
            if (this.device != null) {
                return true;
            }
        } else if (element instanceof ResourceEditPart) {
            this.resource = ((ResourceEditPart)element).getModel();
            this.device = this.resource.getDevice();
            if (this.device != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void executeCommand(IDeploymentExecutor executor) throws Exception {
        executor.deleteResource(this.resource);
    }

    @Override
    protected void manageExecutorError() {
        DeploymentCoordinator.printUnsupportedDeviceProfileMessageBox((Device)this.device, (Resource)this.resource);
    }

    @Override
    protected String getErrorMessageHeader() {
        return "Delete Resource Error";
    }

    @Override
    protected String getCurrentElementName() {
        return "Resource: " + this.resource.getName();
    }
}

