/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDatabase.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDatabasePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_DATABASE_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_DATABASE, WebKitDOMDatabasePrivate)

typedef struct _WebKitDOMDatabasePrivate {
#if ENABLE(SQL_DATABASE)
    RefPtr<WebCore::Database> coreObject;
#endif // ENABLE(SQL_DATABASE)
} WebKitDOMDatabasePrivate;

#if ENABLE(SQL_DATABASE)

namespace WebKit {

WebKitDOMDatabase* kit(WebCore::Database* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_DATABASE(ret);

    return wrapDatabase(obj);
}

WebCore::Database* core(WebKitDOMDatabase* request)
{
    return request ? static_cast<WebCore::Database*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDatabase* wrapDatabase(WebCore::Database* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DATABASE(g_object_new(WEBKIT_TYPE_DOM_DATABASE, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(SQL_DATABASE)

G_DEFINE_TYPE(WebKitDOMDatabase, webkit_dom_database, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_VERSION,
};

static void webkit_dom_database_finalize(GObject* object)
{
    WebKitDOMDatabasePrivate* priv = WEBKIT_DOM_DATABASE_GET_PRIVATE(object);
#if ENABLE(SQL_DATABASE)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(SQL_DATABASE)
    priv->~WebKitDOMDatabasePrivate();
    G_OBJECT_CLASS(webkit_dom_database_parent_class)->finalize(object);
}

static void webkit_dom_database_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(SQL_DATABASE)
    WebKitDOMDatabase* self = WEBKIT_DOM_DATABASE(object);
    WebCore::Database* coreSelf = WebKit::core(self);
#endif // ENABLE(SQL_DATABASE)
    switch (propertyId) {
    case PROP_VERSION: {
#if ENABLE(SQL_DATABASE)
        g_value_take_string(value, convertToUTF8String(coreSelf->version()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("SQL Database")
#endif /* ENABLE(SQL_DATABASE) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_database_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_database_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(SQL_DATABASE)
    WebKitDOMDatabasePrivate* priv = WEBKIT_DOM_DATABASE_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::Database*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(SQL_DATABASE)
    return object;
}

static void webkit_dom_database_class_init(WebKitDOMDatabaseClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMDatabasePrivate));
    gobjectClass->constructor = webkit_dom_database_constructor;
    gobjectClass->finalize = webkit_dom_database_finalize;
    gobjectClass->get_property = webkit_dom_database_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_VERSION,
                                    g_param_spec_string("version", /* name */
                                                           "database_version", /* short description */
                                                           "read-only  gchar* Database.version", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_database_init(WebKitDOMDatabase* request)
{
    WebKitDOMDatabasePrivate* priv = WEBKIT_DOM_DATABASE_GET_PRIVATE(request);
    new (priv) WebKitDOMDatabasePrivate();
}

gchar*
webkit_dom_database_get_version(WebKitDOMDatabase* self)
{
#if ENABLE(SQL_DATABASE)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DATABASE(self), 0);
    WebCore::Database* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->version());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("SQL Database")
    return 0;
#endif /* ENABLE(SQL_DATABASE) */
}

