/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStorage.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSStorageCustom.h"
#include "KURL.h"
#include "Storage.h"
#include "wtf/text/AtomicString.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSStorageTableValues[] =
{
    { "length", DontDelete | DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStorageConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSStorageTable = { 5, 3, JSStorageTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSStorageConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSStorageConstructorTable = { 1, 0, JSStorageConstructorTableValues, 0 };
const ClassInfo JSStorageConstructor::s_info = { "StorageConstructor", &Base::s_info, &JSStorageConstructorTable, 0, CREATE_METHOD_TABLE(JSStorageConstructor) };

JSStorageConstructor::JSStorageConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSStorageConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSStoragePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSStorageConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSStorageConstructor, JSDOMWrapper>(exec, &JSStorageConstructorTable, jsCast<JSStorageConstructor*>(cell), propertyName, slot);
}

bool JSStorageConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSStorageConstructor, JSDOMWrapper>(exec, &JSStorageConstructorTable, jsCast<JSStorageConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSStoragePrototypeTableValues[] =
{
    { "key", DontDelete | DontEnum | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsStoragePrototypeFunctionKey), (intptr_t)1, NoIntrinsic },
    { "getItem", DontDelete | DontEnum | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsStoragePrototypeFunctionGetItem), (intptr_t)1, NoIntrinsic },
    { "setItem", DontDelete | DontEnum | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsStoragePrototypeFunctionSetItem), (intptr_t)2, NoIntrinsic },
    { "removeItem", DontDelete | DontEnum | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsStoragePrototypeFunctionRemoveItem), (intptr_t)1, NoIntrinsic },
    { "clear", DontDelete | DontEnum | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsStoragePrototypeFunctionClear), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSStoragePrototypeTable = { 17, 15, JSStoragePrototypeTableValues, 0 };
const ClassInfo JSStoragePrototype::s_info = { "StoragePrototype", &Base::s_info, &JSStoragePrototypeTable, 0, CREATE_METHOD_TABLE(JSStoragePrototype) };

JSObject* JSStoragePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSStorage>(exec, globalObject);
}

bool JSStoragePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSStoragePrototype* thisObject = jsCast<JSStoragePrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSStoragePrototypeTable, thisObject, propertyName, slot);
}

bool JSStoragePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSStoragePrototype* thisObject = jsCast<JSStoragePrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSStoragePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSStorage::s_info = { "Storage", &Base::s_info, &JSStorageTable, 0 , CREATE_METHOD_TABLE(JSStorage) };

JSStorage::JSStorage(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Storage> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSStorage::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSStorage::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSStoragePrototype::create(exec->globalData(), globalObject, JSStoragePrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSStorage::destroy(JSC::JSCell* cell)
{
    JSStorage* thisObject = static_cast<JSStorage*>(cell);
    thisObject->JSStorage::~JSStorage();
}

JSStorage::~JSStorage()
{
    releaseImplIfNotNull();
}

bool JSStorage::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSStorage* thisObject = jsCast<JSStorage*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSStorage>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    if (canGetItemsForName(exec, static_cast<Storage*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return getStaticValueSlot<JSStorage, Base>(exec, &JSStorageTable, thisObject, propertyName, slot);
}

bool JSStorage::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSStorage* thisObject = jsCast<JSStorage*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSStorageTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    if (canGetItemsForName(exec, static_cast<Storage*>(thisObject->impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(thisObject, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSStorage, Base>(exec, &JSStorageTable, thisObject, propertyName, descriptor);
}

bool JSStorage::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSStorage* thisObject = jsCast<JSStorage*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    PropertyName propertyName = Identifier::from(exec, index);
    if (canGetItemsForName(exec, static_cast<Storage*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsStorageLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSStorage* castedThis = jsCast<JSStorage*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Storage* impl = static_cast<Storage*>(castedThis->impl());
    JSC::JSValue result = jsNumber(impl->length(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsStorageConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSStorage* domObject = jsCast<JSStorage*>(asObject(slotBase));
    return JSStorage::getConstructor(exec, domObject->globalObject());
}

void JSStorage::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSStorage* thisObject = jsCast<JSStorage*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (thisObject->putDelegate(exec, propertyName, value, slot))
        return;
    Base::put(thisObject, exec, propertyName, value, slot);
}

void JSStorage::putByIndex(JSCell* cell, ExecState* exec, unsigned index, JSValue value, bool shouldThrow)
{
    JSStorage* thisObject = jsCast<JSStorage*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    PropertyName propertyName = Identifier::from(exec, index);
    PutPropertySlot slot(shouldThrow);
    if (thisObject->putDelegate(exec, propertyName, value, slot))
        return;
    Base::putByIndex(cell, exec, index, value, shouldThrow);
}

JSValue JSStorage::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStorageConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsStoragePrototypeFunctionKey(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSStorage::s_info))
        return throwVMTypeError(exec);
    JSStorage* castedThis = jsCast<JSStorage*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSStorage::s_info);
    Storage* impl = static_cast<Storage*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringOrNull(exec, impl->key(index, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsStoragePrototypeFunctionGetItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSStorage::s_info))
        return throwVMTypeError(exec);
    JSStorage* castedThis = jsCast<JSStorage*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSStorage::s_info);
    Storage* impl = static_cast<Storage*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& key(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringOrNull(exec, impl->getItem(key, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsStoragePrototypeFunctionSetItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSStorage::s_info))
        return throwVMTypeError(exec);
    JSStorage* castedThis = jsCast<JSStorage*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSStorage::s_info);
    Storage* impl = static_cast<Storage*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& key(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& data(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setItem(key, data, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsStoragePrototypeFunctionRemoveItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSStorage::s_info))
        return throwVMTypeError(exec);
    JSStorage* castedThis = jsCast<JSStorage*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSStorage::s_info);
    Storage* impl = static_cast<Storage*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& key(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->removeItem(key, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsStoragePrototypeFunctionClear(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSStorage::s_info))
        return throwVMTypeError(exec);
    JSStorage* castedThis = jsCast<JSStorage*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSStorage::s_info);
    Storage* impl = static_cast<Storage*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->clear(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSStorage* jsStorage)
{
    if (jsStorage->hasCustomProperties())
        return true;
    return false;
}

bool JSStorageOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSStorage* jsStorage = jsCast<JSStorage*>(handle.get().asCell());
    if (!isObservable(jsStorage))
        return false;
    Frame* root = jsStorage->impl()->frame();
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSStorageOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSStorage* jsStorage = jsCast<JSStorage*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsStorage->impl(), jsStorage);
    jsStorage->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Storage* impl)
{
    return wrap<JSStorage>(exec, globalObject, impl);
}

Storage* toStorage(JSC::JSValue value)
{
    return value.inherits(&JSStorage::s_info) ? jsCast<JSStorage*>(asObject(value))->impl() : 0;
}

}
