/* Generated by re2c 0.13.5 on Tue Feb 19 16:16:47 2013 */
/*
 * Copyright (C) 2009 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Generate js file as follows:
re2c -isc Source/WebCore/inspector/front-end/SourceJavaScriptTokenizer.re2js \
  | sed 's|^yy\([^:]*\)*\:|case \1:|' \
  | sed 's|[*]cursor[+][+]|this._charAt(cursor++)|' \
  | sed 's|[[*][+][+]cursor|this._charAt(++cursor)|' \
  | sed 's|[*]cursor|this._charAt(cursor)|' \
  | sed 's|yych = \*\([^;]*\)|yych = this._charAt\1|' \
  | sed 's|{ gotoCase = \([^; continue; };]*\)|{ gotoCase = \1; continue; }|' \
  | sed 's|yych <= \(0x[0-9a-fA-F]*\)|yych \<\= String.fromCharCode(\1)|' \
  | sed 's|unsigned\ int|var|' \
  | sed 's|var\ yych|case 1: case 1: var yych|' > Source/WebCore/inspector/front-end/SourceJavaScriptTokenizer.js
 */

/**
 * @constructor
 * @extends {WebInspector.SourceTokenizer}
 */
WebInspector.SourceJavaScriptTokenizer = function()
{
    WebInspector.SourceTokenizer.call(this);

    this._lexConditions = {
        DIV: 0,
        NODIV: 1,
        COMMENT: 2,
        DSTRING: 3,
        SSTRING: 4,
        REGEX: 5
    };

    this.case_DIV = 1000;
    this.case_NODIV = 1001;
    this.case_COMMENT = 1002;
    this.case_DSTRING = 1003;
    this.case_SSTRING = 1004;
    this.case_REGEX = 1005;

    this.condition = this.createInitialCondition();
}

WebInspector.SourceJavaScriptTokenizer.Keywords = [
        "null", "true", "false", "break", "case", "catch", "const", "default", "finally", "for",
        "instanceof", "new", "var", "continue", "function", "return", "void", "delete", "if",
        "this", "do", "while", "else", "in", "switch", "throw", "try", "typeof", "debugger",
        "class", "enum", "export", "extends", "import", "super", "get", "set", "with"
    ].keySet();

WebInspector.SourceJavaScriptTokenizer.GlobalObjectValueProperties = {
    "NaN": "javascript-nan",
    "undefined": "javascript-undef",
    "Infinity": "javascript-inf"
};

WebInspector.SourceJavaScriptTokenizer.prototype = {
    createInitialCondition: function()
    {
        return { lexCondition: this._lexConditions.NODIV };
    },

    nextToken: function(cursor)
    {
        var cursorOnEnter = cursor;
        var gotoCase = 1;
        var YYMARKER;
        while (1) {
            switch (gotoCase)
            // Following comment is replaced with generated state machine.
            
        {
            case 1: var yych;
            var yyaccept = 0;
            if (this.getLexCondition() < 3) {
                if (this.getLexCondition() < 1) {
                    { gotoCase = this.case_DIV; continue; };
                } else {
                    if (this.getLexCondition() < 2) {
                        { gotoCase = this.case_NODIV; continue; };
                    } else {
                        { gotoCase = this.case_COMMENT; continue; };
                    }
                }
            } else {
                if (this.getLexCondition() < 4) {
                    { gotoCase = this.case_DSTRING; continue; };
                } else {
                    if (this.getLexCondition() < 5) {
                        { gotoCase = this.case_SSTRING; continue; };
                    } else {
                        { gotoCase = this.case_REGEX; continue; };
                    }
                }
            }
/* *********************************** */
case this.case_COMMENT:

            yych = this._charAt(cursor);
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 4; continue; };
                { gotoCase = 3; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 4; continue; };
                if (yych == '*') { gotoCase = 6; continue; };
                { gotoCase = 3; continue; };
            }
case 2:
            { this.tokenType = "javascript-comment"; return cursor; }
case 3:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            { gotoCase = 12; continue; };
case 4:
            ++cursor;
            { this.tokenType = null; return cursor; }
case 6:
            yyaccept = 1;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych == '*') { gotoCase = 9; continue; };
            if (yych != '/') { gotoCase = 11; continue; };
case 7:
            ++cursor;
            this.setLexCondition(this._lexConditions.NODIV);
            { this.tokenType = "javascript-comment"; return cursor; }
case 9:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '*') { gotoCase = 9; continue; };
            if (yych == '/') { gotoCase = 7; continue; };
case 11:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
case 12:
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 2; continue; };
                { gotoCase = 11; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 2; continue; };
                if (yych == '*') { gotoCase = 9; continue; };
                { gotoCase = 11; continue; };
            }
/* *********************************** */
case this.case_DIV:
            yych = this._charAt(cursor);
            if (yych <= '9') {
                if (yych <= '\'') {
                    if (yych <= '"') {
                        if (yych <= String.fromCharCode(0x1F)) { gotoCase = 15; continue; };
                        if (yych <= ' ') { gotoCase = 17; continue; };
                        if (yych <= '!') { gotoCase = 19; continue; };
                        { gotoCase = 21; continue; };
                    } else {
                        if (yych <= '$') {
                            if (yych >= '$') { gotoCase = 22; continue; };
                        } else {
                            if (yych <= '%') { gotoCase = 24; continue; };
                            if (yych <= '&') { gotoCase = 25; continue; };
                            { gotoCase = 26; continue; };
                        }
                    }
                } else {
                    if (yych <= ',') {
                        if (yych <= ')') {
                            if (yych <= '(') { gotoCase = 27; continue; };
                            { gotoCase = 28; continue; };
                        } else {
                            if (yych <= '*') { gotoCase = 30; continue; };
                            if (yych <= '+') { gotoCase = 31; continue; };
                            { gotoCase = 27; continue; };
                        }
                    } else {
                        if (yych <= '.') {
                            if (yych <= '-') { gotoCase = 32; continue; };
                            { gotoCase = 33; continue; };
                        } else {
                            if (yych <= '/') { gotoCase = 34; continue; };
                            if (yych <= '0') { gotoCase = 36; continue; };
                            { gotoCase = 38; continue; };
                        }
                    }
                }
            } else {
                if (yych <= '\\') {
                    if (yych <= '>') {
                        if (yych <= ';') { gotoCase = 27; continue; };
                        if (yych <= '<') { gotoCase = 39; continue; };
                        if (yych <= '=') { gotoCase = 40; continue; };
                        { gotoCase = 41; continue; };
                    } else {
                        if (yych <= '@') {
                            if (yych <= '?') { gotoCase = 27; continue; };
                        } else {
                            if (yych <= 'Z') { gotoCase = 22; continue; };
                            if (yych <= '[') { gotoCase = 27; continue; };
                            { gotoCase = 42; continue; };
                        }
                    }
                } else {
                    if (yych <= 'z') {
                        if (yych <= '^') {
                            if (yych <= ']') { gotoCase = 27; continue; };
                            { gotoCase = 43; continue; };
                        } else {
                            if (yych != '`') { gotoCase = 22; continue; };
                        }
                    } else {
                        if (yych <= '|') {
                            if (yych <= '{') { gotoCase = 27; continue; };
                            { gotoCase = 44; continue; };
                        } else {
                            if (yych <= '~') { gotoCase = 27; continue; };
                            if (yych >= 0x80) { gotoCase = 22; continue; };
                        }
                    }
                }
            }
case 15:
            ++cursor;
case 16:
            { this.tokenType = null; return cursor; }
case 17:
            ++cursor;
            yych = this._charAt(cursor);
            { gotoCase = 119; continue; };
case 18:
            {this.tokenType = "whitespace"; return cursor; }
case 19:
            ++cursor;
            if ((yych = this._charAt(cursor)) == '=') { gotoCase = 117; continue; };
case 20:
            this.setLexCondition(this._lexConditions.NODIV);
            {
                    var token = this._line.charAt(cursorOnEnter);
                    if (token === "{")
                        this.tokenType = "block-start";
                    else if (token === "}")
                        this.tokenType = "block-end";
                    else if (token === "(")
                        this.tokenType = "brace-start";
                    else this.tokenType = null;
                    return cursor;
                }
case 21:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych == '\n') { gotoCase = 16; continue; };
            if (yych == '\r') { gotoCase = 16; continue; };
            { gotoCase = 109; continue; };
case 22:
            yyaccept = 1;
            yych = this._charAt(YYMARKER = ++cursor);
            { gotoCase = 52; continue; };
case 23:
            {
                    var token = this._line.substring(cursorOnEnter, cursor);
                    if (WebInspector.SourceJavaScriptTokenizer.GlobalObjectValueProperties.hasOwnProperty(token))
                        this.tokenType = WebInspector.SourceJavaScriptTokenizer.GlobalObjectValueProperties[token];
                    else if (WebInspector.SourceJavaScriptTokenizer.Keywords[token] === true && token !== "__proto__")
                        this.tokenType = "javascript-keyword";
                    else
                        this.tokenType = "javascript-ident";
                    return cursor;
                }
case 24:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 45; continue; };
            { gotoCase = 20; continue; };
case 25:
            yych = this._charAt(++cursor);
            if (yych == '&') { gotoCase = 45; continue; };
            if (yych == '=') { gotoCase = 45; continue; };
            { gotoCase = 20; continue; };
case 26:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych == '\n') { gotoCase = 16; continue; };
            if (yych == '\r') { gotoCase = 16; continue; };
            { gotoCase = 98; continue; };
case 27:
            yych = this._charAt(++cursor);
            { gotoCase = 20; continue; };
case 28:
            ++cursor;
            { this.tokenType = "brace-end"; return cursor; }
case 30:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 45; continue; };
            { gotoCase = 20; continue; };
case 31:
            yych = this._charAt(++cursor);
            if (yych == '+') { gotoCase = 45; continue; };
            if (yych == '=') { gotoCase = 45; continue; };
            { gotoCase = 20; continue; };
case 32:
            yych = this._charAt(++cursor);
            if (yych == '-') { gotoCase = 45; continue; };
            if (yych == '=') { gotoCase = 45; continue; };
            { gotoCase = 20; continue; };
case 33:
            yych = this._charAt(++cursor);
            if (yych <= '/') { gotoCase = 20; continue; };
            if (yych <= '9') { gotoCase = 91; continue; };
            { gotoCase = 20; continue; };
case 34:
            yyaccept = 2;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych <= '.') {
                if (yych == '*') { gotoCase = 80; continue; };
            } else {
                if (yych <= '/') { gotoCase = 82; continue; };
                if (yych == '=') { gotoCase = 79; continue; };
            }
case 35:
            this.setLexCondition(this._lexConditions.NODIV);
            { this.tokenType = null; return cursor; }
case 36:
            yyaccept = 3;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych <= 'E') {
                if (yych <= '/') {
                    if (yych == '.') { gotoCase = 65; continue; };
                } else {
                    if (yych <= '7') { gotoCase = 74; continue; };
                    if (yych >= 'E') { gotoCase = 64; continue; };
                }
            } else {
                if (yych <= 'd') {
                    if (yych == 'X') { gotoCase = 76; continue; };
                } else {
                    if (yych <= 'e') { gotoCase = 64; continue; };
                    if (yych == 'x') { gotoCase = 76; continue; };
                }
            }
case 37:
            { this.tokenType = "javascript-number"; return cursor; }
case 38:
            yyaccept = 3;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych <= '9') {
                if (yych == '.') { gotoCase = 65; continue; };
                if (yych <= '/') { gotoCase = 37; continue; };
                { gotoCase = 62; continue; };
            } else {
                if (yych <= 'E') {
                    if (yych <= 'D') { gotoCase = 37; continue; };
                    { gotoCase = 64; continue; };
                } else {
                    if (yych == 'e') { gotoCase = 64; continue; };
                    { gotoCase = 37; continue; };
                }
            }
case 39:
            yych = this._charAt(++cursor);
            if (yych <= ';') { gotoCase = 20; continue; };
            if (yych <= '<') { gotoCase = 61; continue; };
            if (yych <= '=') { gotoCase = 45; continue; };
            { gotoCase = 20; continue; };
case 40:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 60; continue; };
            { gotoCase = 20; continue; };
case 41:
            yych = this._charAt(++cursor);
            if (yych <= '<') { gotoCase = 20; continue; };
            if (yych <= '=') { gotoCase = 45; continue; };
            if (yych <= '>') { gotoCase = 58; continue; };
            { gotoCase = 20; continue; };
case 42:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych == 'u') { gotoCase = 46; continue; };
            { gotoCase = 16; continue; };
case 43:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 45; continue; };
            { gotoCase = 20; continue; };
case 44:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 45; continue; };
            if (yych != '|') { gotoCase = 20; continue; };
case 45:
            yych = this._charAt(++cursor);
            { gotoCase = 20; continue; };
case 46:
            yych = this._charAt(++cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych <= '9') { gotoCase = 48; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 48; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych <= 'f') { gotoCase = 48; continue; };
            }
case 47:
            cursor = YYMARKER;
            if (yyaccept <= 1) {
                if (yyaccept <= 0) {
                    { gotoCase = 16; continue; };
                } else {
                    { gotoCase = 23; continue; };
                }
            } else {
                if (yyaccept <= 2) {
                    { gotoCase = 35; continue; };
                } else {
                    { gotoCase = 37; continue; };
                }
            }
case 48:
            yych = this._charAt(++cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych >= ':') { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 49; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych >= 'g') { gotoCase = 47; continue; };
            }
case 49:
            yych = this._charAt(++cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych >= ':') { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 50; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych >= 'g') { gotoCase = 47; continue; };
            }
case 50:
            yych = this._charAt(++cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych >= ':') { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 51; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych >= 'g') { gotoCase = 47; continue; };
            }
case 51:
            yyaccept = 1;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
case 52:
            if (yych <= '[') {
                if (yych <= '/') {
                    if (yych == '$') { gotoCase = 51; continue; };
                    { gotoCase = 23; continue; };
                } else {
                    if (yych <= '9') { gotoCase = 51; continue; };
                    if (yych <= '@') { gotoCase = 23; continue; };
                    if (yych <= 'Z') { gotoCase = 51; continue; };
                    { gotoCase = 23; continue; };
                }
            } else {
                if (yych <= '_') {
                    if (yych <= '\\') { gotoCase = 53; continue; };
                    if (yych <= '^') { gotoCase = 23; continue; };
                    { gotoCase = 51; continue; };
                } else {
                    if (yych <= '`') { gotoCase = 23; continue; };
                    if (yych <= 'z') { gotoCase = 51; continue; };
                    if (yych <= String.fromCharCode(0x7F)) { gotoCase = 23; continue; };
                    { gotoCase = 51; continue; };
                }
            }
case 53:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych != 'u') { gotoCase = 47; continue; };
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych >= ':') { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 55; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych >= 'g') { gotoCase = 47; continue; };
            }
case 55:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych >= ':') { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 56; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych >= 'g') { gotoCase = 47; continue; };
            }
case 56:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych >= ':') { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 57; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych >= 'g') { gotoCase = 47; continue; };
            }
case 57:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych <= '9') { gotoCase = 51; continue; };
                { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 51; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych <= 'f') { gotoCase = 51; continue; };
                { gotoCase = 47; continue; };
            }
case 58:
            yych = this._charAt(++cursor);
            if (yych <= '<') { gotoCase = 20; continue; };
            if (yych <= '=') { gotoCase = 45; continue; };
            if (yych >= '?') { gotoCase = 20; continue; };
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 45; continue; };
            { gotoCase = 20; continue; };
case 60:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 45; continue; };
            { gotoCase = 20; continue; };
case 61:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 45; continue; };
            { gotoCase = 20; continue; };
case 62:
            yyaccept = 3;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '9') {
                if (yych == '.') { gotoCase = 65; continue; };
                if (yych <= '/') { gotoCase = 37; continue; };
                { gotoCase = 62; continue; };
            } else {
                if (yych <= 'E') {
                    if (yych <= 'D') { gotoCase = 37; continue; };
                } else {
                    if (yych != 'e') { gotoCase = 37; continue; };
                }
            }
case 64:
            yych = this._charAt(++cursor);
            if (yych <= ',') {
                if (yych == '+') { gotoCase = 71; continue; };
                { gotoCase = 47; continue; };
            } else {
                if (yych <= '-') { gotoCase = 71; continue; };
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych <= '9') { gotoCase = 72; continue; };
                { gotoCase = 47; continue; };
            }
case 65:
            yyaccept = 3;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'D') {
                if (yych <= '/') { gotoCase = 37; continue; };
                if (yych <= '9') { gotoCase = 65; continue; };
                { gotoCase = 37; continue; };
            } else {
                if (yych <= 'E') { gotoCase = 67; continue; };
                if (yych != 'e') { gotoCase = 37; continue; };
            }
case 67:
            yych = this._charAt(++cursor);
            if (yych <= ',') {
                if (yych != '+') { gotoCase = 47; continue; };
            } else {
                if (yych <= '-') { gotoCase = 68; continue; };
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych <= '9') { gotoCase = 69; continue; };
                { gotoCase = 47; continue; };
            }
case 68:
            yych = this._charAt(++cursor);
            if (yych <= '/') { gotoCase = 47; continue; };
            if (yych >= ':') { gotoCase = 47; continue; };
case 69:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '/') { gotoCase = 37; continue; };
            if (yych <= '9') { gotoCase = 69; continue; };
            { gotoCase = 37; continue; };
case 71:
            yych = this._charAt(++cursor);
            if (yych <= '/') { gotoCase = 47; continue; };
            if (yych >= ':') { gotoCase = 47; continue; };
case 72:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '/') { gotoCase = 37; continue; };
            if (yych <= '9') { gotoCase = 72; continue; };
            { gotoCase = 37; continue; };
case 74:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '/') { gotoCase = 37; continue; };
            if (yych <= '7') { gotoCase = 74; continue; };
            { gotoCase = 37; continue; };
case 76:
            yych = this._charAt(++cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych >= ':') { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 77; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych >= 'g') { gotoCase = 47; continue; };
            }
case 77:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 37; continue; };
                if (yych <= '9') { gotoCase = 77; continue; };
                { gotoCase = 37; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 77; continue; };
                if (yych <= '`') { gotoCase = 37; continue; };
                if (yych <= 'f') { gotoCase = 77; continue; };
                { gotoCase = 37; continue; };
            }
case 79:
            yych = this._charAt(++cursor);
            { gotoCase = 35; continue; };
case 80:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 87; continue; };
                { gotoCase = 80; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 87; continue; };
                if (yych == '*') { gotoCase = 85; continue; };
                { gotoCase = 80; continue; };
            }
case 82:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '\n') { gotoCase = 84; continue; };
            if (yych != '\r') { gotoCase = 82; continue; };
case 84:
            { this.tokenType = "javascript-comment"; return cursor; }
case 85:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '*') { gotoCase = 85; continue; };
            if (yych == '/') { gotoCase = 89; continue; };
            { gotoCase = 80; continue; };
case 87:
            ++cursor;
            this.setLexCondition(this._lexConditions.COMMENT);
            { this.tokenType = "javascript-comment"; return cursor; }
case 89:
            ++cursor;
            { this.tokenType = "javascript-comment"; return cursor; }
case 91:
            yyaccept = 3;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'D') {
                if (yych <= '/') { gotoCase = 37; continue; };
                if (yych <= '9') { gotoCase = 91; continue; };
                { gotoCase = 37; continue; };
            } else {
                if (yych <= 'E') { gotoCase = 93; continue; };
                if (yych != 'e') { gotoCase = 37; continue; };
            }
case 93:
            yych = this._charAt(++cursor);
            if (yych <= ',') {
                if (yych != '+') { gotoCase = 47; continue; };
            } else {
                if (yych <= '-') { gotoCase = 94; continue; };
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych <= '9') { gotoCase = 95; continue; };
                { gotoCase = 47; continue; };
            }
case 94:
            yych = this._charAt(++cursor);
            if (yych <= '/') { gotoCase = 47; continue; };
            if (yych >= ':') { gotoCase = 47; continue; };
case 95:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '/') { gotoCase = 37; continue; };
            if (yych <= '9') { gotoCase = 95; continue; };
            { gotoCase = 37; continue; };
case 97:
            ++cursor;
            yych = this._charAt(cursor);
case 98:
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 47; continue; };
                if (yych <= '\f') { gotoCase = 97; continue; };
                { gotoCase = 47; continue; };
            } else {
                if (yych <= '\'') {
                    if (yych <= '&') { gotoCase = 97; continue; };
                    { gotoCase = 100; continue; };
                } else {
                    if (yych != '\\') { gotoCase = 97; continue; };
                }
            }
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'a') {
                if (yych <= '!') {
                    if (yych <= '\n') {
                        if (yych <= '\t') { gotoCase = 47; continue; };
                        { gotoCase = 103; continue; };
                    } else {
                        if (yych == '\r') { gotoCase = 103; continue; };
                        { gotoCase = 47; continue; };
                    }
                } else {
                    if (yych <= '\'') {
                        if (yych <= '"') { gotoCase = 97; continue; };
                        if (yych <= '&') { gotoCase = 47; continue; };
                        { gotoCase = 97; continue; };
                    } else {
                        if (yych == '\\') { gotoCase = 97; continue; };
                        { gotoCase = 47; continue; };
                    }
                }
            } else {
                if (yych <= 'q') {
                    if (yych <= 'f') {
                        if (yych <= 'b') { gotoCase = 97; continue; };
                        if (yych <= 'e') { gotoCase = 47; continue; };
                        { gotoCase = 97; continue; };
                    } else {
                        if (yych == 'n') { gotoCase = 97; continue; };
                        { gotoCase = 47; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych == 's') { gotoCase = 47; continue; };
                        { gotoCase = 97; continue; };
                    } else {
                        if (yych <= 'u') { gotoCase = 102; continue; };
                        if (yych <= 'v') { gotoCase = 97; continue; };
                        { gotoCase = 47; continue; };
                    }
                }
            }
case 100:
            ++cursor;
            { this.tokenType = "javascript-string"; return cursor; }
case 102:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych <= '9') { gotoCase = 105; continue; };
                { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 105; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych <= 'f') { gotoCase = 105; continue; };
                { gotoCase = 47; continue; };
            }
case 103:
            ++cursor;
            this.setLexCondition(this._lexConditions.SSTRING);
            { this.tokenType = "javascript-string"; return cursor; }
case 105:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych >= ':') { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 106; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych >= 'g') { gotoCase = 47; continue; };
            }
case 106:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych >= ':') { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 107; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych >= 'g') { gotoCase = 47; continue; };
            }
case 107:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych <= '9') { gotoCase = 97; continue; };
                { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 97; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych <= 'f') { gotoCase = 97; continue; };
                { gotoCase = 47; continue; };
            }
case 108:
            ++cursor;
            yych = this._charAt(cursor);
case 109:
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 47; continue; };
                if (yych <= '\f') { gotoCase = 108; continue; };
                { gotoCase = 47; continue; };
            } else {
                if (yych <= '"') {
                    if (yych <= '!') { gotoCase = 108; continue; };
                    { gotoCase = 100; continue; };
                } else {
                    if (yych != '\\') { gotoCase = 108; continue; };
                }
            }
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'a') {
                if (yych <= '!') {
                    if (yych <= '\n') {
                        if (yych <= '\t') { gotoCase = 47; continue; };
                        { gotoCase = 112; continue; };
                    } else {
                        if (yych == '\r') { gotoCase = 112; continue; };
                        { gotoCase = 47; continue; };
                    }
                } else {
                    if (yych <= '\'') {
                        if (yych <= '"') { gotoCase = 108; continue; };
                        if (yych <= '&') { gotoCase = 47; continue; };
                        { gotoCase = 108; continue; };
                    } else {
                        if (yych == '\\') { gotoCase = 108; continue; };
                        { gotoCase = 47; continue; };
                    }
                }
            } else {
                if (yych <= 'q') {
                    if (yych <= 'f') {
                        if (yych <= 'b') { gotoCase = 108; continue; };
                        if (yych <= 'e') { gotoCase = 47; continue; };
                        { gotoCase = 108; continue; };
                    } else {
                        if (yych == 'n') { gotoCase = 108; continue; };
                        { gotoCase = 47; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych == 's') { gotoCase = 47; continue; };
                        { gotoCase = 108; continue; };
                    } else {
                        if (yych <= 'u') { gotoCase = 111; continue; };
                        if (yych <= 'v') { gotoCase = 108; continue; };
                        { gotoCase = 47; continue; };
                    }
                }
            }
case 111:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych <= '9') { gotoCase = 114; continue; };
                { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 114; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych <= 'f') { gotoCase = 114; continue; };
                { gotoCase = 47; continue; };
            }
case 112:
            ++cursor;
            this.setLexCondition(this._lexConditions.DSTRING);
            { this.tokenType = "javascript-string"; return cursor; }
case 114:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych >= ':') { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 115; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych >= 'g') { gotoCase = 47; continue; };
            }
case 115:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych >= ':') { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 116; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych >= 'g') { gotoCase = 47; continue; };
            }
case 116:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 47; continue; };
                if (yych <= '9') { gotoCase = 108; continue; };
                { gotoCase = 47; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 108; continue; };
                if (yych <= '`') { gotoCase = 47; continue; };
                if (yych <= 'f') { gotoCase = 108; continue; };
                { gotoCase = 47; continue; };
            }
case 117:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 45; continue; };
            { gotoCase = 20; continue; };
case 118:
            ++cursor;
            yych = this._charAt(cursor);
case 119:
            if (yych == ' ') { gotoCase = 118; continue; };
            { gotoCase = 18; continue; };
/* *********************************** */
case this.case_DSTRING:
            yych = this._charAt(cursor);
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 124; continue; };
                if (yych <= '\f') { gotoCase = 123; continue; };
                { gotoCase = 124; continue; };
            } else {
                if (yych <= '"') {
                    if (yych <= '!') { gotoCase = 123; continue; };
                    { gotoCase = 126; continue; };
                } else {
                    if (yych == '\\') { gotoCase = 128; continue; };
                    { gotoCase = 123; continue; };
                }
            }
case 122:
            { this.tokenType = "javascript-string"; return cursor; }
case 123:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            { gotoCase = 130; continue; };
case 124:
            ++cursor;
case 125:
            { this.tokenType = null; return cursor; }
case 126:
            ++cursor;
case 127:
            this.setLexCondition(this._lexConditions.NODIV);
            { this.tokenType = "javascript-string"; return cursor; }
case 128:
            yyaccept = 1;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych <= 'e') {
                if (yych <= '\'') {
                    if (yych == '"') { gotoCase = 129; continue; };
                    if (yych <= '&') { gotoCase = 125; continue; };
                } else {
                    if (yych <= '\\') {
                        if (yych <= '[') { gotoCase = 125; continue; };
                    } else {
                        if (yych != 'b') { gotoCase = 125; continue; };
                    }
                }
            } else {
                if (yych <= 'r') {
                    if (yych <= 'm') {
                        if (yych >= 'g') { gotoCase = 125; continue; };
                    } else {
                        if (yych <= 'n') { gotoCase = 129; continue; };
                        if (yych <= 'q') { gotoCase = 125; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych <= 's') { gotoCase = 125; continue; };
                    } else {
                        if (yych <= 'u') { gotoCase = 131; continue; };
                        if (yych >= 'w') { gotoCase = 125; continue; };
                    }
                }
            }
case 129:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
case 130:
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 122; continue; };
                if (yych <= '\f') { gotoCase = 129; continue; };
                { gotoCase = 122; continue; };
            } else {
                if (yych <= '"') {
                    if (yych <= '!') { gotoCase = 129; continue; };
                    { gotoCase = 137; continue; };
                } else {
                    if (yych == '\\') { gotoCase = 136; continue; };
                    { gotoCase = 129; continue; };
                }
            }
case 131:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 132; continue; };
                if (yych <= '9') { gotoCase = 133; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 133; continue; };
                if (yych <= '`') { gotoCase = 132; continue; };
                if (yych <= 'f') { gotoCase = 133; continue; };
            }
case 132:
            cursor = YYMARKER;
            if (yyaccept <= 0) {
                { gotoCase = 122; continue; };
            } else {
                { gotoCase = 125; continue; };
            }
case 133:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 132; continue; };
                if (yych >= ':') { gotoCase = 132; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 134; continue; };
                if (yych <= '`') { gotoCase = 132; continue; };
                if (yych >= 'g') { gotoCase = 132; continue; };
            }
case 134:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 132; continue; };
                if (yych >= ':') { gotoCase = 132; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 135; continue; };
                if (yych <= '`') { gotoCase = 132; continue; };
                if (yych >= 'g') { gotoCase = 132; continue; };
            }
case 135:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 132; continue; };
                if (yych <= '9') { gotoCase = 129; continue; };
                { gotoCase = 132; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 129; continue; };
                if (yych <= '`') { gotoCase = 132; continue; };
                if (yych <= 'f') { gotoCase = 129; continue; };
                { gotoCase = 132; continue; };
            }
case 136:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'e') {
                if (yych <= '\'') {
                    if (yych == '"') { gotoCase = 129; continue; };
                    if (yych <= '&') { gotoCase = 132; continue; };
                    { gotoCase = 129; continue; };
                } else {
                    if (yych <= '\\') {
                        if (yych <= '[') { gotoCase = 132; continue; };
                        { gotoCase = 129; continue; };
                    } else {
                        if (yych == 'b') { gotoCase = 129; continue; };
                        { gotoCase = 132; continue; };
                    }
                }
            } else {
                if (yych <= 'r') {
                    if (yych <= 'm') {
                        if (yych <= 'f') { gotoCase = 129; continue; };
                        { gotoCase = 132; continue; };
                    } else {
                        if (yych <= 'n') { gotoCase = 129; continue; };
                        if (yych <= 'q') { gotoCase = 132; continue; };
                        { gotoCase = 129; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych <= 's') { gotoCase = 132; continue; };
                        { gotoCase = 129; continue; };
                    } else {
                        if (yych <= 'u') { gotoCase = 131; continue; };
                        if (yych <= 'v') { gotoCase = 129; continue; };
                        { gotoCase = 132; continue; };
                    }
                }
            }
case 137:
            ++cursor;
            yych = this._charAt(cursor);
            { gotoCase = 127; continue; };
/* *********************************** */
case this.case_NODIV:
            yych = this._charAt(cursor);
            if (yych <= '9') {
                if (yych <= '\'') {
                    if (yych <= '"') {
                        if (yych <= String.fromCharCode(0x1F)) { gotoCase = 140; continue; };
                        if (yych <= ' ') { gotoCase = 142; continue; };
                        if (yych <= '!') { gotoCase = 144; continue; };
                        { gotoCase = 146; continue; };
                    } else {
                        if (yych <= '$') {
                            if (yych >= '$') { gotoCase = 147; continue; };
                        } else {
                            if (yych <= '%') { gotoCase = 149; continue; };
                            if (yych <= '&') { gotoCase = 150; continue; };
                            { gotoCase = 151; continue; };
                        }
                    }
                } else {
                    if (yych <= ',') {
                        if (yych <= ')') {
                            if (yych <= '(') { gotoCase = 152; continue; };
                            { gotoCase = 153; continue; };
                        } else {
                            if (yych <= '*') { gotoCase = 155; continue; };
                            if (yych <= '+') { gotoCase = 156; continue; };
                            { gotoCase = 152; continue; };
                        }
                    } else {
                        if (yych <= '.') {
                            if (yych <= '-') { gotoCase = 157; continue; };
                            { gotoCase = 158; continue; };
                        } else {
                            if (yych <= '/') { gotoCase = 159; continue; };
                            if (yych <= '0') { gotoCase = 160; continue; };
                            { gotoCase = 162; continue; };
                        }
                    }
                }
            } else {
                if (yych <= '\\') {
                    if (yych <= '>') {
                        if (yych <= ';') { gotoCase = 152; continue; };
                        if (yych <= '<') { gotoCase = 163; continue; };
                        if (yych <= '=') { gotoCase = 164; continue; };
                        { gotoCase = 165; continue; };
                    } else {
                        if (yych <= '@') {
                            if (yych <= '?') { gotoCase = 152; continue; };
                        } else {
                            if (yych <= 'Z') { gotoCase = 147; continue; };
                            if (yych <= '[') { gotoCase = 152; continue; };
                            { gotoCase = 166; continue; };
                        }
                    }
                } else {
                    if (yych <= 'z') {
                        if (yych <= '^') {
                            if (yych <= ']') { gotoCase = 152; continue; };
                            { gotoCase = 167; continue; };
                        } else {
                            if (yych != '`') { gotoCase = 147; continue; };
                        }
                    } else {
                        if (yych <= '|') {
                            if (yych <= '{') { gotoCase = 152; continue; };
                            { gotoCase = 168; continue; };
                        } else {
                            if (yych <= '~') { gotoCase = 152; continue; };
                            if (yych >= 0x80) { gotoCase = 147; continue; };
                        }
                    }
                }
            }
case 140:
            ++cursor;
case 141:
            { this.tokenType = null; return cursor; }
case 142:
            ++cursor;
            yych = this._charAt(cursor);
            { gotoCase = 268; continue; };
case 143:
            {this.tokenType = "whitespace"; return cursor; }
case 144:
            ++cursor;
            if ((yych = this._charAt(cursor)) == '=') { gotoCase = 266; continue; };
case 145:
            {
                    var token = this._line.charAt(cursorOnEnter);
                    if (token === "{")
                        this.tokenType = "block-start";
                    else if (token === "}")
                        this.tokenType = "block-end";
                    else if (token === "(")
                        this.tokenType = "brace-start";
                    else this.tokenType = null;
                    return cursor;
                }
case 146:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych == '\n') { gotoCase = 141; continue; };
            if (yych == '\r') { gotoCase = 141; continue; };
            { gotoCase = 258; continue; };
case 147:
            yyaccept = 1;
            yych = this._charAt(YYMARKER = ++cursor);
            { gotoCase = 176; continue; };
case 148:
            this.setLexCondition(this._lexConditions.DIV);
            {
                    var token = this._line.substring(cursorOnEnter, cursor);
                    if (WebInspector.SourceJavaScriptTokenizer.GlobalObjectValueProperties.hasOwnProperty(token))
                        this.tokenType = WebInspector.SourceJavaScriptTokenizer.GlobalObjectValueProperties[token];
                    else if (WebInspector.SourceJavaScriptTokenizer.Keywords[token] === true && token !== "__proto__")
                        this.tokenType = "javascript-keyword";
                    else
                        this.tokenType = "javascript-ident";
                    return cursor;
                }
case 149:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 169; continue; };
            { gotoCase = 145; continue; };
case 150:
            yych = this._charAt(++cursor);
            if (yych == '&') { gotoCase = 169; continue; };
            if (yych == '=') { gotoCase = 169; continue; };
            { gotoCase = 145; continue; };
case 151:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych == '\n') { gotoCase = 141; continue; };
            if (yych == '\r') { gotoCase = 141; continue; };
            { gotoCase = 247; continue; };
case 152:
            yych = this._charAt(++cursor);
            { gotoCase = 145; continue; };
case 153:
            ++cursor;
            this.setLexCondition(this._lexConditions.DIV);
            { this.tokenType = "brace-end"; return cursor; }
case 155:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 169; continue; };
            { gotoCase = 145; continue; };
case 156:
            yych = this._charAt(++cursor);
            if (yych == '+') { gotoCase = 169; continue; };
            if (yych == '=') { gotoCase = 169; continue; };
            { gotoCase = 145; continue; };
case 157:
            yych = this._charAt(++cursor);
            if (yych == '-') { gotoCase = 169; continue; };
            if (yych == '=') { gotoCase = 169; continue; };
            { gotoCase = 145; continue; };
case 158:
            yych = this._charAt(++cursor);
            if (yych <= '/') { gotoCase = 145; continue; };
            if (yych <= '9') { gotoCase = 240; continue; };
            { gotoCase = 145; continue; };
case 159:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych <= '*') {
                if (yych <= '\f') {
                    if (yych == '\n') { gotoCase = 141; continue; };
                    { gotoCase = 203; continue; };
                } else {
                    if (yych <= '\r') { gotoCase = 141; continue; };
                    if (yych <= ')') { gotoCase = 203; continue; };
                    { gotoCase = 208; continue; };
                }
            } else {
                if (yych <= 'Z') {
                    if (yych == '/') { gotoCase = 210; continue; };
                    { gotoCase = 203; continue; };
                } else {
                    if (yych <= '[') { gotoCase = 206; continue; };
                    if (yych <= '\\') { gotoCase = 205; continue; };
                    if (yych <= ']') { gotoCase = 141; continue; };
                    { gotoCase = 203; continue; };
                }
            }
case 160:
            yyaccept = 2;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych <= 'E') {
                if (yych <= '/') {
                    if (yych == '.') { gotoCase = 189; continue; };
                } else {
                    if (yych <= '7') { gotoCase = 198; continue; };
                    if (yych >= 'E') { gotoCase = 188; continue; };
                }
            } else {
                if (yych <= 'd') {
                    if (yych == 'X') { gotoCase = 200; continue; };
                } else {
                    if (yych <= 'e') { gotoCase = 188; continue; };
                    if (yych == 'x') { gotoCase = 200; continue; };
                }
            }
case 161:
            this.setLexCondition(this._lexConditions.DIV);
            { this.tokenType = "javascript-number"; return cursor; }
case 162:
            yyaccept = 2;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych <= '9') {
                if (yych == '.') { gotoCase = 189; continue; };
                if (yych <= '/') { gotoCase = 161; continue; };
                { gotoCase = 186; continue; };
            } else {
                if (yych <= 'E') {
                    if (yych <= 'D') { gotoCase = 161; continue; };
                    { gotoCase = 188; continue; };
                } else {
                    if (yych == 'e') { gotoCase = 188; continue; };
                    { gotoCase = 161; continue; };
                }
            }
case 163:
            yych = this._charAt(++cursor);
            if (yych <= ';') { gotoCase = 145; continue; };
            if (yych <= '<') { gotoCase = 185; continue; };
            if (yych <= '=') { gotoCase = 169; continue; };
            { gotoCase = 145; continue; };
case 164:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 184; continue; };
            { gotoCase = 145; continue; };
case 165:
            yych = this._charAt(++cursor);
            if (yych <= '<') { gotoCase = 145; continue; };
            if (yych <= '=') { gotoCase = 169; continue; };
            if (yych <= '>') { gotoCase = 182; continue; };
            { gotoCase = 145; continue; };
case 166:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych == 'u') { gotoCase = 170; continue; };
            { gotoCase = 141; continue; };
case 167:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 169; continue; };
            { gotoCase = 145; continue; };
case 168:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 169; continue; };
            if (yych != '|') { gotoCase = 145; continue; };
case 169:
            yych = this._charAt(++cursor);
            { gotoCase = 145; continue; };
case 170:
            yych = this._charAt(++cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych <= '9') { gotoCase = 172; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 172; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych <= 'f') { gotoCase = 172; continue; };
            }
case 171:
            cursor = YYMARKER;
            if (yyaccept <= 1) {
                if (yyaccept <= 0) {
                    { gotoCase = 141; continue; };
                } else {
                    { gotoCase = 148; continue; };
                }
            } else {
                if (yyaccept <= 2) {
                    { gotoCase = 161; continue; };
                } else {
                    { gotoCase = 223; continue; };
                }
            }
case 172:
            yych = this._charAt(++cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych >= ':') { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 173; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych >= 'g') { gotoCase = 171; continue; };
            }
case 173:
            yych = this._charAt(++cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych >= ':') { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 174; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych >= 'g') { gotoCase = 171; continue; };
            }
case 174:
            yych = this._charAt(++cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych >= ':') { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 175; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych >= 'g') { gotoCase = 171; continue; };
            }
case 175:
            yyaccept = 1;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
case 176:
            if (yych <= '[') {
                if (yych <= '/') {
                    if (yych == '$') { gotoCase = 175; continue; };
                    { gotoCase = 148; continue; };
                } else {
                    if (yych <= '9') { gotoCase = 175; continue; };
                    if (yych <= '@') { gotoCase = 148; continue; };
                    if (yych <= 'Z') { gotoCase = 175; continue; };
                    { gotoCase = 148; continue; };
                }
            } else {
                if (yych <= '_') {
                    if (yych <= '\\') { gotoCase = 177; continue; };
                    if (yych <= '^') { gotoCase = 148; continue; };
                    { gotoCase = 175; continue; };
                } else {
                    if (yych <= '`') { gotoCase = 148; continue; };
                    if (yych <= 'z') { gotoCase = 175; continue; };
                    if (yych <= String.fromCharCode(0x7F)) { gotoCase = 148; continue; };
                    { gotoCase = 175; continue; };
                }
            }
case 177:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych != 'u') { gotoCase = 171; continue; };
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych >= ':') { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 179; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych >= 'g') { gotoCase = 171; continue; };
            }
case 179:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych >= ':') { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 180; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych >= 'g') { gotoCase = 171; continue; };
            }
case 180:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych >= ':') { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 181; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych >= 'g') { gotoCase = 171; continue; };
            }
case 181:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych <= '9') { gotoCase = 175; continue; };
                { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 175; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych <= 'f') { gotoCase = 175; continue; };
                { gotoCase = 171; continue; };
            }
case 182:
            yych = this._charAt(++cursor);
            if (yych <= '<') { gotoCase = 145; continue; };
            if (yych <= '=') { gotoCase = 169; continue; };
            if (yych >= '?') { gotoCase = 145; continue; };
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 169; continue; };
            { gotoCase = 145; continue; };
case 184:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 169; continue; };
            { gotoCase = 145; continue; };
case 185:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 169; continue; };
            { gotoCase = 145; continue; };
case 186:
            yyaccept = 2;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '9') {
                if (yych == '.') { gotoCase = 189; continue; };
                if (yych <= '/') { gotoCase = 161; continue; };
                { gotoCase = 186; continue; };
            } else {
                if (yych <= 'E') {
                    if (yych <= 'D') { gotoCase = 161; continue; };
                } else {
                    if (yych != 'e') { gotoCase = 161; continue; };
                }
            }
case 188:
            yych = this._charAt(++cursor);
            if (yych <= ',') {
                if (yych == '+') { gotoCase = 195; continue; };
                { gotoCase = 171; continue; };
            } else {
                if (yych <= '-') { gotoCase = 195; continue; };
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych <= '9') { gotoCase = 196; continue; };
                { gotoCase = 171; continue; };
            }
case 189:
            yyaccept = 2;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'D') {
                if (yych <= '/') { gotoCase = 161; continue; };
                if (yych <= '9') { gotoCase = 189; continue; };
                { gotoCase = 161; continue; };
            } else {
                if (yych <= 'E') { gotoCase = 191; continue; };
                if (yych != 'e') { gotoCase = 161; continue; };
            }
case 191:
            yych = this._charAt(++cursor);
            if (yych <= ',') {
                if (yych != '+') { gotoCase = 171; continue; };
            } else {
                if (yych <= '-') { gotoCase = 192; continue; };
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych <= '9') { gotoCase = 193; continue; };
                { gotoCase = 171; continue; };
            }
case 192:
            yych = this._charAt(++cursor);
            if (yych <= '/') { gotoCase = 171; continue; };
            if (yych >= ':') { gotoCase = 171; continue; };
case 193:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '/') { gotoCase = 161; continue; };
            if (yych <= '9') { gotoCase = 193; continue; };
            { gotoCase = 161; continue; };
case 195:
            yych = this._charAt(++cursor);
            if (yych <= '/') { gotoCase = 171; continue; };
            if (yych >= ':') { gotoCase = 171; continue; };
case 196:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '/') { gotoCase = 161; continue; };
            if (yych <= '9') { gotoCase = 196; continue; };
            { gotoCase = 161; continue; };
case 198:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '/') { gotoCase = 161; continue; };
            if (yych <= '7') { gotoCase = 198; continue; };
            { gotoCase = 161; continue; };
case 200:
            yych = this._charAt(++cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych >= ':') { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 201; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych >= 'g') { gotoCase = 171; continue; };
            }
case 201:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 161; continue; };
                if (yych <= '9') { gotoCase = 201; continue; };
                { gotoCase = 161; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 201; continue; };
                if (yych <= '`') { gotoCase = 161; continue; };
                if (yych <= 'f') { gotoCase = 201; continue; };
                { gotoCase = 161; continue; };
            }
case 203:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '.') {
                if (yych <= '\n') {
                    if (yych <= '\t') { gotoCase = 203; continue; };
                    { gotoCase = 171; continue; };
                } else {
                    if (yych == '\r') { gotoCase = 171; continue; };
                    { gotoCase = 203; continue; };
                }
            } else {
                if (yych <= '[') {
                    if (yych <= '/') { gotoCase = 226; continue; };
                    if (yych <= 'Z') { gotoCase = 203; continue; };
                    { gotoCase = 234; continue; };
                } else {
                    if (yych <= '\\') { gotoCase = 233; continue; };
                    if (yych <= ']') { gotoCase = 171; continue; };
                    { gotoCase = 203; continue; };
                }
            }
case 205:
            yych = this._charAt(++cursor);
            if (yych == '\n') { gotoCase = 171; continue; };
            if (yych == '\r') { gotoCase = 171; continue; };
            { gotoCase = 203; continue; };
case 206:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '*') {
                if (yych <= '\f') {
                    if (yych == '\n') { gotoCase = 171; continue; };
                    { gotoCase = 206; continue; };
                } else {
                    if (yych <= '\r') { gotoCase = 171; continue; };
                    if (yych <= ')') { gotoCase = 206; continue; };
                    { gotoCase = 171; continue; };
                }
            } else {
                if (yych <= '[') {
                    if (yych == '/') { gotoCase = 171; continue; };
                    { gotoCase = 206; continue; };
                } else {
                    if (yych <= '\\') { gotoCase = 221; continue; };
                    if (yych <= ']') { gotoCase = 219; continue; };
                    { gotoCase = 206; continue; };
                }
            }
case 208:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '\f') {
                if (yych == '\n') { gotoCase = 215; continue; };
                { gotoCase = 208; continue; };
            } else {
                if (yych <= '\r') { gotoCase = 215; continue; };
                if (yych == '*') { gotoCase = 213; continue; };
                { gotoCase = 208; continue; };
            }
case 210:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '\n') { gotoCase = 212; continue; };
            if (yych != '\r') { gotoCase = 210; continue; };
case 212:
            { this.tokenType = "javascript-comment"; return cursor; }
case 213:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '*') { gotoCase = 213; continue; };
            if (yych == '/') { gotoCase = 217; continue; };
            { gotoCase = 208; continue; };
case 215:
            ++cursor;
            this.setLexCondition(this._lexConditions.COMMENT);
            { this.tokenType = "javascript-comment"; return cursor; }
case 217:
            ++cursor;
            { this.tokenType = "javascript-comment"; return cursor; }
case 219:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '*') {
                if (yych <= '\f') {
                    if (yych == '\n') { gotoCase = 171; continue; };
                    { gotoCase = 219; continue; };
                } else {
                    if (yych <= '\r') { gotoCase = 171; continue; };
                    if (yych <= ')') { gotoCase = 219; continue; };
                    { gotoCase = 203; continue; };
                }
            } else {
                if (yych <= 'Z') {
                    if (yych == '/') { gotoCase = 226; continue; };
                    { gotoCase = 219; continue; };
                } else {
                    if (yych <= '[') { gotoCase = 224; continue; };
                    if (yych <= '\\') { gotoCase = 222; continue; };
                    { gotoCase = 219; continue; };
                }
            }
case 221:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '\n') { gotoCase = 171; continue; };
            if (yych == '\r') { gotoCase = 171; continue; };
            { gotoCase = 206; continue; };
case 222:
            yyaccept = 3;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych == '\n') { gotoCase = 223; continue; };
            if (yych != '\r') { gotoCase = 219; continue; };
case 223:
            this.setLexCondition(this._lexConditions.REGEX);
            { this.tokenType = "javascript-regexp"; return cursor; }
case 224:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '*') {
                if (yych <= '\f') {
                    if (yych == '\n') { gotoCase = 171; continue; };
                    { gotoCase = 224; continue; };
                } else {
                    if (yych <= '\r') { gotoCase = 171; continue; };
                    if (yych <= ')') { gotoCase = 224; continue; };
                    { gotoCase = 171; continue; };
                }
            } else {
                if (yych <= '[') {
                    if (yych == '/') { gotoCase = 171; continue; };
                    { gotoCase = 224; continue; };
                } else {
                    if (yych <= '\\') { gotoCase = 231; continue; };
                    if (yych <= ']') { gotoCase = 229; continue; };
                    { gotoCase = 224; continue; };
                }
            }
case 226:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'h') {
                if (yych == 'g') { gotoCase = 226; continue; };
            } else {
                if (yych <= 'i') { gotoCase = 226; continue; };
                if (yych == 'm') { gotoCase = 226; continue; };
            }
            { this.tokenType = "javascript-regexp"; return cursor; }
case 229:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '*') {
                if (yych <= '\f') {
                    if (yych == '\n') { gotoCase = 171; continue; };
                    { gotoCase = 229; continue; };
                } else {
                    if (yych <= '\r') { gotoCase = 171; continue; };
                    if (yych <= ')') { gotoCase = 229; continue; };
                    { gotoCase = 203; continue; };
                }
            } else {
                if (yych <= 'Z') {
                    if (yych == '/') { gotoCase = 226; continue; };
                    { gotoCase = 229; continue; };
                } else {
                    if (yych <= '[') { gotoCase = 224; continue; };
                    if (yych <= '\\') { gotoCase = 232; continue; };
                    { gotoCase = 229; continue; };
                }
            }
case 231:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '\n') { gotoCase = 171; continue; };
            if (yych == '\r') { gotoCase = 171; continue; };
            { gotoCase = 224; continue; };
case 232:
            yyaccept = 3;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych == '\n') { gotoCase = 223; continue; };
            if (yych == '\r') { gotoCase = 223; continue; };
            { gotoCase = 229; continue; };
case 233:
            yyaccept = 3;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych == '\n') { gotoCase = 223; continue; };
            if (yych == '\r') { gotoCase = 223; continue; };
            { gotoCase = 203; continue; };
case 234:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '*') {
                if (yych <= '\f') {
                    if (yych == '\n') { gotoCase = 171; continue; };
                    { gotoCase = 234; continue; };
                } else {
                    if (yych <= '\r') { gotoCase = 171; continue; };
                    if (yych <= ')') { gotoCase = 234; continue; };
                    { gotoCase = 171; continue; };
                }
            } else {
                if (yych <= '[') {
                    if (yych == '/') { gotoCase = 171; continue; };
                    { gotoCase = 234; continue; };
                } else {
                    if (yych <= '\\') { gotoCase = 238; continue; };
                    if (yych >= '^') { gotoCase = 234; continue; };
                }
            }
case 236:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '*') {
                if (yych <= '\f') {
                    if (yych == '\n') { gotoCase = 171; continue; };
                    { gotoCase = 236; continue; };
                } else {
                    if (yych <= '\r') { gotoCase = 171; continue; };
                    if (yych <= ')') { gotoCase = 236; continue; };
                    { gotoCase = 203; continue; };
                }
            } else {
                if (yych <= 'Z') {
                    if (yych == '/') { gotoCase = 226; continue; };
                    { gotoCase = 236; continue; };
                } else {
                    if (yych <= '[') { gotoCase = 234; continue; };
                    if (yych <= '\\') { gotoCase = 239; continue; };
                    { gotoCase = 236; continue; };
                }
            }
case 238:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '\n') { gotoCase = 171; continue; };
            if (yych == '\r') { gotoCase = 171; continue; };
            { gotoCase = 234; continue; };
case 239:
            yyaccept = 3;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych == '\n') { gotoCase = 223; continue; };
            if (yych == '\r') { gotoCase = 223; continue; };
            { gotoCase = 236; continue; };
case 240:
            yyaccept = 2;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'D') {
                if (yych <= '/') { gotoCase = 161; continue; };
                if (yych <= '9') { gotoCase = 240; continue; };
                { gotoCase = 161; continue; };
            } else {
                if (yych <= 'E') { gotoCase = 242; continue; };
                if (yych != 'e') { gotoCase = 161; continue; };
            }
case 242:
            yych = this._charAt(++cursor);
            if (yych <= ',') {
                if (yych != '+') { gotoCase = 171; continue; };
            } else {
                if (yych <= '-') { gotoCase = 243; continue; };
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych <= '9') { gotoCase = 244; continue; };
                { gotoCase = 171; continue; };
            }
case 243:
            yych = this._charAt(++cursor);
            if (yych <= '/') { gotoCase = 171; continue; };
            if (yych >= ':') { gotoCase = 171; continue; };
case 244:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '/') { gotoCase = 161; continue; };
            if (yych <= '9') { gotoCase = 244; continue; };
            { gotoCase = 161; continue; };
case 246:
            ++cursor;
            yych = this._charAt(cursor);
case 247:
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 171; continue; };
                if (yych <= '\f') { gotoCase = 246; continue; };
                { gotoCase = 171; continue; };
            } else {
                if (yych <= '\'') {
                    if (yych <= '&') { gotoCase = 246; continue; };
                    { gotoCase = 249; continue; };
                } else {
                    if (yych != '\\') { gotoCase = 246; continue; };
                }
            }
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'a') {
                if (yych <= '!') {
                    if (yych <= '\n') {
                        if (yych <= '\t') { gotoCase = 171; continue; };
                        { gotoCase = 252; continue; };
                    } else {
                        if (yych == '\r') { gotoCase = 252; continue; };
                        { gotoCase = 171; continue; };
                    }
                } else {
                    if (yych <= '\'') {
                        if (yych <= '"') { gotoCase = 246; continue; };
                        if (yych <= '&') { gotoCase = 171; continue; };
                        { gotoCase = 246; continue; };
                    } else {
                        if (yych == '\\') { gotoCase = 246; continue; };
                        { gotoCase = 171; continue; };
                    }
                }
            } else {
                if (yych <= 'q') {
                    if (yych <= 'f') {
                        if (yych <= 'b') { gotoCase = 246; continue; };
                        if (yych <= 'e') { gotoCase = 171; continue; };
                        { gotoCase = 246; continue; };
                    } else {
                        if (yych == 'n') { gotoCase = 246; continue; };
                        { gotoCase = 171; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych == 's') { gotoCase = 171; continue; };
                        { gotoCase = 246; continue; };
                    } else {
                        if (yych <= 'u') { gotoCase = 251; continue; };
                        if (yych <= 'v') { gotoCase = 246; continue; };
                        { gotoCase = 171; continue; };
                    }
                }
            }
case 249:
            ++cursor;
            { this.tokenType = "javascript-string"; return cursor; }
case 251:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych <= '9') { gotoCase = 254; continue; };
                { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 254; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych <= 'f') { gotoCase = 254; continue; };
                { gotoCase = 171; continue; };
            }
case 252:
            ++cursor;
            this.setLexCondition(this._lexConditions.SSTRING);
            { this.tokenType = "javascript-string"; return cursor; }
case 254:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych >= ':') { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 255; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych >= 'g') { gotoCase = 171; continue; };
            }
case 255:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych >= ':') { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 256; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych >= 'g') { gotoCase = 171; continue; };
            }
case 256:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych <= '9') { gotoCase = 246; continue; };
                { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 246; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych <= 'f') { gotoCase = 246; continue; };
                { gotoCase = 171; continue; };
            }
case 257:
            ++cursor;
            yych = this._charAt(cursor);
case 258:
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 171; continue; };
                if (yych <= '\f') { gotoCase = 257; continue; };
                { gotoCase = 171; continue; };
            } else {
                if (yych <= '"') {
                    if (yych <= '!') { gotoCase = 257; continue; };
                    { gotoCase = 249; continue; };
                } else {
                    if (yych != '\\') { gotoCase = 257; continue; };
                }
            }
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'a') {
                if (yych <= '!') {
                    if (yych <= '\n') {
                        if (yych <= '\t') { gotoCase = 171; continue; };
                        { gotoCase = 261; continue; };
                    } else {
                        if (yych == '\r') { gotoCase = 261; continue; };
                        { gotoCase = 171; continue; };
                    }
                } else {
                    if (yych <= '\'') {
                        if (yych <= '"') { gotoCase = 257; continue; };
                        if (yych <= '&') { gotoCase = 171; continue; };
                        { gotoCase = 257; continue; };
                    } else {
                        if (yych == '\\') { gotoCase = 257; continue; };
                        { gotoCase = 171; continue; };
                    }
                }
            } else {
                if (yych <= 'q') {
                    if (yych <= 'f') {
                        if (yych <= 'b') { gotoCase = 257; continue; };
                        if (yych <= 'e') { gotoCase = 171; continue; };
                        { gotoCase = 257; continue; };
                    } else {
                        if (yych == 'n') { gotoCase = 257; continue; };
                        { gotoCase = 171; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych == 's') { gotoCase = 171; continue; };
                        { gotoCase = 257; continue; };
                    } else {
                        if (yych <= 'u') { gotoCase = 260; continue; };
                        if (yych <= 'v') { gotoCase = 257; continue; };
                        { gotoCase = 171; continue; };
                    }
                }
            }
case 260:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych <= '9') { gotoCase = 263; continue; };
                { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 263; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych <= 'f') { gotoCase = 263; continue; };
                { gotoCase = 171; continue; };
            }
case 261:
            ++cursor;
            this.setLexCondition(this._lexConditions.DSTRING);
            { this.tokenType = "javascript-string"; return cursor; }
case 263:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych >= ':') { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 264; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych >= 'g') { gotoCase = 171; continue; };
            }
case 264:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych >= ':') { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 265; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych >= 'g') { gotoCase = 171; continue; };
            }
case 265:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 171; continue; };
                if (yych <= '9') { gotoCase = 257; continue; };
                { gotoCase = 171; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 257; continue; };
                if (yych <= '`') { gotoCase = 171; continue; };
                if (yych <= 'f') { gotoCase = 257; continue; };
                { gotoCase = 171; continue; };
            }
case 266:
            yych = this._charAt(++cursor);
            if (yych == '=') { gotoCase = 169; continue; };
            { gotoCase = 145; continue; };
case 267:
            ++cursor;
            yych = this._charAt(cursor);
case 268:
            if (yych == ' ') { gotoCase = 267; continue; };
            { gotoCase = 143; continue; };
/* *********************************** */
case this.case_REGEX:
            yych = this._charAt(cursor);
            if (yych <= '.') {
                if (yych <= '\n') {
                    if (yych <= '\t') { gotoCase = 272; continue; };
                    { gotoCase = 273; continue; };
                } else {
                    if (yych == '\r') { gotoCase = 273; continue; };
                    { gotoCase = 272; continue; };
                }
            } else {
                if (yych <= '[') {
                    if (yych <= '/') { gotoCase = 275; continue; };
                    if (yych <= 'Z') { gotoCase = 272; continue; };
                    { gotoCase = 277; continue; };
                } else {
                    if (yych <= '\\') { gotoCase = 278; continue; };
                    if (yych <= ']') { gotoCase = 273; continue; };
                    { gotoCase = 272; continue; };
                }
            }
case 271:
            { this.tokenType = "javascript-regexp"; return cursor; }
case 272:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            { gotoCase = 280; continue; };
case 273:
            ++cursor;
case 274:
            { this.tokenType = null; return cursor; }
case 275:
            ++cursor;
            yych = this._charAt(cursor);
            { gotoCase = 286; continue; };
case 276:
            this.setLexCondition(this._lexConditions.NODIV);
            { this.tokenType = "javascript-regexp"; return cursor; }
case 277:
            yyaccept = 1;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 274; continue; };
                if (yych <= '\f') { gotoCase = 284; continue; };
                { gotoCase = 274; continue; };
            } else {
                if (yych <= '*') {
                    if (yych <= ')') { gotoCase = 284; continue; };
                    { gotoCase = 274; continue; };
                } else {
                    if (yych == '/') { gotoCase = 274; continue; };
                    { gotoCase = 284; continue; };
                }
            }
case 278:
            yych = this._charAt(++cursor);
            if (yych == '\n') { gotoCase = 274; continue; };
            if (yych == '\r') { gotoCase = 274; continue; };
case 279:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
case 280:
            if (yych <= '.') {
                if (yych <= '\n') {
                    if (yych <= '\t') { gotoCase = 279; continue; };
                    { gotoCase = 271; continue; };
                } else {
                    if (yych == '\r') { gotoCase = 271; continue; };
                    { gotoCase = 279; continue; };
                }
            } else {
                if (yych <= '[') {
                    if (yych <= '/') { gotoCase = 285; continue; };
                    if (yych <= 'Z') { gotoCase = 279; continue; };
                    { gotoCase = 283; continue; };
                } else {
                    if (yych <= '\\') { gotoCase = 281; continue; };
                    if (yych <= ']') { gotoCase = 271; continue; };
                    { gotoCase = 279; continue; };
                }
            }
case 281:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '\n') { gotoCase = 282; continue; };
            if (yych != '\r') { gotoCase = 279; continue; };
case 282:
            cursor = YYMARKER;
            if (yyaccept <= 0) {
                { gotoCase = 271; continue; };
            } else {
                { gotoCase = 274; continue; };
            }
case 283:
            ++cursor;
            yych = this._charAt(cursor);
case 284:
            if (yych <= '*') {
                if (yych <= '\f') {
                    if (yych == '\n') { gotoCase = 282; continue; };
                    { gotoCase = 283; continue; };
                } else {
                    if (yych <= '\r') { gotoCase = 282; continue; };
                    if (yych <= ')') { gotoCase = 283; continue; };
                    { gotoCase = 282; continue; };
                }
            } else {
                if (yych <= '[') {
                    if (yych == '/') { gotoCase = 282; continue; };
                    { gotoCase = 283; continue; };
                } else {
                    if (yych <= '\\') { gotoCase = 289; continue; };
                    if (yych <= ']') { gotoCase = 287; continue; };
                    { gotoCase = 283; continue; };
                }
            }
case 285:
            ++cursor;
            yych = this._charAt(cursor);
case 286:
            if (yych <= 'h') {
                if (yych == 'g') { gotoCase = 285; continue; };
                { gotoCase = 276; continue; };
            } else {
                if (yych <= 'i') { gotoCase = 285; continue; };
                if (yych == 'm') { gotoCase = 285; continue; };
                { gotoCase = 276; continue; };
            }
case 287:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '*') {
                if (yych <= '\f') {
                    if (yych == '\n') { gotoCase = 271; continue; };
                    { gotoCase = 287; continue; };
                } else {
                    if (yych <= '\r') { gotoCase = 271; continue; };
                    if (yych <= ')') { gotoCase = 287; continue; };
                    { gotoCase = 279; continue; };
                }
            } else {
                if (yych <= 'Z') {
                    if (yych == '/') { gotoCase = 285; continue; };
                    { gotoCase = 287; continue; };
                } else {
                    if (yych <= '[') { gotoCase = 283; continue; };
                    if (yych <= '\\') { gotoCase = 290; continue; };
                    { gotoCase = 287; continue; };
                }
            }
case 289:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '\n') { gotoCase = 282; continue; };
            if (yych == '\r') { gotoCase = 282; continue; };
            { gotoCase = 283; continue; };
case 290:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych == '\n') { gotoCase = 282; continue; };
            if (yych == '\r') { gotoCase = 282; continue; };
            { gotoCase = 287; continue; };
/* *********************************** */
case this.case_SSTRING:
            yych = this._charAt(cursor);
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 295; continue; };
                if (yych <= '\f') { gotoCase = 294; continue; };
                { gotoCase = 295; continue; };
            } else {
                if (yych <= '\'') {
                    if (yych <= '&') { gotoCase = 294; continue; };
                    { gotoCase = 297; continue; };
                } else {
                    if (yych == '\\') { gotoCase = 299; continue; };
                    { gotoCase = 294; continue; };
                }
            }
case 293:
            { this.tokenType = "javascript-string"; return cursor; }
case 294:
            yyaccept = 0;
            yych = this._charAt(YYMARKER = ++cursor);
            { gotoCase = 301; continue; };
case 295:
            ++cursor;
case 296:
            { this.tokenType = null; return cursor; }
case 297:
            ++cursor;
case 298:
            this.setLexCondition(this._lexConditions.NODIV);
            { this.tokenType = "javascript-string"; return cursor; }
case 299:
            yyaccept = 1;
            yych = this._charAt(YYMARKER = ++cursor);
            if (yych <= 'e') {
                if (yych <= '\'') {
                    if (yych == '"') { gotoCase = 300; continue; };
                    if (yych <= '&') { gotoCase = 296; continue; };
                } else {
                    if (yych <= '\\') {
                        if (yych <= '[') { gotoCase = 296; continue; };
                    } else {
                        if (yych != 'b') { gotoCase = 296; continue; };
                    }
                }
            } else {
                if (yych <= 'r') {
                    if (yych <= 'm') {
                        if (yych >= 'g') { gotoCase = 296; continue; };
                    } else {
                        if (yych <= 'n') { gotoCase = 300; continue; };
                        if (yych <= 'q') { gotoCase = 296; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych <= 's') { gotoCase = 296; continue; };
                    } else {
                        if (yych <= 'u') { gotoCase = 302; continue; };
                        if (yych >= 'w') { gotoCase = 296; continue; };
                    }
                }
            }
case 300:
            yyaccept = 0;
            YYMARKER = ++cursor;
            yych = this._charAt(cursor);
case 301:
            if (yych <= '\r') {
                if (yych == '\n') { gotoCase = 293; continue; };
                if (yych <= '\f') { gotoCase = 300; continue; };
                { gotoCase = 293; continue; };
            } else {
                if (yych <= '\'') {
                    if (yych <= '&') { gotoCase = 300; continue; };
                    { gotoCase = 308; continue; };
                } else {
                    if (yych == '\\') { gotoCase = 307; continue; };
                    { gotoCase = 300; continue; };
                }
            }
case 302:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 303; continue; };
                if (yych <= '9') { gotoCase = 304; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 304; continue; };
                if (yych <= '`') { gotoCase = 303; continue; };
                if (yych <= 'f') { gotoCase = 304; continue; };
            }
case 303:
            cursor = YYMARKER;
            if (yyaccept <= 0) {
                { gotoCase = 293; continue; };
            } else {
                { gotoCase = 296; continue; };
            }
case 304:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 303; continue; };
                if (yych >= ':') { gotoCase = 303; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 305; continue; };
                if (yych <= '`') { gotoCase = 303; continue; };
                if (yych >= 'g') { gotoCase = 303; continue; };
            }
case 305:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 303; continue; };
                if (yych >= ':') { gotoCase = 303; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 306; continue; };
                if (yych <= '`') { gotoCase = 303; continue; };
                if (yych >= 'g') { gotoCase = 303; continue; };
            }
case 306:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= '@') {
                if (yych <= '/') { gotoCase = 303; continue; };
                if (yych <= '9') { gotoCase = 300; continue; };
                { gotoCase = 303; continue; };
            } else {
                if (yych <= 'F') { gotoCase = 300; continue; };
                if (yych <= '`') { gotoCase = 303; continue; };
                if (yych <= 'f') { gotoCase = 300; continue; };
                { gotoCase = 303; continue; };
            }
case 307:
            ++cursor;
            yych = this._charAt(cursor);
            if (yych <= 'e') {
                if (yych <= '\'') {
                    if (yych == '"') { gotoCase = 300; continue; };
                    if (yych <= '&') { gotoCase = 303; continue; };
                    { gotoCase = 300; continue; };
                } else {
                    if (yych <= '\\') {
                        if (yych <= '[') { gotoCase = 303; continue; };
                        { gotoCase = 300; continue; };
                    } else {
                        if (yych == 'b') { gotoCase = 300; continue; };
                        { gotoCase = 303; continue; };
                    }
                }
            } else {
                if (yych <= 'r') {
                    if (yych <= 'm') {
                        if (yych <= 'f') { gotoCase = 300; continue; };
                        { gotoCase = 303; continue; };
                    } else {
                        if (yych <= 'n') { gotoCase = 300; continue; };
                        if (yych <= 'q') { gotoCase = 303; continue; };
                        { gotoCase = 300; continue; };
                    }
                } else {
                    if (yych <= 't') {
                        if (yych <= 's') { gotoCase = 303; continue; };
                        { gotoCase = 300; continue; };
                    } else {
                        if (yych <= 'u') { gotoCase = 302; continue; };
                        if (yych <= 'v') { gotoCase = 300; continue; };
                        { gotoCase = 303; continue; };
                    }
                }
            }
case 308:
            ++cursor;
            yych = this._charAt(cursor);
            { gotoCase = 298; continue; };
        }

        }
    },

    __proto__: WebInspector.SourceTokenizer.prototype
}
