/****************************************
*  Computer Algebra System SINGULAR     *
****************************************/

// syntax table for Singular
//
// - search for an exact match of the argument types
// - otherwise search for the first possibility
//   with converted types of the arguments
// - otherwise report an error
//
// operation: ++ (identifier)  ->  nothing
// operation: -- (identifier)  ->  nothing
// operation: - (int)  ->  int
// operation: - (bigint)  ->  bigint
// operation: - (number)  ->  number
// operation: - (poly)  ->  poly
// operation: - (vector)  ->  vector
// operation: - (matrix)  ->  matrix
// operation: - (intvec)  ->  intvec
// operation: - (intmat)  ->  intmat
// operation: - (bigintmat)  ->  bigintmat
// operation: ( (proc)  ->  any_type
// operation: attrib (def)  ->  nothing
// operation: bareiss (module)  ->  list
// operation: betti (list)  ->  intmat
// operation: betti (resolution)  ->  intmat
// operation: betti (ideal)  ->  intmat
// operation: betti (module)  ->  intmat
// operation: bigint (bigint)  ->  bigint
// operation: bigint (number)  ->  bigint
// operation: bigint (poly)  ->  bigint
// operation: bigintmat (bigintmat)  ->  bigintmat
// operation: char (ring)  ->  int
// operation: char_series (ideal)  ->  matrix
// operation: charstr (ring)  ->  string
// operation: close (link)  ->  nothing
// operation: ncols (matrix)  ->  int
// operation: ncols (ideal)  ->  int
// operation: ncols (module)  ->  int
// operation: ncols (intmat)  ->  int
// operation: ncols (bigintmat)  ->  int
// DUMMY // operation: ncols (intvec)  ->  $INVALID$
// operation: cleardenom (poly)  ->  poly
// operation: cleardenom (vector)  ->  vector
// operation: size (bigint)  ->  int
// operation: size (number)  ->  int
// operation: size (resolution)  ->  int
// operation: size (string)  ->  int
// operation: size (poly)  ->  int
// operation: size (vector)  ->  int
// operation: size (ideal)  ->  int
// operation: size (module)  ->  int
// operation: size (matrix)  ->  int
// operation: size (intvec)  ->  int
// operation: size (intmat)  ->  int
// operation: size (list)  ->  int
// operation: size (ring)  ->  int
// operation: def (int)  ->  def
// DUMMY // operation: def (any_type)  ->  $INVALID$
// operation: deg (poly)  ->  int
// operation: deg (vector)  ->  int
// operation: deg (matrix)  ->  int
// operation: degree (ideal)  ->  string
// operation: degree (module)  ->  string
// operation: defined (def)  ->  int
// operation: denominator (number)  ->  number
// operation: numerator (number)  ->  number
// operation: det (bigintmat)  ->  bigint
// operation: det (intmat)  ->  int
// operation: det (matrix)  ->  poly
// operation: det (module)  ->  poly
// operation: dim (ideal)  ->  int
// operation: dim (module)  ->  int
// operation: dim (resolution)  ->  int
// operation: dump (link)  ->  nothing
// operation: gen (int)  ->  vector
// WARNING: gen requires currRing
// operation: execute (string)  ->  nothing
// operation: ERROR (string)  ->  nothing
// operation: factorize (poly)  ->  list
// operation: finduni (ideal)  ->  ideal
// operation: freemodule (int)  ->  module
// WARNING: freemodule requires currRing
// operation: facstd (ideal)  ->  list
// operation: getdump (link)  ->  nothing
// operation: highcorner (ideal)  ->  poly
// operation: highcorner (module)  ->  vector
// operation: hilb (ideal)  ->  nothing
// operation: hilb (module)  ->  nothing
// operation: hilb (intvec)  ->  intvec
// operation: homog (ideal)  ->  int
// operation: homog (module)  ->  int
// operation: ideal (ideal)  ->  ideal
// operation: ideal (vector)  ->  ideal
// operation: ideal (matrix)  ->  ideal
// operation: ideal (ring)  ->  ideal
// WARNING: ideal requires currRing
// operation: ideal (map)  ->  ideal
// operation: impart (number)  ->  number
// operation: indepSet (ideal)  ->  intvec
// operation: int (int)  ->  int
// operation: int (bigint)  ->  int
// operation: int (number)  ->  int
// operation: int (poly)  ->  int
// operation: interred (ideal)  ->  ideal
// operation: interred (module)  ->  module
// operation: intmat (intmat)  ->  intmat
// operation: intvec (intmat)  ->  intvec
// operation: intvec (intvec)  ->  intvec
// operation: rvar (poly)  ->  int
// operation: rvar (string)  ->  int
// operation: rvar (any_type)  ->  int
// operation: jacob (poly)  ->  ideal
// operation: jacob (ideal)  ->  matrix
// operation: jacob (module)  ->  module
// operation: janet (ideal)  ->  ideal
// operation: kbase (ideal)  ->  ideal
// operation: kbase (module)  ->  module
// operation: ludecomp (matrix)  ->  list
// operation: primefactors (bigint)  ->  list
// operation: primefactors (number)  ->  list
// operation: killattrib (identifier)  ->  nothing
// operation: lead (poly)  ->  poly
// operation: lead (ideal)  ->  ideal
// operation: lead (vector)  ->  vector
// operation: lead (module)  ->  module
// operation: leadcoef (poly)  ->  number
// operation: leadcoef (vector)  ->  number
// operation: leadexp (poly)  ->  intvec
// operation: leadexp (vector)  ->  intvec
// operation: leadmonom (poly)  ->  poly
// operation: leadmonom (vector)  ->  vector
// operation: link (link)  ->  link
// operation: list (def)  ->  list
// DUMMY // operation: map (any_type)  ->  $INVALID$
// operation: matrix (matrix)  ->  matrix
// operation: maxideal (int)  ->  ideal
// WARNING: maxideal requires currRing
// operation: memory (int)  ->  bigint
// operation: minbase (ideal)  ->  ideal
// operation: minbase (module)  ->  module
// operation: minres (list)  ->  list
// operation: minres (resolution)  ->  resolution
// operation: module (module)  ->  module
// operation: monitor (link)  ->  nothing
// operation: monomial (intvec)  ->  poly
// WARNING: monomial requires currRing
// operation: mult (ideal)  ->  int
// operation: mult (module)  ->  int
// operation: mstd (ideal)  ->  list
// operation: mstd (module)  ->  list
// operation: nameof (any_type)  ->  string
// operation: names (int)  ->  list
// operation: names (package)  ->  list
// operation: names (ring)  ->  list
// operation: not (int)  ->  int
// operation: number (number)  ->  number
// operation: number (poly)  ->  number
// operation: number (bigint)  ->  number
// WARNING: number requires currRing
// operation: npars (ring)  ->  int
// operation: nvars (ring)  ->  int
// operation: open (link)  ->  nothing
// operation: option (def)  ->  nothing
// operation: ord (poly)  ->  int
// operation: ord (vector)  ->  int
// operation: ordstr (ring)  ->  string
// operation: par (int)  ->  number
// WARNING: par requires currRing
// operation: pardeg (number)  ->  int
// operation: parstr (int)  ->  string
// operation: parstr (ring)  ->  string
// operation: poly (poly)  ->  poly
// operation: poly (bigint)  ->  poly
// WARNING: poly requires currRing
// operation: preimage (map)  ->  ring
// operation: prime (int)  ->  int
// operation: print (list)  ->  string
// operation: print (def)  ->  string
// operation: proc (proc)  ->  proc
// operation: prune (module)  ->  module
// operation: qhweight (ideal)  ->  intvec
// operation: qhweight (module)  ->  intvec
// operation: qring (ring)  ->  qring
// operation: rank (matrix)  ->  int
// operation: read (link)  ->  string
// operation: regularity (list)  ->  int
// operation: repart (number)  ->  number
// operation: reservedName (string)  ->  int
// operation: resolution (list)  ->  resolution
// WARNING: resolution requires currRing
// operation: resolution (resolution)  ->  resolution
// operation: ringlist (ring)  ->  list
// operation: ring (ring)  ->  ring
// operation: ring (list)  ->  ring
// operation: nrows (vector)  ->  int
// operation: nrows (module)  ->  int
// operation: nrows (matrix)  ->  int
// operation: nrows (intmat)  ->  int
// operation: nrows (bigintmat)  ->  int
// operation: nrows (intvec)  ->  int
// operation: sba (ideal)  ->  ideal
// operation: sba (module)  ->  module
// operation: slimgb (ideal)  ->  ideal
// operation: slimgb (module)  ->  module
// operation: sortvec (ideal)  ->  intvec
// operation: sortvec (module)  ->  intvec
// operation: sqrfree (poly)  ->  list
// operation: std (ideal)  ->  ideal
// operation: std (module)  ->  module
// operation: string (string)  ->  string
// operation: syz (ideal)  ->  module
// operation: syz (module)  ->  module
// operation: envelope (ring)  ->  ring
// operation: opposite (ring)  ->  ring
// operation: twostd (ideal)  ->  ideal
// DUMMY // operation: trace (intvec)  ->  $INVALID$
// DUMMY // operation: trace (ideal)  ->  $INVALID$
// operation: trace (intmat)  ->  int
// operation: trace (matrix)  ->  poly
// operation: transpose (intvec)  ->  intmat
// operation: transpose (intmat)  ->  intmat
// operation: transpose (bigintmat)  ->  bigintmat
// operation: transpose (matrix)  ->  matrix
// operation: transpose (module)  ->  module
// operation: typeof (any_type)  ->  string
// operation: univariate (poly)  ->  int
// operation: variables (poly)  ->  ideal
// operation: variables (ideal)  ->  ideal
// operation: variables (matrix)  ->  ideal
// operation: vector (vector)  ->  vector
// operation: vdim (ideal)  ->  int
// operation: vdim (module)  ->  int
// operation: var (int)  ->  poly
// WARNING: var requires currRing
// operation: varstr (int)  ->  string
// operation: varstr (ring)  ->  string
// operation: weight (ideal)  ->  intvec
// operation: weight (module)  ->  intvec
// operation: load (string)  ->  nothing
// operation: convhull (ideal)  ->  ideal
// operation: waitfirst (list)  ->  int
// operation: waitall (list)  ->  int
/*---------------------------------------------*/
// operation: :: (def, def)  ->  any_type
// operation: + (int, int)  ->  int
// operation: + (bigint, bigint)  ->  bigint
// operation: + (number, number)  ->  number
// operation: + (poly, poly)  ->  poly
// operation: + (vector, vector)  ->  vector
// operation: + (ideal, ideal)  ->  ideal
// operation: + (module, module)  ->  module
// operation: + (poly, matrix)  ->  matrix
// operation: + (matrix, poly)  ->  matrix
// operation: + (matrix, matrix)  ->  matrix
// operation: + (string, string)  ->  string
// operation: + (intvec, int)  ->  intvec
// operation: + (int, intvec)  ->  intvec
// operation: + (intmat, int)  ->  intmat
// operation: + (int, intmat)  ->  intmat
// operation: + (intvec, intvec)  ->  intvec
// operation: + (intmat, intmat)  ->  intmat
// operation: + (bigintmat, bigintmat)  ->  bigintmat
// operation: + (bigintmat, int)  ->  bigintmat
// operation: + (int, bigintmat)  ->  bigintmat
// operation: + (bigintmat, bigint)  ->  bigintmat
// operation: + (bigint, bigintmat)  ->  bigintmat
// operation: + (list, list)  ->  list
// operation: + (ring, ring)  ->  ring
// operation: - (int, int)  ->  int
// operation: - (bigint, bigint)  ->  bigint
// operation: - (number, number)  ->  number
// operation: - (poly, poly)  ->  poly
// operation: - (vector, vector)  ->  vector
// operation: - (matrix, poly)  ->  matrix
// operation: - (matrix, matrix)  ->  matrix
// operation: - (intvec, int)  ->  intvec
// operation: - (intmat, int)  ->  intmat
// operation: - (intvec, intvec)  ->  intvec
// operation: - (intmat, intmat)  ->  intmat
// operation: - (bigintmat, bigintmat)  ->  bigintmat
// operation: - (bigintmat, int)  ->  bigintmat
// operation: - (int, bigintmat)  ->  bigintmat
// operation: - (bigintmat, bigint)  ->  bigintmat
// operation: - (bigint, bigintmat)  ->  bigintmat
// DUMMY // operation: - (ideal, ideal)  ->  nothing
// DUMMY // operation: - (module, module)  ->  nothing
// operation: * (int, int)  ->  int
// operation: * (bigint, bigint)  ->  bigint
// operation: * (number, number)  ->  number
// operation: * (poly, poly)  ->  poly
// operation: * (poly, vector)  ->  vector
// operation: * (vector, poly)  ->  vector
// operation: * (ideal, poly)  ->  ideal
// operation: * (poly, ideal)  ->  ideal
// operation: * (module, poly)  ->  module
// operation: * (poly, module)  ->  module
// operation: * (ideal, ideal)  ->  ideal
// operation: * (ideal, vector)  ->  module
// operation: * (vector, ideal)  ->  module
// operation: * (ideal, module)  ->  module
// operation: * (module, ideal)  ->  module
// operation: * (matrix, poly)  ->  matrix
// operation: * (poly, matrix)  ->  matrix
// operation: * (matrix, number)  ->  matrix
// operation: * (number, matrix)  ->  matrix
// operation: * (matrix, int)  ->  matrix
// operation: * (int, matrix)  ->  matrix
// operation: * (matrix, matrix)  ->  matrix
// operation: * (matrix, bigint)  ->  matrix
// operation: * (bigint, matrix)  ->  matrix
// operation: * (intvec, int)  ->  intvec
// operation: * (int, intvec)  ->  intvec
// operation: * (intmat, int)  ->  intmat
// operation: * (int, intmat)  ->  intmat
// operation: * (intmat, intvec)  ->  intvec
// operation: * (intmat, intmat)  ->  intmat
// operation: * (intvec, intmat)  ->  intmat
// operation: * (bigintmat, bigintmat)  ->  bigintmat
// operation: * (bigintmat, int)  ->  bigintmat
// operation: * (int, bigintmat)  ->  bigintmat
// operation: * (bigintmat, bigint)  ->  bigintmat
// operation: * (bigint, bigintmat)  ->  bigintmat
// operation: / (number, number)  ->  number
// operation: / (poly, poly)  ->  poly
// operation: / (vector, poly)  ->  vector
// operation: / (matrix, poly)  ->  matrix
// operation: / (int, int)  ->  int
// operation: / (bigint, bigint)  ->  bigint
// operation: / (intvec, int)  ->  intvec
// operation: / (intmat, int)  ->  intmat
// operation: div (int, int)  ->  int
// operation: div (bigint, bigint)  ->  bigint
// operation: div (intvec, int)  ->  intvec
// operation: div (intmat, int)  ->  intmat
// operation: % (int, int)  ->  int
// operation: % (bigint, bigint)  ->  bigint
// operation: % (intvec, int)  ->  intvec
// operation: % (intmat, int)  ->  intmat
// operation: % (number, number)  ->  number
// operation: ^ (int, int)  ->  int
// operation: ^ (bigint, int)  ->  bigint
// operation: ^ (number, int)  ->  number
// operation: ^ (poly, int)  ->  poly
// operation: ^ (ideal, int)  ->  ideal
// operation: <= (int, int)  ->  int
// operation: <= (bigint, bigint)  ->  int
// operation: <= (number, number)  ->  int
// operation: <= (string, string)  ->  int
// operation: <= (intvec, int)  ->  int
// operation: <= (intvec, intvec)  ->  int
// operation: <= (poly, poly)  ->  int
// operation: <= (vector, vector)  ->  int
// operation: < (int, int)  ->  int
// operation: < (bigint, bigint)  ->  int
// operation: < (number, number)  ->  int
// operation: < (intvec, int)  ->  int
// operation: < (intvec, intvec)  ->  int
// operation: < (string, string)  ->  int
// operation: < (poly, poly)  ->  int
// operation: < (vector, vector)  ->  int
// operation: >= (int, int)  ->  int
// operation: >= (bigint, bigint)  ->  int
// operation: >= (number, number)  ->  int
// operation: >= (string, string)  ->  int
// operation: >= (intvec, int)  ->  int
// operation: >= (intvec, intvec)  ->  int
// operation: >= (poly, poly)  ->  int
// operation: >= (vector, vector)  ->  int
// operation: > (int, int)  ->  int
// operation: > (bigint, bigint)  ->  int
// operation: > (number, number)  ->  int
// operation: > (string, string)  ->  int
// operation: > (intvec, int)  ->  int
// operation: > (intvec, intvec)  ->  int
// operation: > (poly, poly)  ->  int
// operation: > (vector, vector)  ->  int
// operation: and (int, int)  ->  int
// operation: or (int, int)  ->  int
// operation: == (int, int)  ->  int
// operation: == (bigint, bigint)  ->  int
// operation: == (number, number)  ->  int
// operation: == (string, string)  ->  int
// operation: == (poly, poly)  ->  int
// operation: == (vector, vector)  ->  int
// operation: == (intvec, int)  ->  int
// operation: == (intvec, intvec)  ->  int
// operation: == (intmat, intmat)  ->  int
// operation: == (bigintmat, bigintmat)  ->  int
// operation: == (matrix, matrix)  ->  int
// DUMMY // operation: == (ideal, ideal)  ->  $INVALID$
// DUMMY // operation: == (module, module)  ->  $INVALID$
// DUMMY // operation: == (ideal, module)  ->  $INVALID$
// DUMMY // operation: == (module, ideal)  ->  $INVALID$
// operation: <> (int, int)  ->  int
// operation: <> (bigint, bigint)  ->  int
// operation: <> (number, number)  ->  int
// operation: <> (string, string)  ->  int
// operation: <> (poly, poly)  ->  int
// operation: <> (vector, vector)  ->  int
// operation: <> (intvec, intvec)  ->  int
// operation: <> (intmat, intmat)  ->  int
// operation: <> (matrix, matrix)  ->  int
// DUMMY // operation: <> (ideal, ideal)  ->  $INVALID$
// DUMMY // operation: <> (module, module)  ->  $INVALID$
// DUMMY // operation: <> (ideal, module)  ->  $INVALID$
// DUMMY // operation: <> (module, ideal)  ->  $INVALID$
// operation: .. (int, int)  ->  intvec
// operation: [ (intvec, int)  ->  int
// operation: [ (intvec, intvec)  ->  int
// operation: [ (ideal, int)  ->  poly
// operation: [ (map, int)  ->  poly
// operation: [ (ideal, intvec)  ->  poly
// operation: [ (module, int)  ->  vector
// operation: [ (module, intvec)  ->  vector
// operation: [ (string, int)  ->  string
// operation: [ (string, intvec)  ->  string
// operation: [ (list, int)  ->  any_type
// operation: [ (list, intvec)  ->  any_type
// operation: [ (poly, int)  ->  poly
// operation: [ (poly, intvec)  ->  poly
// operation: [ (vector, int)  ->  poly
// operation: [ (vector, intvec)  ->  vector
// operation: ( (proc, def)  ->  any_type
// operation: ( (map, def)  ->  any_type
// operation: ( (LIB, string)  ->  nothing
// operation: ( (any_type, int)  ->  any_type
// operation: ( (any_type, intvec)  ->  any_type
// operation: : (int, int)  ->  intvec
// operation: align (vector, int)  ->  vector
// operation: align (module, int)  ->  module
// operation: attrib (def, string)  ->  nothing
// operation: betti (list, int)  ->  intmat
// operation: betti (resolution, int)  ->  intmat
// operation: betti (ideal, int)  ->  intmat
// operation: betti (module, int)  ->  intmat
// operation: bracket (poly, poly)  ->  poly
// operation: chinrem (intvec, intvec)  ->  bigint
// operation: chinrem (list, intvec)  ->  any_type
// operation: chinrem (list, list)  ->  any_type
// operation: coef (poly, poly)  ->  matrix
// operation: coeffs (ideal, poly)  ->  matrix
// operation: coeffs (module, poly)  ->  matrix
// operation: coeffs (ideal, ideal)  ->  matrix
// operation: coeffs (module, module)  ->  matrix
// operation: contract (ideal, ideal)  ->  matrix
// operation: deg (poly, intvec)  ->  int
// operation: deg (vector, intvec)  ->  int
// operation: deg (matrix, intvec)  ->  int
// operation: delete (list, int)  ->  list
// operation: diff (poly, poly)  ->  poly
// operation: diff (vector, poly)  ->  vector
// operation: diff (ideal, poly)  ->  ideal
// operation: diff (ideal, ideal)  ->  matrix
// operation: diff (module, poly)  ->  module
// operation: diff (matrix, poly)  ->  matrix
// operation: diff (number, number)  ->  number
// operation: dim (ideal, ideal)  ->  int
// operation: dim (module, ideal)  ->  int
// operation: division (ideal, ideal)  ->  list
// operation: division (module, module)  ->  list
// operation: eliminate (ideal, poly)  ->  ideal
// operation: eliminate (module, poly)  ->  module
// operation: eliminate (ideal, intvec)  ->  ideal
// operation: eliminate (module, intvec)  ->  module
// operation: exportto (package, identifier)  ->  nothing
// operation: extgcd (int, int)  ->  list
// operation: extgcd (bigint, bigint)  ->  list
// operation: extgcd (poly, poly)  ->  list
// operation: factorize (poly, int)  ->  ideal
// operation: facstd (ideal, ideal)  ->  list
// operation: farey (bigint, bigint)  ->  number
// WARNING: farey requires currRing
// operation: farey (ideal, bigint)  ->  any_type
// operation: farey (module, bigint)  ->  any_type
// operation: farey (matrix, bigint)  ->  any_type
// operation: fetch (ring, any_type)  ->  any_type
// operation: fglm (ring, def)  ->  ideal
// WARNING: fglm requires currRing
// operation: fglmquot (ideal, poly)  ->  ideal
// operation: find (string, string)  ->  int
// operation: frwalk (ring, def)  ->  ideal
// WARNING: frwalk requires currRing
// operation: gcd (int, int)  ->  int
// operation: gcd (number, number)  ->  number
// operation: gcd (bigint, bigint)  ->  bigint
// operation: gcd (poly, poly)  ->  poly
// operation: hilb (ideal, int)  ->  intvec
// operation: hilb (module, int)  ->  intvec
// operation: homog (ideal, intvec)  ->  int
// operation: homog (module, intvec)  ->  int
// operation: homog (poly, poly)  ->  poly
// operation: homog (vector, poly)  ->  vector
// operation: homog (ideal, poly)  ->  ideal
// operation: homog (module, poly)  ->  module
// operation: hres (ideal, int)  ->  resolution
// operation: imap (ring, any_type)  ->  any_type
// operation: importfrom (package, any_type)  ->  nothing
// operation: indepSet (ideal, int)  ->  list
// operation: insert (list, def)  ->  list
// operation: interpolation (list, intvec)  ->  ideal
// WARNING: interpolation requires currRing
// operation: intersect (ideal, ideal)  ->  ideal
// operation: intersect (module, module)  ->  module
// operation: janet (ideal, int)  ->  ideal
// operation: jet (poly, int)  ->  poly
// operation: jet (ideal, int)  ->  ideal
// operation: jet (vector, int)  ->  vector
// operation: jet (module, int)  ->  module
// operation: jet (matrix, int)  ->  matrix
// operation: kbase (ideal, int)  ->  ideal
// operation: kbase (module, int)  ->  module
// operation: kernel (ring, any_type)  ->  ideal
// WARNING: kernel requires currRing
// operation: killattrib (identifier, string)  ->  nothing
// operation: koszul (int, int)  ->  matrix
// WARNING: koszul requires currRing
// operation: koszul (int, ideal)  ->  matrix
// operation: kres (ideal, int)  ->  resolution
// operation: lift (ideal, ideal)  ->  matrix
// operation: lift (module, module)  ->  matrix
// operation: liftstd (ideal, matrix)  ->  ideal
// operation: liftstd (module, matrix)  ->  module
// operation: load (string, string)  ->  nothing
// operation: lres (ideal, int)  ->  resolution
// operation: modulo (ideal, ideal)  ->  module
// operation: modulo (module, module)  ->  module
// operation: monitor (link, string)  ->  nothing
// operation: mpresmat (ideal, int)  ->  module
// operation: newstruct (string, string)  ->  nothing
// operation: mres (ideal, int)  ->  resolution
// operation: mres (module, int)  ->  resolution
// operation: primefactors (bigint, int)  ->  list
// operation: primefactors (number, int)  ->  list
// operation: ncalgebra (poly, poly)  ->  nothing
// operation: ncalgebra (poly, matrix)  ->  nothing
// operation: ncalgebra (matrix, poly)  ->  nothing
// operation: ncalgebra (matrix, matrix)  ->  nothing
// operation: nc_algebra (poly, poly)  ->  ring
// operation: nc_algebra (poly, matrix)  ->  ring
// operation: nc_algebra (matrix, poly)  ->  ring
// operation: nc_algebra (matrix, matrix)  ->  ring
// operation: oppose (ring, def)  ->  any_type
// operation: parstr (ring, int)  ->  string
// operation: print (def, string)  ->  string
// operation: quotient (ideal, ideal)  ->  ideal
// operation: quotient (module, ideal)  ->  module
// operation: quotient (module, module)  ->  ideal
// operation: random (int, int)  ->  int
// operation: rank (matrix, int)  ->  int
// operation: read (link, string)  ->  string
// operation: reduce (poly, ideal)  ->  poly
// operation: reduce (vector, ideal)  ->  vector
// operation: reduce (vector, module)  ->  vector
// operation: reduce (ideal, ideal)  ->  ideal
// operation: reduce (module, ideal)  ->  module
// operation: reduce (module, module)  ->  module
// operation: nres (ideal, int)  ->  resolution
// operation: nres (module, int)  ->  resolution
// operation: sqrfree (poly, int)  ->  ideal
// operation: status (link, string)  ->  string
// operation: status (list, int)  ->  int
// operation: simplify (poly, int)  ->  poly
// operation: simplify (vector, int)  ->  vector
// operation: simplify (ideal, int)  ->  ideal
// operation: simplify (module, int)  ->  module
// operation: sres (ideal, int)  ->  resolution
// operation: sres (module, int)  ->  resolution
// operation: sba (ideal, int)  ->  ideal
// operation: sba (module, int)  ->  module
// operation: std (ideal, poly)  ->  ideal
// operation: std (module, vector)  ->  module
// operation: std (ideal, ideal)  ->  ideal
// operation: std (module, module)  ->  module
// operation: std (ideal, intvec)  ->  ideal
// operation: std (module, intvec)  ->  module
// operation: varstr (ring, int)  ->  string
// operation: waitfirst (list, int)  ->  int
// operation: waitall (list, int)  ->  int
// operation: wedge (matrix, int)  ->  matrix
/*---------------------------------------------*/
// operation: [ (string, int, int)  ->  string
// operation: [ (intmat, int, int)  ->  int
// operation: [ (bigintmat, int, int)  ->  bigint
// operation: [ (intmat, int, intvec)  ->  int
// operation: [ (bigintmat, int, intvec)  ->  bigint
// operation: [ (intmat, intvec, int)  ->  int
// operation: [ (bigintmat, intvec, int)  ->  bigint
// operation: [ (intmat, intvec, intvec)  ->  int
// operation: [ (bigintmat, intvec, intvec)  ->  bigint
// operation: [ (matrix, int, int)  ->  poly
// operation: [ (matrix, int, intvec)  ->  poly
// operation: [ (matrix, intvec, int)  ->  poly
// operation: [ (matrix, intvec, intvec)  ->  poly
// operation: ( (proc, def, def)  ->  any_type
// operation: attrib (identifier, string, def)  ->  nothing
// operation: bareiss (module, int, int)  ->  list
// operation: coeffs (poly, poly, matrix)  ->  matrix
// operation: coeffs (vector, poly, matrix)  ->  matrix
// operation: coeffs (ideal, poly, matrix)  ->  matrix
// operation: coeffs (module, poly, matrix)  ->  matrix
// operation: coeffs (ideal, ideal, poly)  ->  matrix
// operation: coeffs (module, module, poly)  ->  matrix
// operation: eliminate (ideal, poly, intvec)  ->  ideal
// operation: eliminate (module, poly, intvec)  ->  module
// operation: find (string, string, int)  ->  int
// operation: frwalk (ring, def, int)  ->  ideal
// WARNING: frwalk requires currRing
// operation: hilb (ideal, int, intvec)  ->  intvec
// operation: hilb (module, int, intvec)  ->  intvec
// operation: homog (poly, poly, intvec)  ->  poly
// operation: homog (vector, poly, intvec)  ->  vector
// operation: homog (ideal, poly, intvec)  ->  ideal
// operation: homog (module, poly, intvec)  ->  module
// operation: insert (list, def, int)  ->  list
// operation: intmat (intmat, int, int)  ->  intmat
// operation: jet (poly, int, intvec)  ->  poly
// operation: jet (ideal, int, intvec)  ->  ideal
// operation: jet (vector, int, intvec)  ->  vector
// operation: jet (module, int, intvec)  ->  module
// operation: jet (poly, poly, int)  ->  poly
// operation: jet (vector, poly, int)  ->  vector
// operation: jet (ideal, matrix, int)  ->  ideal
// operation: jet (module, matrix, int)  ->  module
// DUMMY // operation: jet (poly, int, int)  ->  poly
// operation: koszul (int, int, ideal)  ->  matrix
// operation: lift (ideal, ideal, matrix)  ->  matrix
// operation: lift (module, module, matrix)  ->  matrix
// operation: liftstd (ideal, matrix, module)  ->  ideal
// operation: liftstd (module, matrix, module)  ->  module
// operation: matrix (ideal, int, int)  ->  matrix
// operation: matrix (module, int, int)  ->  matrix
// operation: matrix (matrix, int, int)  ->  matrix
// operation: newstruct (string, string, string)  ->  nothing
// operation: preimage (ring, any_type, any_type)  ->  ideal
// WARNING: preimage requires currRing
// operation: random (int, int, int)  ->  intmat
// operation: reduce (poly, ideal, int)  ->  poly
// operation: reduce (vector, ideal, int)  ->  vector
// operation: reduce (vector, module, int)  ->  vector
// operation: reduce (ideal, ideal, int)  ->  ideal
// operation: reduce (module, module, int)  ->  module
// operation: reduce (module, ideal, int)  ->  module
// operation: reduce (poly, poly, ideal)  ->  poly
// operation: reduce (vector, poly, module)  ->  vector
// operation: reduce (ideal, ideal, matrix)  ->  ideal
// operation: reduce (module, module, matrix)  ->  module
// operation: resultant (poly, poly, poly)  ->  poly
// operation: ring (def, def, def)  ->  ring
// operation: sba (ideal, int, int)  ->  ideal
// operation: sba (module, int, int)  ->  module
// operation: status (link, string, string)  ->  int
// operation: std (ideal, intvec, intvec)  ->  ideal
// operation: std (module, intvec, intvec)  ->  module
// operation: subst (poly, poly, poly)  ->  poly
// operation: subst (poly, poly, poly)  ->  poly
// operation: subst (vector, poly, poly)  ->  vector
// operation: subst (ideal, poly, poly)  ->  ideal
// operation: subst (module, poly, poly)  ->  module
// operation: subst (matrix, poly, poly)  ->  matrix
// operation: subst (matrix, poly, int)  ->  matrix
// operation: subst (matrix, poly, number)  ->  matrix
// operation: laguerre (poly, int, int)  ->  list
// operation: vandermonde (ideal, ideal, int)  ->  poly
/*---------------------------------------------*/
// operation: ( (...)  ->  any_type ( number of arguments >0 )
// operation: breakpoint (...)  ->  nothing ( 0 arguments )
// operation: breakpoint (...)  ->  nothing ( number of arguments >0 )
// operation: branchTo (...)  ->  nothing ( number of arguments >0 )
// operation: coef (...)  ->  matrix ( 2 arguments )
// operation: coef (...)  ->  nothing ( 4 arguments )
// operation: division (...)  ->  any_type ( 2 arguments )
// operation: division (...)  ->  any_type ( 3 arguments )
// operation: division (...)  ->  any_type ( 4 arguments )
// operation: dbprint (...)  ->  nothing ( number of arguments >0 )
// operation: fetch (...)  ->  any_type ( 2 arguments )
// operation: fetch (...)  ->  any_type ( 3 arguments )
// operation: fetch (...)  ->  any_type ( 4 arguments )
// operation: ideal (...)  ->  ideal ( 1 arguments )
// operation: ideal (...)  ->  ideal ( any number of arguments )
// operation: intersect (...)  ->  ideal ( 2 arguments )
// operation: intersect (...)  ->  ideal ( number of arguments >0 )
// operation: intvec (...)  ->  intvec ( 1 arguments )
// operation: intvec (...)  ->  intvec ( number of arguments >0 )
// operation: jet (...)  ->  poly ( 2 arguments )
// operation: jet (...)  ->  poly ( 3 arguments )
// operation: jet (...)  ->  poly ( 4 arguments )
// operation: LIB (...)  ->  nothing ( 1 arguments )
// operation: list (...)  ->  list ( any number of arguments )
// operation: luinverse (...)  ->  list ( number of arguments >0 )
// operation: lusolve (...)  ->  list ( number of arguments >0 )
// operation: minor (...)  ->  nothing ( 1 arguments )
// operation: minor (...)  ->  ideal ( number of arguments >0 )
// operation: module (...)  ->  module ( 1 arguments )
// operation: module (...)  ->  module ( any number of arguments )
// operation: names (...)  ->  list ( 1 arguments )
// operation: names (...)  ->  list ( 0 arguments )
// operation: option (...)  ->  string ( any number of arguments )
// operation: reduce (...)  ->  ideal ( 2 arguments )
// operation: reduce (...)  ->  ideal ( 3 arguments )
// operation: reduce (...)  ->  ideal ( 4 arguments )
// operation: reduce (...)  ->  ideal ( 5 arguments )
// operation: reservedName (...)  ->  int ( 1 arguments )
// operation: reservedName (...)  ->  nothing ( 0 arguments )
// operation: string (...)  ->  string ( any number of arguments )
// operation: subst (...)  ->  nothing ( 3 arguments )
// operation: subst (...)  ->  nothing ( number of arguments >0 )
// operation: system (...)  ->  nothing ( number of arguments >0 )
// operation: test (...)  ->  nothing ( number of arguments >0 )
// operation: write (...)  ->  nothing ( number of arguments >0 )
// operation: status (...)  ->  string ( 2 arguments )
// operation: status (...)  ->  int ( 3 arguments )
// operation: status (...)  ->  int ( 4 arguments )
// operation: simplex (...)  ->  list ( 6 arguments )
// operation: uressolve (...)  ->  list ( 4 arguments )
// operation: std (...)  ->  ideal ( 1 arguments )
// operation: std (...)  ->  ideal ( 2 arguments )
// operation: std (...)  ->  ideal ( 3 arguments )
// operation: std (...)  ->  ideal ( 4 arguments )
// operation: qrds (...)  ->  list ( 4 arguments )
// operation: factmodd (...)  ->  list ( number of arguments >0 )
/*---------------------------------------------*/
// assign: ideal =  ideal
// assign: ideal =  matrix
// assign: resolution =  resolution
// assign: int =  int
// assign: int =  intmat
// assign: matrix =  matrix
// assign: map =  ideal
// assign: map =  map
// assign: module =  module
// assign: module =  poly
// assign: poly =  poly
// assign: poly =  matrix
// assign: ring =  ring
// assign: qring =  ideal
// assign: qring =  qring
// assign: qring =  ring
// assign: string =  string
// assign: proc =  string
// assign: proc =  proc
// assign: vector =  vector
// assign: intvec =  intvec
// assign: intmat =  intmat
// assign: bigintmat =  bigintmat
// assign: number =  number
// assign: bigint =  bigint
// assign: list =  resolution
// assign: list =  list
// assign: link =  string
// assign: link =  link
// assign: package =  package
// assign: def =  def
/*---------------------------------------------*/
// convert intmat -> bigintmat
// convert bigintmat -> intmat
// convert intvec -> intmat
// convert qring -> ring
// convert poly -> ideal
// convert bigint -> ideal
// convert int -> ideal
// convert intmat -> matrix
// convert ideal -> matrix
// convert module -> matrix
// convert number -> matrix
// convert poly -> matrix
// convert vector -> matrix
// convert bigint -> matrix
// convert int -> matrix
// convert intvec -> matrix
// convert ideal -> module
// convert matrix -> module
// convert vector -> module
// convert bigint -> number
// convert int -> number
// convert number -> poly
// convert bigint -> poly
// convert int -> poly
// convert list -> resolution
// convert poly -> vector
// convert bigint -> vector
// convert int -> vector
// convert int -> bigint
// convert int -> intvec
// convert string -> link
// convert resolution -> list
/*---------------------------------------------*/
// token 61 : =
// token 62 : >
// token 60 : <
// token 43 : +
// token 42 : *
// token 47 : /
// token 91 : [
// token 46 : .
// token 94 : ^
// token 44 : ,
// token 37 : %
// token 40 : (
// token 59 : ;
// token 258 : ..
// token 259 : ==
// token 260 : >=
// token 261 : <=
// token 262 : --
// token 263 : not
// token 264 : <>
// token 265 : ++
// token 266 : ::
// token 269 : bigintmat
// token 270 : intmat
// token 271 : proc
// token 272 : ring
// token 274 : ideal
// token 275 : map
// token 276 : matrix
// token 277 : module
// token 278 : number
// token 279 : poly
// token 280 : resolution
// token 281 : vector
// token 282 : betti
// token 283 : coeffs
// token 284 : coef
// token 285 : contract
// token 286 : degree
// token 287 : deg
// token 288 : diff
// token 289 : dim
// token 290 : division
// token 291 : eliminate
// token 292 : gen
// token 293 : farey
// token 294 : fetch
// token 295 : freemodule
// token 296 : keepring
// token 297 : hilb
// token 298 : homog
// token 299 : imap
// token 300 : indepSet
// token 301 : interred
// token 302 : intersect
// token 303 : jacob
// token 304 : jet
// token 305 : kbase
// token 306 : koszul
// token 307 : leadcoef
// token 308 : leadexp
// token 309 : lead
// token 310 : leadmonom
// token 311 : liftstd
// token 312 : lift
// token 313 : maxideal
// token 314 : minbase
// token 315 : minor
// token 316 : minres
// token 317 : modulo
// token 318 : monomial
// token 319 : mres
// token 320 : mult
// token 321 : ord
// token 322 : par
// token 323 : pardeg
// token 324 : preimage
// token 325 : quotient
// token 326 : qhweight
// token 327 : reduce
// token 328 : regularity
// token 329 : nres
// token 330 : sba
// token 331 : simplify
// token 332 : sortvec
// token 333 : sres
// token 334 : std
// token 335 : subst
// token 336 : syz
// token 337 : var
// token 338 : vdim
// token 339 : wedge
// token 340 : weight
// token 342 : degBound
// token 343 : multBound
// token 344 : noether
// token 345 : minpoly
// token 346 : nothing
// token 359 : example
// token 360 : export
// token 362 : kill
// token 363 : LIB
// token 364 : listvar
// token 365 : setring
// token 366 : type
// token 373 : apply
// token 374 : ASSUME
// token 375 : break
// token 376 : continue
// token 377 : else
// token 378 : eval
// token 379 : quote
// token 381 : forif
// token 384 : return
// token 385 : parameter
// token 389 : command
// token 390 : any_type
// token 391 : identifier
// token 402 : alias
// token 403 : align
// token 404 : attrib
// token 405 : bareiss
// token 406 : bigint
// token 407 : branchTo
// token 408 : bracket
// token 409 : breakpoint
// token 410 : char
// token 411 : charstr
// token 412 : char_series
// token 413 : chinrem
// token 416 : close
// token 417 : ncols
// token 418 : cleardenom
// token 419 : size
// token 420 : (c)ring
// token 421 : dbprint
// token 422 : def
// token 423 : defined
// token 424 : delete
// token 425 : denominator
// token 426 : det
// token 427 : dump
// token 428 : RETURN
// token 429 : envelope
// token 430 : ERROR
// token 431 : execute
// token 432 : exportto
// token 433 : extgcd
// token 434 : factorize
// token 435 : find
// token 436 : facstd
// token 437 : factmodd
// token 438 : frwalk
// token 439 : fglm
// token 440 : fglmquot
// token 441 : finduni
// token 442 : gcd
// token 443 : getdump
// token 444 : highcorner
// token 445 : hres
// token 446 : impart
// token 447 : importfrom
// token 448 : insert
// token 449 : int
// token 450 : div
// token 451 : interpolation
// token 452 : intvec
// token 453 : rvar
// token 454 : janet
// token 455 : kernel
// token 456 : killattrib
// token 457 : kres
// token 458 : laguerre
// token 459 : link
// token 460 : list
// token 461 : load
// token 462 : lres
// token 463 : ludecomp
// token 464 : luinverse
// token 465 : lusolve
// token 466 : memory
// token 467 : monitor
// token 468 : mpresmat
// token 469 : mstd
// token 470 : nameof
// token 471 : names
// token 472 : newstruct
// token 473 : ncalgebra
// token 474 : nc_algebra
// token 475 : convhull
// token 476 : npars
// token 477 : numerator
// token 478 : nvars
// token 479 : open
// token 480 : oppose
// token 481 : opposite
// token 482 : option
// token 483 : ordstr
// token 484 : package
// token 485 : parstr
// token 486 : primefactors
// token 487 : prime
// token 488 : print
// token 489 : prune
// token 490 : qring
// token 491 : qrds
// token 492 : random
// token 493 : rank
// token 494 : read
// token 495 : repart
// token 496 : reservedName
// token 497 : resultant
// token 498 : ringlist
// token 499 : nrows
// token 500 : simplex
// token 501 : slimgb
// token 502 : sqrfree
// token 503 : status
// token 504 : string
// token 505 : system
// token 506 : test
// token 507 : transpose
// token 508 : trace
// token 509 : twostd
// token 510 : typeof
// token 511 : univariate
// token 513 : uressolve
// token 514 : vandermonde
// token 515 : variables
// token 516 : varstr
// token 517 : waitfirst
// token 518 : waitall
// token 519 : write
// token 520 : echo
// token 521 : pagewidth
// token 522 : timer
// token 523 : rtimer
// token 524 : TRACE
// token 525 : voice
// token 526 : short
// token 527 : printlevel
/*--max. token: 528, gr: 387 --*/
/*---------------------------------------------*/
struct sValCmdTab dArithTab1[]=
{
 { 40,11 },
 { 45,2 },
 { 262,1 },
 { 263,140 },
 { 265,0 },
 { 269,21 },
 { 270,93 },
 { 271,161 },
 { 272,174 },
 { 274,80 },
 { 275,121 },
 { 276,122 },
 { 277,129 },
 { 278,141 },
 { 279,155 },
 { 280,171 },
 { 281,211 },
 { 282,14 },
 { 286,52 },
 { 287,49 },
 { 289,61 },
 { 292,65 },
 { 295,70 },
 { 297,75 },
 { 298,78 },
 { 300,86 },
 { 301,91 },
 { 303,99 },
 { 305,103 },
 { 307,113 },
 { 308,115 },
 { 309,109 },
 { 310,117 },
 { 313,123 },
 { 314,125 },
 { 316,127 },
 { 318,131 },
 { 320,132 },
 { 321,148 },
 { 322,151 },
 { 323,152 },
 { 324,157 },
 { 326,163 },
 { 328,168 },
 { 330,182 },
 { 332,186 },
 { 334,189 },
 { 336,192 },
 { 337,214 },
 { 338,212 },
 { 340,217 },
 { 404,12 },
 { 405,13 },
 { 406,18 },
 { 410,22 },
 { 411,24 },
 { 412,23 },
 { 416,25 },
 { 417,26 },
 { 418,32 },
 { 419,34 },
 { 422,47 },
 { 423,54 },
 { 425,55 },
 { 426,57 },
 { 427,64 },
 { 429,194 },
 { 430,67 },
 { 431,66 },
 { 434,68 },
 { 436,71 },
 { 441,69 },
 { 443,72 },
 { 444,73 },
 { 446,85 },
 { 449,87 },
 { 452,94 },
 { 453,96 },
 { 454,102 },
 { 456,108 },
 { 459,119 },
 { 460,120 },
 { 461,219 },
 { 463,105 },
 { 466,124 },
 { 467,130 },
 { 469,134 },
 { 470,136 },
 { 471,137 },
 { 475,220 },
 { 476,144 },
 { 477,56 },
 { 478,145 },
 { 479,146 },
 { 481,195 },
 { 482,147 },
 { 483,150 },
 { 485,153 },
 { 486,106 },
 { 487,158 },
 { 488,159 },
 { 489,162 },
 { 490,165 },
 { 493,166 },
 { 494,167 },
 { 495,169 },
 { 496,170 },
 { 498,173 },
 { 499,176 },
 { 501,184 },
 { 502,188 },
 { 504,191 },
 { 507,201 },
 { 508,197 },
 { 509,196 },
 { 510,206 },
 { 511,207 },
 { 515,208 },
 { 516,215 },
 { 517,221 },
 { 518,222 },
 { 10000,0 }
};
#define JJTAB1LEN 121
struct sValCmdTab dArithTab2[]=
{
 { 37,91 },
 { 38,133 },
 { 40,179 },
 { 42,43 },
 { 43,1 },
 { 45,25 },
 { 47,79 },
 { 58,184 },
 { 60,109 },
 { 62,125 },
 { 91,164 },
 { 94,96 },
 { 124,134 },
 { 258,163 },
 { 259,135 },
 { 260,117 },
 { 261,101 },
 { 264,150 },
 { 266,0 },
 { 282,188 },
 { 283,197 },
 { 284,196 },
 { 285,201 },
 { 287,202 },
 { 288,206 },
 { 289,213 },
 { 290,215 },
 { 291,217 },
 { 293,227 },
 { 294,231 },
 { 297,240 },
 { 298,242 },
 { 299,249 },
 { 300,251 },
 { 302,254 },
 { 304,257 },
 { 305,262 },
 { 306,266 },
 { 311,271 },
 { 312,269 },
 { 317,275 },
 { 319,280 },
 { 325,295 },
 { 327,301 },
 { 329,307 },
 { 330,318 },
 { 331,312 },
 { 333,316 },
 { 334,320 },
 { 339,329 },
 { 403,185 },
 { 404,187 },
 { 408,192 },
 { 413,193 },
 { 424,205 },
 { 432,221 },
 { 433,222 },
 { 434,225 },
 { 435,234 },
 { 436,226 },
 { 438,235 },
 { 439,232 },
 { 440,233 },
 { 442,236 },
 { 445,248 },
 { 447,250 },
 { 448,252 },
 { 450,87 },
 { 451,253 },
 { 454,256 },
 { 455,264 },
 { 456,265 },
 { 457,268 },
 { 461,273 },
 { 462,274 },
 { 467,277 },
 { 468,278 },
 { 472,279 },
 { 473,284 },
 { 474,288 },
 { 480,292 },
 { 485,293 },
 { 486,282 },
 { 488,294 },
 { 492,298 },
 { 493,299 },
 { 494,300 },
 { 502,309 },
 { 503,310 },
 { 516,326 },
 { 517,327 },
 { 518,328 },
 { 10000,0 }
};
#define JJTAB2LEN 92
/****************************************
*  Computer Algebra System SINGULAR     *
****************************************/

// identifier table for Singular
//
#ifdef MODULE_GENERATOR
#define omAlloc0(A) malloc(A)
#endif
void iiInitCmdName()
{
  sArithBase.nCmdUsed      = 0;
  sArithBase.nCmdAllocated = 233;
  sArithBase.sCmds = (cmdnames*)omAlloc0(sArithBase.nCmdAllocated*sizeof(cmdnames));

  // name-string                   alias  tokval toktype index
  iiArithAddCmd("$INVALID$",           0,  -1, 0, 0);
  iiArithAddCmd("ASSUME",              0, 374, 374, 1);
  iiArithAddCmd("ERROR",               0, 430, CMD_1, 2);
  iiArithAddCmd("GCD",                 2, 442, CMD_2, 3);
  iiArithAddCmd("IN",                  1, 309, CMD_1, 4);
  iiArithAddCmd("LIB",                 0, 363, SYSVAR, 5);
  iiArithAddCmd("NF",                  1, 327, CMD_M, 6);
  iiArithAddCmd("RETURN",              0, 428, 384, 7);
  iiArithAddCmd("TRACE",               0, 524, SYSVAR, 8);
  iiArithAddCmd("alias",               0, 402, 385, 9);
  iiArithAddCmd("align",               0, 403, CMD_2, 10);
  iiArithAddCmd("and",                 0,  38, '&', 11);
  iiArithAddCmd("apply",               0, 373, 373, 12);
  iiArithAddCmd("attrib",              0, 404, CMD_123, 13);
  iiArithAddCmd("bareiss",             0, 405, 351, 14);
  iiArithAddCmd("betti",               0, 282, CMD_12, 15);
  iiArithAddCmd("bigint",              0, 406, ROOT_DECL, 16);
  iiArithAddCmd("bigintmat",           0, 269, 269, 17);
  iiArithAddCmd("bracket",             0, 408, CMD_2, 18);
  iiArithAddCmd("branchTo",            0, 407, CMD_M, 19);
  iiArithAddCmd("break",               0, 375, 375, 20);
  iiArithAddCmd("breakpoint",          0, 409, CMD_M, 21);
  iiArithAddCmd("char",                0, 410, CMD_1, 22);
  iiArithAddCmd("char_series",         0, 412, CMD_1, 23);
  iiArithAddCmd("charstr",             0, 411, CMD_1, 24);
  iiArithAddCmd("chinrem",             0, 413, CMD_2, 25);
  iiArithAddCmd("cleardenom",          0, 418, CMD_1, 26);
  iiArithAddCmd("close",               0, 416, CMD_1, 27);
  iiArithAddCmd("coef",                0, 284, CMD_M, 28);
  iiArithAddCmd("coeffs",              0, 283, CMD_23, 29);
  iiArithAddCmd("continue",            0, 376, 376, 30);
  iiArithAddCmd("contract",            0, 285, CMD_2, 31);
  iiArithAddCmd("convhull",            0, 475, CMD_1, 32);
  iiArithAddCmd("dbprint",             0, 421, CMD_M, 33);
  iiArithAddCmd("def",                 0, 422, ROOT_DECL, 34);
  iiArithAddCmd("defined",             0, 423, CMD_1, 35);
  iiArithAddCmd("deg",                 0, 287, CMD_12, 36);
  iiArithAddCmd("degBound",            0, 342, SYSVAR, 37);
  iiArithAddCmd("degree",              0, 286, CMD_1, 38);
  iiArithAddCmd("delete",              0, 424, CMD_2, 39);
  iiArithAddCmd("denominator",         0, 425, CMD_1, 40);
  iiArithAddCmd("det",                 0, 426, CMD_1, 41);
  iiArithAddCmd("diff",                0, 288, CMD_2, 42);
  iiArithAddCmd("dim",                 0, 289, CMD_12, 43);
  iiArithAddCmd("div",                 0, 450, '/', 44);
  iiArithAddCmd("division",            0, 290, CMD_M, 45);
  iiArithAddCmd("dump",                0, 427, CMD_1, 46);
  iiArithAddCmd("echo",                0, 520, SYSVAR, 47);
  iiArithAddCmd("eliminate",           0, 291, CMD_23, 48);
  iiArithAddCmd("else",                0, 377, 377, 49);
  iiArithAddCmd("envelope",            0, 429, CMD_1, 50);
  iiArithAddCmd("eval",                0, 378, 378, 51);
  iiArithAddCmd("example",             0, 359, 359, 52);
  iiArithAddCmd("execute",             0, 431, CMD_1, 53);
  iiArithAddCmd("export",              0, 360, 360, 54);
  iiArithAddCmd("exportto",            0, 432, CMD_2, 55);
  iiArithAddCmd("extgcd",              0, 433, CMD_2, 56);
  iiArithAddCmd("facstd",              0, 436, CMD_12, 57);
  iiArithAddCmd("factmodd",            0, 437, CMD_M, 58);
  iiArithAddCmd("factorize",           0, 434, CMD_12, 59);
  iiArithAddCmd("farey",               0, 293, CMD_2, 60);
  iiArithAddCmd("fetch",               0, 294, CMD_M, 61);
  iiArithAddCmd("fglm",                0, 439, CMD_2, 62);
  iiArithAddCmd("fglmquot",            0, 440, CMD_2, 63);
  iiArithAddCmd("find",                0, 435, CMD_23, 64);
  iiArithAddCmd("finduni",             0, 441, CMD_1, 65);
  iiArithAddCmd("forif",               0, 381, 381, 66);
  iiArithAddCmd("freemodule",          0, 295, CMD_1, 67);
  iiArithAddCmd("frwalk",              0, 438, CMD_23, 68);
  iiArithAddCmd("gcd",                 0, 442, CMD_2, 69);
  iiArithAddCmd("gen",                 0, 292, CMD_1, 70);
  iiArithAddCmd("getdump",             0, 443, CMD_1, 71);
  iiArithAddCmd("highcorner",          0, 444, CMD_1, 72);
  iiArithAddCmd("hilb",                0, 297, CMD_123, 73);
  iiArithAddCmd("homog",               0, 298, CMD_123, 74);
  iiArithAddCmd("hres",                0, 445, CMD_2, 75);
  iiArithAddCmd("ideal",               0, 274, 358, 76);
  iiArithAddCmd("if",                  0, 381, 381, 77);
  iiArithAddCmd("imap",                0, 299, CMD_2, 78);
  iiArithAddCmd("impart",              0, 446, CMD_1, 79);
  iiArithAddCmd("importfrom",          0, 447, CMD_2, 80);
  iiArithAddCmd("indepSet",            0, 300, CMD_12, 81);
  iiArithAddCmd("insert",              0, 448, CMD_23, 82);
  iiArithAddCmd("int",                 0, 449, ROOT_DECL, 83);
  iiArithAddCmd("interpolation",       0, 451, CMD_2, 84);
  iiArithAddCmd("interred",            0, 301, CMD_1, 85);
  iiArithAddCmd("intersect",           0, 302, CMD_M, 86);
  iiArithAddCmd("intmat",              0, 270, 270, 87);
  iiArithAddCmd("intvec",              0, 452, ROOT_DECL_LIST, 88);
  iiArithAddCmd("jacob",               0, 303, CMD_1, 89);
  iiArithAddCmd("janet",               0, 454, CMD_12, 90);
  iiArithAddCmd("jet",                 0, 304, CMD_M, 91);
  iiArithAddCmd("kbase",               0, 305, CMD_12, 92);
  iiArithAddCmd("keepring",            0, 296, 296, 93);
  iiArithAddCmd("kernel",              0, 455, CMD_2, 94);
  iiArithAddCmd("kill",                0, 362, 362, 95);
  iiArithAddCmd("killattrib",          0, 456, CMD_12, 96);
  iiArithAddCmd("koszul",              0, 306, CMD_23, 97);
  iiArithAddCmd("kres",                0, 457, CMD_2, 98);
  iiArithAddCmd("laguerre",            0, 458, CMD_3, 99);
  iiArithAddCmd("lead",                0, 309, CMD_1, 100);
  iiArithAddCmd("leadcoef",            0, 307, CMD_1, 101);
  iiArithAddCmd("leadexp",             0, 308, CMD_1, 102);
  iiArithAddCmd("leadmonom",           0, 310, CMD_1, 103);
  iiArithAddCmd("lift",                0, 312, CMD_23, 104);
  iiArithAddCmd("liftstd",             0, 311, CMD_23, 105);
  iiArithAddCmd("link",                0, 459, ROOT_DECL, 106);
  iiArithAddCmd("list",                0, 460, ROOT_DECL_LIST, 107);
  iiArithAddCmd("listvar",             0, 364, 364, 108);
  iiArithAddCmd("load",                0, 461, CMD_12, 109);
  iiArithAddCmd("lres",                0, 462, CMD_2, 110);
  iiArithAddCmd("ludecomp",            0, 463, CMD_1, 111);
  iiArithAddCmd("luinverse",           0, 464, CMD_M, 112);
  iiArithAddCmd("lusolve",             0, 465, CMD_M, 113);
  iiArithAddCmd("map",                 0, 275, RING_DECL, 114);
  iiArithAddCmd("matrix",              0, 276, 276, 115);
  iiArithAddCmd("maxideal",            0, 313, CMD_1, 116);
  iiArithAddCmd("memory",              0, 466, CMD_1, 117);
  iiArithAddCmd("minbase",             0, 314, CMD_1, 118);
  iiArithAddCmd("minor",               0, 315, CMD_M, 119);
  iiArithAddCmd("minpoly",             0, 345, SYSVAR, 120);
  iiArithAddCmd("minres",              0, 316, CMD_1, 121);
  iiArithAddCmd("mod",                 0,  37, '/', 122);
  iiArithAddCmd("module",              0, 277, 358, 123);
  iiArithAddCmd("modulo",              0, 317, CMD_2, 124);
  iiArithAddCmd("monitor",             0, 467, CMD_12, 125);
  iiArithAddCmd("monomial",            0, 318, CMD_1, 126);
  iiArithAddCmd("mpresmat",            0, 468, CMD_2, 127);
  iiArithAddCmd("mres",                0, 319, CMD_2, 128);
  iiArithAddCmd("mstd",                0, 469, CMD_1, 129);
  iiArithAddCmd("mult",                0, 320, CMD_1, 130);
  iiArithAddCmd("multBound",           0, 343, SYSVAR, 131);
  iiArithAddCmd("multiplicity",        1, 320, CMD_1, 132);
  iiArithAddCmd("nameof",              0, 470, CMD_1, 133);
  iiArithAddCmd("names",               0, 471, CMD_M, 134);
  iiArithAddCmd("nc_algebra",          0, 474, CMD_2, 135);
  iiArithAddCmd("ncalgebra",           2, 473, CMD_2, 136);
  iiArithAddCmd("ncols",               0, 417, CMD_1, 137);
  iiArithAddCmd("newstruct",           0, 472, CMD_23, 138);
  iiArithAddCmd("noether",             0, 344, SYSVAR, 139);
  iiArithAddCmd("not",                 0, 263, 263, 140);
  iiArithAddCmd("npars",               0, 476, CMD_1, 141);
  iiArithAddCmd("nres",                0, 329, CMD_2, 142);
  iiArithAddCmd("nrows",               0, 499, CMD_1, 143);
  iiArithAddCmd("number",              0, 278, RING_DECL, 144);
  iiArithAddCmd("numerator",           0, 477, CMD_1, 145);
  iiArithAddCmd("nvars",               0, 478, CMD_1, 146);
  iiArithAddCmd("open",                0, 479, CMD_1, 147);
  iiArithAddCmd("oppose",              0, 480, CMD_2, 148);
  iiArithAddCmd("opposite",            0, 481, CMD_1, 149);
  iiArithAddCmd("option",              0, 482, CMD_M, 150);
  iiArithAddCmd("or",                  0, 124, '&', 151);
  iiArithAddCmd("ord",                 0, 321, CMD_1, 152);
  iiArithAddCmd("ordstr",              0, 483, CMD_1, 153);
  iiArithAddCmd("package",             0, 484, ROOT_DECL, 154);
  iiArithAddCmd("pagewidth",           0, 521, SYSVAR, 155);
  iiArithAddCmd("par",                 0, 322, CMD_1, 156);
  iiArithAddCmd("parameter",           0, 385, 385, 157);
  iiArithAddCmd("pardeg",              0, 323, CMD_1, 158);
  iiArithAddCmd("parstr",              0, 485, CMD_12, 159);
  iiArithAddCmd("poly",                0, 279, RING_DECL, 160);
  iiArithAddCmd("preimage",            0, 324, 351, 161);
  iiArithAddCmd("prime",               0, 487, CMD_1, 162);
  iiArithAddCmd("primefactors",        0, 486, CMD_12, 163);
  iiArithAddCmd("print",               0, 488, CMD_12, 164);
  iiArithAddCmd("printlevel",          0, 527, SYSVAR, 165);
  iiArithAddCmd("proc",                0, 271, 271, 166);
  iiArithAddCmd("prune",               0, 489, CMD_1, 167);
  iiArithAddCmd("qhweight",            0, 326, CMD_1, 168);
  iiArithAddCmd("qrds",                0, 491, CMD_M, 169);
  iiArithAddCmd("qring",               0, 490, ROOT_DECL, 170);
  iiArithAddCmd("quote",               0, 379, 379, 171);
  iiArithAddCmd("quotient",            0, 325, CMD_2, 172);
  iiArithAddCmd("random",              0, 492, CMD_23, 173);
  iiArithAddCmd("rank",                0, 493, CMD_12, 174);
  iiArithAddCmd("read",                0, 494, CMD_12, 175);
  iiArithAddCmd("reduce",              0, 327, CMD_M, 176);
  iiArithAddCmd("regularity",          0, 328, CMD_1, 177);
  iiArithAddCmd("repart",              0, 495, CMD_1, 178);
  iiArithAddCmd("reservedName",        0, 496, CMD_M, 179);
  iiArithAddCmd("resolution",          0, 280, RING_DECL, 180);
  iiArithAddCmd("resultant",           0, 497, CMD_3, 181);
  iiArithAddCmd("return",              0, 384, 384, 182);
  iiArithAddCmd("ring",                0, 272, 272, 183);
  iiArithAddCmd("ringlist",            0, 498, CMD_1, 184);
  iiArithAddCmd("rtimer",              0, 523, SYSVAR, 185);
  iiArithAddCmd("rvar",                0, 453, CMD_1, 186);
  iiArithAddCmd("sba",                 0, 330, CMD_123, 187);
  iiArithAddCmd("setring",             0, 365, 365, 188);
  iiArithAddCmd("short",               0, 526, SYSVAR, 189);
  iiArithAddCmd("simplex",             0, 500, CMD_M, 190);
  iiArithAddCmd("simplify",            0, 331, CMD_2, 191);
  iiArithAddCmd("size",                0, 419, CMD_1, 192);
  iiArithAddCmd("slimgb",              0, 501, CMD_1, 193);
  iiArithAddCmd("sortvec",             0, 332, CMD_1, 194);
  iiArithAddCmd("sqrfree",             0, 502, CMD_12, 195);
  iiArithAddCmd("sres",                0, 333, CMD_2, 196);
  iiArithAddCmd("status",              0, 503, CMD_M, 197);
  iiArithAddCmd("std",                 0, 334, CMD_M, 198);
  iiArithAddCmd("string",              0, 504, ROOT_DECL_LIST, 199);
  iiArithAddCmd("subst",               0, 335, CMD_M, 200);
  iiArithAddCmd("system",              0, 505, CMD_M, 201);
  iiArithAddCmd("syz",                 0, 336, CMD_1, 202);
  iiArithAddCmd("test",                0, 506, CMD_M, 203);
  iiArithAddCmd("timer",               0, 522, SYSVAR, 204);
  iiArithAddCmd("trace",               0, 508, CMD_1, 205);
  iiArithAddCmd("transpose",           0, 507, CMD_1, 206);
  iiArithAddCmd("twostd",              0, 509, CMD_1, 207);
  iiArithAddCmd("type",                0, 366, 366, 208);
  iiArithAddCmd("typeof",              0, 510, CMD_1, 209);
  iiArithAddCmd("univariate",          0, 511, CMD_1, 210);
  iiArithAddCmd("uressolve",           0, 513, CMD_M, 211);
  iiArithAddCmd("vandermonde",         0, 514, CMD_3, 212);
  iiArithAddCmd("var",                 0, 337, CMD_1, 213);
  iiArithAddCmd("variables",           0, 515, CMD_1, 214);
  iiArithAddCmd("varstr",              0, 516, CMD_12, 215);
  iiArithAddCmd("vdim",                0, 338, CMD_1, 216);
  iiArithAddCmd("vector",              0, 281, RING_DECL, 217);
  iiArithAddCmd("verbose",             2, 482, CMD_M, 218);
  iiArithAddCmd("voice",               0, 525, SYSVAR, 219);
  iiArithAddCmd("waitall",             0, 518, CMD_12, 220);
  iiArithAddCmd("waitfirst",           0, 517, CMD_12, 221);
  iiArithAddCmd("wedge",               0, 339, CMD_2, 222);
  iiArithAddCmd("weight",              0, 340, CMD_1, 223);
  iiArithAddCmd("whileif",             0, 381, 381, 224);
  iiArithAddCmd("write",               0, 519, CMD_M, 225);
  iiArithAddCmd("exit",                0,  -1, 0, 226);
  iiArithAddCmd("for",                 0,  -1, 0, 227);
  iiArithAddCmd("help",                0,  -1, 0, 228);
  iiArithAddCmd("newline",             0,  -1, 0, 229);
  iiArithAddCmd("pause",               2,  -1, 0, 230);
  iiArithAddCmd("quit",                0,  -1, 0, 231);
  iiArithAddCmd("while",               0,  -1, 0, 232);
/* end of list marker */
  sArithBase.nLastIdentifier = 225;
}
#define LAST_IDENTIFIER 225
