; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx -show-mc-encoding | FileCheck %s --check-prefix=AVX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl -show-mc-encoding | FileCheck %s --check-prefix=AVX512VL

define <4 x double> @test_x86_avx_vzeroall(<4 x double> %a, <4 x double> %b) {
; AVX-LABEL: test_x86_avx_vzeroall:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # encoding: [0xc5,0xfd,0x58,0xc1]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    # encoding: [0xc5,0xfd,0x11,0x44,0x24,0xd8]
; AVX-NEXT:    vzeroall # encoding: [0xc5,0xfc,0x77]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    # encoding: [0xc5,0xfc,0x10,0x44,0x24,0xd8]
; AVX-NEXT:    retq # encoding: [0xc3]
;
; AVX512VL-LABEL: test_x86_avx_vzeroall:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vaddpd %ymm1, %ymm0, %ymm16 # encoding: [0x62,0xe1,0xfd,0x28,0x58,0xc1]
; AVX512VL-NEXT:    vzeroall # encoding: [0xc5,0xfc,0x77]
; AVX512VL-NEXT:    vmovapd %ymm16, %ymm0 # encoding: [0x62,0xb1,0xfd,0x28,0x28,0xc0]
; AVX512VL-NEXT:    retq # encoding: [0xc3]
  %c = fadd <4 x double> %a, %b
  call void @llvm.x86.avx.vzeroall()
  ret <4 x double> %c
}
declare void @llvm.x86.avx.vzeroall() nounwind

define <4 x double> @test_x86_avx_vzeroupper(<4 x double> %a, <4 x double> %b) {
; AVX-LABEL: test_x86_avx_vzeroupper:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddpd %ymm1, %ymm0, %ymm0 # encoding: [0xc5,0xfd,0x58,0xc1]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    # encoding: [0xc5,0xfd,0x11,0x44,0x24,0xd8]
; AVX-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    # encoding: [0xc5,0xfc,0x10,0x44,0x24,0xd8]
; AVX-NEXT:    retq # encoding: [0xc3]
;
; AVX512VL-LABEL: test_x86_avx_vzeroupper:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vaddpd %ymm1, %ymm0, %ymm16 # encoding: [0x62,0xe1,0xfd,0x28,0x58,0xc1]
; AVX512VL-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; AVX512VL-NEXT:    vmovapd %ymm16, %ymm0 # encoding: [0x62,0xb1,0xfd,0x28,0x28,0xc0]
; AVX512VL-NEXT:    retq # encoding: [0xc3]
  %c = fadd <4 x double> %a, %b
  call void @llvm.x86.avx.vzeroupper()
  ret <4 x double> %c
}
declare void @llvm.x86.avx.vzeroupper() nounwind
