; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

target datalayout = "n32"

@var_7 = external global i8, align 1
@var_1 = external global i32, align 4
@var_0 = external global i16, align 2
@var_5 = external global i64, align 8
@arr_2 = external global [0 x i32], align 4
@arr_4 = external global [0 x i16], align 2
@arr_3 = external global [8 x i32], align 16

define void @_Z4testv() {
; CHECK-LABEL: @_Z4testv(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[I:%.*]] = load i8, ptr @var_7, align 1
; CHECK-NEXT:    [[I1:%.*]] = icmp eq i8 [[I]], -1
; CHECK-NEXT:    [[I4:%.*]] = load i16, ptr @var_0, align 2
; CHECK-NEXT:    br i1 [[I1]], label [[BB10:%.*]], label [[BB9:%.*]]
; CHECK:       bb9:
; CHECK-NEXT:    br label [[BB12:%.*]]
; CHECK:       bb10:
; CHECK-NEXT:    [[I2:%.*]] = load i32, ptr @var_1, align 4
; CHECK-NEXT:    [[I3:%.*]] = icmp eq i32 [[I2]], 0
; CHECK-NEXT:    [[I6:%.*]] = load i64, ptr @var_5, align 8
; CHECK-NEXT:    [[I5:%.*]] = sext i16 [[I4]] to i64
; CHECK-NEXT:    [[I7:%.*]] = select i1 [[I3]], i64 [[I6]], i64 [[I5]]
; CHECK-NEXT:    [[I11:%.*]] = trunc i64 [[I7]] to i32
; CHECK-NEXT:    br label [[BB12]]
; CHECK:       bb12:
; CHECK-NEXT:    [[STOREMERGE:%.*]] = phi i32 [ 1, [[BB9]] ], [ [[I11]], [[BB10]] ]
; CHECK-NEXT:    store i32 [[STOREMERGE]], ptr @arr_2, align 4
; CHECK-NEXT:    store i16 [[I4]], ptr @arr_4, align 2
; CHECK-NEXT:    [[I8:%.*]] = sext i16 [[I4]] to i32
; CHECK-NEXT:    store i32 [[I8]], ptr @arr_3, align 4
; CHECK-NEXT:    store i32 [[STOREMERGE]], ptr getelementptr inbounds nuw (i8, ptr @arr_2, i64 4), align 4
; CHECK-NEXT:    store i16 [[I4]], ptr getelementptr inbounds nuw (i8, ptr @arr_4, i64 2), align 2
; CHECK-NEXT:    store i32 [[I8]], ptr getelementptr inbounds nuw (i8, ptr @arr_3, i64 4), align 4
; CHECK-NEXT:    ret void
;
bb:
  %i = load i8, ptr @var_7, align 1
  %i1 = icmp eq i8 %i, -1
  %i2 = load i32, ptr @var_1, align 4
  %i3 = icmp eq i32 %i2, 0
  %i4 = load i16, ptr @var_0, align 2
  %i5 = sext i16 %i4 to i64
  %i6 = load i64, ptr @var_5, align 8
  %i7 = select i1 %i3, i64 %i6, i64 %i5
  %i8 = sext i16 %i4 to i32
  br i1 %i1, label %bb10, label %bb9

bb9:                                              ; preds = %bb
  store i32 1, ptr @arr_2, align 4
  store i16 %i4, ptr @arr_4, align 2
  store i32 %i8, ptr @arr_3, align 4
  store i32 1, ptr getelementptr inbounds ([0 x i32], ptr @arr_2, i64 0, i64 1), align 4
  store i16 %i4, ptr getelementptr inbounds ([0 x i16], ptr @arr_4, i64 0, i64 1), align 2
  store i32 %i8, ptr getelementptr inbounds ([8 x i32], ptr @arr_3, i64 0, i64 1), align 4
  br label %bb12

bb10:                                             ; preds = %bb
  %i11 = trunc i64 %i7 to i32
  store i32 %i11, ptr @arr_2, align 4
  store i16 %i4, ptr @arr_4, align 2
  store i32 %i8, ptr @arr_3, align 4
  store i32 %i11, ptr getelementptr inbounds ([0 x i32], ptr @arr_2, i64 0, i64 1), align 4
  store i16 %i4, ptr getelementptr inbounds ([0 x i16], ptr @arr_4, i64 0, i64 1), align 2
  store i32 %i8, ptr getelementptr inbounds ([8 x i32], ptr @arr_3, i64 0, i64 1), align 4
  br label %bb12

bb12:                                             ; preds = %bb10, %bb9
  ret void
}

define half @diff_types_same_width_merge(i1 %cond, half %a, i16 %b) {
; CHECK-LABEL: @diff_types_same_width_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB0:%.*]], label [[BB1:%.*]]
; CHECK:       BB0:
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i16 [[B:%.*]] to half
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[STOREMERGE:%.*]] = phi half [ [[TMP0]], [[BB1]] ], [ [[A:%.*]], [[BB0]] ]
; CHECK-NEXT:    ret half [[STOREMERGE]]
;
entry:
  %alloca = alloca half
  br i1 %cond, label %BB0, label %BB1
BB0:
  store half %a, ptr %alloca
  br label %sink
BB1:
  store i16 %b, ptr %alloca
  br label %sink
sink:
  %val = load half, ptr %alloca
  ret half %val
}

define i32 @diff_types_diff_width_no_merge(i1 %cond, i32 %a, i64 %b) {
; CHECK-LABEL: @diff_types_diff_width_no_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca i64, align 8
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[IF:%.*]], label [[ELSE:%.*]]
; CHECK:       if:
; CHECK-NEXT:    store i32 [[A:%.*]], ptr [[ALLOCA]], align 4
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       else:
; CHECK-NEXT:    store i64 [[B:%.*]], ptr [[ALLOCA]], align 4
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[VAL:%.*]] = load i32, ptr [[ALLOCA]], align 4
; CHECK-NEXT:    ret i32 [[VAL]]
;
entry:
  %alloca = alloca i64
  br i1 %cond, label %if, label %else
if:
  store i32 %a, ptr %alloca
  br label %sink
  else:
  store i64 %b, ptr %alloca
  br label %sink
sink:
  %val = load i32, ptr %alloca
  ret i32 %val
}

define <4 x i32> @vec_no_merge(i1 %cond, <2 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: @vec_no_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca i64, align 8
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[IF:%.*]], label [[ELSE:%.*]]
; CHECK:       if:
; CHECK-NEXT:    store <2 x i32> [[A:%.*]], ptr [[ALLOCA]], align 8
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       else:
; CHECK-NEXT:    store <4 x i32> [[B:%.*]], ptr [[ALLOCA]], align 16
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[VAL:%.*]] = load <4 x i32>, ptr [[ALLOCA]], align 16
; CHECK-NEXT:    ret <4 x i32> [[VAL]]
;
entry:
  %alloca = alloca i64
  br i1 %cond, label %if, label %else
if:
  store <2 x i32> %a, ptr %alloca
  br label %sink
else:
  store <4 x i32> %b, ptr %alloca
  br label %sink
sink:
  %val = load <4 x i32>, ptr %alloca
  ret <4 x i32> %val
}

%struct.half = type { half };

define %struct.half @one_elem_struct_merge(i1 %cond, %struct.half %a, half %b) {
; CHECK-LABEL: @one_elem_struct_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB0:%.*]], label [[BB1:%.*]]
; CHECK:       BB0:
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    [[TMP0:%.*]] = insertvalue [[STRUCT_HALF:%.*]] poison, half [[B:%.*]], 0
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[VAL1_MERGED:%.*]] = phi [[STRUCT_HALF]] [ [[A:%.*]], [[BB0]] ], [ [[TMP0]], [[BB1]] ]
; CHECK-NEXT:    ret [[STRUCT_HALF]] [[VAL1_MERGED]]
;
entry:
  %alloca = alloca i64
  br i1 %cond, label %BB0, label %BB1
BB0:
  store %struct.half %a, ptr %alloca
  br label %sink
BB1:
  store half %b, ptr %alloca
  br label %sink
sink:
  %val = load %struct.half, ptr %alloca
  ret %struct.half %val
}

%struct.tup = type { half, i32 };

define %struct.tup @multi_elem_struct_no_merge(i1 %cond, %struct.tup %a, half %b) {
; CHECK-LABEL: @multi_elem_struct_no_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca i64, align 8
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[IF:%.*]], label [[ELSE:%.*]]
; CHECK:       if:
; CHECK-NEXT:    store [[STRUCT_TUP:%.*]] [[A:%.*]], ptr [[ALLOCA]], align 4
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       else:
; CHECK-NEXT:    store half [[B:%.*]], ptr [[ALLOCA]], align 2
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[VAL:%.*]] = load [[STRUCT_TUP]], ptr [[ALLOCA]], align 4
; CHECK-NEXT:    ret [[STRUCT_TUP]] [[VAL]]
;
entry:
  %alloca = alloca i64
  br i1 %cond, label %if, label %else
if:
  store %struct.tup %a, ptr %alloca
  br label %sink
else:
  store half %b, ptr %alloca
  br label %sink
sink:
  %val = load %struct.tup, ptr %alloca
  ret %struct.tup %val
}

define i16 @same_types_diff_align_no_merge(i1 %cond, i16 %a, i16 %b) {
; CHECK-LABEL: @same_types_diff_align_no_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca i16, align 4
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB0:%.*]], label [[BB1:%.*]]
; CHECK:       BB0:
; CHECK-NEXT:    store i16 [[A:%.*]], ptr [[ALLOCA]], align 8
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    store i16 [[B:%.*]], ptr [[ALLOCA]], align 4
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[VAL:%.*]] = load i16, ptr [[ALLOCA]], align 2
; CHECK-NEXT:    ret i16 [[VAL]]
;
entry:
  %alloca = alloca i16, align 4
  br i1 %cond, label %BB0, label %BB1
BB0:
  store i16 %a, ptr %alloca, align 8
  br label %sink
BB1:
  store i16 %b, ptr %alloca, align 4
  br label %sink
sink:
  %val = load i16, ptr %alloca
  ret i16 %val
}

define i64 @ptrtoint_merge(i1 %cond, i64 %a, ptr %b) {
; CHECK-LABEL: @ptrtoint_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca ptr, align 8
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB0:%.*]], label [[BB1:%.*]]
; CHECK:       BB0:
; CHECK-NEXT:    store i64 [[A:%.*]], ptr [[ALLOCA]], align 4
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    store ptr [[B:%.*]], ptr [[ALLOCA]], align 8
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[VAL:%.*]] = load i64, ptr [[ALLOCA]], align 4
; CHECK-NEXT:    ret i64 [[VAL]]
;
entry:
  %alloca = alloca ptr
  br i1 %cond, label %BB0, label %BB1
BB0:
  store i64 %a, ptr %alloca
  br label %sink
BB1:
  store ptr %b, ptr %alloca
  br label %sink
sink:
  %val = load i64, ptr %alloca
  ret i64 %val
}

define ptr @inttoptr_merge(i1 %cond, i64 %a, ptr %b) {
; CHECK-LABEL: @inttoptr_merge(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[BB0:%.*]], label [[BB1:%.*]]
; CHECK:       BB0:
; CHECK-NEXT:    [[TMP0:%.*]] = inttoptr i64 [[A:%.*]] to ptr
; CHECK-NEXT:    br label [[SINK:%.*]]
; CHECK:       BB1:
; CHECK-NEXT:    br label [[SINK]]
; CHECK:       sink:
; CHECK-NEXT:    [[STOREMERGE:%.*]] = phi ptr [ [[B:%.*]], [[BB1]] ], [ [[TMP0]], [[BB0]] ]
; CHECK-NEXT:    ret ptr [[STOREMERGE]]
;
entry:
  %alloca = alloca ptr
  br i1 %cond, label %BB0, label %BB1
BB0:
  store i64 %a, ptr %alloca, align 8
  br label %sink
BB1:
  store ptr %b, ptr %alloca, align 8
  br label %sink
sink:
  %val = load ptr, ptr %alloca
  ret ptr %val
}


define void @pr46688(i1 %cond, i32 %x, i16 %d, ptr %p1, ptr %p2) {
; CHECK-LABEL: @pr46688(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[IF:%.*]], label [[ELSE:%.*]]
; CHECK:       if:
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[DONV_PN:%.*]] = zext i16 [[D:%.*]] to i32
; CHECK-NEXT:    [[THR_PN:%.*]] = lshr i32 [[DONV_PN]], [[X:%.*]]
; CHECK-NEXT:    [[THR1_PN:%.*]] = lshr i32 [[THR_PN]], [[X]]
; CHECK-NEXT:    [[THR2_PN:%.*]] = lshr i32 [[THR1_PN]], [[X]]
; CHECK-NEXT:    [[STOREMERGE:%.*]] = lshr i32 [[THR2_PN]], [[X]]
; CHECK-NEXT:    [[STOREMERGE1:%.*]] = trunc nuw i32 [[STOREMERGE]] to i16
; CHECK-NEXT:    store i16 [[STOREMERGE1]], ptr [[P1:%.*]], align 2
; CHECK-NEXT:    store i32 [[STOREMERGE]], ptr [[P2:%.*]], align 4
; CHECK-NEXT:    ret void
;
entry:
  br i1 %cond, label %if, label %else

if:
  %conv = zext i16 %d to i32
  %shr = lshr i32 %conv, %x
  %shr1 = lshr i32 %shr, %x
  %shr2 = lshr i32 %shr1, %x
  %shr3 = lshr i32 %shr2, %x
  %conv4 = trunc i32 %shr3 to i16
  store i16 %conv4, ptr %p1, align 2
  %conv5 = and i32 %shr3, 65535
  store i32 %conv5, ptr %p2, align 4
  br label %exit

else:
  %donv = zext i16 %d to i32
  %thr = lshr i32 %donv, %x
  %thr1 = lshr i32 %thr, %x
  %thr2 = lshr i32 %thr1, %x
  %thr3 = lshr i32 %thr2, %x
  %donv4 = trunc i32 %thr3 to i16
  store i16 %donv4, ptr %p1, align 2
  store i32 %thr3, ptr %p2, align 4
  br label %exit

exit:
  ret void
}
