; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=instcombine < %s | FileCheck %s

@gv = constant i32 0

define float @cvt_var(i32 %a) {
; CHECK-LABEL: define float @cvt_var(
; CHECK-SAME: i32 [[A:%.*]]) {
; CHECK-NEXT:    [[RET:%.*]] = call float @llvm.amdgcn.cvt.off.f32.i4(i32 [[A]])
; CHECK-NEXT:    ret float [[RET]]
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 %a)
  ret float %ret
}

define float @cvt_imm_0() {
; CHECK-LABEL: define float @cvt_imm_0() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 0)
  ret float %ret
}

define float @cvt_imm_1() {
; CHECK-LABEL: define float @cvt_imm_1() {
; CHECK-NEXT:    ret float 6.250000e-02
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 1)
  ret float %ret
}

define float @cvt_imm_2() {
; CHECK-LABEL: define float @cvt_imm_2() {
; CHECK-NEXT:    ret float 1.250000e-01
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 2)
  ret float %ret
}

define float @cvt_imm_3() {
; CHECK-LABEL: define float @cvt_imm_3() {
; CHECK-NEXT:    ret float 1.875000e-01
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 3)
  ret float %ret
}

define float @cvt_imm_4() {
; CHECK-LABEL: define float @cvt_imm_4() {
; CHECK-NEXT:    ret float 2.500000e-01
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 4)
  ret float %ret
}

define float @cvt_imm_5() {
; CHECK-LABEL: define float @cvt_imm_5() {
; CHECK-NEXT:    ret float 3.125000e-01
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 5)
  ret float %ret
}

define float @cvt_imm_6() {
; CHECK-LABEL: define float @cvt_imm_6() {
; CHECK-NEXT:    ret float 3.750000e-01
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 6)
  ret float %ret
}

define float @cvt_imm_7() {
; CHECK-LABEL: define float @cvt_imm_7() {
; CHECK-NEXT:    ret float 4.375000e-01
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 7)
  ret float %ret
}

define float @cvt_imm_8() {
; CHECK-LABEL: define float @cvt_imm_8() {
; CHECK-NEXT:    ret float -5.000000e-01
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 8)
  ret float %ret
}

define float @cvt_imm_9() {
; CHECK-LABEL: define float @cvt_imm_9() {
; CHECK-NEXT:    ret float -4.375000e-01
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 9)
  ret float %ret
}

define float @cvt_imm_10() {
; CHECK-LABEL: define float @cvt_imm_10() {
; CHECK-NEXT:    ret float -3.750000e-01
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 10)
  ret float %ret
}

define float @cvt_imm_11() {
; CHECK-LABEL: define float @cvt_imm_11() {
; CHECK-NEXT:    ret float -3.125000e-01
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 11)
  ret float %ret
}

define float @cvt_imm_12() {
; CHECK-LABEL: define float @cvt_imm_12() {
; CHECK-NEXT:    ret float -2.500000e-01
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 12)
  ret float %ret
}

define float @cvt_imm_13() {
; CHECK-LABEL: define float @cvt_imm_13() {
; CHECK-NEXT:    ret float -1.875000e-01
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 13)
  ret float %ret
}

define float @cvt_imm_14() {
; CHECK-LABEL: define float @cvt_imm_14() {
; CHECK-NEXT:    ret float -1.250000e-01
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 14)
  ret float %ret
}

define float @cvt_imm_15() {
; CHECK-LABEL: define float @cvt_imm_15() {
; CHECK-NEXT:    ret float -6.250000e-02
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 15)
  ret float %ret
}

define float @cvt_imm_underflow() {
; CHECK-LABEL: define float @cvt_imm_underflow() {
; CHECK-NEXT:    ret float -6.250000e-02
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 -1)
  ret float %ret
}

define float @cvt_imm_overflow() {
; CHECK-LABEL: define float @cvt_imm_overflow() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 16)
  ret float %ret
}

define float @cvt_poison() {
; CHECK-LABEL: define float @cvt_poison() {
; CHECK-NEXT:    ret float poison
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 poison)
  ret float %ret
}

define float @cvt_undef() {
; CHECK-LABEL: define float @cvt_undef() {
; CHECK-NEXT:    ret float 0.000000e+00
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 undef)
  ret float %ret
}

define float @cvt_constexpr() {
; CHECK-LABEL: define float @cvt_constexpr() {
; CHECK-NEXT:    [[RET:%.*]] = call float @llvm.amdgcn.cvt.off.f32.i4(i32 ptrtoint (ptr @gv to i32))
; CHECK-NEXT:    ret float [[RET]]
;
  %ret = call float @llvm.amdgcn.cvt.off.f32.i4(i32 ptrtoint (ptr @gv to i32))
  ret float %ret
}
