; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=riscv64 -stop-after=finalize-isel < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+experimental-zicfilp -stop-after=finalize-isel < %s | FileCheck -check-prefixes=ZICFILP %s

@brind.arr = internal unnamed_addr constant [2 x ptr] [ptr blockaddress(@brind, %5), ptr blockaddress(@brind, %8)], align 8
@x = dso_local global i32 0, align 4

define void @brind(i32 noundef signext %0) {
  ; CHECK-LABEL: name: brind
  ; CHECK:   PseudoBRIND killed [[VAR:%.*]], 0
  ; ZICFILP-LABEL: name: brind
  ; ZICFILP:   PseudoBRINDNonX7 killed [[VAR:%.*]], 0
  %2 = sext i32 %0 to i64
  %3 = getelementptr inbounds [2 x ptr], ptr @brind.arr, i64 0, i64 %2
  %4 = load ptr, ptr %3, align 8
  indirectbr ptr %4, [label %5, label %8]

5:                                                ; preds = %1
  %6 = load i32, ptr @x, align 4
  %7 = add nsw i32 %6, 2
  store i32 %7, ptr @x, align 4
  br label %8

8:                                                ; preds = %5, %1
  %9 = load i32, ptr @x, align 4
  %10 = add nsw i32 %9, 1
  store i32 %10, ptr @x, align 4
  ret void
}

define i32 @indirect_call(ptr %0) {
  ; CHECK-LABEL: name: indirect_call
  ; CHECK: PseudoCALLIndirect
  ; ZICFILP-LABEL: name: indirect_call
  ; ZICFILP: PseudoCALLIndirectNonX7
  call void %0()
  ret i32 0
}


define void @indirect_tail(ptr %0) {
  ; CHECK-LABEL: name: indirect_tail
  ; CHECK: PseudoTAILIndirect
  ; ZICFILP-LABEL: name: indirect_tail
  ; ZICFILP: PseudoTAILIndirectNonX7
  tail call void %0()
  ret void
}
