; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32-unknown-elf -mattr=+zba %s -o - | FileCheck %s

declare i32 @callee2(i32, i32)
declare i32 @callee3(i32, i32, i32)

; Positive test
; The users of addi aren't more than 2
define void @t1(i32 %a, i32 %b, i32 %c) {
; CHECK-LABEL: t1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sh2add a2, a0, a2
; CHECK-NEXT:    sh2add a0, a0, a1
; CHECK-NEXT:    addi a0, a0, 42
; CHECK-NEXT:    addi a1, a2, 42
; CHECK-NEXT:    tail callee2
entry:
  %shl = shl i32 %a, 2
  %add = add nsw i32 %shl, 42
  %add1 = add nsw i32 %add, %b
  %add2 = add nsw i32 %add, %c
  %call = tail call i32 @callee2(i32 %add1, i32 %add2)
  ret void
}

; Negative test
; The users of addi are more than 2.
define void @t2(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e) {
; CHECK-LABEL: t2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    addi a4, a0, 42
; CHECK-NEXT:    add a0, a4, a1
; CHECK-NEXT:    add a1, a4, a2
; CHECK-NEXT:    add a2, a4, a3
; CHECK-NEXT:    tail callee3
entry:
  %shl = shl i32 %a, 2
  %add = add nsw i32 %shl, 42
  %add1 = add nsw i32 %add, %b
  %add2 = add nsw i32 %add, %c
  %add3 = add nsw i32 %add, %d
  %call = tail call i32 @callee3(i32 %add1, i32 %add2, i32 %add3)
  ret void
}

; Negative test
; shl doesn't have one use.
define void @t3(i32 %a, i32 %b, i32 %c, i32 %d) {
; CHECK-LABEL: t3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    slli a4, a0, 2
; CHECK-NEXT:    addi a5, a4, 45
; CHECK-NEXT:    add a4, a5, a1
; CHECK-NEXT:    add a1, a5, a2
; CHECK-NEXT:    sh2add a2, a0, a3
; CHECK-NEXT:    mv a0, a4
; CHECK-NEXT:    tail callee3
entry:
  %shl = shl i32 %a, 2
  %add = add nsw i32 %shl, 45
  %add1 = add nsw i32 %add, %b
  %add2 = add nsw i32 %add, %c
  %add3 = add nsw i32 %shl, %d
  %call = tail call i32 @callee3(i32 %add1, i32 %add2, i32 %add3)
  ret void
}

; Negative test
; shift amount isn't 1, 2, or 3.
define void @t4(i32 %a, i32 %b, i32 %c, i32 %d) {
; CHECK-LABEL: t4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    addi a3, a0, 45
; CHECK-NEXT:    add a0, a3, a1
; CHECK-NEXT:    add a1, a3, a2
; CHECK-NEXT:    tail callee2
entry:
  %shl = shl i32 %a, 4
  %add = add nsw i32 %shl, 45
  %add1 = add nsw i32 %add, %b
  %add2 = add nsw i32 %add, %c
  %call = tail call i32 @callee2(i32 %add1, i32 %add2)
  ret void
}
