; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple arm | FileCheck %s -check-prefixes=CHECK-ALE
; RUN: llc < %s -mtriple armeb | FileCheck %s -check-prefixes=CHECK-ABE
; RUN: llc < %s -mtriple thumb | FileCheck %s -check-prefixes=CHECK-TLE
; RUN: llc < %s -mtriple thumbeb | FileCheck %s -check-prefixes=CHECK-TBE

declare dso_local void @main()

define dso_local void @naked() naked "frame-pointer"="all" {
; CHECK-ALE-LABEL: naked:
; CHECK-ALE:       @ %bb.0:
; CHECK-ALE-NEXT:    bl main
;
; CHECK-ABE-LABEL: naked:
; CHECK-ABE:       @ %bb.0:
; CHECK-ABE-NEXT:    bl main
;
; CHECK-TLE-LABEL: naked:
; CHECK-TLE:       @ %bb.0:
; CHECK-TLE-NEXT:    bl main
;
; CHECK-TBE-LABEL: naked:
; CHECK-TBE:       @ %bb.0:
; CHECK-TBE-NEXT:    bl main
  call void @main()
  unreachable
}

define dso_local void @normal() "frame-pointer"="all" {
; CHECK-ALE-LABEL: normal:
; CHECK-ALE:       @ %bb.0:
; CHECK-ALE-NEXT:    push {r11, lr}
; CHECK-ALE-NEXT:    mov r11, sp
; CHECK-ALE-NEXT:    bl main
;
; CHECK-ABE-LABEL: normal:
; CHECK-ABE:       @ %bb.0:
; CHECK-ABE-NEXT:    push {r11, lr}
; CHECK-ABE-NEXT:    mov r11, sp
; CHECK-ABE-NEXT:    bl main
;
; CHECK-TLE-LABEL: normal:
; CHECK-TLE:       @ %bb.0:
; CHECK-TLE-NEXT:    push {r7, lr}
; CHECK-TLE-NEXT:    add r7, sp, #0
; CHECK-TLE-NEXT:    bl main
;
; CHECK-TBE-LABEL: normal:
; CHECK-TBE:       @ %bb.0:
; CHECK-TBE-NEXT:    push {r7, lr}
; CHECK-TBE-NEXT:    add r7, sp, #0
; CHECK-TBE-NEXT:    bl main
  call void @main()
  unreachable
}
