; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 4
; RUN: opt -disable-output "-passes=print<scalar-evolution>" -scalar-evolution-classify-expressions=0 < %s 2>&1 | FileCheck %s

define i32 @slt_trip_count_with_range_attr(i32 range(i32 1, 100) %limit) {
;
; CHECK-LABEL: 'slt_trip_count_with_range_attr'
; CHECK-NEXT:  Determining loop execution counts for: @slt_trip_count_with_range_attr
; CHECK-NEXT:  Loop %loop: backedge-taken count is (-1 + %limit)<nsw>
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 98
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (-1 + %limit)<nsw>
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
 entry:
  br label %loop

 loop:
  %index = phi i32 [ 0, %entry ], [ %index.inc, %loop ]
  %index.inc = add i32 %index, 1
  %continue = icmp slt i32 %index.inc, %limit
  br i1 %continue, label %loop, label %loop.exit

 loop.exit:
  ret i32 0
}

declare i32 @get_i32()

define i32 @slt_trip_count_with_range_call() {
;
; CHECK-LABEL: 'slt_trip_count_with_range_call'
; CHECK-NEXT:  Determining loop execution counts for: @slt_trip_count_with_range_call
; CHECK-NEXT:  Loop %loop: backedge-taken count is (-1 + %limit)<nsw>
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 98
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (-1 + %limit)<nsw>
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
 entry:
  %limit = call range(i32 1, 100) i32 @get_i32()
  br label %loop

 loop:
  %index = phi i32 [ 0, %entry ], [ %index.inc, %loop ]
  %index.inc = add i32 %index, 1
  %continue = icmp slt i32 %index.inc, %limit
  br i1 %continue, label %loop, label %loop.exit

 loop.exit:
  ret i32 0
}

declare range(i32 1, 100) i32 @get_i32_in_range()

define i32 @slt_trip_count_with_range_result() {
;
; CHECK-LABEL: 'slt_trip_count_with_range_result'
; CHECK-NEXT:  Determining loop execution counts for: @slt_trip_count_with_range_result
; CHECK-NEXT:  Loop %loop: backedge-taken count is (-1 + %limit)<nsw>
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i32 98
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (-1 + %limit)<nsw>
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
 entry:
  %limit = call i32 @get_i32_in_range()
  br label %loop

 loop:
  %index = phi i32 [ 0, %entry ], [ %index.inc, %loop ]
  %index.inc = add i32 %index, 1
  %continue = icmp slt i32 %index.inc, %limit
  br i1 %continue, label %loop, label %loop.exit

 loop.exit:
  ret i32 0
}
